/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.util.IntegerVector;
import com.ibm.webrunner.util.Sorter;
import com.ibm.webrunner.util.TableModel;
import com.ibm.webrunner.util.event.TableEvent;
import com.ibm.webrunner.util.event.TableListener;
import com.ibm.webrunner.widget.Alignment;
import com.ibm.webrunner.widget.Caption;
import com.ibm.webrunner.widget.CaptionBar;
import com.ibm.webrunner.widget.ListboxCaption;
import com.ibm.webrunner.widget.ListboxColumn;
import com.ibm.webrunner.widget.ListboxTable;
import com.ibm.webrunner.widget.Paintable;
import com.ibm.webrunner.widget.Scroller;
import com.ibm.webrunner.widget.event.CaptionBarEvent;
import com.ibm.webrunner.widget.event.CaptionBarListener;
import com.ibm.webrunner.widget.event.ListboxEvent;
import com.ibm.webrunner.widget.event.ListboxListener;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiColumnListboxBase
extends Panel
implements ItemSelectable {
    protected transient Object LOCK;
    public static final Object DEFAULT_KEY = null;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    public static final int DEFAULT_CAPTIONBAR_HEIGHT = 20;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.lightGray;
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.black;
    public static final Color DEFAULT_SEPARATOR_COLOR = Color.black;
    public static final Color DEFAULT_SELECTION_BACKGROUND = Color.gray;
    public static final Color DEFAULT_SELECTION_FOREGROUND = Color.black;
    CaptionBar fCaptionBar = new CaptionBar();
    ViewArea fViewArea = new ViewArea();
    Scroller fHScrollbar = new Scroller(0);
    Scroller fVScrollbar = new Scroller(1);
    EventHandler fEventHandler = new EventHandler();
    TableModel fTable;
    boolean fListboxTable = false;
    Vector fColumnInfo;
    IntegerVector fColumns;
    IntegerVector fRows;
    BitSet fSelected;
    transient Vector fCaptionBarListeners;
    transient Vector fListboxListeners;
    transient Vector fItemListeners;
    boolean fBorder = true;
    boolean fHSeparator = false;
    int fRowHeight = 20;
    boolean fSelectable = true;
    Color fSelectionForeground = DEFAULT_SELECTION_FOREGROUND;
    Color fSelectionBackground = DEFAULT_SELECTION_BACKGROUND;
    Color fSeparatorColor = DEFAULT_SEPARATOR_COLOR;
    boolean fVSeparator = false;
    boolean fUpdate = true;
    transient Image fBackgroundImage;
    boolean fMultipleSelections = false;
    int fMouseDownRow = -1;
    int fClickCount;
    long fClickTime;
    int fLastCaptionSelected = -1;
    int fLastSelected = -1;
    int fFocusLine;
    boolean fHasFocus;

    protected MultiColumnListboxBase() {
        this.init();
        this.fCaptionBar.setSize(this.fCaptionBar.getSize().width, this.getDefaultCaptionBarHeight());
        this.fCaptionBar.setHorizontalAdjuster(this.fHScrollbar);
        this.fHScrollbar.setVisible(false);
        this.fVScrollbar.setVisible(false);
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        super.setLayout(null);
        this.add(this.fCaptionBar);
        this.add(this.fViewArea);
        this.add(this.fHScrollbar);
        this.add(this.fVScrollbar);
        this.addFocusListener(this.fEventHandler);
        this.addKeyListener(this.fEventHandler);
        this.fViewArea.addMouseListener(this.fEventHandler);
    }

    private int getDefaultCaptionBarHeight() {
        int n = this.fCaptionBar.getSize().height;
        if (n <= 0) {
            Frame frame = new Frame();
            frame.setLayout(new BorderLayout());
            TextField textField = new TextField("ABC");
            Font font = this.fCaptionBar.getFont();
            if (font != null) {
                textField.setFont(font);
            }
            frame.add("Center", textField);
            frame.pack();
            n = textField.getSize().height;
            if (n > 2) {
                n -= 2;
            }
        }
        if (n <= 0) {
            n = 20;
        }
        return n;
    }

    protected MultiColumnListboxBase(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void init() {
        this.LOCK = this.getTreeLock();
        this.fCaptionBarListeners = new Vector();
        this.fListboxListeners = new Vector();
        this.fCaptionBar.addCaptionBarListener(this.fEventHandler);
        this.fHScrollbar.addAdjustmentListener(this.fEventHandler);
        this.fVScrollbar.addAdjustmentListener(this.fEventHandler);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void addNotify() {
        this.fHScrollbar.startThread();
        this.fVScrollbar.startThread();
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.fHScrollbar.stopThread();
        this.fVScrollbar.stopThread();
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null || this.fViewArea == null) {
            return;
        }
        this.fViewArea.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null || this.fViewArea == null) {
            return;
        }
        this.fViewArea.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null || this.fViewArea == null) {
            return;
        }
        this.fViewArea.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null || this.fViewArea == null) {
            return;
        }
        this.fViewArea.removeMouseMotionListener(mouseMotionListener);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.doLayout();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Object object = this.LOCK;
        synchronized (object) {
            int n3;
            int n4;
            Dimension dimension2 = this.getPhysicalSize();
            int n5 = this.fBorder ? 1 : 0;
            int n6 = 0;
            if (this.fCaptionBar.isVisible()) {
                n4 = this.fCaptionBar.isBorderVisible() ? n5 : 0;
                n6 = this.fCaptionBar.getSize().height;
                this.fCaptionBar.setBounds(n4, n4, n - 2 * n4, n6);
            }
            n4 = this.fVScrollbar.getPreferredSize().width;
            int n7 = this.fHScrollbar.getPreferredSize().height;
            boolean bl = false;
            boolean bl2 = false;
            if (n2 > n6 + 2 * n7) {
                if (dimension2.width > n) {
                    bl = true;
                } else if (dimension2.width + n4 > n) {
                    bl2 = true;
                }
            }
            boolean bl3 = false;
            boolean bl4 = false;
            if (dimension2.height > n2) {
                bl3 = true;
            } else if (dimension2.height + n7 > n2) {
                bl4 = true;
            }
            if (bl2 && bl3) {
                bl = true;
            }
            if (bl4 && bl) {
                bl3 = true;
            }
            if (bl2 && bl3) {
                bl = true;
            }
            if (bl) {
                n3 = bl3 ? n4 : 0;
                this.fHScrollbar.setBounds(n5, n2 - n7 - n5, n - n3 - n5, n7);
            } else {
                this.fHScrollbar.setValue(0);
            }
            if (bl3) {
                n3 = bl ? n7 : 0;
                this.fVScrollbar.setBounds(n - n4 - n5, n6 + n5, n4, n2 - n6 - n3 - n5 - 1);
            } else {
                this.fVScrollbar.setValue(0);
            }
            this.fHScrollbar.setVisible(bl);
            this.fVScrollbar.setVisible(bl3);
            n3 = n5 * 2 + (bl3 ? n4 : 0);
            int n8 = n5 * 2 + (bl ? n7 : 0);
            this.fViewArea.setBounds(n5, n5 + n6, n - n3, n2 - n6 - n8);
            if (this.fTable != null) {
                int n9 = dimension2.width;
                int n10 = bl3 ? n4 : 0;
                this.setHorizontalAdjustmentValues(this.fHScrollbar.getValue(), n, 0, n9 + n10);
                int n11 = this.fViewArea.getSize().height / this.fRowHeight;
                int n12 = this.fRows.size();
                this.setVerticalAdjustmentValues(this.fVScrollbar.getValue(), n11, 0, n12);
            } else {
                this.setHorizontalAdjustmentValues(0, 1, 0, 1);
                this.setVerticalAdjustmentValues(0, 1, 0, 1);
            }
            return;
        }
    }

    private Dimension getPhysicalSize() {
        int n = 0;
        int n2 = 0;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                int n3 = this.fColumns.size();
                int n4 = 0;
                while (n4 < n3) {
                    ListboxColumn listboxColumn = (ListboxColumn)this.fColumnInfo.elementAt(n4);
                    if (listboxColumn.isVisible()) {
                        n += listboxColumn.getWidth();
                    }
                    ++n4;
                }
                n2 += this.fRows.size() * this.fRowHeight;
            }
            if (this.fCaptionBar.isVisible()) {
                n2 += this.fCaptionBar.getSize().height;
            }
        }
        return new Dimension(n, n2);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    protected void addListboxListener(ListboxListener listboxListener) {
        if (listboxListener == null) {
            return;
        }
        this.fListboxListeners.addElement(listboxListener);
    }

    protected void removeListboxListener(ListboxListener listboxListener) {
        if (listboxListener == null) {
            return;
        }
        this.fListboxListeners.removeElement(listboxListener);
    }

    protected void addCaptionBarListener(CaptionBarListener captionBarListener) {
        if (captionBarListener == null) {
            return;
        }
        this.fCaptionBarListeners.addElement(captionBarListener);
    }

    protected void removeCaptionBarListener(CaptionBarListener captionBarListener) {
        if (captionBarListener == null) {
            return;
        }
        this.fCaptionBarListeners.removeElement(captionBarListener);
    }

    protected Adjustable getHorizontalAdjuster() {
        return this.fHScrollbar;
    }

    private void setHorizontalAdjustmentValues(int n, int n2, int n3, int n4) {
        Object object = this.LOCK;
        synchronized (object) {
            this.fHScrollbar.setMinimum(n3);
            this.fHScrollbar.setMaximum(n4);
            this.fHScrollbar.setValue(n);
            this.fHScrollbar.setVisibleAmount(n2);
            this.fHScrollbar.setUnitIncrement(n2 / 4);
            this.fHScrollbar.setBlockIncrement(n2);
            this.fViewArea.repaint();
            return;
        }
    }

    protected Adjustable getVerticalAdjuster() {
        return this.fVScrollbar;
    }

    private void setVerticalAdjustmentValues(int n, int n2, int n3, int n4) {
        Object object = this.LOCK;
        synchronized (object) {
            this.fVScrollbar.setMinimum(n3);
            this.fVScrollbar.setMaximum(n4);
            this.fVScrollbar.setValue(n);
            this.fVScrollbar.setVisibleAmount(n2);
            this.fVScrollbar.setUnitIncrement(1);
            this.fVScrollbar.setBlockIncrement(n2);
            this.fViewArea.repaint();
            return;
        }
    }

    protected void setTableModel(TableModel tableModel) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                this.fTable.removeTableListener(this.fEventHandler);
            }
            this.fTable = tableModel;
            this.fCaptionBar.removeAll();
            this.fViewArea.removeAll();
            if (this.fTable == null) {
                this.fColumnInfo = null;
                this.fColumns = null;
                this.fRows = null;
                this.fSelected = null;
                Object var3_3 = null;
                return;
            }
            TableModel tableModel2 = this.fTable;
            synchronized (tableModel2) {
                int n = this.fTable.getColumnCount();
                int n2 = this.fTable.getRowCount();
                this.fColumnInfo = new Vector(n);
                this.fColumns = new IntegerVector(n);
                this.fRows = new IntegerVector(n2);
                this.fSelected = new BitSet(n2);
                this.fTable.addTableListener(this.fEventHandler);
                int n3 = 0;
                while (n3 < n) {
                    ListboxCaption listboxCaption = this.createCaption();
                    listboxCaption.setLabel(this.fTable.getColumnInfo(n3));
                    if (!this.fCaptionBar.isBorderVisible()) {
                        listboxCaption.setBorderVisible(false);
                    }
                    this.fCaptionBar.addCaption(listboxCaption);
                    ListboxColumn listboxColumn = new ListboxColumn(this, this.fTable, n3, listboxCaption);
                    this.fColumnInfo.addElement(listboxColumn);
                    this.fColumns.addElement(n3);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < n2) {
                    this.fRows.addElement(n4);
                    ++n4;
                }
            }
            this.fListboxTable = false;
            this.doLayout();
            return;
        }
    }

    protected TableModel getTableModel() {
        if (this.fListboxTable) {
            return null;
        }
        return this.fTable;
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fItemListeners == null) {
                this.fItemListeners = new Vector();
            }
            this.fItemListeners.addElement(itemListener);
            return;
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fItemListeners != null) {
                this.fItemListeners.removeElement(itemListener);
                if (this.fItemListeners.size() == 0) {
                    this.fItemListeners = null;
                }
            }
            return;
        }
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedRows();
    }

    protected void sort() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                Object var2_2 = null;
                return;
            }
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                ListboxColumn listboxColumn;
                Sorter sorter;
                int n = this.fCaptionBar.getSelectedCaptionIndex();
                if (n != -1 && (sorter = (listboxColumn = (ListboxColumn)this.fColumnInfo.elementAt(n)).getSorter()) != null) {
                    if (listboxColumn.getState()) {
                        sorter.setSortOrder(1);
                    } else {
                        sorter.setSortOrder(0);
                    }
                    int[] nArray = sorter.sort(this.getColumn(n));
                    if (this.fListboxTable) {
                        ListboxTable listboxTable = (ListboxTable)this.fTable;
                        Object[][] objectArray = new Object[nArray.length][this.fColumns.size()];
                        Object[] objectArray2 = new Object[nArray.length];
                        BitSet bitSet = new BitSet(this.fSelected.size());
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            objectArray[n2] = this.getRow(nArray[n2]);
                            objectArray2[n2] = listboxTable.getRowInfo(nArray[n2]);
                            if (this.fSelected.get(nArray[n2])) {
                                bitSet.set(n2);
                            }
                            ++n2;
                        }
                        this.fSelected = bitSet;
                        boolean bl = false;
                        boolean bl2 = false;
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            listboxTable.replaceRowImpl(objectArray[n3], objectArray2[n3], n3);
                            if (!bl && nArray[n3] == this.fLastSelected) {
                                this.fLastSelected = n3;
                                bl = true;
                            }
                            if (!bl2 && nArray[n3] == this.fFocusLine) {
                                this.fFocusLine = n3;
                                bl2 = true;
                            }
                            ++n3;
                        }
                        this.fViewArea.repaint();
                    } else {
                        IntegerVector integerVector = new IntegerVector();
                        BitSet bitSet = new BitSet(this.fSelected.size());
                        boolean bl = false;
                        boolean bl3 = false;
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            int n5 = nArray[n4];
                            if (this.fSelected.get(n5)) {
                                bitSet.set(n4);
                            }
                            integerVector.addElement(this.fRows.elementAt(n5));
                            if (!bl && n5 == this.fLastSelected) {
                                this.fLastSelected = n4;
                                bl = true;
                            }
                            if (!bl3 && n5 == this.fFocusLine) {
                                this.fFocusLine = n4;
                                bl3 = true;
                            }
                            ++n4;
                        }
                        this.fRows = integerVector;
                        this.fSelected = bitSet;
                    }
                    if (this.fUpdate) {
                        this.fViewArea.repaint();
                    }
                }
            }
            return;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public void setBackground(Color color) {
        this.fViewArea.setBackground(color);
    }

    public Color getBackground() {
        return this.fViewArea.getBackground();
    }

    protected void setSeparatorColor(Color color) {
        if (color == null) {
            color = DEFAULT_SEPARATOR_COLOR;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.fSeparatorColor.equals(color)) {
                this.fSeparatorColor = color;
                this.fViewArea.repaint();
            }
            return;
        }
    }

    protected Color getSeparatorColor() {
        return this.fSeparatorColor;
    }

    protected void setUpdate(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            this.fUpdate = bl;
            if (bl) {
                this.fCaptionBar.repaint();
                this.fViewArea.repaint();
                this.fVScrollbar.repaint();
                this.fHScrollbar.repaint();
            }
            return;
        }
    }

    protected boolean getUpdate() {
        return this.fUpdate;
    }

    protected void setCaptionBarBackground(Color color) {
        this.fCaptionBar.setBackground(color);
    }

    protected Color getCaptionBarBackground() {
        return this.fCaptionBar.getBackground();
    }

    protected void setCaptionBarForeground(Color color) {
        this.fCaptionBar.setForeground(color);
    }

    protected Color getCaptionBarForeground() {
        return this.fCaptionBar.getForeground();
    }

    protected void setCaptionBarFont(Font font) {
        this.fCaptionBar.setFont(font);
        this.fCaptionBar.setSize(this.fCaptionBar.getSize().width, 0);
        this.setCaptionBarHeight(this.getDefaultCaptionBarHeight());
    }

    protected Font getCaptionBarFont() {
        return this.fCaptionBar.getFont();
    }

    protected void setCaptionBarVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (bl != this.fCaptionBar.isVisible()) {
                this.fCaptionBar.setVisible(bl);
                this.doLayout();
            }
            return;
        }
    }

    protected boolean isCaptionBarVisible() {
        return this.fCaptionBar.isVisible();
    }

    protected void setCaptionBarHeight(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (n > 0) {
                this.fCaptionBar.setSize(this.fCaptionBar.getSize().width, n);
                this.doLayout();
            }
            return;
        }
    }

    protected int getCaptionBarHeight() {
        return this.fCaptionBar.getSize().height;
    }

    protected void setContinuousDrag(boolean bl) {
        this.fCaptionBar.setContinuousDrag(bl);
    }

    protected boolean getContinuousDrag() {
        return this.fCaptionBar.getContinuousDrag();
    }

    protected void setRowHeight(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fRowHeight != n) {
                this.fRowHeight = n;
                if (this.fUpdate) {
                    this.fViewArea.repaint();
                }
            }
            return;
        }
    }

    protected int getRowHeight() {
        return this.fRowHeight;
    }

    protected void setMultipleSelections(boolean bl) {
        this.fMultipleSelections = bl;
    }

    protected boolean getMultipleSelections() {
        return this.fMultipleSelections;
    }

    protected void setHorizontalSeparatorVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (bl != this.fHSeparator) {
                this.fHSeparator = bl;
                if (this.fUpdate) {
                    this.fViewArea.repaint();
                }
            }
            return;
        }
    }

    protected boolean isHorizontalSeparatorVisible() {
        return this.fHSeparator;
    }

    protected void setVerticalSeparatorVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (bl != this.fVSeparator) {
                this.fVSeparator = bl;
                if (this.fUpdate) {
                    this.fViewArea.repaint();
                }
            }
            return;
        }
    }

    protected boolean isVerticalSeparatorVisible() {
        return this.fVSeparator;
    }

    protected void useSystemColors() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = this.getUpdate();
            this.setUpdate(false);
            super.setBackground(SystemColor.control);
            this.fCaptionBar.setBackground(SystemColor.control);
            this.fCaptionBar.setForeground(SystemColor.controlText);
            this.fVScrollbar.setBackground(SystemColor.control);
            this.fHScrollbar.setBackground(SystemColor.control);
            this.fViewArea.setBackground(SystemColor.window);
            this.fViewArea.setForeground(SystemColor.textText);
            this.setSelectionBackground(SystemColor.textHighlight);
            this.setSelectionForeground(SystemColor.textHighlightText);
            this.setUpdate(bl);
            return;
        }
    }

    protected void setSelectionBackground(Color color) {
        if (color == null) {
            color = DEFAULT_SELECTION_BACKGROUND;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.fSelectionBackground.equals(color)) {
                this.fSelectionBackground = color;
                if (this.fUpdate) {
                    this.fViewArea.repaint();
                }
            }
            return;
        }
    }

    protected Color getSelectionBackground() {
        return this.fSelectionBackground;
    }

    protected void setSelectionForeground(Color color) {
        if (color == null) {
            color = DEFAULT_SELECTION_BACKGROUND;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.fSelectionForeground.equals(color)) {
                this.fSelectionForeground = color;
                if (this.fUpdate) {
                    this.fViewArea.repaint();
                }
            }
            return;
        }
    }

    protected Color getSelectionForeground() {
        return this.fSelectionForeground;
    }

    protected void setBorderVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fBorder != bl) {
                this.fBorder = bl;
                this.doLayout();
            }
            return;
        }
    }

    protected boolean isBorderVisible() {
        return this.fBorder;
    }

    protected void setCaptionBorderVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fCaptionBar.isBorderVisible() != bl) {
                this.fCaptionBar.setBorderVisible(bl);
                this.doLayout();
            }
            return;
        }
    }

    protected boolean isCaptionBorderVisible() {
        return this.fCaptionBar.isBorderVisible();
    }

    protected void setBackgroundImage(Image image) {
        this.fBackgroundImage = image;
        this.fViewArea.repaint();
    }

    protected void setCaptionBarBackgroundImage(Image image) {
        this.fCaptionBar.setBackgroundImage(image);
    }

    protected Image getCaptionBarBackgroundImage() {
        return this.fCaptionBar.getBackgroundImage();
    }

    protected Image getBackgroundImage() {
        return this.fBackgroundImage;
    }

    protected int getColumnCount() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                int n = this.fColumns.size();
                Object var3_3 = null;
                return n;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] getColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return null;
            }
            Object[] objectArray = null;
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n2 = this.fColumns.size();
                if (n < 0) return null;
                if (n >= n2) {
                    return null;
                }
                int n3 = this.fColumns.elementAt(n);
                objectArray = new Object[this.fRows.size()];
                int n4 = 0;
                while (n4 < objectArray.length) {
                    int n5 = this.fRows.elementAt(n4);
                    objectArray[n4] = this.fTable.getElement(n5, n3);
                    ++n4;
                }
                return objectArray;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void autoSizeColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return;
            }
            int n2 = this.fColumnInfo.size();
            if (n < 0) return;
            if (n >= n2) {
                return;
            }
            ListboxColumn listboxColumn = (ListboxColumn)this.fColumnInfo.elementAt(n);
            if (!listboxColumn.isResizable()) {
                return;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Font font = this.fCaptionBar.getFont();
            FontMetrics fontMetrics = toolkit.getFontMetrics(font);
            int n3 = 0;
            String string = listboxColumn.getLabel().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            block6: while (true) {
                int n4;
                if (!stringTokenizer.hasMoreTokens()) {
                    fontMetrics = toolkit.getFontMetrics(this.getFont());
                    n4 = this.fColumns.elementAt(n);
                    TableModel tableModel = this.fTable;
                    synchronized (tableModel) {
                        int n5 = this.fTable.getRowCount();
                        int n6 = 0;
                        while (true) {
                            if (n6 >= n5) {
                                break block6;
                            }
                            Object object2 = this.fTable.getElement(n6, n4);
                            if (object2 != null) {
                                int n7 = 0;
                                if (object2 instanceof Component) {
                                    n7 = ((Component)object2).getPreferredSize().width;
                                } else if (object2 instanceof Paintable) {
                                    n7 = ((Paintable)object2).getSize().width;
                                } else {
                                    String string2 = this.paintHook(object2.toString(), n6, n);
                                    n7 = fontMetrics.stringWidth(string2) + 10;
                                }
                                if (n7 > n3) {
                                    n3 = n7;
                                }
                            }
                            ++n6;
                        }
                    }
                }
                n4 = fontMetrics.stringWidth(stringTokenizer.nextToken()) + 14;
                if (n4 <= n3) continue;
                n3 = n4;
            }
            listboxColumn.setWidth(n3);
            this.fCaptionBar.repaint();
            return;
        }
    }

    protected ListboxColumn addColumn(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (this.fTable == null) {
                this.setTableModel(new ListboxTable());
                this.fListboxTable = true;
            }
            ListboxColumn listboxColumn = null;
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                this.fTable.addColumn(null, object);
                listboxColumn = (ListboxColumn)this.fColumnInfo.elementAt(this.fColumns.size() - 1);
            }
            ListboxColumn listboxColumn2 = listboxColumn;
            Object var4_6 = null;
            return listboxColumn2;
        }
    }

    protected void addColumns(Object[] objectArray) {
        boolean bl = this.fUpdate;
        this.fUpdate = false;
        int n = 0;
        while (n < objectArray.length) {
            this.addColumn(objectArray[n]);
            ++n;
        }
        this.setUpdate(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return;
            }
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n2 = this.fColumns.size();
                if (n < 0) return;
                if (n >= n2) {
                    return;
                }
                int n3 = this.fColumns.elementAt(n);
                this.fTable.removeColumn(n3);
            }
            return;
        }
    }

    protected void removeAllColumns() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                this.fTable.removeAllColumns();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ListboxColumn getColumnInfo(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return null;
            }
            if (n < 0) return null;
            if (n < this.fColumns.size()) return (ListboxColumn)this.fColumnInfo.elementAt(n);
            return null;
        }
    }

    protected void replaceColumn(Object[] objectArray, int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block10: {
                if (this.fTable == null) {
                    Object var4_4 = null;
                    return;
                }
                int n2 = this.fColumns.size();
                if (n < 0) break block10;
                if (n < n2) break block11;
            }
            Object var4_5 = null;
            {
                block11: {
                    return;
                }
                int n3 = this.fColumns.elementAt(n);
                TableModel tableModel = this.fTable;
                synchronized (tableModel) {
                    Object object2 = this.fTable.getColumnInfo(n3);
                    this.fTable.replaceColumn(objectArray, object2, n3);
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void makeRowVisible(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return;
            }
            int n2 = this.fRows.size();
            if (n < 0) return;
            if (n >= n2) {
                return;
            }
            int n3 = this.fVScrollbar.getValue();
            int n4 = this.fVScrollbar.getVisibleAmount();
            if (n >= n3 && n < n3 + n4) {
                return;
            }
            this.fVScrollbar.setValue(n);
            this.fViewArea.repaint();
            return;
        }
    }

    protected int getRowCount() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                int n = this.fRows.size();
                Object var3_3 = null;
                return n;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] getRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return null;
            }
            Object[] objectArray = null;
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n2 = this.fRows.size();
                if (n < 0) return null;
                if (n >= n2) {
                    return null;
                }
                int n3 = this.fRows.elementAt(n);
                objectArray = new Object[this.fColumns.size()];
                int n4 = 0;
                while (n4 < objectArray.length) {
                    int n5 = this.fColumns.elementAt(n4);
                    objectArray[n4] = this.fTable.getElement(n3, n5);
                    ++n4;
                }
                return objectArray;
            }
        }
    }

    protected void addRow(Object[] objectArray) {
        this.addRow(objectArray, null);
    }

    protected void addRow(Object[] objectArray, Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (objectArray == null) {
                Object var4_4 = null;
                return;
            }
            if (this.fTable == null) {
                this.setTableModel(new ListboxTable());
                this.fListboxTable = true;
            }
            Object[] objectArray2 = new Object[this.fColumns.size()];
            int n = 0;
            while (n < objectArray.length) {
                if (n >= objectArray2.length) break;
                objectArray2[this.fColumns.elementAt((int)n)] = objectArray[n];
                ++n;
            }
            this.fTable.addRow(objectArray2, object);
            return;
        }
    }

    protected void addRows(Object[][] objectArray) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.fUpdate;
        this.fUpdate = false;
        int n = 0;
        while (n < objectArray.length) {
            this.addRow(objectArray[n], null);
            ++n;
        }
        this.setUpdate(bl);
    }

    protected void addRows(Object[][] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.fUpdate;
        this.fUpdate = false;
        int n = 0;
        while (n < objectArray.length) {
            Object object = n < objectArray2.length ? objectArray2[n] : null;
            this.addRow(objectArray[n], object);
            ++n;
        }
        this.setUpdate(bl);
    }

    protected void removeRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block7: {
                if (this.fTable == null) {
                    Object var3_3 = null;
                    return;
                }
                int n2 = this.fRows.size();
                if (n < 0) break block7;
                if (n < n2) break block8;
            }
            Object var3_4 = null;
            {
                block8: {
                    return;
                }
                int n3 = this.fRows.elementAt(n);
                this.fTable.removeRow(n3);
                return;
            }
        }
    }

    protected void removeAllRows() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable != null) {
                this.fTable.removeAllRows();
            }
            return;
        }
    }

    protected void removeRows(int n, int n2) {
        boolean bl = this.fUpdate;
        this.fUpdate = false;
        int n3 = 0;
        while (n3 < n2) {
            this.removeRow(n);
            ++n3;
        }
        this.setUpdate(bl);
    }

    protected void insertRow(Object[] objectArray, int n) {
        this.insertRow(objectArray, null, n);
    }

    protected void insertRow(Object[] objectArray, Object object, int n) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (objectArray == null) {
                Object var5_5 = null;
                return;
            }
            if (this.fTable == null) {
                this.setTableModel(new ListboxTable());
                this.fListboxTable = true;
            }
            Object[] objectArray2 = new Object[this.fColumns.size()];
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (n2 >= objectArray2.length) break;
                objectArray2[this.fColumns.elementAt((int)n2)] = objectArray[n2];
                ++n2;
            }
            this.fTable.insertRow(objectArray2, object, n);
            return;
        }
    }

    protected void insertRows(Object[][] objectArray, int n) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.fUpdate;
        this.fUpdate = false;
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.insertRow(objectArray[n2], null, n);
            ++n2;
        }
        this.setUpdate(bl);
    }

    protected void insertRows(Object[][] objectArray, Object[] objectArray2, int n) {
        if (objectArray == null) {
            return;
        }
        boolean bl = this.fUpdate;
        this.fUpdate = false;
        int n2 = objectArray2 == null ? 0 : objectArray2.length;
        int n3 = objectArray.length - 1;
        while (n3 >= 0) {
            if (n3 < n2) {
                this.insertRow(objectArray[n3], null, n);
            } else {
                this.insertRow(objectArray[n3], objectArray2[n3], n);
            }
            --n3;
        }
        this.setUpdate(bl);
    }

    protected void replaceRow(Object[] objectArray, int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block10: {
                if (this.fTable == null) {
                    Object var4_4 = null;
                    return;
                }
                int n2 = this.fRows.size();
                if (n < 0) break block10;
                if (n < n2) break block11;
            }
            Object var4_5 = null;
            {
                block11: {
                    return;
                }
                int n3 = this.fRows.elementAt(n);
                TableModel tableModel = this.fTable;
                synchronized (tableModel) {
                    Object object2 = this.fTable.getRowInfo(n3);
                    this.fTable.replaceRow(objectArray, object2, n3);
                }
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] getKeys() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return null;
            }
            int n = this.fRows.size();
            if (n == 0) {
                return null;
            }
            Object[] objectArray = new Object[n];
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.fRows.elementAt(n2);
                    objectArray[n2] = this.fTable.getRowInfo(n3);
                    ++n2;
                }
                return objectArray;
            }
        }
    }

    protected Object[] getRowByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            int n = this.getIndexByKey(object);
            if (n == -1) {
                Object[] objectArray = null;
                Object var4_6 = null;
                return objectArray;
            }
            Object[] objectArray = this.getRow(n);
            Object var4_7 = null;
            return objectArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getIndexByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (this.fTable == null) {
                return -1;
            }
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n = this.fRows.size();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.fRows.elementAt(n2);
                    Object object3 = this.fTable.getRowInfo(n3);
                    if (object == null) {
                        if (object3 == null) return n2;
                    }
                    if (object.equals(object3)) {
                        return n2;
                    }
                    ++n2;
                }
                return -1;
            }
        }
    }

    protected void setRowKey(Object object, int n) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            block7: {
                if (this.fTable == null) {
                    Object var4_4 = null;
                    return;
                }
                int n2 = this.fRows.size();
                if (n < 0) break block7;
                if (n < n2) break block8;
            }
            Object var4_5 = null;
            {
                block8: {
                    return;
                }
                this.fTable.setRowInfo(object, n);
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getRowKey(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return null;
            }
            int n2 = this.fRows.size();
            if (n < 0) return null;
            if (n < n2) return this.fTable.getRowInfo(n);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int listboxColumnToTableColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return -1;
            }
            int n2 = this.fColumns.size();
            if (n < 0) return -1;
            if (n < n2) return this.fColumns.elementAt(n);
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int listboxRowToTableRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return -1;
            }
            int n2 = this.fRows.size();
            if (n < 0) return -1;
            if (n < n2) return this.fRows.elementAt(n);
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int tableColumnToListboxColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return -1;
            }
            int n2 = this.fColumns.size();
            if (n < 0) return -1;
            if (n < n2) return this.fColumns.indexOf(n);
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int tableRowToListboxRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return -1;
            }
            int n2 = this.fRows.size();
            if (n < 0) return -1;
            if (n < n2) return this.fRows.indexOf(n);
            return -1;
        }
    }

    protected void setSelectable(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fSelectable != bl) {
                this.fSelectable = bl;
                if (!bl) {
                    this.deselectAllRows();
                }
            }
            return;
        }
    }

    protected boolean isSelectable() {
        return this.fSelectable;
    }

    protected void selectColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block9: {
                if (this.fTable == null) {
                    Object var3_3 = null;
                    return;
                }
                int n2 = this.fColumns.size();
                if (n < 0) break block9;
                if (n < n2) break block10;
            }
            Object var3_4 = null;
            {
                block10: {
                    return;
                }
                int n3 = this.fCaptionBar.getSelectedCaptionIndex();
                if (n3 != -1) {
                    this.fCaptionBar.getCaption(n3).setSelected(false);
                }
                this.fCaptionBar.getCaption(n).setSelected(true);
                this.fCaptionBar.repaint();
                if (this.fTable != null) {
                    this.sort();
                }
                return;
            }
        }
    }

    protected void deselectColumn(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block8: {
                if (this.fTable == null) {
                    Object var3_3 = null;
                    return;
                }
                int n2 = this.fColumns.size();
                if (n < 0) break block8;
                if (n < n2) break block9;
            }
            Object var3_4 = null;
            {
                block9: {
                    return;
                }
                int n3 = this.fCaptionBar.getSelectedCaptionIndex();
                if (n3 != -1) {
                    this.fCaptionBar.getCaption(n3).setSelected(false);
                }
                return;
            }
        }
    }

    protected void selectRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block10: {
                if (this.fTable == null) {
                    Object var3_3 = null;
                    return;
                }
                int n2 = this.fTable.getRowCount();
                if (n < 0) break block10;
                if (n < n2) break block11;
            }
            Object var3_4 = null;
            {
                block11: {
                    return;
                }
                if (!this.fMultipleSelections) {
                    this.deselectAllRows();
                }
                this.fSelected.set(n);
                if (this.fUpdate) {
                    int n3 = this.fVScrollbar.getValue();
                    int n4 = this.fVScrollbar.getVisibleAmount();
                    if (n >= n3 && n < n3 + n4) {
                        this.fViewArea.repaint();
                    }
                }
                this.fLastSelected = n;
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invertSelections() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return;
            }
            if (!this.fMultipleSelections) {
                return;
            }
            int n = this.fRows.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (!this.fUpdate) return;
                    this.fViewArea.repaint();
                    return;
                }
                if (this.fSelected.get(n2)) {
                    this.fSelected.clear(n2);
                } else {
                    this.fSelected.set(n2);
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void selectAllRows() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return;
            }
            if (!this.fMultipleSelections) return;
            if (this.fColumns.size() == 0) return;
            int n = this.fRows.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.fLastSelected = 0;
                    if (!this.fUpdate) return;
                    this.fViewArea.repaint();
                    break;
                }
                this.fSelected.set(n2);
                ++n2;
            }
            return;
        }
    }

    protected void selectRowByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (this.fTable == null) {
                Object var3_3 = null;
                return;
            }
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n = this.fRows.size();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.fRows.elementAt(n2);
                    Object object3 = this.fTable.getRowInfo(n3);
                    if (object == null && object3 == null || object.equals(object3)) {
                        if (!this.fMultipleSelections) {
                            this.deselectAllRows();
                        }
                        this.fSelected.set(n2);
                        this.fLastSelected = n2;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.fUpdate) {
                this.fViewArea.repaint();
            }
            return;
        }
    }

    protected void deselectRow(int n) {
        Object object = this.LOCK;
        synchronized (object) {
            block12: {
                if (this.fTable == null) {
                    Object var3_3 = null;
                    return;
                }
                int n2 = this.fTable.getRowCount();
                if (n < 0) break block12;
                if (n < n2) break block13;
            }
            Object var3_4 = null;
            {
                block13: {
                    return;
                }
                if (!this.fMultipleSelections) {
                    this.deselectAllRows();
                } else {
                    this.fSelected.clear(n);
                    if (this.fLastSelected == n) {
                        this.fLastSelected = -1;
                    }
                }
                if (this.fUpdate) {
                    int n3 = this.fVScrollbar.getValue();
                    int n4 = this.fVScrollbar.getVisibleAmount();
                    if (n >= n3 && n < n3 + n4) {
                        this.fViewArea.repaint();
                    }
                }
                return;
            }
        }
    }

    protected void deselectAllRows() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                Object var2_2 = null;
                return;
            }
            this.fSelected = new BitSet(this.fTable.getRowCount());
            this.fLastSelected = -1;
            if (this.fUpdate) {
                this.fViewArea.repaint();
            }
            return;
        }
    }

    protected void deselectRowByKey(Object object) {
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (this.fTable == null) {
                Object var3_3 = null;
                return;
            }
            TableModel tableModel = this.fTable;
            synchronized (tableModel) {
                int n = this.fRows.size();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = this.fRows.elementAt(n2);
                    Object object3 = this.fTable.getRowInfo(n3);
                    if (object == null && object3 == null || object.equals(object3)) {
                        if (!this.fMultipleSelections) {
                            this.deselectAllRows();
                            break;
                        }
                        this.fSelected.clear(n2);
                        if (this.fLastSelected != n2) break;
                        this.fLastSelected = -1;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.fUpdate) {
                this.fViewArea.repaint();
            }
            return;
        }
    }

    protected int getSelectedColumnIndex() {
        return this.fCaptionBar.getSelectedCaptionIndex();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getSelectedIndex() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return -1;
            }
            int n = this.fRows.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.fSelected.get(n2)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int[] getSelectedIndexes() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return new int[0];
            }
            int n = this.fTable.getRowCount();
            if (n == 0) {
                return new int[0];
            }
            Vector<Integer> vector = new Vector<Integer>();
            int n2 = 0;
            while (n2 < n) {
                if (this.fSelected.get(n2)) {
                    vector.addElement(new Integer(n2));
                }
                ++n2;
            }
            int[] nArray = new int[vector.size()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = (Integer)vector.elementAt(n3);
                ++n3;
            }
            return nArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] getSelectedRow() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.fTable == null) {
                return new Object[0];
            }
            int n = this.fRows.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.fSelected.get(n2)) {
                    return this.getRow(n2);
                }
                ++n2;
            }
            return new Object[0];
        }
    }

    protected Object[][] getSelectedRows() {
        Object object = this.LOCK;
        synchronized (object) {
            Object[][] objectArray;
            int[] nArray = this.getSelectedIndexes();
            if (nArray.length == 0) {
                objectArray = new Object[0][0];
            } else {
                objectArray = new Object[nArray.length][this.fColumns.size()];
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = this.getRow(nArray[n]);
                    ++n;
                }
            }
            Object[][] objectArray2 = objectArray;
            Object var3_6 = null;
            return objectArray2;
        }
    }

    public void repaint() {
        this.fCaptionBar.repaint();
        this.fHScrollbar.repaint();
        this.fVScrollbar.repaint();
        this.fViewArea.repaint();
        super.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.fBorder) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.fSeparatorColor);
            int n = this.fCaptionBar.isBorderVisible() ? 0 : this.fCaptionBar.getSize().height;
            graphics.drawRect(0, n, dimension.width - 1, dimension.height - 1 - n);
        }
    }

    protected String paintHook(String string, int n, int n2) {
        return string;
    }

    protected boolean allowSelection(ListboxEvent listboxEvent) {
        return true;
    }

    protected void deliverEvent(EventObject eventObject) {
        if (eventObject instanceof ListboxEvent) {
            this.fireListboxEvent((ListboxEvent)eventObject);
            return;
        }
        if (eventObject instanceof CaptionBarEvent) {
            this.fireCaptionBarEvent((CaptionBarEvent)eventObject);
            return;
        }
        if (eventObject instanceof ItemEvent) {
            this.fireItemEvent((ItemEvent)eventObject);
            return;
        }
    }

    protected void fireListboxEvent(ListboxEvent listboxEvent) {
        Vector vector = (Vector)this.fListboxListeners.clone();
        int n = vector.size();
        if (listboxEvent.getID() == 2000) {
            int n2 = 0;
            while (n2 < n) {
                ((ListboxListener)vector.elementAt(n2)).rowSelected(listboxEvent);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            ((ListboxListener)vector.elementAt(n3)).rowDeselected(listboxEvent);
            ++n3;
        }
    }

    protected void fireItemEvent(ItemEvent itemEvent) {
        if (this.fItemListeners != null) {
            Vector vector = (Vector)this.fItemListeners.clone();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ItemListener)vector.elementAt(n2)).itemStateChanged(itemEvent);
                ++n2;
            }
        }
    }

    protected void fireCaptionBarEvent(CaptionBarEvent captionBarEvent) {
        Vector vector = (Vector)this.fCaptionBarListeners.clone();
        int n = vector.size();
        if (captionBarEvent.getID() == 2000) {
            int n2 = 0;
            while (n2 < n) {
                ((CaptionBarListener)vector.elementAt(n2)).captionSelected(captionBarEvent);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            ((CaptionBarListener)vector.elementAt(n3)).captionResized(captionBarEvent);
            ++n3;
        }
    }

    protected ListboxCaption createCaption() {
        return new ListboxCaption();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("model=" + this.fTable);
        if (this.fSelectable) {
            stringBuffer.append(",selection=");
            if (this.fMultipleSelections) {
                stringBuffer.append("multiple");
            } else {
                stringBuffer.append("single");
            }
        }
        if (this.fCaptionBar.isVisible()) {
            stringBuffer.append(",capbar");
        }
        if (this.fHSeparator) {
            stringBuffer.append(",hsep");
        }
        if (this.fVSeparator) {
            stringBuffer.append(",vsep");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    class EventHandler
    implements Serializable,
    TableListener,
    CaptionBarListener,
    FocusListener,
    MouseListener,
    KeyListener,
    AdjustmentListener {
        private MultiColumnListboxBase fParent;

        public void tableRefreshed(TableEvent tableEvent) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                if (tableEvent.getRow() != -1) {
                    int[] nArray = tableEvent.getIndexes();
                    IntegerVector integerVector = (IntegerVector)this.fParent.fRows.clone();
                    BitSet bitSet = new BitSet(nArray.length);
                    int n = 0;
                    while (n < nArray.length) {
                        integerVector.setElementAt(nArray[n], n);
                        if (this.fParent.fSelected.get(MultiColumnListboxBase.this.fRows.elementAt(n))) {
                            bitSet.set(n);
                        }
                        ++n;
                    }
                    this.fParent.fRows = integerVector;
                    this.fParent.fSelected = bitSet;
                } else if (tableEvent.getColumn() != -1) {
                    int[] nArray = tableEvent.getIndexes();
                    IntegerVector integerVector = (IntegerVector)this.fParent.fColumns.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        integerVector.setElementAt(nArray[n], n);
                        ++n;
                    }
                    this.fParent.fColumns = integerVector;
                }
            }
            this.fParent.doLayout();
        }

        public void tableChanged(TableEvent tableEvent) {
            this.fParent.setTableModel(MultiColumnListboxBase.this.fTable);
        }

        public void columnChanged(TableEvent tableEvent) {
            if (this.fParent.fUpdate) {
                this.fParent.fViewArea.repaint();
            }
        }

        public void rowChanged(TableEvent tableEvent) {
            this.elementChanged(tableEvent);
        }

        public void elementChanged(TableEvent tableEvent) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n = tableEvent.getRow();
                int n2 = this.fParent.fVScrollbar.getValue();
                int n3 = this.fParent.fVScrollbar.getVisibleAmount();
                if (this.fParent.fUpdate && n >= n2 && n < n2 + n3) {
                    this.fParent.fViewArea.repaint();
                }
                return;
            }
        }

        public void columnInfoChanged(TableEvent tableEvent) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                TableModel tableModel = this.fParent.fTable;
                synchronized (tableModel) {
                    int n = tableEvent.getColumn();
                    int n2 = this.fParent.fColumns.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        if (this.fParent.fColumns.elementAt(n3) == n) {
                            Caption caption = this.fParent.fCaptionBar.getCaption(n3);
                            caption.setLabel(this.fParent.fTable.getColumnInfo(n));
                            this.fParent.fCaptionBar.repaint();
                            break;
                        }
                        ++n3;
                    }
                }
                return;
            }
        }

        public void columnAdded(TableEvent tableEvent) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n = tableEvent.getColumn();
                ListboxCaption listboxCaption = this.fParent.createCaption();
                listboxCaption.setLabel(this.fParent.fTable.getColumnInfo(n));
                this.fParent.fCaptionBar.addCaption(listboxCaption);
                ListboxColumn listboxColumn = new ListboxColumn(this.fParent, MultiColumnListboxBase.this.fTable, n, listboxCaption);
                this.fParent.fColumnInfo.addElement(listboxColumn);
                this.fParent.fColumns.addElement(n);
                this.fParent.doLayout();
                return;
            }
        }

        public void columnRemoved(TableEvent tableEvent) {
            int n = tableEvent.getColumn();
            if (n == -2) {
                this.fParent.setTableModel(MultiColumnListboxBase.this.fTable);
                return;
            }
            Object object = this.fParent.LOCK;
            synchronized (object) {
                n = this.fParent.fColumns.indexOf(tableEvent.getColumn());
                this.fParent.fColumnInfo.removeElementAt(n);
                int n2 = this.fParent.fColumns.size();
                int n3 = tableEvent.getColumn() + 1;
                while (n3 < n2) {
                    int n4 = this.fParent.fColumns.indexOf(n3);
                    this.fParent.fColumns.setElementAt(this.fParent.fColumns.elementAt(n4) - 1, n4);
                    ++n3;
                }
                this.fParent.fColumns.removeElementAt(n);
                this.fParent.doLayout();
                return;
            }
        }

        public void columnInserted(TableEvent tableEvent) {
            this.columnAdded(tableEvent);
        }

        public void rowInfoChanged(TableEvent tableEvent) {
            if (this.fParent.fUpdate) {
                this.fParent.fCaptionBar.repaint();
            }
        }

        public void rowAdded(TableEvent tableEvent) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n = this.fParent.fRows.size();
                this.fParent.fRows.addElement(n);
                int n2 = this.fParent.fVScrollbar.getValue();
                int n3 = this.fParent.fVScrollbar.getMaximum();
                int n4 = this.fParent.fVScrollbar.getVisibleAmount();
                if (n3 - n2 < n4) {
                    this.fParent.fVScrollbar.setMaximum(n3 + 1);
                    if (this.fParent.fUpdate) {
                        this.fParent.fViewArea.repaint();
                    }
                } else {
                    this.fParent.doLayout();
                }
                return;
            }
        }

        public void rowRemoved(TableEvent tableEvent) {
            int n = tableEvent.getRow();
            Object object = this.fParent.LOCK;
            synchronized (object) {
                if (n == -2) {
                    this.fParent.fRows = new IntegerVector();
                    this.fParent.fSelected = new BitSet();
                    this.fParent.fFocusLine = 0;
                    this.fParent.fLastSelected = -1;
                } else {
                    int n2 = this.fParent.fRows.size();
                    int n3 = this.fParent.fRows.indexOf(n);
                    while (n3 < n2 - 1) {
                        if (this.fParent.fSelected.get(n3 + 1)) {
                            this.fParent.fSelected.set(n3);
                        } else {
                            this.fParent.fSelected.clear(n3);
                        }
                        ++n3;
                    }
                    this.fParent.fSelected.clear(n2 - 1);
                    int n4 = n + 1;
                    while (n4 < n2) {
                        int n5 = this.fParent.fRows.indexOf(n4);
                        int n6 = this.fParent.fRows.elementAt(n5) - 1;
                        this.fParent.fRows.setElementAt(n6, n5);
                        ++n4;
                    }
                    if (n < this.fParent.fLastSelected) {
                        --this.fParent.fLastSelected;
                    } else if (n == this.fParent.fLastSelected) {
                        this.fParent.fLastSelected = 0;
                    }
                    if (n < this.fParent.fFocusLine) {
                        --this.fParent.fFocusLine;
                    } else if (n == this.fParent.fFocusLine) {
                        this.fParent.fFocusLine = 0;
                    }
                    this.fParent.fRows.removeElementAt(this.fParent.fRows.indexOf(n));
                }
            }
            this.fParent.doLayout();
        }

        public void rowInserted(TableEvent tableEvent) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n;
                int n2 = tableEvent.getRow();
                int n3 = this.fParent.fRows.size();
                int n4 = n3 - 1;
                while (n4 >= n2) {
                    n = this.fParent.fRows.indexOf(n4);
                    int n5 = this.fParent.fRows.elementAt(n) + 1;
                    this.fParent.fRows.setElementAt(n5, n);
                    --n4;
                }
                if (this.fParent.fListboxTable) {
                    this.fParent.fRows.insertElementAt(n2, n2);
                    n = this.fParent.fRows.size();
                    while (n > n2) {
                        if (this.fParent.fSelected.get(n - 1)) {
                            this.fParent.fSelected.set(n);
                        } else {
                            this.fParent.fSelected.clear(n);
                        }
                        --n;
                    }
                    this.fParent.fSelected.clear(n2);
                    if (n2 <= this.fParent.fLastSelected) {
                        ++this.fParent.fLastSelected;
                    }
                    if (n2 <= this.fParent.fFocusLine) {
                        ++this.fParent.fFocusLine;
                    }
                } else {
                    this.fParent.fRows.addElement(n2);
                }
            }
            this.fParent.doLayout();
        }

        public void captionSelected(CaptionBarEvent captionBarEvent) {
            MultiColumnListboxBase.this.requestFocus();
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n = captionBarEvent.getCaption();
                ListboxCaption listboxCaption = (ListboxCaption)this.fParent.fCaptionBar.getCaption(n);
                ListboxColumn listboxColumn = (ListboxColumn)this.fParent.fColumnInfo.elementAt(n);
                if (listboxColumn.isSortable()) {
                    if (n == this.fParent.fLastCaptionSelected) {
                        listboxCaption.setState(!listboxCaption.getState());
                        this.fParent.fCaptionBar.repaint();
                        if (listboxCaption.getState()) {
                            listboxColumn.getSorter().setSortOrder(0);
                        } else {
                            listboxColumn.getSorter().setSortOrder(1);
                        }
                    }
                    this.fParent.fLastCaptionSelected = n;
                    this.fParent.sort();
                }
            }
            this.fParent.fireCaptionBarEvent(captionBarEvent);
        }

        public void captionResized(CaptionBarEvent captionBarEvent) {
            CaptionBar captionBar = (CaptionBar)captionBarEvent.getSource();
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n = captionBarEvent.getCaption();
                if (captionBarEvent.getClickCount() > 1) {
                    this.fParent.autoSizeColumn(n);
                } else {
                    Caption caption = captionBar.getCaption(n);
                    ListboxColumn listboxColumn = (ListboxColumn)this.fParent.fColumnInfo.elementAt(n);
                    listboxColumn.setWidth(caption.getLength());
                }
            }
            this.fParent.fireCaptionBarEvent(captionBarEvent);
        }

        public synchronized void focusGained(FocusEvent focusEvent) {
            this.fParent.fHasFocus = true;
            this.fParent.repaint();
        }

        public synchronized void focusLost(FocusEvent focusEvent) {
            this.fParent.fHasFocus = false;
            this.fParent.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.fParent.requestFocus();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (!this.fParent.fHasFocus) {
                this.fParent.requestFocus();
            }
            if (object != this.fParent.fViewArea) return;
            ListboxEvent listboxEvent = null;
            Object object2 = this.fParent.LOCK;
            synchronized (object2) {
                boolean bl;
                int n;
                int n2;
                block31: {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    boolean bl2;
                    int n7;
                    block33: {
                        boolean bl3;
                        block32: {
                            if (!this.fParent.fSelectable) return;
                            if (this.fParent.fTable == null) {
                                return;
                            }
                            int n8 = this.fParent.fColumns.size();
                            if (n8 < 1) {
                                return;
                            }
                            int n9 = mouseEvent.getX();
                            int n10 = mouseEvent.getY();
                            n7 = mouseEvent.getModifiers();
                            bl3 = mouseEvent.isShiftDown();
                            bl2 = mouseEvent.isControlDown();
                            boolean bl4 = mouseEvent.isAltDown();
                            boolean bl5 = mouseEvent.isMetaDown();
                            n6 = -1;
                            n5 = -1;
                            int n11 = this.fParent.fVScrollbar.getValue();
                            this.fParent.fVScrollbar.getVisibleAmount();
                            int n12 = n10 / this.fParent.fRowHeight + n11;
                            if (n12 >= this.fParent.fRows.size()) {
                                return;
                            }
                            long l = System.currentTimeMillis();
                            this.fParent.fClickCount = n12 != this.fParent.fMouseDownRow ? 1 : (l - MultiColumnListboxBase.this.fClickTime < 400L ? ++this.fParent.fClickCount : 1);
                            this.fParent.fMouseDownRow = n12;
                            this.fParent.fClickTime = l;
                            n6 = this.fParent.fMouseDownRow;
                            if (n6 < 0) return;
                            if (n6 >= this.fParent.fRows.size()) {
                                return;
                            }
                            n2 = this.fParent.fLastSelected;
                            n = this.fParent.fFocusLine;
                            bl = this.fParent.getUpdate();
                            n6 = n10 / this.fParent.fRowHeight + n11;
                            int n13 = this.fParent.fHScrollbar != null ? -this.fParent.fHScrollbar.getValue() : 0;
                            int n14 = this.fParent.fCaptionBar.getCaptionCount();
                            int n15 = 0;
                            while (n15 < n14) {
                                Caption caption = this.fParent.fCaptionBar.getCaption(n15);
                                if (caption.isVisible()) {
                                    n4 = caption.getLength();
                                    if (n9 >= n13 && n9 < n13 + n4) {
                                        n5 = n15;
                                        break;
                                    }
                                    n13 += n4;
                                }
                                ++n15;
                            }
                            if (n5 == -1) {
                                n3 = 0;
                                n4 = 0;
                            } else {
                                n3 = n9 - n13;
                                n4 = n10 - (n6 - n11) * this.fParent.fRowHeight;
                            }
                            if (!bl5) break block32;
                            if (n7 == 4 || bl4) {
                                n2 = n = n6;
                                listboxEvent = new ListboxEvent(this.fParent, 2000, n, n5, this.fParent.fClickCount, n7, n3, n4);
                                if (!this.fParent.allowSelection(listboxEvent)) {
                                    return;
                                }
                                this.fParent.setUpdate(false);
                                this.fParent.deselectAllRows();
                                this.fParent.selectRow(n);
                                break block31;
                            } else {
                                listboxEvent = new ListboxEvent(this.fParent, 2000, n2, n5, this.fParent.fClickCount, n7, n3, n4);
                                if (!this.fParent.allowSelection(listboxEvent)) {
                                    return;
                                }
                            }
                            break block31;
                        }
                        if (!bl3) break block33;
                        n = n6;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n, n5, this.fParent.fClickCount, n7, n3, n4);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        if (!bl2) {
                            this.fParent.deselectAllRows();
                        }
                        if (this.fParent.fMultipleSelections) {
                            if (n2 < n) {
                                int n16 = n2;
                                while (n16 <= n) {
                                    this.fParent.selectRow(n16);
                                    ++n16;
                                }
                                break block31;
                            } else {
                                int n17 = n;
                                while (n17 <= n2) {
                                    this.fParent.selectRow(n17);
                                    ++n17;
                                }
                            }
                            break block31;
                        } else {
                            this.fParent.selectRow(n);
                        }
                        break block31;
                    }
                    if (bl2) {
                        n2 = n = n6;
                        int n18 = this.fParent.fSelected.get(n) ? 2001 : 2000;
                        listboxEvent = new ListboxEvent(this.fParent, n18, n, n5, this.fParent.fClickCount, n7, n3, n4);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        if (n18 == 2000) {
                            this.fParent.selectRow(n);
                        } else {
                            this.fParent.deselectRow(n);
                        }
                    } else {
                        n2 = n = n6;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n, n5, this.fParent.fClickCount, n7, n3, n4);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        this.fParent.selectRow(n);
                    }
                }
                this.fParent.fLastSelected = n2;
                this.fParent.fFocusLine = n;
                this.fParent.setUpdate(bl);
            }
            if (listboxEvent == null) return;
            this.fParent.deliverEvent(listboxEvent);
            if (this.fParent.fItemListeners == null) return;
            object2 = new Integer(listboxEvent.getRow());
            int n = listboxEvent.getID() == 2000 ? 1 : 2;
            ItemEvent itemEvent = new ItemEvent(this.fParent, 701, object2, n);
            this.fParent.deliverEvent(itemEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void keyPressed(KeyEvent keyEvent) {
            if (!this.fParent.fHasFocus) {
                this.fParent.requestFocus();
            }
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            boolean bl = keyEvent.isShiftDown();
            boolean bl2 = keyEvent.isControlDown();
            boolean bl3 = keyEvent.isAltDown();
            switch (n) {
                case 9: {
                    this.fParent.transferFocus();
                    return;
                }
                case 37: 
                case 39: {
                    Object object = this.fParent.LOCK;
                    synchronized (object) {
                        int n3 = this.fParent.fHScrollbar.getValue();
                        int n4 = 0;
                        if (n == 39) {
                            this.fParent.fHScrollbar.setValue(n3 + 1);
                            n4 = 1;
                        } else {
                            this.fParent.fHScrollbar.setValue(n3 - 1);
                            n4 = 2;
                        }
                        int n5 = this.fParent.fHScrollbar.getValue();
                        if (n3 == n5) return;
                        AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this.fParent.fHScrollbar, 601, n4, n5);
                        this.adjustmentValueChanged(adjustmentEvent);
                        return;
                    }
                }
            }
            if (bl3) {
                return;
            }
            ListboxEvent listboxEvent = null;
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n6 = this.fParent.fLastSelected;
                int n7 = this.fParent.fFocusLine;
                int n8 = this.fParent.fVScrollbar.getValue();
                int n9 = this.fParent.fVScrollbar.getVisibleAmount();
                int n10 = this.fParent.fRows.size() - 1;
                boolean bl4 = this.fParent.getUpdate();
                if (!this.fParent.fSelectable) {
                    bl = false;
                    bl3 = false;
                    bl2 = true;
                }
                boolean bl5 = bl && this.fParent.getMultipleSelections();
                switch (n) {
                    case 32: {
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.selectRow(n7);
                        break;
                    }
                    case 10: {
                        if (!this.fParent.fSelected.get(n7)) {
                            return;
                        }
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 2, n2);
                        if (this.fParent.allowSelection(listboxEvent)) break;
                        return;
                    }
                    case 36: {
                        if (n7 == 0) {
                            return;
                        }
                        n7 = 0;
                        n8 = 0;
                        if (!bl5 && !bl2) {
                            n6 = n7;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        if (bl5 && this.fParent.fMultipleSelections) {
                            int n11 = n7;
                            while (n11 <= n6) {
                                this.fParent.selectRow(n11);
                                ++n11;
                            }
                            break;
                        } else {
                            this.fParent.selectRow(n7);
                            break;
                        }
                    }
                    case 33: {
                        if (n7 == 0) {
                            return;
                        }
                        if (n7 == n8) {
                            if ((n7 -= n9) < 0) {
                                n7 = 0;
                            }
                            n8 = n7;
                        } else {
                            n7 = n8;
                        }
                        if (!bl5 && !bl2) {
                            n6 = n7;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        if (bl5 && this.fParent.fMultipleSelections) {
                            if (n6 < n7) {
                                int n12 = n6;
                                while (n12 <= n7) {
                                    this.fParent.selectRow(n12);
                                    ++n12;
                                }
                            } else {
                                int n13 = n7;
                                while (n13 <= n6) {
                                    this.fParent.selectRow(n13);
                                    ++n13;
                                }
                            }
                            break;
                        }
                        this.fParent.selectRow(n7);
                        break;
                    }
                    case 38: {
                        if (n7 == 0) {
                            return;
                        }
                        if (--n7 < n8 || n7 > n8 + n9) {
                            n8 = n7;
                        }
                        if (!bl5 && !bl2) {
                            n6 = n7;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        if (bl5 && this.fParent.fMultipleSelections) {
                            if (n6 < n7) {
                                int n14 = n6;
                                while (n14 <= n7) {
                                    this.fParent.selectRow(n14);
                                    ++n14;
                                }
                            } else {
                                int n15 = n7;
                                while (n15 <= n6) {
                                    this.fParent.selectRow(n15);
                                    ++n15;
                                }
                            }
                            break;
                        }
                        this.fParent.selectRow(n7);
                        break;
                    }
                    case 40: {
                        if (n7 == n10) {
                            return;
                        }
                        if (++n7 < n8 || n7 > n8 + n9) {
                            n8 = n7;
                        } else if (n7 == n8 + n9) {
                            ++n8;
                        }
                        if (!bl5 && !bl2) {
                            n6 = n7;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        if (bl5 && this.fParent.fMultipleSelections) {
                            if (n6 < n7) {
                                int n16 = n6;
                                while (n16 <= n7) {
                                    this.fParent.selectRow(n16);
                                    ++n16;
                                }
                            } else {
                                int n17 = n7;
                                while (n17 <= n6) {
                                    this.fParent.selectRow(n17);
                                    ++n17;
                                }
                            }
                            break;
                        }
                        this.fParent.selectRow(n7);
                        break;
                    }
                    case 34: {
                        if (n7 == n10) {
                            return;
                        }
                        if (n7 == n8 + n9 - 1) {
                            if ((n7 += n9) > n10) {
                                n7 = n10;
                            }
                            n8 += n9;
                        } else {
                            n7 = n8 + n9 - 1;
                            if (n7 > n10) {
                                n7 = n10;
                            }
                        }
                        if (!bl5 && !bl2) {
                            n6 = n7;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        if (bl5 && this.fParent.fMultipleSelections) {
                            if (n6 < n7) {
                                int n18 = n6;
                                while (n18 <= n7) {
                                    this.fParent.selectRow(n18);
                                    ++n18;
                                }
                            } else {
                                int n19 = n7;
                                while (n19 <= n6) {
                                    this.fParent.selectRow(n19);
                                    ++n19;
                                }
                            }
                            break;
                        }
                        this.fParent.selectRow(n7);
                        break;
                    }
                    case 35: {
                        if (n7 == n10) {
                            return;
                        }
                        n7 = n10;
                        if (n7 > n8 + n9 - 1 && (n8 = n7 - n9 + 1) < 0) {
                            n8 = 0;
                        }
                        if (!bl5 && !bl2) {
                            n6 = n7;
                        }
                        if (bl2) break;
                        listboxEvent = new ListboxEvent(this.fParent, 2000, n7, -1, 1, n2);
                        if (!this.fParent.allowSelection(listboxEvent)) {
                            return;
                        }
                        this.fParent.setUpdate(false);
                        this.fParent.deselectAllRows();
                        if (bl5 && this.fParent.fMultipleSelections) {
                            int n20 = n6;
                            while (n20 <= n7) {
                                this.fParent.selectRow(n20);
                                ++n20;
                            }
                            break;
                        } else {
                            this.fParent.selectRow(n7);
                            break;
                        }
                    }
                    default: {
                        return;
                    }
                }
                this.fParent.fLastSelected = n6;
                this.fParent.fFocusLine = n7;
                this.fParent.fVScrollbar.setValue(n8);
                this.fParent.setUpdate(bl4);
            }
            if (listboxEvent == null) return;
            MultiColumnListboxBase.this.deliverEvent(listboxEvent);
            if (this.fParent.fItemListeners == null) return;
            object = new ItemEvent(this.fParent, 701, new Integer(listboxEvent.getRow()), 1);
            MultiColumnListboxBase.this.deliverEvent((EventObject)object);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            Object object2 = this.fParent.LOCK;
            synchronized (object2) {
                if (object == this.fParent.fHScrollbar) {
                    this.fParent.fCaptionBar.repaint();
                }
                this.fParent.fViewArea.repaint();
                return;
            }
        }

        EventHandler() {
            this.fParent = MultiColumnListboxBase.this = MultiColumnListboxBase.this;
        }
    }

    class ViewArea
    extends Panel {
        private MultiColumnListboxBase fParent;
        private transient Image fBuffer;
        private transient Graphics fBufferGraphics;
        private transient Dimension fBufferSize;
        private transient Hashtable fComponents;

        public ViewArea() {
            this.fParent = MultiColumnListboxBase.this = MultiColumnListboxBase.this;
            this.init();
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.init();
        }

        private void init() {
            this.fComponents = new Hashtable();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            Object object = this.fParent.LOCK;
            synchronized (object) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                Dimension dimension = this.getSize();
                Graphics graphics2 = this.fBufferGraphics;
                try {
                    if (this.fBuffer == null || this.fBufferSize.width != dimension.width || this.fBufferSize.height != dimension.height) {
                        if (this.fBuffer != null) {
                            this.fBuffer.flush();
                            this.fBuffer = null;
                            this.fBufferGraphics.dispose();
                        }
                        this.fBufferSize = this.getSize();
                        this.fBuffer = this.createImage(this.fBufferSize.width, this.fBufferSize.height);
                        graphics2 = this.fBufferGraphics = this.fBuffer.getGraphics();
                    }
                }
                catch (Exception exception) {
                    graphics2 = graphics;
                }
                if (this.fParent.fBackgroundImage == null) {
                    graphics2.setColor(this.fParent.getBackground());
                    graphics2.fillRect(0, 0, dimension.width, dimension.height);
                } else {
                    n6 = this.fParent.fBackgroundImage.getWidth(this);
                    n5 = this.fParent.fBackgroundImage.getHeight(this);
                    int n7 = dimension.width / n6 + 2;
                    int n8 = dimension.height / n5 + 2;
                    n4 = MultiColumnListboxBase.this.fHScrollbar.getValue();
                    int n9 = MultiColumnListboxBase.this.fVScrollbar.getValue() * MultiColumnListboxBase.this.fRowHeight;
                    n3 = n4 / n6;
                    n2 = n9 / n5;
                    n4 -= n3 * n6;
                    n9 -= n2 * n5;
                    n = 0;
                    while (n < n7) {
                        int n10 = 0;
                        while (n10 < n8) {
                            int n11 = n * n6 - n4;
                            int n12 = n10 * n5 - n9;
                            graphics2.drawImage(MultiColumnListboxBase.this.fBackgroundImage, n11, n12, this);
                            ++n10;
                        }
                        ++n;
                    }
                }
                if (this.fParent.fTable != null) {
                    n6 = 0;
                    if (this.fParent.fHScrollbar.isVisible()) {
                        n6 = this.fParent.fHScrollbar.getPreferredSize().height;
                    }
                    n5 = 0;
                    if (this.fParent.fVScrollbar.isVisible()) {
                        n5 = this.fParent.fVScrollbar.getPreferredSize().width;
                    }
                    TableModel tableModel = this.fParent.fTable;
                    synchronized (tableModel) {
                        n4 = this.fParent.fTable.getRowCount();
                        if (n4 == 0) {
                            this.removeAll();
                        } else {
                            Component[] componentArray = this.getComponents();
                            this.fComponents.clear();
                            n3 = 0;
                            while (n3 < componentArray.length) {
                                this.fComponents.put(componentArray[n3], Boolean.FALSE);
                                ++n3;
                            }
                            n2 = 0;
                            n = this.fParent.fVScrollbar.getValue();
                            while (n < n4) {
                                this.paintRow(graphics2, n);
                                if ((n2 += this.fParent.fRowHeight) > dimension.height) break;
                                ++n;
                            }
                            Enumeration enumeration = this.fComponents.keys();
                            while (enumeration.hasMoreElements()) {
                                Component component = (Component)enumeration.nextElement();
                                Boolean bl = (Boolean)this.fComponents.get(component);
                                if (bl.booleanValue()) continue;
                                this.remove(component);
                            }
                        }
                    }
                }
                if (this.fBuffer != null && this.fBufferGraphics == graphics2) {
                    graphics.drawImage(this.fBuffer, 0, 0, this);
                }
                return;
            }
        }

        public void paintRow(Graphics graphics, int n) {
            Serializable serializable;
            int n2;
            int n3 = MultiColumnListboxBase.this.fRows.elementAt(n);
            Dimension dimension = this.getSize();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fParent.getFont());
            int n4 = -this.fParent.fHScrollbar.getValue();
            int n5 = (n - this.fParent.fVScrollbar.getValue()) * this.fParent.fRowHeight;
            boolean bl = this.fParent.fSelected.get(n);
            if (bl) {
                graphics.setColor(this.fParent.fSelectionBackground);
                graphics.fillRect(0, n5, dimension.width, MultiColumnListboxBase.this.fRowHeight);
            }
            int n6 = this.fParent.fTable.getColumnCount();
            int n7 = 0;
            while (n7 < n6) {
                n2 = this.fParent.fColumns.elementAt(n7);
                serializable = (ListboxColumn)this.fParent.fColumnInfo.elementAt(n2);
                if (((ListboxColumn)serializable).isVisible()) {
                    int n8 = ((ListboxColumn)serializable).getWidth();
                    if (n4 + n8 < 0) {
                        n4 += n8;
                    } else {
                        Object object;
                        graphics.setClip(n4, n5, n8, MultiColumnListboxBase.this.fRowHeight);
                        if (bl) {
                            graphics.setColor(this.fParent.fSelectionForeground);
                        } else {
                            object = ((ListboxColumn)serializable).getBackground();
                            if (object != null) {
                                graphics.setColor((Color)object);
                                graphics.fillRect(n4, n5, n8, this.fParent.fRowHeight);
                            }
                            if ((object = ((ListboxColumn)serializable).getForeground()) == null) {
                                object = this.fParent.getForeground();
                            }
                            graphics.setColor((Color)object);
                        }
                        if (this.fParent.fVSeparator || this.fParent.fHSeparator) {
                            graphics.setClip(n4, n5, n8 - (this.fParent.fVSeparator ? 3 : 2), this.fParent.fRowHeight - (this.fParent.fHSeparator ? 1 : 0));
                        }
                        if ((object = this.fParent.fTable.getElement(n3, n2)) != null) {
                            Alignment alignment;
                            Object object2;
                            Object object3;
                            Object object4;
                            if (object instanceof Component) {
                                object4 = (Component)object;
                                if (!this.fComponents.containsKey(object4)) {
                                    ((Component)object4).setVisible(false);
                                    this.add((Component)object4);
                                }
                                Rectangle rectangle = ((Component)object4).getBounds();
                                if (rectangle.x != n4 || rectangle.y != n5) {
                                    ((Component)object4).setLocation(n4, n5);
                                }
                                if (rectangle.width != n8 || rectangle.height != MultiColumnListboxBase.this.fRowHeight) {
                                    ((Component)object4).setSize(n8, MultiColumnListboxBase.this.fHSeparator ? MultiColumnListboxBase.this.fRowHeight - 1 : MultiColumnListboxBase.this.fRowHeight);
                                    ((Component)object4).doLayout();
                                }
                                if (!((Component)object4).isVisible()) {
                                    ((Component)object4).setVisible(true);
                                }
                                if (((Component)object4).isVisible() && !(object4 instanceof Canvas) && !(object4 instanceof Panel)) {
                                    object3 = ((Component)object4).getBounds();
                                    object2 = graphics.create(((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height);
                                    try {
                                        ((Component)object4).paint((Graphics)object2);
                                    }
                                    finally {
                                        alignment = null;
                                        ((Graphics)object2).dispose();
                                    }
                                }
                                this.fComponents.remove(object4);
                                this.fComponents.put(object4, Boolean.TRUE);
                            } else if (object instanceof Paintable) {
                                object4 = graphics.getClipBounds();
                                Graphics graphics2 = graphics.create(((Rectangle)object4).x, ((Rectangle)object4).y, ((Rectangle)object4).width, ((Rectangle)object4).height);
                                ((Paintable)object).paint(graphics2);
                                graphics2.dispose();
                            } else {
                                object4 = this.fParent.paintHook(object.toString(), n, n7);
                                int n9 = fontMetrics.getAscent() + 2 + n5;
                                object3 = new StringTokenizer((String)object4, "\n");
                                while (((StringTokenizer)object3).hasMoreTokens()) {
                                    object2 = ((StringTokenizer)object3).nextToken();
                                    int n10 = 2 + n4;
                                    alignment = ((ListboxColumn)serializable).getAlignment();
                                    if (alignment.isCenter()) {
                                        n10 += (n8 - fontMetrics.stringWidth((String)object2)) / 2;
                                    } else if (alignment.isRight()) {
                                        n10 += n8 - 4 - fontMetrics.stringWidth((String)object2);
                                    }
                                    graphics.drawString((String)object2, n10, n9);
                                    n9 += fontMetrics.getHeight();
                                }
                            }
                        }
                        graphics.setClip(0, 0, dimension.width, dimension.height);
                        if (this.fParent.fVSeparator) {
                            graphics.setColor(this.fParent.fSeparatorColor);
                            graphics.drawLine(n4 + n8 - 1, n5, n4 + n8 - 1, n5 + this.fParent.fRowHeight - 1);
                        }
                        if ((n4 += n8) > dimension.width) break;
                    }
                }
                ++n7;
            }
            if (this.fParent.fHSeparator) {
                graphics.setColor(this.fParent.fSeparatorColor);
                graphics.drawLine(0, n5 + MultiColumnListboxBase.this.fRowHeight - 1, dimension.width - 1, n5 + MultiColumnListboxBase.this.fRowHeight - 1);
            }
            if (this.fParent.fHasFocus && n == this.fParent.fFocusLine) {
                n2 = this.fParent.fRowHeight - (this.fParent.fHSeparator ? 1 : 0);
                serializable = bl ? this.fParent.fSelectionForeground : this.fParent.getForeground();
                this.drawDashedBorder(graphics, (Color)serializable, 0, n5, dimension.width, n2);
            }
        }

        private void drawDashedBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            int n5 = n2 % 2 == 0 ? 0 : 1;
            int n6 = n;
            while (n6 < n + n3) {
                if (n6 % 2 == n5) {
                    graphics.drawLine(n6, n2, n6, n2);
                }
                ++n6;
            }
            n5 = (n2 + n4 - 1) % 2 == 0 ? 0 : 1;
            int n7 = n;
            while (n7 < n + n3) {
                if (n7 % 2 == n5) {
                    graphics.drawLine(n7, n2 + n4 - 1, n7, n2 + n4 - 1);
                }
                ++n7;
            }
            n5 = n % 2 == 0 ? 0 : 1;
            int n8 = n2;
            while (n8 < n2 + n4) {
                if (n8 % 2 == n5) {
                    graphics.drawLine(n, n8, n, n8);
                }
                ++n8;
            }
            n5 = (n + n3 - 1) % 2 == 0 ? 0 : 1;
            int n9 = n2;
            while (n9 < n2 + n4) {
                if (n9 % 2 == n5) {
                    graphics.drawLine(n + n3 - 1, n9, n + n3 - 1, n9);
                }
                ++n9;
            }
            graphics.setColor(color2);
        }
    }
}

