/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.ProgressBarDirection;
import com.ibm.webrunner.widget.ProgressBarOrientation;
import com.ibm.webrunner.widget.ProgressBarStyle;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ProgressBar
extends Canvas
implements Runnable,
AdjustmentListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final ProgressBarOrientation DEFAULT_ORIENTATION = ProgressBarOrientation.HORIZONTAL;
    public static final int SOLID = 0;
    public static final int BLOCK = 1;
    public static final int STRIPED = 2;
    public static final ProgressBarStyle DEFAULT_STYLE = ProgressBarStyle.SOLID;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final ProgressBarDirection DEFAULT_DIRECTION = ProgressBarDirection.RIGHT;
    public static final Color DEFAULT_COLOR = Color.blue;
    public static final Color DEFAULT_FOREGROUND = Color.blue;
    public static final Color DEFAULT_BACKGROUND = Color.lightGray;
    public static final int DEFAULT_MIN = 0;
    public static final int DEFAULT_MAX = 100;
    public static final int DEFAULT_DELAY = 250;
    public static final boolean DEFAULT_PERCENT = false;
    private transient PropertyChangeSupport fChanges;
    private boolean fNameSet = false;
    private static int fNumber;
    private ProgressBarOrientation fOrientation = DEFAULT_ORIENTATION;
    private ProgressBarStyle fStyle = DEFAULT_STYLE;
    private ProgressBarDirection fDirection = DEFAULT_DIRECTION;
    private boolean fPercent = false;
    private int fMinimum = 0;
    private int fMaximum = 100;
    private int fValue = 0;
    private transient Image fSolidBuffer;
    private transient Graphics fSolidBufferGraphics;
    private transient Dimension fSolidBufferSize;
    private transient Image fBlockBuffer;
    private transient Dimension fBlockBufferSize;
    private transient Image fStripeBuffer;
    private transient Dimension fStripeBufferSize;
    private transient Thread fThread;
    private int fDelay = 250;

    public ProgressBar() {
        this.init();
        if (!this.fNameSet) {
            int n = fNumber++;
            this.setName("progress" + n);
            this.setForeground(DEFAULT_FOREGROUND);
            this.setBackground(DEFAULT_BACKGROUND);
            this.fNameSet = true;
        }
    }

    public ProgressBar(int n) {
        this();
        this.setStyle(ProgressBarStyle.SOLID);
    }

    public ProgressBar(int n, int n2) {
        this();
        this.fMinimum = n;
        this.fMaximum = n2;
    }

    private void init() {
        this.fChanges = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fChanges.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fChanges.removePropertyChangeListener(propertyChangeListener);
    }

    public void run() {
        try {
            while (true) {
                this.repaint();
                this.fValue += 2;
                Thread.sleep(this.fDelay);
            }
        }
        catch (InterruptedException interruptedException) {
            this.fThread = null;
            this.fStyle = ProgressBarStyle.SOLID;
            this.fValue = this.fMinimum;
            this.repaint();
            return;
        }
    }

    public void setDelay(int n) {
        this.fDelay = n;
    }

    public int getDelay() {
        return this.fDelay;
    }

    public void setBackground(Color color) {
        this.flushResources();
        Color color2 = this.getBackground();
        super.setBackground(color);
        this.fChanges.firePropertyChange("background", color2, color);
    }

    public void setForeground(Color color) {
        this.flushResources();
        Color color2 = this.getForeground();
        super.setForeground(color);
        this.fChanges.firePropertyChange("foreground", color2, color);
    }

    private void flushResources() {
        if (this.fSolidBuffer != null) {
            this.fSolidBuffer.flush();
        }
        this.fSolidBuffer = null;
        if (this.fBlockBuffer != null) {
            this.fBlockBuffer.flush();
        }
        this.fBlockBuffer = null;
        if (this.fStripeBuffer != null) {
            this.fStripeBuffer.flush();
        }
        this.fStripeBuffer = null;
    }

    public synchronized void setOrientation(ProgressBarOrientation progressBarOrientation) {
        if (!this.fOrientation.equals(progressBarOrientation)) {
            ProgressBarOrientation progressBarOrientation2 = this.fOrientation;
            this.fOrientation = progressBarOrientation;
            this.fChanges.firePropertyChange("orientation", progressBarOrientation2, progressBarOrientation);
            if (progressBarOrientation.isVertical()) {
                if (!this.fDirection.isUp() && !this.fDirection.isDown()) {
                    if (this.fDirection.isRight()) {
                        this.setDirection(ProgressBarDirection.UP);
                    } else {
                        this.setDirection(ProgressBarDirection.DOWN);
                    }
                }
            } else if (!this.fDirection.isRight() && !this.fDirection.isLeft()) {
                if (this.fDirection.isUp()) {
                    this.setDirection(ProgressBarDirection.RIGHT);
                } else {
                    this.setDirection(ProgressBarDirection.LEFT);
                }
            }
            this.flushResources();
            this.repaint();
        }
    }

    public ProgressBarOrientation getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int n) {
        switch (n) {
            case 0: {
                this.setOrientation(ProgressBarOrientation.HORIZONTAL);
                return;
            }
        }
        this.setOrientation(ProgressBarOrientation.VERTICAL);
    }

    public synchronized void setStyle(ProgressBarStyle progressBarStyle) {
        if (!this.fStyle.equals(progressBarStyle)) {
            if (this.fStyle.isStriped()) {
                this.stop();
            }
            this.fStyle = progressBarStyle;
            if (progressBarStyle.isStriped()) {
                this.start();
                return;
            }
            this.repaint();
        }
    }

    public ProgressBarStyle getStyle() {
        return this.fStyle;
    }

    public synchronized void setDirection(ProgressBarDirection progressBarDirection) {
        if (!this.fDirection.equals(progressBarDirection)) {
            ProgressBarDirection progressBarDirection2 = this.fDirection;
            this.fDirection = progressBarDirection;
            this.fChanges.firePropertyChange("direction", progressBarDirection2, progressBarDirection);
            if (progressBarDirection.isRight() || progressBarDirection.isLeft()) {
                if (this.fOrientation.isVertical()) {
                    this.setOrientation(ProgressBarOrientation.HORIZONTAL);
                }
            } else if (this.fOrientation.isHorizontal()) {
                this.setOrientation(ProgressBarOrientation.VERTICAL);
            }
            this.flushResources();
            this.repaint();
        }
    }

    public ProgressBarDirection getDirection() {
        return this.fDirection;
    }

    public void setPercent(boolean bl) {
        if (this.fPercent != bl) {
            this.fPercent = bl;
            this.repaint();
        }
    }

    public boolean getPercent() {
        return this.fPercent;
    }

    public synchronized void add(int n) {
        if (this.fValue < this.fMaximum) {
            this.fValue = this.fValue + n <= this.fMaximum ? (this.fValue + n < this.fMinimum ? this.fMinimum : (this.fValue += n)) : this.fMaximum;
            this.repaint();
        }
    }

    public void setMin(int n) {
        this.setMinimum(n);
    }

    public synchronized void setMinimum(int n) {
        if (this.fMinimum != n) {
            this.fMinimum = n;
            if (this.fValue < this.fMinimum) {
                this.fValue = this.fMinimum;
            }
            if (!this.fStyle.isStriped()) {
                this.repaint();
            }
        }
    }

    public int getMin() {
        return this.getMinimum();
    }

    public int getMinimum() {
        return this.fMinimum;
    }

    public void setMax(int n) {
        this.setMaximum(n);
    }

    public synchronized void setMaximum(int n) {
        if (this.fMaximum != n) {
            this.fMaximum = n;
            if (this.fValue > this.fMaximum) {
                this.fValue = this.fMaximum;
            }
            if (!this.fStyle.isStriped()) {
                this.repaint();
            }
        }
    }

    public int getMax() {
        return this.getMaximum();
    }

    public int getMaximum() {
        return this.fMaximum;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setValue(adjustmentEvent.getValue());
    }

    public synchronized void setValue(int n) {
        int n2 = this.fValue;
        if (n < this.fMinimum) {
            this.fValue = 0;
        } else if (n > this.fMaximum) {
            this.fValue = this.fMaximum;
        } else if (this.fValue != n) {
            this.fValue = n;
        }
        this.fChanges.firePropertyChange("value", new Integer(n2), new Integer(this.fValue));
        this.repaint();
    }

    public int getValue() {
        return this.fValue;
    }

    public void reset() {
        if (this.fValue != this.fMinimum) {
            this.fValue = this.fMinimum;
            this.repaint();
        }
    }

    public void start() {
        if (this.fStyle.isStriped()) {
            if (this.fThread != null) {
                this.fThread.stop();
            }
            this.fThread = new Thread(this);
            this.fThread.start();
        }
    }

    public void stop() {
        if (this.fStyle.isStriped() && this.fThread != null) {
            this.fThread.stop();
            this.fThread = null;
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = 100;
        int n2 = 20;
        if (this.fOrientation.isHorizontal()) {
            try {
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
                n2 = 4 + fontMetrics.getHeight();
            }
            catch (Exception exception) {}
        } else {
            n = 20;
            n2 = 100;
        }
        return new Dimension(n, n2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        if (!this.fStyle.isStriped()) {
            double d = this.fValue - this.fMinimum;
            double d2 = this.fMaximum - this.fMinimum;
            if (this.fOrientation.isHorizontal()) {
                n = (int)((double)dimension.width * (d / d2));
                n2 = dimension.width;
            } else {
                n = (int)((double)dimension.height * (d / d2));
                n2 = dimension.height;
            }
        }
        graphics.setColor(this.getForeground());
        if (this.fStyle.isBlock()) {
            boolean bl = true;
            int n3 = dimension.width;
            int n4 = 14;
            if (this.fOrientation.isHorizontal()) {
                if (this.fBlockBuffer == null || this.fBlockBufferSize.height != dimension.height) {
                    n3 = 14;
                    n4 = dimension.height;
                    bl = false;
                }
            } else if (this.fBlockBuffer == null || this.fBlockBufferSize.width != dimension.width) {
                bl = false;
            }
            if (!bl) {
                this.fBlockBufferSize = new Dimension(n3, n4);
                this.fBlockBuffer = this.createImage(n3, n4);
                Graphics graphics2 = this.fBlockBuffer.getGraphics();
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, n3, n4);
                graphics2.setColor(this.getForeground());
                graphics2.fillRect(2, 2, n3 - 4, n4 - 4);
            }
            graphics.setColor(this.getBackground());
            if (this.fOrientation.isHorizontal()) {
                int n5 = dimension.width / this.fBlockBufferSize.width;
                int n6 = (dimension.width - n5 * this.fBlockBufferSize.width) / 2;
                int n7 = n * n5 / dimension.width;
                if (this.fDirection.isRight()) {
                    graphics.fillRect(0, 0, n6, dimension.height);
                    int n8 = 0;
                    while (n8 < n7) {
                        graphics.drawImage(this.fBlockBuffer, n6, 0, this);
                        n6 += this.fBlockBufferSize.width;
                        ++n8;
                    }
                    graphics.fillRect(n6, 0, dimension.width - n6, dimension.height);
                    return;
                }
                graphics.fillRect(dimension.width - n6, 0, n6, dimension.height);
                int n9 = 0;
                while (n9 < n7) {
                    graphics.drawImage(this.fBlockBuffer, dimension.width - n6 - this.fBlockBufferSize.width, 0, this);
                    n6 += this.fBlockBufferSize.width;
                    ++n9;
                }
                graphics.fillRect(0, 0, dimension.width - n6, dimension.height);
                return;
            }
            int n10 = dimension.height / this.fBlockBufferSize.height;
            int n11 = (dimension.height - n10 * this.fBlockBufferSize.height) / 2;
            int n12 = n * n10 / dimension.height;
            if (this.fDirection.isUp()) {
                graphics.fillRect(0, dimension.height - n11, dimension.width, n11);
                int n13 = 0;
                while (n13 < n12) {
                    graphics.drawImage(this.fBlockBuffer, 0, dimension.height - n11 - this.fBlockBufferSize.height, this);
                    n11 += this.fBlockBufferSize.height;
                    ++n13;
                }
                graphics.fillRect(0, 0, dimension.width, dimension.height - n11);
                return;
            }
            graphics.fillRect(0, 0, dimension.width, n11);
            int n14 = 0;
            while (n14 < n12) {
                graphics.drawImage(this.fBlockBuffer, 0, n11, this);
                n11 += this.fBlockBufferSize.height;
                ++n14;
            }
            graphics.fillRect(0, n11, dimension.width, dimension.height - n11);
            return;
        }
        if (this.fStyle.isStriped()) {
            int n15;
            if (this.fOrientation.isHorizontal()) {
                int n16;
                if (this.fStripeBuffer == null || this.fStripeBufferSize.height != dimension.height) {
                    int n17 = dimension.height * 2;
                    n16 = dimension.height;
                    this.fStripeBufferSize = new Dimension(n17, n16);
                    this.fStripeBuffer = this.createImage(n17, n16);
                    Graphics graphics3 = this.fStripeBuffer.getGraphics();
                    graphics3.setColor(this.getBackground());
                    graphics3.fillRect(0, 0, n17, n16);
                    graphics3.setColor(this.getForeground());
                    int n18 = 0;
                    while (n18 < n16) {
                        graphics3.drawLine(n18, dimension.height - 1, n18 + n16 - 1, 0);
                        ++n18;
                    }
                }
                this.fValue %= this.fStripeBufferSize.width;
                int n19 = dimension.width / this.fStripeBufferSize.height + 1;
                n16 = this.fDirection.isRight() ? this.fValue : -this.fValue;
                int n20 = -1;
                while (n20 < n19 + 1) {
                    graphics.drawImage(this.fStripeBuffer, n20 * this.fStripeBufferSize.width + n16, 0, this);
                    ++n20;
                }
                return;
            }
            if (this.fStripeBuffer == null || this.fStripeBufferSize.width != dimension.width) {
                int n21 = dimension.width;
                n15 = dimension.width * 2;
                this.fStripeBufferSize = new Dimension(n21, n15);
                this.fStripeBuffer = this.createImage(n21, n15);
                Graphics graphics4 = this.fStripeBuffer.getGraphics();
                graphics4.setColor(this.getBackground());
                graphics4.fillRect(0, 0, n21, n15);
                graphics4.setColor(this.getForeground());
                int n22 = 0;
                while (n22 < n21) {
                    graphics4.drawLine(0, n22, n21 - 1, n22 + n21 - 1);
                    ++n22;
                }
            }
            this.fValue %= this.fStripeBufferSize.height;
            int n23 = dimension.height / this.fStripeBufferSize.width + 1;
            n15 = this.fDirection.isDown() ? this.fValue : -this.fValue;
            int n24 = -1;
            while (n24 < n23 + 1) {
                graphics.drawImage(this.fStripeBuffer, 0, n24 * this.fStripeBufferSize.height + n15, this);
                ++n24;
            }
            return;
        }
        if (this.fStyle.isSolid()) {
            if (this.fSolidBuffer == null || this.fSolidBufferSize.width != dimension.width || this.fSolidBufferSize.height != dimension.height) {
                if (this.fSolidBuffer != null) {
                    this.fSolidBuffer.flush();
                    this.fSolidBufferGraphics.dispose();
                }
                this.fSolidBufferSize = new Dimension(dimension.width, dimension.height);
                this.fSolidBuffer = this.createImage(dimension.width, dimension.height);
                this.fSolidBufferGraphics = this.fSolidBuffer.getGraphics();
            }
            this.fSolidBufferGraphics.setColor(this.getForeground());
            if (this.fOrientation.isHorizontal()) {
                if (this.fDirection.isRight()) {
                    this.fSolidBufferGraphics.fillRect(0, 0, n, dimension.height);
                } else {
                    this.fSolidBufferGraphics.fillRect(dimension.width - n, 0, dimension.width, dimension.height);
                }
            } else if (this.fDirection.isUp()) {
                this.fSolidBufferGraphics.fillRect(0, dimension.height - n, dimension.width, dimension.height);
            } else {
                this.fSolidBufferGraphics.fillRect(0, 0, dimension.width, n);
            }
            this.fSolidBufferGraphics.setColor(this.getBackground());
            if (this.fOrientation.isHorizontal()) {
                if (this.fDirection.isRight()) {
                    this.fSolidBufferGraphics.fillRect(n, 0, dimension.width, dimension.height);
                } else {
                    this.fSolidBufferGraphics.fillRect(0, 0, dimension.width - n, dimension.height);
                }
            } else if (this.fDirection.isUp()) {
                this.fSolidBufferGraphics.fillRect(0, 0, dimension.width, dimension.height - n);
            } else {
                this.fSolidBufferGraphics.fillRect(0, n, dimension.width, dimension.height);
            }
            if (this.fPercent) {
                String string = String.valueOf(Integer.toString(Math.abs(this.fValue) * 100 / (this.fMaximum - this.fMinimum))) + "%";
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
                int n25 = fontMetrics.stringWidth(string);
                int n26 = fontMetrics.getHeight();
                int n27 = (dimension.width - n25) / 2;
                int n28 = (dimension.height + n26) / 2 - fontMetrics.getDescent();
                this.fSolidBufferGraphics.setColor(this.getForeground());
                this.fSolidBufferGraphics.drawString(string, n27, n28);
                if (this.fOrientation.isHorizontal()) {
                    if (this.fDirection.isRight()) {
                        this.fSolidBufferGraphics.setClip(0, 0, n, dimension.height);
                    } else {
                        this.fSolidBufferGraphics.setClip(dimension.width - n, 0, dimension.width, dimension.height);
                    }
                } else if (this.fDirection.isUp()) {
                    this.fSolidBufferGraphics.setClip(0, dimension.height - n, dimension.width, dimension.height);
                } else {
                    this.fSolidBufferGraphics.setClip(0, 0, dimension.width, n);
                }
                this.fSolidBufferGraphics.setColor(this.getBackground());
                this.fSolidBufferGraphics.drawString(string, n27, n28);
                this.fSolidBufferGraphics.setClip(0, 0, this.fSolidBufferSize.width, this.fSolidBufferSize.height);
            }
            graphics.drawImage(this.fSolidBuffer, 0, 0, this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append(",orientation=" + this.fOrientation);
        stringBuffer.append(",direction=" + this.fDirection);
        stringBuffer.append(",style=" + this.fStyle);
        stringBuffer.append(",min=" + this.fMinimum);
        stringBuffer.append(",max=" + this.fMaximum);
        stringBuffer.append(",value=" + this.fValue);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

