/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class Separator
extends Canvas
implements Serializable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DEFAULT_ORIENTATION = 0;
    public static final Insets DEFAULT_INSETS = new Insets(1, 1, 1, 1);
    private int orientation = 0;
    private Insets insets = DEFAULT_INSETS;

    public Separator() {
    }

    public Separator(int n) {
        this.setOrientation(n);
    }

    public void setOrientation(int n) {
        if (n != 0) {
            n = 1;
        }
        this.orientation = n;
        this.repaint();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        Insets insets = new Insets(n, n2, n3, n4);
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            this.repaint();
        }
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(2 + this.insets.left + this.insets.right, 2 + this.insets.top + this.insets.bottom);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        Color color2 = color.brighter().brighter().brighter();
        Color color3 = color.darker().darker().darker();
        if (this.orientation == 0) {
            graphics.setColor(color3);
            graphics.drawLine(this.insets.left, this.insets.top, dimension.width - 1 - this.insets.right, this.insets.top);
            graphics.setColor(color2);
            graphics.drawLine(this.insets.left + 1, this.insets.top + 1, dimension.width - this.insets.right, this.insets.top + 1);
            return;
        }
        graphics.setColor(color3);
        graphics.drawLine(this.insets.left, this.insets.top, this.insets.left, dimension.height - 1 - this.insets.bottom);
        graphics.setColor(color2);
        graphics.drawLine(this.insets.left + 1, this.insets.top + 1, this.insets.left + 1, dimension.height - this.insets.bottom);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("orientation=");
        if (this.orientation == 0) {
            stringBuffer.append("HORIZONTAL");
        } else {
            stringBuffer.append("VERTICAL");
        }
        stringBuffer.append("insets=" + this.insets);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

