/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.ClipboardCapable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class TextClipboardComponent
extends Canvas
implements ClipboardOwner,
ClipboardCapable {
    public static final char DEFAULT_CUT_CHAR = '\u0018';
    public static final int DEFAULT_CUT_MODIFIER = 2;
    public static final char DEFAULT_COPY_CHAR = '\u0003';
    public static final int DEFAULT_COPY_MODIFIER = 2;
    public static final char DEFAULT_PASTE_CHAR = '\u0016';
    public static final int DEFAULT_PASTE_MODIFIER = 2;
    public static final Color DEFAULT_SELECTION_BACKGROUND = new Color(0, 0, 128);
    public static final Color DEFAULT_SELECTION_FOREGROUND = Color.white;
    protected static transient Clipboard fClipboard;
    private static char fCutChar;
    private static int fCutModifier;
    private static char fCopyChar;
    private static int fCopyModifier;
    private static char fPasteChar;
    private static int fPasteModifier;
    private Color fSelectionBackground = DEFAULT_SELECTION_BACKGROUND;
    private Color fSelectionForeground = DEFAULT_SELECTION_FOREGROUND;
    protected int fBegin;
    protected int fEnd;
    protected boolean fEditable = true;

    public TextClipboardComponent() {
        this.init();
        this.setCursor(Cursor.getPredefinedCursor(2));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void init() {
        try {
            fClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void setCutCharacter(char c) {
        fCutChar = c;
    }

    public static char getCutCharacter() {
        return fCutChar;
    }

    public static void setCutModifier(int n) {
        fCutModifier = n;
    }

    public static int getCutModifier() {
        return fCutModifier;
    }

    public static void setCopyCharacter(char c) {
        fCopyChar = c;
    }

    public static char getCopyCharacter() {
        return fCopyChar;
    }

    public static void setCopyModifier(int n) {
        fCopyModifier = n;
    }

    public static int getCopyModifier() {
        return fCopyModifier;
    }

    public static void setPasteCharacter(char c) {
        fPasteChar = c;
    }

    public static char getPasteCharacter() {
        return fPasteChar;
    }

    public static void setPasteModifier(int n) {
        fPasteModifier = n;
    }

    public static int getPasteModifier() {
        return fPasteModifier;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public synchronized void copyToClipboard(String string) {
        if (fClipboard == null || string == null || string.length() == 0) {
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        fClipboard.setContents(stringSelection, this);
    }

    public synchronized String copyFromClipboard() {
        Transferable transferable;
        if (fClipboard != null && (transferable = fClipboard.getContents(this)) != null) {
            try {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean clipboardCommand(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if (c == fCutChar && n == fCutModifier) {
            this.cut();
        } else if (c == fCopyChar && n == fCopyModifier) {
            this.copy();
        } else if (c == fPasteChar && n == fPasteModifier) {
            this.paste();
        } else {
            return false;
        }
        return true;
    }

    public void setSelectionBackground(Color color) {
        this.fSelectionBackground = color;
        this.repaint();
    }

    public Color getSelectionBackground() {
        return this.fSelectionBackground;
    }

    public void setSelectionForeground(Color color) {
        this.fSelectionForeground = color;
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.fSelectionForeground;
    }

    protected abstract String getDisplayText();

    public abstract void setText(String var1);

    public abstract String getText();

    public void setEditable(boolean bl) {
        this.fEditable = bl;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public synchronized void setCaretPosition(int n) {
        if (n < 0) {
            n = 0;
        } else {
            int n2 = this.getDisplayText().length();
            if (n > n2) {
                n = n2;
            }
        }
        this.fEnd = this.fBegin = n;
        this.repaint();
    }

    public int getCaretPosition() {
        return this.fBegin;
    }

    public synchronized void select(int n, int n2) {
        this.fBegin = n;
        this.fEnd = n2;
        this.repaint();
    }

    public synchronized void selectAll() {
        this.select(0, this.getDisplayText().length());
    }

    public synchronized String getSelectedText() {
        return this.getDisplayText().substring(this.fBegin, this.fEnd);
    }

    public synchronized void setSelectionStart(int n) {
        if (n < 0) {
            n = 0;
        } else {
            int n2 = this.getDisplayText().length();
            if (n > n2) {
                n = n2;
            }
        }
        if (this.fEnd < n) {
            this.fEnd = n;
        }
        this.fBegin = n;
        this.repaint();
    }

    public int getSelectionStart() {
        return this.fBegin;
    }

    public synchronized void setSelectionEnd(int n) {
        if (n < this.fBegin) {
            n = this.fBegin;
        } else {
            int n2 = this.getDisplayText().length();
            if (n > n2) {
                n = n2;
            }
        }
        this.fEnd = n;
        this.repaint();
    }

    public int getSelectionEnd() {
        return this.fEnd;
    }

    public abstract void addTextListener(TextListener var1);

    public abstract void removeTextListener(TextListener var1);

    static {
        fCutChar = (char)24;
        fCutModifier = 2;
        fCopyChar = (char)3;
        fCopyModifier = 2;
        fPasteChar = (char)22;
        fPasteModifier = 2;
    }
}

