/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.image.MaskedImageFilter;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Vector;

public class UpdatingImageButton
extends Canvas
implements Runnable,
MouseListener,
FocusListener {
    public static final int NORMAL = 0;
    public static final int STICKY = 1;
    public static final int MULTIPLE_STATE = 2;
    public static final int DEFAULT_STYLE = 0;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final ImageFilter DEFAULT_FILTER = new MaskedImageFilter();
    Vector listeners = new Vector();
    private Image[] images = new Image[1];
    private Dimension size;
    private Image pushedImage;
    private boolean keepRunning = false;
    private int style = 0;
    private boolean down;
    private boolean updateLive = true;
    private int state;
    private int borderThickness = 2;
    private boolean pressed;
    private boolean stillinside;
    private boolean mousedown;
    private boolean disabled;
    private Image gray;
    private ImageFilter filter;
    private Image buffer;
    private Graphics bufg;
    private Dimension bufsize;
    private transient Thread thread;

    public boolean getUpdateLive() {
        return this.updateLive;
    }

    public void setUpdateLive(boolean bl) {
        this.updateLive = bl;
    }

    public void setBorderThickness(int n) {
        this.borderThickness = n;
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public UpdatingImageButton(Image image) {
        this.images[0] = image;
        this.pushedImage = null;
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    public UpdatingImageButton(Image image, Image image2) {
        this(image);
        this.pushedImage = image2;
    }

    public UpdatingImageButton(Image image, int n, int n2) {
        this(image);
        if (n > 0 && n2 > 0) {
            this.size = new Dimension(n + 4, n2 + 4);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (this.size != null) {
            return this.size;
        }
        int n = 20;
        int n2 = 20;
        if (this.images != null) {
            n = 4 + this.images[0].getWidth(this);
            n2 = 4 + this.images[0].getHeight(this);
        }
        return new Dimension(n, n2);
    }

    public UpdatingImageButton setPushedImage(Image image) {
        this.pushedImage = image;
        if (this.down) {
            this.repaint();
        }
        return this;
    }

    public Image getPushedImage() {
        return this.pushedImage;
    }

    public int getStyle() {
        return this.style;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdatingImageButton setState(int n) {
        block7: {
            block6: {
                if (this.style != 1) break block6;
                if (n != 0 && n != 1) {
                    return this;
                }
                switch (n) {
                    case 0: {
                        this.down = false;
                        break block7;
                    }
                    case 1: {
                        this.down = true;
                        break block7;
                    }
                    default: {
                        if (this.state == n) return this;
                    }
                }
            }
            if (n < 0 || n >= this.images.length) {
                return this;
            }
        }
        if (this.state == n) return this;
        this.state = n;
        this.repaint();
        return this;
    }

    public int getState() {
        return this.state;
    }

    public UpdatingImageButton addStateImage(Image image) {
        if (image != null) {
            Image[] imageArray = new Image[this.images.length + 1];
            int n = 0;
            while (n < this.images.length) {
                imageArray[n] = this.images[n];
                ++n;
            }
            imageArray[this.images.length] = image;
            this.images = imageArray;
        }
        return this;
    }

    public UpdatingImageButton setStateImage(int n, Image image) {
        if (n >= 0 && n < this.images.length && image != null) {
            this.images[n] = image;
            if (this.state == n) {
                this.repaint();
            }
        }
        return this;
    }

    public Image getStateImage(int n) {
        if (n < 0 || n >= this.images.length) {
            return null;
        }
        return this.images[n];
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.disabled = false;
            this.gray = null;
            this.repaint();
            super.setEnabled(bl);
            return;
        }
        super.setEnabled(bl);
        this.disabled = true;
        this.down = false;
        this.repaint();
    }

    public UpdatingImageButton setDisabledImageFilter(ImageFilter imageFilter) {
        this.filter = imageFilter;
        if (this.disabled) {
            this.gray = null;
            this.repaint();
        }
        return this;
    }

    public ImageFilter getDisabledImageFilter() {
        return this.filter;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Cloneable cloneable;
        if (this.disabled && this.gray == null) {
            cloneable = this.filter;
            if (this.filter == null) {
                cloneable = DEFAULT_FILTER;
            }
            FilteredImageSource filteredImageSource = new FilteredImageSource(this.images[this.state].getSource(), (ImageFilter)cloneable);
            this.gray = this.createImage(filteredImageSource);
        }
        cloneable = this.getSize();
        if (this.buffer == null || !this.bufsize.equals(cloneable)) {
            this.buffer = this.createImage(cloneable.width, cloneable.height);
            this.bufg = this.buffer.getGraphics();
            this.bufsize = new Dimension(cloneable.width, cloneable.height);
        }
        if (!this.pressed) {
            switch (this.style) {
                case 1: {
                    if (this.down) {
                        this.paintDown(this.bufg);
                        break;
                    }
                    this.paintUp(this.bufg);
                    break;
                }
                default: {
                    this.paintUp(this.bufg);
                    break;
                }
            }
        } else {
            switch (this.style) {
                case 1: {
                    if (this.down) {
                        this.paintUp(this.bufg);
                        break;
                    }
                    this.paintDown(this.bufg);
                    break;
                }
                default: {
                    this.paintDown(this.bufg);
                    break;
                }
            }
        }
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    private void paintUp(Graphics graphics) {
        Color color = this.getBackground().brighter().brighter().brighter();
        Color color2 = this.getBackground().darker().darker().darker();
        Image image = this.disabled ? this.gray : this.images[this.state];
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        int n3 = this.buffer.getWidth(this);
        int n4 = this.buffer.getHeight(this);
        int n5 = n > n3 ? 0 : (n3 - n) / 2;
        int n6 = n2 > n4 ? 0 : (n4 - n2) / 2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n3, n4);
        graphics.drawImage(image, n5, n6, this);
        Dimension dimension = this.getSize();
        graphics.setColor(color);
        graphics.drawLine(0, 0, 0, dimension.height - 2);
        graphics.drawLine(1, 0, dimension.width - 1, 0);
        if (this.borderThickness > 1) {
            graphics.drawLine(1, 1, 1, dimension.height - 3);
            graphics.drawLine(2, 1, dimension.width - 2, 1);
        }
        graphics.setColor(color2);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 2, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
        if (this.borderThickness > 1) {
            graphics.drawLine(1, dimension.height - 2, dimension.width - 3, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 2);
        }
    }

    private void paintDown(Graphics graphics) {
        Color color = this.getBackground().brighter().brighter().brighter();
        Color color2 = this.getBackground().darker().darker().darker();
        Image image = this.disabled ? this.gray : (this.pushedImage == null ? (this.style == 2 ? this.images[(this.state + 1) % this.images.length] : this.images[this.state]) : this.pushedImage);
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        int n3 = this.buffer.getWidth(this);
        int n4 = this.buffer.getHeight(this);
        int n5 = n > n3 ? 0 : (n3 - n) / 2;
        int n6 = n2 > n4 ? 0 : (n4 - n2) / 2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n3, n4);
        graphics.drawImage(image, n5 + 1, n6 + 1, this);
        Dimension dimension = this.getSize();
        graphics.setColor(color);
        graphics.drawLine(2, dimension.height - 1, dimension.width - 2, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color2);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.drawLine(1, 1, 1, dimension.height - 1);
        graphics.drawLine(2, 2, 2, dimension.height - 2);
        graphics.drawLine(1, 0, dimension.width - 1, 0);
        graphics.drawLine(2, 1, dimension.width - 1, 1);
        graphics.drawLine(3, 2, dimension.width - 2, 2);
    }

    public void setMouseDown(boolean bl) {
        this.mousedown = bl;
    }

    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {}
        ActionEvent actionEvent = new ActionEvent(this, 1001, "");
        while (this.keepRunning) {
            if (this.keepRunning) {
                this.fireActionEvent(actionEvent);
            }
            try {
                Thread.sleep(125L);
            }
            catch (Exception exception) {}
        }
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((ActionListener)vector.elementAt(n2)).actionPerformed(actionEvent);
            ++n2;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.mousedown && this.updateLive && this.thread == null) {
            this.thread = new Thread(this);
            this.keepRunning = true;
            this.thread.start();
        }
        this.mousedown = true;
        this.pressed = this.style == 1 ? !this.pressed : true;
        this.repaint();
        this.stillinside = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        UpdatingImageButton updatingImageButton = this;
        synchronized (updatingImageButton) {
            Serializable serializable;
            if (this.updateLive && this.thread != null) {
                this.keepRunning = false;
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.mousedown) {
                this.mousedown = false;
                serializable = this.getBounds();
                ((Rectangle)serializable).y = 0;
                ((Rectangle)serializable).x = 0;
                if (((Rectangle)serializable).contains(mouseEvent.getX(), mouseEvent.getY())) {
                    switch (this.style) {
                        case 1: {
                            this.down = !this.down;
                            break;
                        }
                        case 2: {
                            this.state = (this.state + 1) % this.images.length;
                            break;
                        }
                    }
                    bl = true;
                }
                this.pressed = false;
            }
            if (bl) {
                serializable = new ActionEvent(this, 1001, "");
                this.fireActionEvent((ActionEvent)serializable);
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mousedown) {
            this.pressed = this.style == 1 ? !this.pressed : true;
            this.repaint();
            if (this.updateLive && this.thread == null) {
                this.thread = new Thread(this);
                this.keepRunning = true;
                this.thread.start();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.thread != null) {
            this.keepRunning = false;
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.mousedown) {
            this.pressed = this.style == 1 ? !this.pressed : false;
            this.repaint();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mouseReleased(new MouseEvent(this, 502, System.currentTimeMillis(), 0, -1, -1, 1, false));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getClass().getName()) + "[");
        stringBuffer.append("style=");
        switch (this.style) {
            case 0: {
                stringBuffer.append("NORMAL");
                break;
            }
            case 1: {
                stringBuffer.append("STICKY,state=");
                if (this.down) {
                    stringBuffer.append("DOWN");
                    break;
                }
                stringBuffer.append("UP");
                break;
            }
            case 2: {
                stringBuffer.append("MULTIPLE_STATE,state=");
                stringBuffer.append(this.state);
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

