/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.form.ConsultarRetornoForm;
import br.com.bb.plugins.dbt.negocio.facade.ConsultarArquivoRetornoFacade;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectRecebimentoRetorno;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprimirArquivoRetornoAction
extends DBTPluginActionAbstrato {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ConsultarArquivoRetornoFacade fachada = this.getDBTFacadeFactory().novoConsultarArquivoRetornoFacade();
        ConsultarRetornoForm formulario = this.getConsultarRetornoForm(form);
        formulario.setCodigoPessoaConvenente(this.getCodigoConveneteTela());
        List<RecebimentoDebitoTO> lista = fachada.listarPorFiltro(formulario.getRecebimentoTO());
        formulario.setLista(this.criarListaComTotalizadores(lista));
        return null;
    }

    public ConsultarRetornoForm getConsultarRetornoForm(PluginFormAbstrato form) {
        return (ConsultarRetornoForm)form;
    }

    private Integer getCodigoConveneteTela() {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        return acesso.getConvenenteTO().getCodigoPessoaConvenente();
    }

    private List<IObjectRecebimentoRetorno> criarListaComTotalizadores(Collection<RecebimentoDebitoTO> recebimento) {
        LinkedList<IObjectRecebimentoRetorno> retorno = new LinkedList<IObjectRecebimentoRetorno>();
        BigDecimal total = new BigDecimal(0);
        BigDecimal totalGeral = new BigDecimal(0);
        Date dataDebito = null;
        for (RecebimentoDebitoTO to : recebimento) {
            Date dataRecebimento = to.getDataRecebimento();
            if (dataDebito != null && dataDebito.compareTo(dataRecebimento) != 0) {
                IObjectRecebimentoRetorno itemTotal = new IObjectRecebimentoRetorno("Subtotal", total);
                retorno.add(itemTotal);
                total = new BigDecimal(0);
            }
            dataDebito = to.getDataRecebimento();
            retorno.add(new IObjectRecebimentoRetorno(to));
            BigDecimal valor = to.getValorRecebimento();
            if (valor == null) continue;
            total = total.add(valor);
            totalGeral = totalGeral.add(valor);
        }
        IObjectRecebimentoRetorno itemTotal = new IObjectRecebimentoRetorno("Subtotal", total);
        retorno.add(itemTotal);
        IObjectRecebimentoRetorno itemTotalGeral = new IObjectRecebimentoRetorno(totalGeral);
        retorno.add(itemTotalGeral);
        return retorno;
    }
}

