/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterconvenente.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.dominio.action.ConsultarListaConvenioDebitoPessoaConvenenteAction;
import br.com.bb.plugins.dbt.apresentacao.dominio.form.DBTDominioForm;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.CarregarViewDetalharConvenenteAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.CarregarViewManterConvenenteAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.CarregarViewManterConvenioAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.ConsultarConvenentesAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.ExcluirConvenenteAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.ImprimirListaConvenenteAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.VerificaConvenioConvenentesAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.form.ManterConvenenteForm;
import br.com.bb.plugins.dbt.factory.DBTActionFactory;
import br.com.bb.plugins.dbt.factory.DBTFormFactory;
import br.com.bb.plugins.dbt.util.objecttablemodel.ConvenenteBO;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenenteTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioConvenenteDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioSubConvenioDecorator;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilIdentificadorProprio;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.mascara.MascaraUtil;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import br.com.bb.plugins.gac.util.swing.componente.BBJTablePagina;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.formatador.UtilFormatadorDeCEP;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGerenciarConvenente
extends DBTBasicInternalFrame {
    private JPanel panelMain = null;
    private JPanel panelBotoes = null;
    private BBJTablePagina<ConvenenteBO> tblConvenentes = null;
    private String[] columnNames = new String[]{"Inscri\u00e7\u00e3o", "Nome"};
    private int[] columnSizes = new int[]{150, 450};
    private int[] columnAligment = new int[]{2, 2};
    private BBJButton btnConvenios;
    private BBJButton btnEditar;
    private BBJButton btnDetalhar;
    private BBJButton btnExcluir;
    private BBJButton btnVoltar;
    private BBJButton btnImprimir;
    private BBJPaginacao paginacao = null;
    private JPanel panelObservacao = null;
    private boolean mostraMsgSemConvenio;

    public ViewGerenciarConvenente() {
        super("Gerenciar Convenentes", false, false);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(this.getLayoutFactory().novoBorderLayout());
        this.add(this.getPanelMain(), "Center");
    }

    public JPanel getPanelMain() {
        if (!this.isReferencia(this.panelMain)) {
            this.panelMain = this.getPainelFactory().novoJPainel();
            this.panelMain.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelMain.setPreferredSize(this.getLayoutFactory().novoDimension(525, 430));
            this.panelMain.setOpaque(false);
            this.panelMain.add((Component)this.getTblConvenentes(), "North");
            JPanel panelBotoesObservacoes = new JPanel();
            panelBotoesObservacoes.setOpaque(false);
            panelBotoesObservacoes.setLayout(new BorderLayout());
            panelBotoesObservacoes.add((Component)this.getPanelBotoes(), "North");
            panelBotoesObservacoes.add((Component)this.getPanelObservacao(), "Center");
            panelBotoesObservacoes.setPreferredSize(new Dimension(0, 70));
            this.panelMain.add((Component)panelBotoesObservacoes, "Center");
        }
        return this.panelMain;
    }

    public BBJTablePagina<ConvenenteBO> getTblConvenentes() {
        if (!this.isReferencia(this.tblConvenentes)) {
            BBJPaginacao paginacao = this.getBotoesPaginacao();
            this.tblConvenentes = new BBJTablePagina(this.columnNames, this.columnSizes, this.columnAligment, null, 5, 5, paginacao);
            this.tblConvenentes.setName("listaConvenentesSelecionados");
            this.tblConvenentes.setFocusable(false);
            BBJTable bbtModel = this.tblConvenentes.getTable().getBbtModel();
            bbtModel.setNomeColunas(new String[]{"identificacaoTOs.textoIdentificacao", "pessoaTO.textoNome"});
            bbtModel.setOrdenacaoAutomatica(true);
            bbtModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarConvenente.this.habilitarBotoes(e.getActionCommand().equalsIgnoreCase("SELECIONADO"));
                    if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewGerenciarConvenente.this.ordenarTabela();
                    }
                    try {
                        if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                            ManterConvenenteForm convenenteForm = (ManterConvenenteForm)ViewGerenciarConvenente.this.getForm();
                            int selecionado = ViewGerenciarConvenente.this.tblConvenentes.getTable().getSelectedRow();
                            if (selecionado != -1) {
                                convenenteForm.setConvenenteTO(((ConvenenteBO)((Object)ViewGerenciarConvenente.this.tblConvenentes.getDataListTabela().get(selecionado))).getConvenenteTO());
                                new VerificaConvenioConvenentesAction().executar(convenenteForm);
                                ViewGerenciarConvenente.this.setMostraMsgSemConvenio(!convenenteForm.isExisteConvenioConvenente());
                            }
                        }
                    }
                    catch (BBException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.tblConvenentes;
    }

    private void ordenarTabela() {
        BBJTableImpl table = this.getTblConvenentes().getTable();
        BBJTable bbtModel = table.getBbtModel();
        this.getManterConvenenteForm().getConvenenteTO().setNomeColunaOrdenada(bbtModel.getNomeColunaOrdenada());
        this.getManterConvenenteForm().getConvenenteTO().setTipoOrdenacao(bbtModel.getTipoordenacao());
        this.consultarConvenentes();
        this.preencherTabelaConvenente();
    }

    private void habilitarBotoes(boolean habilitar) {
        this.getBtnConvenios().setEnabled(habilitar);
        this.getBtnEditar().setEnabled(habilitar);
        this.getBtnDetalhar().setEnabled(habilitar);
        this.getBtnExcluir().setEnabled(habilitar);
        this.getBtnImprimir().setEnabled(habilitar);
    }

    private BBJPaginacao getBotoesPaginacao() {
        BBJPaginacao paginacao = this.getPaginacao();
        paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ViewGerenciarConvenente.this.getManterConvenenteForm().setPaginaAtual((Integer)evt.getNewValue());
                ViewGerenciarConvenente.this.consultarConvenentes();
                ViewGerenciarConvenente.this.preencherTabelaConvenente();
            }
        });
        return paginacao;
    }

    private ManterConvenenteForm getManterConvenenteForm() {
        return (ManterConvenenteForm)this.getForm();
    }

    protected PluginFormAbstrato novoForm() {
        return this.getDBTFormFactory().novoManterConvenenteForm();
    }

    public BBJPaginacao getPaginacao() {
        if (!this.isReferencia(this.paginacao)) {
            this.paginacao = this.getPainelFactory().novoBBJPaginacao();
        }
        return this.paginacao;
    }

    public JPanel getPanelBotoes() {
        if (!this.isReferencia(this.panelBotoes)) {
            this.panelBotoes = this.getPainelFactory().novoJPainel();
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = this.getLayoutFactory().novoFlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add((Component)this.getBtnConvenios());
            this.panelBotoes.add((Component)this.getBtnEditar());
            this.panelBotoes.add((Component)this.getBtnDetalhar());
            this.panelBotoes.add((Component)this.getBtnExcluir());
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBtnConvenios() {
        if (!this.isReferencia(this.btnConvenios)) {
            CarregarViewManterConvenioAction action = this.getDBTActionFactory().novoCarregarViewManterConvenioAction();
            this.btnConvenios = this.getBotaoFactory().novoConvenio((PluginActionAbstrato)action);
            this.btnConvenios.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ManterConvenenteForm convenenteForm = (ManterConvenenteForm)ViewGerenciarConvenente.this.getForm();
                    if (!convenenteForm.isExisteConvenioConvenente()) {
                        BBJPopupMensagem.exibirMensagem((String)"Nenhum conv\u00eanio encontrado para a Convenente selecionado.");
                    }
                }
            });
        }
        return this.btnConvenios;
    }

    public BBJButton getBtnDetalhar() {
        if (!this.isReferencia(this.btnDetalhar)) {
            CarregarViewDetalharConvenenteAction action = this.getDBTActionFactory().novoCarregarViewDetalharConvenenteAction();
            this.btnDetalhar = this.getBotaoFactory().novoDetalhar((PluginActionAbstrato)action);
        }
        return this.btnDetalhar;
    }

    public BBJButton getBtnEditar() {
        if (!this.isReferencia(this.btnEditar)) {
            CarregarViewManterConvenenteAction action = this.getDBTActionFactory().novoCarregarViewManterConvenenteAction();
            this.btnEditar = this.getBotaoFactory().novoEditar((PluginActionAbstrato)action);
        }
        return this.btnEditar;
    }

    public BBJButton getBtnExcluir() {
        if (!this.isReferencia(this.btnExcluir)) {
            ExcluirConvenenteAction action = this.getDBTActionFactory().novoExcluirConvenenteAction();
            this.btnExcluir = this.getBotaoFactory().novoExcluir((PluginActionAbstrato)action);
        }
        return this.btnExcluir;
    }

    public void posExecucaoExcluirConvenenteAction() {
        BBJPopupMensagem.exibirMensagem((String)this.getUtilMensagem().getMensagem("MP003"));
        this.carregarTela();
    }

    protected BBJButton getBtnImprimir() {
        if (!this.isReferencia(this.btnImprimir)) {
            ImprimirListaConvenenteAction acao = this.getDBTActionFactory().novoImprimirListaConvenenteAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.btnImprimir;
    }

    public void posExecucaoImprimirListaConvenenteAction() {
        if (this.isReferencia(this.getManterConvenenteForm().getListaConvenentesSelecionados())) {
            this.imprimirConvenente();
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getUtilMensagem().getMensagem("MP004"));
        }
    }

    private void imprimirConvenente() {
        JasperPrint impressao = null;
        try {
            impressao = UtilRelatorioJasper.imprimirRelatorio((String)Arquivo.JASPER_CONVENENTES_COM_CONVENIOS, (Map)this.getMapaSubRelatorio(), this.getListaConvenente());
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
    }

    private Collection<RelatorioConvenenteDecorator> getListaConvenente() {
        ArrayList<RelatorioConvenenteDecorator> colecaoDecorator = new ArrayList<RelatorioConvenenteDecorator>();
        Collection<ConvenenteTODecorator> lista = this.getManterConvenenteForm().getListaConvenentesSelecionados();
        for (ConvenenteTODecorator to : lista) {
            colecaoDecorator.add(this.novoRelatorioConvenenteDecorator(to));
        }
        return colecaoDecorator;
    }

    private RelatorioConvenenteDecorator novoRelatorioConvenenteDecorator(ConvenenteTODecorator to) {
        RelatorioConvenenteDecorator retorno = new RelatorioConvenenteDecorator();
        retorno.setNome("");
        retorno.setInscricao("");
        retorno.setEndereco("");
        retorno.setBairro("");
        retorno.setCep("");
        retorno.setUf("");
        retorno.setCidade("");
        retorno.setTipo("");
        retorno.setTamanho("");
        retorno.setSigla("");
        retorno.setTipoDoc("");
        IdentificadorTO identificadorTO = UtilIdentificadorProprio.getInstancia().consultaIdentificadorProprioPor(to.getConvenente(), this.getServicoAtual());
        if (identificadorTO != null && identificadorTO.getIndicadorDominio() != null) {
            if (identificadorTO.getIndicadorDominio().equals(Character.valueOf('N'))) {
                retorno.setTipo("Num\u00e9rico");
            } else if (identificadorTO.getIndicadorDominio().equals(Character.valueOf('A'))) {
                retorno.setTipo("AlfaNum\u00e9rico");
            }
        }
        if (identificadorTO != null && identificadorTO.getNumeroTamanhoIdentificador() != null) {
            retorno.setTamanho(identificadorTO.getNumeroTamanhoIdentificador().toString());
        }
        if (identificadorTO != null && identificadorTO.getTipoDocumentoTO() != null) {
            retorno.setTipoDoc(identificadorTO.getTipoDocumentoTO().getCodigoTipoDocumento().toString());
        }
        if (identificadorTO != null && identificadorTO.getTipoDocumentoTO() != null && identificadorTO.getTipoDocumentoTO().getCodigoTipoDocumento() != null && identificadorTO.getTipoDocumentoTO().getCodigoTipoDocumento() == 10) {
            retorno.setSigla(identificadorTO.getNomeIdentificador());
        }
        if (to.getConvenente().getPessoaTO() != null) {
            retorno.setNome(to.getConvenente().getPessoaTO().getTextoNome());
        }
        if (to.getInscricao() != null) {
            retorno.setInscricao(MascaraUtil.mascaraInscricao((String)to.getInscricao()));
        }
        for (LogradouroTO logradouroTO : to.getPessoaTO().getLogradouroTOs()) {
            if (logradouroTO.getTextoLogradouro() != null) {
                retorno.setEndereco(logradouroTO.getTextoLogradouro());
            }
            if (logradouroTO.getTextoBairro() != null) {
                retorno.setBairro(logradouroTO.getTextoBairro());
            }
            if (logradouroTO.getTextoCep() != null) {
                retorno.setCep(UtilFormatadorDeCEP.formatar((String)logradouroTO.getTextoCep()));
            }
            if (logradouroTO.getUnidadeFederativaBrasilTO() != null) {
                retorno.setUf(logradouroTO.getUnidadeFederativaBrasilTO().getTextoSiglaUf());
            }
            if (logradouroTO.getTextoCidade() == null) continue;
            retorno.setCidade(logradouroTO.getTextoCidade());
        }
        for (ConvenioTO convenio : to.getConvenente().getConvenioTOs()) {
            RelatorioSubConvenioDecorator sub = new RelatorioSubConvenioDecorator();
            sub.setConvenio(convenio.getNumeroConvenio().toString());
            sub.setNatureza(convenio.getTextoDescricaoConvenio());
            sub.setBanco(convenio.getAgenciaInstituicaoFinanceiraTO().getInstituicaoFinanceiraTO().getCodigoInstituicaoFinanceira());
            sub.setAgencia(String.valueOf(String.valueOf(convenio.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia())) + "-" + convenio.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia());
            sub.setContacorrente(String.valueOf(String.valueOf(convenio.getCodigoContaCorrente())) + "-" + convenio.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente());
            Set<ConvenioDebitoTO> convenioDebitoTOs = this.buscaConvenioDebitoTOs(convenio);
            if (convenioDebitoTOs != null) {
                for (ConvenioDebitoTO convenioDebitoTO : convenioDebitoTOs) {
                    if (convenioDebitoTO.getNumeroTamanhoIdentificadorDebito() != null) {
                        sub.setTamanho(convenioDebitoTO.getNumeroTamanhoIdentificadorDebito().toString());
                    } else {
                        sub.setTamanho("");
                    }
                    if (convenioDebitoTO.getTextoIdentificadorRegistroDebito() != null) {
                        if (convenioDebitoTO.getTextoIdentificadorRegistroDebito().equals("A")) {
                            sub.setTipo("Alfa-num\u00e9rico");
                            continue;
                        }
                        if (!convenioDebitoTO.getTextoIdentificadorRegistroDebito().equals("N")) continue;
                        sub.setTipo("Num\u00e9rico");
                        continue;
                    }
                    sub.setTipo("");
                }
            } else {
                sub.setTipo("");
            }
            retorno.getListaConveniosTO().add(sub);
        }
        return retorno;
    }

    private Map getMapaSubRelatorio() {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        mapa.put("nomeDoConvenente", FramePrincipal.getInstance().getConvenente().getPessoaTO().getTextoNome());
        mapa.put("subRelatorio", UtilArquivo.getInputStream((String)Arquivo.JASPER_LISTA_CONVENIOS_CONVENENTE));
        return mapa;
    }

    public BBJButton getBtnVoltar() {
        if (!this.isReferencia(this.btnVoltar)) {
            this.btnVoltar = new BBJButton("VOLTAR", true);
            this.btnVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarConvenente.this.doClose(null);
                }
            });
        }
        return this.btnVoltar;
    }

    public void doShow(Map context) {
        this.setVisible(true);
        super.doShow(context);
        this.configuraOrdenacao();
        this.carregarTela();
        this.habilitarBotoes(false);
        this.getTblConvenentes().getTable().requestFocusInWindow();
        this.getTblConvenentes().getTable().changeSelection(0, 0, false, false);
        this.getBtnVoltar().requestFocus();
    }

    private void configuraOrdenacao() {
        this.getManterConvenenteForm().getConvenenteTO().setNomeColunaOrdenada("pessoaTO.textoNome");
        this.getManterConvenenteForm().getConvenenteTO().setTipoOrdenacao("ASC");
    }

    public JPanel getPanelObservacao() {
        if (this.panelObservacao == null) {
            this.panelObservacao = new JPanel();
            this.panelObservacao.setOpaque(false);
            this.panelObservacao.setLayout(new BoxLayout(this.panelObservacao, 1));
            this.panelObservacao.add(Box.createRigidArea(new Dimension(0, 20)));
            BBJLabel labelObs = new BBJLabel("* A inclus\u00e3o deve ser efetuada atrav\u00e9s do recebimento/processamento do arquivo de configura\u00e7\u00e3o autom\u00e1tica no menu Gerenciar/Configurar Convenente");
            labelObs.setFont(BBJEstilos.LABELOBSERVACOES.getFont());
            labelObs.setForeground(BBJEstilos.LABELOBSERVACOES.getColor());
            this.panelObservacao.add((Component)labelObs);
        }
        return this.panelObservacao;
    }

    private void carregarTela() {
        this.consultarConvenentes();
        this.preencherTabelaConvenente();
        this.setValorMaximoPaginacao();
    }

    private void setValorMaximoPaginacao() {
        this.getPaginacao().setValorMaximo(this.getManterConvenenteForm().getNumeroDePaginas().intValue());
    }

    private void preencherTabelaConvenente() {
        Collection<ConvenenteTODecorator> listaConvenenteTO = this.getManterConvenenteForm().getListaConvenente();
        List dados = this.getColecaoFactory().novoArrayList();
        if (!UtilColecao.isVazio(listaConvenenteTO)) {
            for (ConvenenteTODecorator convenenteTO : listaConvenenteTO) {
                dados.add(new ConvenenteBO(convenenteTO));
            }
        }
        this.getTblConvenentes().setDataListTabela(dados);
    }

    private void consultarConvenentes() {
        try {
            ServicoTO servico = new ServicoTO();
            servico.setTextoIdentificadorServico("DBT");
            this.getManterConvenenteForm().getConvenenteTO().setServico(servico);
            this.getConsultarConvenentesAction().executar(this.getManterConvenenteForm());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem((String)UtilBBException.getErroDeSistema((Throwable)e).getMessage());
        }
    }

    private ConsultarConvenentesAction getConsultarConvenentesAction() {
        return this.getDBTActionFactory().novoConsultarConvenentesAction();
    }

    public void doClose(Map context) {
        super.doClose(context);
    }

    public boolean isMostraMsgSemConvenio() {
        return this.mostraMsgSemConvenio;
    }

    public void setMostraMsgSemConvenio(boolean mostraMsgSemConvenio) {
        this.mostraMsgSemConvenio = mostraMsgSemConvenio;
    }

    private Set<ConvenioDebitoTO> buscaConvenioDebitoTOs(ConvenioTO to) {
        DBTDominioForm dbtdominioForm = this.getDBTDominioForm();
        this.getConsultarListaConvenioDebitoPessoaConvenenteAction().executar(dbtdominioForm);
        return new HashSet<ConvenioDebitoTO>(dbtdominioForm.getListaConvenioDebito());
    }

    private DBTDominioForm getDBTDominioForm() {
        return DBTFormFactory.getInstancia().novoDBTDominioForm();
    }

    private ConsultarListaConvenioDebitoPessoaConvenenteAction getConsultarListaConvenioDebitoPessoaConvenenteAction() {
        return DBTActionFactory.getInstancia().novoConsultarListaConvenioDebitoPessoaConvenenteAction();
    }
}

