/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterdadosdedebito.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.mantercliente.form.ManterClienteForm;
import br.com.bb.plugins.dbt.apresentacao.manterdadosdedebito.action.AtivarSituacaoDebitoAction;
import br.com.bb.plugins.dbt.apresentacao.manterdadosdedebito.action.ConsultarListaDadosDeDebitoAction;
import br.com.bb.plugins.dbt.apresentacao.manterdadosdedebito.action.DesativarSituacaoDebitoAction;
import br.com.bb.plugins.dbt.apresentacao.manterdadosdedebito.action.ExcluirDadosDeDebitoAction;
import br.com.bb.plugins.dbt.apresentacao.manterdadosdedebito.form.ManterDadosDeDebitoForm;
import br.com.bb.plugins.dbt.util.objecttablemodel.DadosCadastroClienteDebito;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificacaoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.Utilitarios;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import br.com.bb.plugins.gac.util.swing.componente.BBJTablePagina;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import br.com.politec.generico.colecao.UtilColecao;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterDadosDebito
extends DBTBasicInternalFrame {
    private JPanel jpMain = null;
    private JPanel painelBotoes = null;
    private JPanel painelJTable = null;
    private BBJButton botaoNovo = null;
    private BBJButton botaoEditar = null;
    private BBJButton botaoVoltar = null;
    private BBJButton botaoExcluir = null;
    private BBJButton botaoDesativar = null;
    private BBJButton botaoAtivar = null;
    private BBJButton btnDetalhar;
    private BBJLabel labelCliente = null;
    private BBJLabel labelInscricao = null;
    private JPanel panelDadosCliente = null;
    private BBJPaginacao paginacao = null;
    private final String[] columnNames = new String[]{"Nome", "Conv\u00eanio", "Identifica\u00e7\u00e3o P/D\u00e9bito", "Cod. Banco", "Ag\u00eancia", "Conta Corr.", "Situa\u00e7\u00e3o", "Grupo"};
    private final int[] columnSizes = new int[]{320, 100, 280, 150, 120, 160, 160, 200};
    private final int[] columnAligment = new int[]{2, 2, 2, 2, 4, 4, 2, 2};
    protected BBJTablePagina<DadosCadastroClienteDebito> tabelaDebitos;
    private Map context;
    ManterClienteForm manterClienteForm;
    private ConvenenteTO convenente;

    public ViewManterDadosDebito() {
        super("Consultar Identifica\u00e7\u00f5es para D\u00e9bito", false, false);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getJPMain());
    }

    public void carregarListaDeDados() {
        this.consultarListaDadosDeDebito();
        this.preecherTabelaDados();
    }

    public JPanel getJPMain() {
        if (!this.isReferencia(this.jpMain)) {
            this.jpMain = this.getPainelFactory().novoJPainel();
            this.jpMain.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.jpMain.setBackground(Color.WHITE);
            this.jpMain.add((Component)this.getPainelCentro(), "North");
        }
        return this.jpMain;
    }

    public JPanel getPainelBotoes() {
        if (!this.isReferencia(this.painelBotoes)) {
            this.painelBotoes = this.getPainelFactory().novoJPainel();
            this.painelBotoes.setOpaque(false);
            FlowLayout flw = this.getLayoutFactory().novoFlowLayout();
            flw.setAlignment(2);
            this.painelBotoes.setLayout(flw);
            this.painelBotoes.add((Component)this.getBotaoNovo());
            this.painelBotoes.add((Component)this.getBotaoEditar());
            this.painelBotoes.add((Component)this.getBtnDetalhar());
            this.painelBotoes.add((Component)this.getBotaoExcluir());
            this.painelBotoes.add((Component)this.getBotaoDesativar());
            this.painelBotoes.add((Component)this.getBotaoAtivar());
            this.painelBotoes.add((Component)this.getBotaoVoltar());
        }
        return this.painelBotoes;
    }

    public BBJButton getBotaoEditar() {
        if (!this.isReferencia(this.botaoEditar)) {
            this.botaoEditar = new BBJButton("EDITAR", true);
            this.botaoEditar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterDadosDebito.this.abrirTelaEditar();
                }
            });
        }
        return this.botaoEditar;
    }

    public BBJButton getBtnDetalhar() {
        if (!this.isReferencia(this.btnDetalhar)) {
            this.btnDetalhar = new BBJButton("DETALHAR");
            this.btnDetalhar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterDadosDebito.this.abrirTelaDetalhar();
                }
            });
        }
        return this.btnDetalhar;
    }

    public BBJButton getBotaoDesativar() {
        if (!this.isReferencia(this.botaoDesativar)) {
            this.botaoDesativar = new BBJButton("DESATIVAR", true);
            this.botaoDesativar = this.getBotaoFactory().novoDesabilitar((PluginActionAbstrato)this.getDesabilitarSituacaoDebitoAction());
        }
        return this.botaoDesativar;
    }

    public BBJButton getBotaoAtivar() {
        if (!this.isReferencia(this.botaoAtivar)) {
            this.botaoAtivar = new BBJButton("ATIVAR", true);
            this.botaoAtivar = this.getBotaoFactory().novoAbilitar((PluginActionAbstrato)this.getAtivarSituacaoDebitoAction());
        }
        return this.botaoAtivar;
    }

    public BBJButton getBotaoExcluir() {
        if (!this.isReferencia(this.botaoExcluir)) {
            this.botaoExcluir = new BBJButton("EXCLUIR", true);
            this.botaoExcluir = this.getBotaoFactory().novoExcluir((PluginActionAbstrato)this.getExcluirDadosDeDebitoAction());
        }
        return this.botaoExcluir;
    }

    public BBJTablePagina<DadosCadastroClienteDebito> getTabelaDebitos() {
        if (!this.isReferencia(this.tabelaDebitos)) {
            this.tabelaDebitos = this.getPainelFactory().novoBBJTablePagina(this.columnNames, this.columnSizes, this.columnAligment, "", 0, 5, this.getBotoesPaginacao());
            this.tabelaDebitos.getTable().setPreferredSize(new Dimension(0, 320));
            this.tabelaDebitos.getTable().getBbtModel().setOrdenacaoAutomatica(false);
            this.tabelaDebitos.getTable().getBbtModel().setNomeColunas(new String[]{"identificadorClienteDebitoTO.pessoaTO.textoNome", "identificadorClienteDebitoTO.convenioDebitoTO.convenioTO.textoDescricaoConvenio", "identificadorClienteDebitoTO.textoIdentificadorDebito", "identificadorClienteDebitoTO.agenciaInstituicaoFinanceiraTO.instituicaoFinanceiraTO.textoNomeInstituicaoFinanceira", "identificadorClienteDebitoTO.agenciaInstituicaoFinanceiraTO.id.codigoAgencia", "identificadorClienteDebitoTO.contaCorrenteClienteTO.id.codigoContaCorrente", "identificadorClienteDebitoTO.situacaoIdentificadorDebitoTO.textoDescricao", "identificadorClienteDebitoTO.membroGrupoClienteRecebimentoTOs.grupoClienteRecebimentoTO.textoDescricao"});
            this.tabelaDebitos.getTable().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterDadosDebito.this.habilitarBotoes(e.getActionCommand().equalsIgnoreCase("SELECIONADO"));
                    if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewManterDadosDebito.this.ordenarTabela();
                    }
                }
            });
        }
        return this.tabelaDebitos;
    }

    private void habilitarBotoes(boolean habilitar) {
        this.getBotaoEditar().setEnabled(habilitar);
        this.getBotaoExcluir().setEnabled(habilitar);
        this.getBotaoDesativar().setEnabled(habilitar);
        this.getBotaoAtivar().setEnabled(habilitar);
        this.getBtnDetalhar().setEnabled(habilitar);
        if (habilitar) {
            char situacao = ((DadosCadastroClienteDebito)this.getTabelaDebitos().getObjetoSelecionado()).getIdentificadorClienteDebitoTODecorator().getSituacaoIdentificadorDebitoTO().getTextoSituacaoIdentificador();
            this.getBotaoExcluir().setEnabled(situacao == 'A' || situacao == 'O');
            this.getBotaoDesativar().setEnabled(situacao != 'I' && situacao != 'O');
            this.getBotaoAtivar().setEnabled(situacao != 'A' && situacao != 'O');
        }
    }

    public void preencherTela() {
        if (!this.getManterDadosDebitoForm().getManterClienteForm().isAcaoBotaoConsultar()) {
            this.consultarListaDadosDeDebito();
            this.getPaginacao().setValorMaximo(this.getForm().getNumeroDePaginas().intValue());
            this.preecherTabelaDados();
        } else {
            this.getManterDadosDebitoForm().getIdentificadorClienteDebitoTODecorator().setNomeColunaOrdenada(null);
            this.getManterDadosDebitoForm().getIdentificadorClienteDebitoTODecorator().setTipoOrdenacao(null);
        }
        this.getManterDadosDebitoForm().getManterClienteForm().setAcaoBotaoConsultar(false);
    }

    private BBJPaginacao getBotoesPaginacao() {
        BBJPaginacao paginacao = this.getPaginacao();
        paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ViewManterDadosDebito.this.getManterDadosDebitoForm().setPaginaAtual((Integer)evt.getNewValue());
                ViewManterDadosDebito.this.preencherTela();
            }
        });
        return paginacao;
    }

    protected IdentificadorClienteDebitoTODecorator getIdentificadorClienteDebitoTODecoratorSelecionado() {
        BBJTableImpl tableModel = this.getTabelaDebitos().getTable();
        BBJTable table = tableModel.getBbtModel();
        List lista = table.getItensChecadosCheckBox();
        IdentificadorClienteDebitoTODecorator identificadorClienteDebitoTODecorator = null;
        if (!UtilColecao.isVazio((Collection)lista)) {
            for (DadosCadastroClienteDebito dadosCadastro : lista) {
                identificadorClienteDebitoTODecorator = dadosCadastro.getIdentificadorClienteDebitoTODecorator();
            }
        } else {
            Collection<IdentificadorClienteDebitoTODecorator> colecaoIdentificadorDecorator = this.getManterDadosDebitoForm().getColecaoIdentificadorDecorator();
            if (!UtilColecao.isVazio(colecaoIdentificadorDecorator)) {
                identificadorClienteDebitoTODecorator = colecaoIdentificadorDecorator.iterator().next();
            }
        }
        return identificadorClienteDebitoTODecorator;
    }

    private void ordenarTabela() {
        BBJTableImpl table = this.getTabelaDebitos().getTable();
        BBJTable bbtModel = table.getBbtModel();
        this.getManterDadosDebitoForm().getIdentificadorClienteDebitoTODecorator().setNomeColunaOrdenada(bbtModel.getNomeColunaOrdenada());
        this.getManterDadosDebitoForm().getIdentificadorClienteDebitoTODecorator().setTipoOrdenacao(bbtModel.getTipoordenacao());
        if (bbtModel.getNomeColunaOrdenada() != null && !bbtModel.getNomeColunaOrdenada().equals("identificadorClienteDebitoTO.membroGrupoClienteRecebimentoTOs.grupoClienteRecebimentoTO.textoDescricao")) {
            this.preencherTela();
        }
    }

    public void setBotaoEditar(BBJButton botaoEditar) {
        this.botaoEditar = botaoEditar;
    }

    public DesativarSituacaoDebitoAction getDesabilitarSituacaoDebitoAction() {
        return this.getDBTActionFactory().novoDesativarSituacaoDebito();
    }

    public AtivarSituacaoDebitoAction getAtivarSituacaoDebitoAction() {
        return this.getDBTActionFactory().novoAtivarSituacaoDebito();
    }

    public void setBotaoExcluir(BBJButton botaoExcluir) {
        this.botaoExcluir = botaoExcluir;
    }

    public BBJButton getBotaoNovo() {
        if (!this.isReferencia(this.botaoNovo)) {
            this.botaoNovo = new BBJButton("NOVO", true);
            this.botaoNovo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterDadosDebito.this.abrirTelaNovo();
                }
            });
        }
        return this.botaoNovo;
    }

    public void setBotaoNovo(BBJButton botaoNovo) {
        this.botaoNovo = botaoNovo;
    }

    public BBJButton getBotaoVoltar() {
        if (!this.isReferencia(this.botaoVoltar)) {
            this.botaoVoltar = new BBJButton("VOLTAR", true);
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterDadosDebito.this.doClose(null);
                }
            };
            this.botaoVoltar.addActionListener(listener);
        }
        return this.botaoVoltar;
    }

    public void setBotaoVoltar(BBJButton botaoVoltar) {
        this.botaoVoltar = botaoVoltar;
    }

    public void setPainelBotoes(JPanel painelBotoes) {
        this.painelBotoes = painelBotoes;
    }

    public JPanel getPainelCentro() {
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this.getPainelSuperior(), "North");
        pnl.add((Component)this.getPainelBotoes(), "South");
        return pnl;
    }

    public JPanel getPainelSuperior() {
        JPanel pnl = this.getPainelFactory().novoJPainel();
        pnl.setOpaque(false);
        pnl.setLayout(this.getLayoutFactory().novoBorderLayout());
        pnl.add((Component)this.getPanelDadosConvenente(), "North");
        pnl.add((Component)this.getPainelJTable(), "Center");
        return pnl;
    }

    public JPanel getPainelJTable() {
        if (!this.isReferencia(this.painelJTable)) {
            this.painelJTable = this.getPainelFactory().novoJPainel();
            this.painelJTable.setOpaque(false);
            this.painelJTable.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.painelJTable.add((Component)this.getTabelaDebitos(), "North");
        }
        return this.painelJTable;
    }

    public void setPainelJTable(JPanel painelJTable) {
        this.painelJTable = painelJTable;
    }

    public JPanel getPanelDadosConvenente() {
        if (!this.isReferencia(this.panelDadosCliente)) {
            this.panelDadosCliente = this.getPainelFactory().novoJPainel();
            this.panelDadosCliente.setOpaque(false);
            this.panelDadosCliente.setLayout(this.getLayoutFactory().novoGridBagLayout());
            this.panelDadosCliente.setPreferredSize(this.getLayoutFactory().novoDimension(0, 35));
            this.panelDadosCliente.setBorder(BBJBordaOval.createOvalBorder());
            GridBagConstraints gbc = this.getLayoutFactory().novoGridBagConstraints();
            gbc.insets = this.getLayoutFactory().novoInsets(4, 6, 4, 6);
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.15;
            this.panelDadosCliente.add((Component)this.getPainelFactory().novoBBJLabel("Cliente:"), gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.5;
            this.panelDadosCliente.add((Component)this.getLabelCliente(), gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.15;
            this.panelDadosCliente.add((Component)this.getPainelFactory().novoBBJLabel("Inscri\u00e7\u00e3o:"), gbc);
            gbc.gridx = 3;
            gbc.weightx = 0.2;
            this.panelDadosCliente.add((Component)this.getLabelInscricao(), gbc);
            this.panelDadosCliente.setPreferredSize(this.getLayoutFactory().novoDimension(0, 50));
        }
        return this.panelDadosCliente;
    }

    public BBJLabel getLabelCliente() {
        if (!this.isReferencia(this.labelCliente)) {
            this.labelCliente = this.getPainelFactory().novoBBJLabel("");
        }
        return this.labelCliente;
    }

    public BBJLabel getLabelInscricao() {
        if (!this.isReferencia(this.labelInscricao)) {
            this.labelInscricao = this.getPainelFactory().novoBBJLabel("");
        }
        return this.labelInscricao;
    }

    public void doShow(Map context) {
        this.setContext(context);
        this.inicializaTela();
        this.carregarDados();
        this.setVisible(true);
        this.getBotaoNovo().requestFocus();
    }

    public void carregarDados() {
        if ((ManterClienteForm)((Object)this.getContext().get("FORM")) != null) {
            this.manterClienteForm = (ManterClienteForm)((Object)this.getContext().get("FORM"));
            this.getManterDadosDebitoForm().setPaginaAtual(1);
            this.getManterDadosDebitoForm().setManterClienteForm(this.manterClienteForm);
            this.getPaginacao().setValorPos(1);
            this.getPaginacao().atualiza();
        }
        if (this.manterClienteForm != null && this.manterClienteForm.getExibirLista() == 1) {
            this.getManterDadosDebitoForm().setColecaoClientes(this.manterClienteForm.getColecaoPessoaTO2());
            this.setListaDeClientes(true);
            this.getPanelDadosConvenente().setVisible(false);
            this.getContext().put("FORM", this.manterClienteForm);
        } else {
            PessoaTO pessoaTO = (PessoaTO)this.getContext().get("to");
            if (pessoaTO != null) {
                this.getManterDadosDebitoForm().setPessoaTO(pessoaTO);
                this.getManterDadosDebitoForm().setCodigoPessoaCliente(pessoaTO.getCodigoPessoa());
            } else {
                pessoaTO = this.getManterDadosDebitoForm().getPessoaTO();
            }
            this.getLabelCliente().setText(pessoaTO.getTextoNome());
            this.getLabelInscricao().setText("");
            for (IdentificacaoTO to : pessoaTO.getIdentificacaoTOs()) {
                if (to.getId().getCodigoTipoDocumento() != 1 && to.getId().getCodigoTipoDocumento() != 2) continue;
                IdentificacaoTODecorator decorador = this.getTOFactory().novoIdentificacaoTODecorator();
                decorador.setIdentificacaoTO(to);
                if (decorador.getTextoIdentificacao() == null) break;
                this.getLabelInscricao().setText(Utilitarios.formatarCPFouCNPJ((String)decorador.getTextoIdentificacao()));
                break;
            }
            this.setListaDeClientes(false);
            this.getPanelDadosConvenente().setVisible(true);
        }
        if (this.getManterDadosDebitoForm().getNomeColunaOrdenada() == null) {
            this.tabelaDebitos.getTable().getBbtModel().setColunaordenada(-1);
        }
        this.abilitarColunaNome(this.isListaDeClientes());
        this.preencherTela();
    }

    public void doClose(Map context) {
        this.tabelaDebitos.getTable().getBbtModel().setColunaordenada(-1);
        super.doClose(context);
    }

    public void consultarListaDadosDeDebito() {
        try {
            this.getConsultarDadosDebitoAction().executar(this.getManterDadosDebitoForm());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem((String)UtilBBException.getErroDeSistema((Throwable)e).getMessage());
        }
    }

    private ConsultarListaDadosDeDebitoAction getConsultarDadosDebitoAction() {
        return this.getDBTActionFactory().novoConsultarListaDadosDeDebitoAction();
    }

    public void preecherTabelaDados() {
        Collection<IdentificadorClienteDebitoTO> listaDebitos = this.getManterDadosDebitoForm().getColecaoDeRegistros();
        List dados = this.getColecaoFactory().novoArrayList();
        if (!UtilColecao.isVazio(listaDebitos)) {
            for (IdentificadorClienteDebitoTO debito : listaDebitos) {
                IdentificadorClienteDebitoTODecorator to = this.getTOFactory().novoIdentificadorClienteDebitoTODecorator();
                to.setIdentificadorClienteDebitoTO(debito);
                to.setAgenciaInstituicaoFinanceiraTODaDecorator(debito.getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO());
                dados.add(new DadosCadastroClienteDebito(to));
            }
        }
        this.getTabelaDebitos().setDataListTabela(dados);
    }

    protected PluginFormAbstrato novoForm() {
        return this.getDBTFormFactory().novoManterDadosDeDebitoForm();
    }

    public ManterDadosDeDebitoForm getManterDadosDebitoForm() {
        return (ManterDadosDeDebitoForm)this.getForm();
    }

    public void abrirTelaNovo() {
        PessoaTO pessoaTo = null;
        if (!this.isListaDeClientes()) {
            pessoaTo = this.getManterDadosDebitoForm().getPessoaTO();
        }
        this.getContext().put("Cliente", pessoaTo);
        this.getContext().put("ACAO", 1);
        ViewController.getInstance().goToView("DBTVIEWIDENTDEBTO", this.getContext());
    }

    public void abrirTelaEditar() {
        DadosCadastroClienteDebito dados = (DadosCadastroClienteDebito)this.getTabelaDebitos().getObjetoSelecionado();
        if (dados.getIdentificadorClienteDebitoTODecorator().getSituacaoIdentificadorDebitoTO().getTextoSituacaoIdentificador() != 'A') {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP051"));
            return;
        }
        this.getContext().put("Cliente", dados.getIdentificadorClienteDebitoTODecorator().getIdentificadorClienteDebitoTO().getPessoaTO());
        this.getContext().put("ACAO", 2);
        this.getContext().put("to", dados.getIdentificadorClienteDebitoTODecorator().getIdentificadorClienteDebitoTO());
        ViewController.getInstance().goToView("DBTVIEWIDENTDEBTO", this.getContext());
    }

    public void abrirTelaDetalhar() {
        DadosCadastroClienteDebito dados = (DadosCadastroClienteDebito)this.getTabelaDebitos().getObjetoSelecionado();
        this.getContext().put("Cliente", dados.getIdentificadorClienteDebitoTODecorator().getIdentificadorClienteDebitoTO().getPessoaTO());
        this.getContext().put("ACAO", 5);
        this.getContext().put("to", dados.getIdentificadorClienteDebitoTODecorator().getIdentificadorClienteDebitoTO());
        ViewController.getInstance().goToView("DBTVIEWIDENTDEBTO", this.getContext());
    }

    public ExcluirDadosDeDebitoAction getExcluirDadosDeDebitoAction() {
        return this.getDBTActionFactory().novoExcluirDadosDeDebitoAction();
    }

    public void preExecucaoCarregarViewEditarDadosDebitoAction() {
        this.getManterDadosDebitoForm().setIdentificadorClienteDebitoTODecorator(this.getIdentificadorClienteDebitoTODecoratorSelecionado());
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
        }
        return this.paginacao;
    }

    public void setPaginacao(BBJPaginacao paginacao) {
        this.paginacao = paginacao;
    }

    public void posExecucaoExcluirDadosDeDebitoAction() {
        if (this.getManterDadosDebitoForm().isExclusao()) {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP003"));
            this.preencherTela();
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP049"));
        }
    }

    public void preExecucaoExcluirDadosDeDebitoAction() {
        this.carregarDadosDebitoSelecionado();
    }

    public void preExecucaoDesativarSituacaoDebitoAction() {
        this.carregarDadosDebitoSelecionado();
    }

    public void preExecucaoAtivarSituacaoDebitoAction() {
        this.carregarDadosDebitoSelecionado();
    }

    public void posExecucaoDesativarSituacaoDebitoAction() {
        if (this.getManterDadosDebitoForm().isDesativar()) {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP059"));
            this.preencherTela();
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP060"));
        }
    }

    public void posExecucaoAtivarSituacaoDebitoAction() {
        if (this.getManterDadosDebitoForm().isAtivar()) {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP061"));
            this.preencherTela();
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP062"));
        }
    }

    private void carregarDadosDebitoSelecionado() {
        this.getManterDadosDebitoForm().setIdentificadorClienteDebitoTODecorator(this.getIdentificadorClienteDebitoTODecoratorSelecionado());
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    private void abilitarColunaNome(boolean abilitar) {
        if (abilitar) {
            this.getTabelaDebitos().getTable().getColumnModel().getColumn(1).setMaxWidth(320);
            this.getTabelaDebitos().getTable().getColumnModel().getColumn(1).setMinWidth(0);
            this.getTabelaDebitos().getTable().getColumnModel().getColumn(1).setPreferredWidth(320);
            this.getTabelaDebitos().getTable().fireTableDataChanged();
        } else {
            this.getTabelaDebitos().getTable().getColumnModel().getColumn(1).setMaxWidth(0);
            this.getTabelaDebitos().getTable().getColumnModel().getColumn(1).setMinWidth(0);
            this.getTabelaDebitos().getTable().getColumnModel().getColumn(1).setPreferredWidth(0);
            this.getTabelaDebitos().getTable().fireTableDataChanged();
        }
    }

    public boolean isListaDeClientes() {
        return this.getManterDadosDebitoForm().isListaDeClientes();
    }

    public void setListaDeClientes(boolean isListaDeClientes) {
        this.getManterDadosDebitoForm().setListaDeClientes(isListaDeClientes);
    }

    public void setTitulo(String titulo) {
        super.setTitulo(titulo);
        FramePrincipal.getInstance().getTitulodesktop().setTitulo(titulo);
        FramePrincipal.getInstance().getTitulodesktop().repaint();
    }

    public PessoaTO getPessoaTO() {
        return this.getConvenente().getPessoaTO();
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.getConvenente().setPessoaTO(pessoaTO);
    }

    public ConvenenteTO getConvenente() {
        return this.convenente;
    }
}

