/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.form.ManterRecebimentoForm;
import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.negocio.facade.ManterRecebimentoFacade;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectRecebimento;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.swing.IActionDeConfirmacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import java.util.ArrayList;
import java.util.List;

public class ExcluirListaDeRecebimentosAction
extends DBTPluginActionAbstrato
implements IActionDeConfirmacao {
    private ManterRecebimentoFacade facade;

    public void preExecutar(PluginFormAbstrato form) {
        form.setPermitirValidacao(false);
    }

    public String executar(PluginFormAbstrato form) throws BBException {
        ManterRecebimentoForm recebimentoForm = (ManterRecebimentoForm)form;
        this.excluir(recebimentoForm);
        return null;
    }

    public ManterRecebimentoFacade getManterRecebimentoFacade() {
        if (this.facade == null) {
            this.facade = this.getDBTFacadeFactory().novoManterRecebimentoFacade();
        }
        return this.facade;
    }

    public String getMensagemDeConfirmacao() {
        return this.getUtilMensagem().getMensagem("MN074");
    }

    private boolean SelecionadoETipoG(IObjectRecebimento recebimento) {
        return recebimento.getDebitoTO().getSituacaoRecebimentoTO().getCodigoSituacaoRecebimento().charValue() == 'G';
    }

    private boolean SelecionadoETipoO(IObjectRecebimento recebimento) {
        return recebimento.getDebitoTO().getSituacaoRecebimentoTO().getCodigoSituacaoRecebimento().charValue() == 'O';
    }

    private void excluir(ManterRecebimentoForm recebimentoForm) throws BBException {
        List<IObjectRecebimento> listaExcluirRecebimento = recebimentoForm.getListaExcluirRecebimento();
        ArrayList listaSemSucessoRecebimentoDebitoTODecorators = new ArrayList(listaExcluirRecebimento.size());
        for (IObjectRecebimento iObjectRecebimento : listaExcluirRecebimento) {
            RecebimentoDebitoTODecorator decorator = DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator();
            decorator.setRecebimentoDebitoTO(iObjectRecebimento.getDebitoTO());
            this.getManterRecebimentoFacade().excluir(decorator);
        }
        if (listaSemSucessoRecebimentoDebitoTODecorators.size() == listaExcluirRecebimento.size()) {
            BBJPopupMensagem.exibirMensagemErro((String)this.getMensagem("MP052"));
        } else if (listaSemSucessoRecebimentoDebitoTODecorators.size() > 0) {
            BBJPopupMensagem.exibirMensagemErro((String)this.getMensagem("MP065"));
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP003"));
        }
    }

    protected String getMensagem(String mensagem) {
        return UtilMensagem.getInstancia().getMensagem(mensagem);
    }
}

