/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action.CarregarPopupImprimirRecebimentosAction;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action.ConsultarRecebimentosAction;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action.ExcluirRecebimentosAction;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.form.ConsultarRecebimentosForm;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.view.ViewExcluirListaDeRecebimentos;
import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectRecebimento;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPanelInformacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import br.com.bb.plugins.gac.util.swing.menu.BBJMigalha;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGerenciarRecebimentosListar
extends DBTBasicInternalFrame {
    private final String[] columnNames = new String[]{"Nome", "Conv\u00eanio", "Data", "Situa\u00e7\u00e3o", "Data Remessa", "Valor"};
    private final int[] columnSizes = new int[]{550, 150, 150, 150, 150, 50};
    private final int[] columnAligment;
    private JPanel panelRodape;
    public static final int RECEBIMENTOS_DEBITO = 4;
    private BBJTableImpl<IObjectRecebimento> tabelaRemessa;
    private BBJLabel lblValorTotal;
    private JPanel panelPrincipal;
    private JPanel panelInformacao;
    private JPanel panelDados;
    private JPanel panelSuperior;
    private JPanel panelBotoes;
    private BBJPaginacao paginacao;
    private BBJButton btnNovo;
    private BBJButton btnEditar;
    private BBJButton btnDetalhar;
    private BBJButton btnExcluir;
    private BBJButton btnVoltar;
    private BBJButton btnImprimir;
    private Map context;
    private BBJPanelInformacao panelValorTotal;
    private BBJButton btnDesmarcarTodos;
    private BBJButton btnMarcarTodos;

    public BBJPaginacao getPaginacao() {
        if (!this.isReferencia(this.paginacao)) {
            this.paginacao = new BBJPaginacao();
        }
        return this.paginacao;
    }

    public void setPaginacao(BBJPaginacao paginacao) {
        this.paginacao = paginacao;
    }

    public ViewGerenciarRecebimentosListar() {
        super("Consultar Lan\u00e7amentos", false, false);
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[5] = 4;
        this.columnAligment = nArray;
        this.panelRodape = null;
        this.panelDados = null;
        this.panelSuperior = null;
        this.panelValorTotal = null;
        this.setLayout(new BorderLayout());
        this.add(this.getPanelInformacao(), "North");
        this.add(this.getPanelPrincipal(), "Center");
        this.setBackground(Color.white);
    }

    public JPanel getPanelInformacao() {
        if (this.panelInformacao == null) {
            this.panelInformacao = this.getPainelFactory().novoJPainel();
            this.panelInformacao.setOpaque(false);
            this.panelInformacao.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
            this.panelInformacao.setLayout(new BorderLayout());
            this.panelInformacao.add((Component)new BBJLabel("Selecione o lan\u00e7amento e escolha a op\u00e7\u00e3o desejada"));
            this.panelInformacao.setPreferredSize(new Dimension(0, 30));
        }
        return this.panelInformacao;
    }

    public void doShow(Map context) {
        this.setContext(context);
        this.setForm(null);
        this.getTabelaRemessa().getBbtModel().setDataListTabela(null);
        Object form = this.getContext().get("FORM");
        this.habilitaBotoes();
        this.getPanelValorTotal().setValor("0,00");
        if (form instanceof ConsultarRecebimentosForm) {
            this.setFormAnterior((ConsultarRecebimentosForm)((Object)form));
            this.getConsultarRecebimentosForm().setPaginaAtual(1);
            this.getPaginacao().setValorPos(1);
            this.getPaginacao().setValorMaximo(this.getConsultarRecebimentosForm().getNumeroDePaginas().intValue());
            this.getPaginacao().atualiza();
        } else {
            this.getConsultarRecebimentosForm().setAcaoBotaoConsultar(true);
            this.consultarListaRecebimentos();
        }
        this.getConsultarRecebimentosForm().setAcaoBotaoConsultar(false);
        this.atualizaTabela();
        super.doShow(context);
        this.getBtnNovo().requestFocus();
        this.setVisible(true);
    }

    public void doClose(Map context) {
        this.getTabelaRemessa().getBbtModel().setColunaordenada(-1);
        this.setVisible(false);
        super.doClose(context);
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = this.getPainelFactory().novoJPainel();
            this.panelBotoes.setBackground(Color.white);
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = this.getLayoutFactory().novoFlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add((Component)this.getBtnNovo());
            this.panelBotoes.add((Component)this.getBtnEditar());
            this.panelBotoes.add((Component)this.getBtnDetalhar());
            this.panelBotoes.add((Component)this.getBtnMarcarTodos());
            this.panelBotoes.add((Component)this.getBtnDesmarcarTodos());
            this.panelBotoes.add((Component)this.getBtnExcluir());
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBtnNovo() {
        if (!this.isReferencia(this.btnNovo)) {
            this.btnNovo = new BBJButton("NOVO");
            this.btnNovo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarRecebimentosListar.this.getContext().put("ACAO", 1);
                    ViewController.getInstance().goToView("DBTGERNOVORECEBIMENTO", ViewGerenciarRecebimentosListar.this.getContext());
                }
            });
        }
        return this.btnNovo;
    }

    public BBJButton getBtnEditar() {
        if (!this.isReferencia(this.btnEditar)) {
            this.btnEditar = new BBJButton("EDITAR");
            this.btnEditar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarRecebimentosListar.this.getContext().put("ACAO", 2);
                    ViewGerenciarRecebimentosListar.this.getContext().put("to", ViewGerenciarRecebimentosListar.this.getDecoratorSelecionado());
                    ViewController.getInstance().goToView("DBTGERRECEBNOVO", ViewGerenciarRecebimentosListar.this.getContext());
                }
            });
        }
        return this.btnEditar;
    }

    public BBJButton getBtnDetalhar() {
        if (!this.isReferencia(this.btnDetalhar)) {
            this.btnDetalhar = new BBJButton("DETALHAR");
            this.btnDetalhar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarRecebimentosListar.this.getContext().put("ACAO", 5);
                    ViewGerenciarRecebimentosListar.this.getContext().put("to", ViewGerenciarRecebimentosListar.this.getDecoratorSelecionado());
                    ViewController.getInstance().goToView("DBTGERRECEBNOVO", ViewGerenciarRecebimentosListar.this.getContext());
                }
            });
        }
        return this.btnDetalhar;
    }

    private RecebimentoDebitoTODecorator getDecoratorSelecionado() {
        List lista = this.getTabelaRemessa().getBbtModel().getItensChecadosCheckBox();
        if (lista.size() == 0) {
            return null;
        }
        IObjectRecebimento obj = (IObjectRecebimento)((Object)lista.get(0));
        RecebimentoDebitoTODecorator decorator = DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator();
        decorator.setRecebimentoDebitoTO(obj.getDebitoTO());
        return decorator;
    }

    public BBJButton getBtnExcluir() {
        if (!this.isReferencia(this.btnExcluir)) {
            ExcluirRecebimentosAction acao = this.getDBTActionFactory().novoExcluirRecebimentosAction();
            this.btnExcluir = this.getBotaoFactory().novoExcluir((PluginActionAbstrato)acao);
        }
        return this.btnExcluir;
    }

    public void preExecucaoExcluirRecebimentosAction() {
        this.getConsultarRecebimentosForm().setRecebimentoSelecionado(this.getDecoratorSelecionado());
    }

    public void preExecucaoMostraViewExcluirListaDeRecebimentosAction() {
    }

    public void posExecucaoExcluirRecebimentosAction() {
        BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP003"));
        this.getTabelaRemessa().getBbtModel().setDataListTabela(null);
        this.consultarListaRecebimentos();
        this.atualizaTabela();
    }

    public void posExecucaoMostraViewExcluirListaDeRecebimentosAction() {
        this.mostraViewExcluirListaRecebimento();
    }

    private void mostraViewExcluirListaRecebimento() {
        this.getContext().put("FORM", this.getConsultarRecebimentosForm());
        this.getContext().put("colecao", this.getListaLancamentoSelecionado());
        BBJMigalha.getInstance().Empilhar("DBTGERRECEBLISTAR", "Excluir Lan\u00e7amentos");
        ViewExcluirListaDeRecebimentos view = (ViewExcluirListaDeRecebimentos)ViewController.getInstance().goToView("DBTEXCLUIRLISTADERECEBIMENTOS", this.getContext(), false);
    }

    public BBJButton getBtnImprimir() {
        if (this.btnImprimir == null) {
            CarregarPopupImprimirRecebimentosAction acao = this.getDBTActionFactory().novoCarregarPopupImprimirRecebimentosAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.btnImprimir;
    }

    public void posExecucaoCarregarPopupImprimirRecebimentosAction() {
        this.getContext().put("FORM", this.getForm());
        this.getContext().put("TIPO_RELATORIO", 4);
        ControlableView view = ViewController.getInstance().goToView("DBTRELATORIOSRECEBIMENTOS", null, false);
        view.doShow(this.getContext());
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public BBJButton getBtnVoltar() {
        if (!this.isReferencia(this.btnVoltar)) {
            this.btnVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.btnVoltar;
    }

    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    private JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = this.getPainelFactory().novoJPainel();
            this.panelPrincipal.setLayout(new BorderLayout());
            this.panelPrincipal.add((Component)this.getPainelSuperior(), "North");
            this.panelPrincipal.add((Component)this.getPanelBotoes(), "Center");
            this.panelPrincipal.setOpaque(false);
        }
        return this.panelPrincipal;
    }

    public JPanel getPainelSuperior() {
        if (this.panelSuperior == null) {
            this.panelSuperior = this.getPainelFactory().novoJPainel();
            this.panelSuperior.setOpaque(false);
            this.panelSuperior.setLayout(new BorderLayout());
            this.panelSuperior.add((Component)this.getPanelDados(), "North");
            this.panelSuperior.add((Component)this.getPanelRodape(), "Center");
            this.panelSuperior.add((Component)this.getBotoesPaginacao(), "South");
        }
        return this.panelSuperior;
    }

    public JPanel getPanelDados() {
        if (this.panelDados == null) {
            this.panelDados = this.getPainelFactory().novoJPainel();
            this.panelDados.setLayout(new BorderLayout());
            this.panelDados.add((Component)this.getTabelaRemessa().getTable().getTableHeader(), "North");
            this.panelDados.add((Component)this.getTabelaRemessa(), "Center");
            this.panelDados.setBorder(BBJBordaOval.createOvalBorder());
            this.panelDados.setOpaque(false);
            this.panelDados.setPreferredSize(new Dimension(0, 350));
        }
        return this.panelDados;
    }

    private JPanel getPanelRodape() {
        if (this.panelRodape == null) {
            this.panelRodape = this.getPainelFactory().novoJPainel();
            this.panelRodape.setOpaque(false);
            this.panelRodape.setLayout(new FlowLayout(2));
            this.panelRodape.setPreferredSize(new Dimension(0, 30));
            this.panelRodape.add((Component)this.getPanelValorTotal());
        }
        return this.panelRodape;
    }

    public BBJTableImpl<IObjectRecebimento> getTabelaRemessa() {
        if (!this.isReferencia(this.tabelaRemessa)) {
            this.tabelaRemessa = new BBJTableImpl(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tabelaRemessa.setPreferredSize(new Dimension(0, 240));
            this.tabelaRemessa.setNomeColunas(new String[]{"identificadorClienteDebitoTO.contaCorrenteClienteTO.pessoaTO.textoNome", "convenioDebitoTO.convenioTO.numeroConvenio", "dataRecebimento", "situacaoRecebimentoTO.textoDescricao", "remessaTO.dataRemessa", "valorRecebimento"});
            this.tabelaRemessa.setOrdenacaoAutomatica(false);
            this.tabelaRemessa.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewGerenciarRecebimentosListar.this.ordenarTabela();
                    }
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO") || e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewGerenciarRecebimentosListar.this.habilitaBotoes();
                        ViewGerenciarRecebimentosListar.this.definaAcaoBotaoExcluir();
                    }
                }
            });
        }
        return this.tabelaRemessa;
    }

    protected void definaAcaoBotaoExcluir() {
        this.getBtnExcluir().setAcao((PluginActionAbstrato)(this.maisDeUmItem() ? this.getDBTActionFactory().novoMostraViewExcluirListaDeRecebimentosAction() : this.getDBTActionFactory().novoExcluirRecebimentosAction()));
    }

    private void habilitaBotoes() {
        this.getBtnEditar().setEnabled(this.SelecionadoETipoG() || this.SelecionadoETipoO());
        this.getBtnExcluir().setEnabled(this.umItem() || this.maisDeUmItem());
        this.getBtnDetalhar().setEnabled(this.umItem());
        this.getBtnDesmarcarTodos().setEnabled(this.maisDeZeroItemSelecionado());
        this.getBtnImprimir().setEnabled(this.listaNaoVaziaAtivaBotaoImprimir());
    }

    private boolean maisDeZeroItemSelecionado() {
        return this.getTabelaRemessa().getPaginaItensChecadosCheckBox().size() > 0;
    }

    private boolean maisDeUmItem() {
        return this.getTabelaRemessa().getPaginaItensChecadosCheckBox().size() > 1;
    }

    private boolean listaNaoVaziaAtivaBotaoImprimir() {
        return this.getConsultarRecebimentosForm() != null && this.getConsultarRecebimentosForm().getPaginadorTO() != null && this.getConsultarRecebimentosForm().getPaginadorTO().getColecaoDeRegistros() != null && this.getConsultarRecebimentosForm().getPaginadorTO().getColecaoDeRegistros().size() > 0;
    }

    private boolean SelecionadoETipoG() {
        Iterator iterator;
        if (this.umItem() && (iterator = this.getTabelaRemessa().getPaginaItensChecadosCheckBox().iterator()).hasNext()) {
            IObjectRecebimento recebimento = (IObjectRecebimento)((Object)iterator.next());
            return recebimento.getDebitoTO().getSituacaoRecebimentoTO().getCodigoSituacaoRecebimento().charValue() == 'G';
        }
        return false;
    }

    private boolean umItem() {
        return this.getTabelaRemessa().getPaginaItensChecadosCheckBox().size() == 1;
    }

    private boolean SelecionadoETipoO() {
        Iterator iterator;
        if (this.umItem() && (iterator = this.getTabelaRemessa().getPaginaItensChecadosCheckBox().iterator()).hasNext()) {
            IObjectRecebimento recebimento = (IObjectRecebimento)((Object)iterator.next());
            return recebimento.getDebitoTO().getSituacaoRecebimentoTO().getCodigoSituacaoRecebimento().charValue() == 'O';
        }
        return false;
    }

    private void ordenarTabela() {
        BBJTable model = this.getTabelaRemessa().getBbtModel();
        this.getConsultarRecebimentosForm().setTipoOrdenacao(model.getTipoordenacao());
        this.getConsultarRecebimentosForm().setNomeColunaOrdenada(model.getNomeColunaOrdenada());
        this.consultarListaRecebimentos();
        this.atualizaTabela();
    }

    private BBJPaginacao getBotoesPaginacao() {
        BBJPaginacao paginacao = this.getPaginacao();
        paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ViewGerenciarRecebimentosListar.this.getConsultarRecebimentosForm().setPaginaAtual((Integer)evt.getNewValue());
                if (!ViewGerenciarRecebimentosListar.this.getConsultarRecebimentosForm().isAcaoBotaoConsultar()) {
                    ViewGerenciarRecebimentosListar.this.consultarListaRecebimentos();
                }
                ViewGerenciarRecebimentosListar.this.atualizaTabela();
                ViewGerenciarRecebimentosListar.this.habilitaBotoes();
            }
        });
        return paginacao;
    }

    protected void consultarListaRecebimentos() {
        ConsultarRecebimentosAction action = this.getDBTActionFactory().novoConsultarRecebimentosAction();
        try {
            action.executar(this.getConsultarRecebimentosForm());
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem((String)e.getMessage());
        }
    }

    private void atualizaTabela() {
        Collection colecaoPessoaTO = this.getConsultarRecebimentosForm().getPaginadorTO().getColecaoDeRegistros();
        ArrayList<IObjectRecebimento> dados = new ArrayList<IObjectRecebimento>();
        if (!UtilColecao.isVazio((Collection)colecaoPessoaTO)) {
            for (RecebimentoDebitoTO debitoTO : colecaoPessoaTO) {
                dados.add(new IObjectRecebimento(debitoTO));
            }
        }
        this.getPanelValorTotal().setValor(this.getConsultarRecebimentosForm().getTotalRecebimentos() != null ? " " + UtilFormatadorDeReal.formatar((Number)this.getConsultarRecebimentosForm().getTotalRecebimentos()) : "");
        this.getTabelaRemessa().getBbtModel().addDataListTabela(dados);
        this.habilitaBotoes(false);
        if (this.getConsultarRecebimentosForm().getRecebimentoTODecorator().getNomeColunaOrdenada() == null) {
            this.tabelaRemessa.getBbtModel().setColunaordenada(-1);
        }
    }

    private void habilitaBotoes(boolean habilita) {
        this.getBtnEditar().setEnabled(habilita);
        this.getBtnExcluir().setEnabled(habilita);
        this.getBtnDetalhar().setEnabled(habilita);
    }

    private ConsultarRecebimentosForm getConsultarRecebimentosForm() {
        return this.novoForm();
    }

    protected ConsultarRecebimentosForm novoForm() {
        return (ConsultarRecebimentosForm)this.getFormAnterior();
    }

    public BBJPanelInformacao getPanelValorTotal() {
        if (this.panelValorTotal == null) {
            this.panelValorTotal = new BBJPanelInformacao("Valor Total:", 150, 100);
            this.panelValorTotal.setAlinhamentotitulo(2);
            this.panelValorTotal.setAlinhamentovalor(4);
        }
        return this.panelValorTotal;
    }

    protected List<IObjectRecebimento> getListaLancamentoSelecionado() {
        return this.getTabelaRemessa().getPaginaItensChecadosCheckBox();
    }

    public BBJButton getBtnMarcarTodos() {
        if (this.btnMarcarTodos == null) {
            this.btnMarcarTodos = new BBJButton("MARCAR TODOS");
            this.btnMarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarRecebimentosListar.this.marcarTodosRegistros(true);
                    ViewGerenciarRecebimentosListar.this.habilitaBotoes();
                }
            });
        }
        return this.btnMarcarTodos;
    }

    public BBJButton getBtnDesmarcarTodos() {
        if (this.btnDesmarcarTodos == null) {
            this.btnDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.btnDesmarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerenciarRecebimentosListar.this.marcarTodosRegistros(false);
                    ViewGerenciarRecebimentosListar.this.habilitaBotoes();
                }
            });
        }
        return this.btnDesmarcarTodos;
    }

    private void marcarTodosRegistros(boolean selected) {
        this.getTabelaRemessa().getBbtModel().marcaTodos(selected);
    }
}

