/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.CamposLeiauteDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.LeiauteDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.TipoRetornoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.ExportarDadosDeDebitoRecebimentoTODecorator;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeCharacter;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.data.UtilData;
import br.com.politec.generico.formatador.UtilFormatadorDeCPFouCNPJ;
import br.com.politec.generico.formatador.UtilFormatadorDeData;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportarDadosDeDebitoRecebimentoModel
extends PluginModelAbstrato {
    private InstituicaoFinanceiraDAO instituicaoFinanceiraDAO;
    private IdentificacaoDAO identificacaoDAO;
    private PessoaDAO pessoaDAO;
    private TipoDocumentoDAO tipoDocumentoDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private RemessaDAO remessaDAO;
    private ConvenentePessoaDAO convenentePessoaDAO;
    private CamposLeiauteDAO camposLeiauteDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private LeiauteDAO leiauteDao;
    private LeiauteTO leiauteTO;
    private ConvenentePessoaTO convenentePessoaTO;

    public ConvenentePessoaTO getConvenentePessoaTO() {
        return this.convenentePessoaTO;
    }

    public void setConvenentePessoaTO(ConvenentePessoaTO convenentePessoaTO) {
        this.convenentePessoaTO = convenentePessoaTO;
    }

    public PaginadorTO listar(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        PaginadorTO paginador = this.getConvenentePessoaDAO().consultarPorFiltro(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator());
        Collection colecao = paginador.getColecaoDeRegistros();
        ArrayList<ConvenentePessoaTODecorator> colecaoDecorator = new ArrayList<ConvenentePessoaTODecorator>();
        for (ConvenentePessoaTO convenentePessoaTO : colecao) {
            colecaoDecorator.add(this.novoConvenentePessoaTODecorator(convenentePessoaTO));
        }
        paginador.setColecaoDeRegistros(colecaoDecorator);
        return paginador;
    }

    private ConvenentePessoaTODecorator novoConvenentePessoaTODecorator(ConvenentePessoaTO convenentePessoaTO) {
        ConvenentePessoaTODecorator decorator = this.getFabricaDeTO().novoConvenentePessoaTODecorator(convenentePessoaTO);
        Set colecaoIdentificaoTO = convenentePessoaTO.getPessoaTO().getIdentificacaoTOs();
        IdentificacaoTO cpfCnpjIdentificacaoTO = null;
        for (IdentificacaoTO identificacaoTO : colecaoIdentificaoTO) {
            Integer codigoTipoDocumento;
            if (!this.isReferencia(identificacaoTO.getTipoDocumentoTO()) || !UtilDominioTipoDocumento.CPF_PF.equals(codigoTipoDocumento = identificacaoTO.getTipoDocumentoTO().getCodigoTipoDocumento()) && !UtilDominioTipoDocumento.CNPJ_PJ.equals(codigoTipoDocumento)) continue;
            cpfCnpjIdentificacaoTO = identificacaoTO;
            String cpfCnpj = UtilString.trim((String)cpfCnpjIdentificacaoTO.getTextoIdentificacao());
            cpfCnpjIdentificacaoTO.setTextoIdentificacao(UtilFormatadorDeCPFouCNPJ.formatar((String)cpfCnpj));
        }
        decorator.setIdentificacaoTO(cpfCnpjIdentificacaoTO);
        return decorator;
    }

    protected void recuperarValorEAtribuir(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) {
        exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getConvenioTO().getId().setNumeroConvenio(exportarDadosDeDebitoRecebimentoTODecorator.getConvenioTO().getId().getNumeroConvenio());
    }

    protected void validaDadosDeExportacao(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        if (!UtilString.isVazio((String)exportarDadosDeDebitoRecebimentoTODecorator.getTextoNome())) {
            this.isExisteNome(exportarDadosDeDebitoRecebimentoTODecorator);
        }
        if (!UtilString.isVazio((String)exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getIdentificacaoTO().getTextoComplemento())) {
            this.isExisteIdentificacao(exportarDadosDeDebitoRecebimentoTODecorator);
        }
        if (!UtilString.isVazio((String)exportarDadosDeDebitoRecebimentoTODecorator.getTextoIdentificadorDebito())) {
            this.isExisteIdentificadorParaDebito(exportarDadosDeDebitoRecebimentoTODecorator);
        }
        if (this.isReferencia(exportarDadosDeDebitoRecebimentoTODecorator.getCodigoInstituicaoFinanceira())) {
            this.isExisteInstituicaoFinanceira(exportarDadosDeDebitoRecebimentoTODecorator);
        }
        if (!UtilString.isVazio((String)exportarDadosDeDebitoRecebimentoTODecorator.getTextoIdentificacao())) {
            this.isExisteTipoDocumento(exportarDadosDeDebitoRecebimentoTODecorator);
        }
        if (this.isReferencia(exportarDadosDeDebitoRecebimentoTODecorator.getCodigoContaCorrente()) && this.isReferencia(exportarDadosDeDebitoRecebimentoTODecorator.getInstituicaoFinanceiraTO().getCodigoInstituicaoFinanceira())) {
            this.isExisteDadosContaCliente(exportarDadosDeDebitoRecebimentoTODecorator);
        }
        if (this.isReferencia(exportarDadosDeDebitoRecebimentoTODecorator.getDataRemessa())) {
            this.isExisteDataDeRemessa(exportarDadosDeDebitoRecebimentoTODecorator);
        }
    }

    public boolean isExisteTipoInscricao(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retornaCodigo = this.isExisteTipoDocumento(exportarDadosDeDebitoRecebimentoTODecorator);
        boolean retorno = false;
        retorno = this.getIdentificacaoDAO().isExistePorIdentificacaoETipoDocumento(exportarDadosDeDebitoRecebimentoTODecorator.getPessoaTODecorator().getIdentificacaoTO());
        return retorno;
    }

    public boolean isExisteNome(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retorno = false;
        retorno = this.getPessoaDAO().isPossuiDocumentoPorNome(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getPessoaTO());
        return retorno;
    }

    public boolean isExisteIdentificacao(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retorno = false;
        retorno = this.getIdentificacaoDAO().isExistePorIdentificacaoETipoDocumento(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getIdentificacaoTO());
        return retorno;
    }

    public boolean isExisteTipoDocumento(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        Collection retorno = null;
        TipoDocumentoTO tipoDocumento = this.getFabricaDeTO().novoTipoDocumentoTO();
        exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getIdentificacaoTO().getTipoDocumentoTO().setTextoDescricao("Refer\u00eancia");
        retorno = this.getTipoDocumentoDAO().consultarPorTextoDescricao(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getIdentificacaoTO().getTipoDocumentoTO());
        if (!UtilColecao.isVazio((Collection)retorno)) {
            for (TipoDocumentoTO tipoDocumentoTO : retorno) {
                Integer codigoTipoDocumento = tipoDocumentoTO.getCodigoTipoDocumento();
                tipoDocumento.setCodigoTipoDocumento(codigoTipoDocumento);
            }
        }
        boolean retornoTo = false;
        retornoTo = this.getIdentificacaoDAO().isExistePorIdentificacaoETipoDocumento(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getIdentificacaoTO());
        if (!retornoTo) {
            throw new BBException("MN004", "Tipo Documento");
        }
        return retornoTo;
    }

    public boolean isExisteIdentificadorParaDebito(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retorno = false;
        retorno = this.getIdentificadorClienteDebitoDAO().isExistePeloTextoDeIdentificacao(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getIdentificadorClienteDebitoTO());
        return retorno;
    }

    public boolean isInstituicaoFinanceira(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retorno = this.getInstituicaoFinanceiraDAO().isExisteRegistro(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getConvenioTO().getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO().getInstituicaoFinanceiraTO());
        return retorno;
    }

    public boolean isExisteInstituicaoFinanceira(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        InstituicaoFinanceiraTO instituicaoFinanceiraTO = exportarDadosDeDebitoRecebimentoTODecorator.getInstituicaoFinanceiraTO();
        if (!this.isReferencia(instituicaoFinanceiraTO) || !this.isReferencia(instituicaoFinanceiraTO.getCodigoInstituicaoFinanceira())) {
            instituicaoFinanceiraTO = this.getFabricaDeTO().novoInstituicaoFinanceiraTO();
            instituicaoFinanceiraTO.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        }
        boolean retorno = this.getInstituicaoFinanceiraDAO().isExisteRegistro(exportarDadosDeDebitoRecebimentoTODecorator.getInstituicaoFinanceiraTO());
        return retorno;
    }

    public boolean isExisteDadosContaCliente(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retorno = false;
        int codigo = exportarDadosDeDebitoRecebimentoTODecorator.getCodigoContaCorrente().intValue();
        exportarDadosDeDebitoRecebimentoTODecorator.getContaCorrenteClienteTODecorator().getAgenciaInstituicaoFinanceiraTOId().setCodigoInstituicaoFinanceira(Integer.valueOf(codigo));
        retorno = this.getContaCorrenteClienteDAO().isExistePelaInstituicaoAgenciaEConta(exportarDadosDeDebitoRecebimentoTODecorator.getConvenentePessoaTODecorator().getConvenioTO().getContaCorrenteClienteTO());
        return retorno;
    }

    public boolean isExisteDataDeRemessa(ExportarDadosDeDebitoRecebimentoTODecorator exportarDadosDeDebitoRecebimentoTODecorator) throws BBException {
        boolean retorno = false;
        retorno = this.getRemessaDAO().isExistePorDataDeRemessa(exportarDadosDeDebitoRecebimentoTODecorator.getRemessaTO());
        return retorno;
    }

    public int exportar(RecebimentoDebitoTODecorator decorator, LeiauteTO leiauteTO, String pastaDestinoExportacao) {
        List<RecebimentoDebitoTO> listaRecebimentos = this.getRecebimentoDebitoDAO().listarPorFiltro(decorator);
        int resultado = -1;
        try {
            this.montarArquivoExportacao(decorator.getNotificaExportacao(), listaRecebimentos, leiauteTO, pastaDestinoExportacao);
            resultado = listaRecebimentos.size();
        }
        catch (FileNotFoundException e) {
            BBJPopupMensagem.exibirMensagem((String)UtilBBException.getErroDeSistema((IOException)e).getMessage());
        }
        catch (IOException e) {
            BBJPopupMensagem.exibirMensagem((String)UtilBBException.getErroDeSistema((IOException)e).getMessage());
        }
        return resultado;
    }

    private Collection<CamposLeiauteTO> recuperaCamposLeiaute(TipoLeiauteTO tipoLeiauteTO) {
        tipoLeiauteTO.getServicoTO().setTextoIdentificadorServico("DBT");
        tipoLeiauteTO.setTextoTipoOperacao("EXP");
        return this.getCamposLeiauteDAO().consultarPorTipoDeLeiaute(tipoLeiauteTO);
    }

    private void montarArquivoExportacao(UtilNotificador notificador, Collection<RecebimentoDebitoTO> colecaoDadosClientes, LeiauteTO leiauteTO, String pastaDestinoExportacao) throws FileNotFoundException, IOException {
        Set colecaoCamposLeiauteTO = leiauteTO.getCamposLeiauteTOs();
        int registroAtual = 1;
        int totalRegistros = colecaoDadosClientes.size();
        this.criaPastasSeNecessario(pastaDestinoExportacao);
        BufferedWriter bufferedWriter = this.getBufferedWriter(pastaDestinoExportacao);
        for (RecebimentoDebitoTO recebDebito : colecaoDadosClientes) {
            bufferedWriter.write(this.geraNovaLinhaArquivo(recebDebito, colecaoCamposLeiauteTO));
            this.atualizaPorcentagem(notificador, totalRegistros, ++registroAtual);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private BufferedWriter getBufferedWriter(String pastaDestinoExportacao) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getPathArquivoExportacao(pastaDestinoExportacao))));
    }

    private String geraNovaLinhaArquivo(RecebimentoDebitoTO to, Collection<CamposLeiauteTO> camposLeiaute) {
        StringBuffer novaLinha = new StringBuffer();
        RecebimentoDebitoTODecorator decorator = DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator();
        decorator.setRecebimentoDebitoTO(to);
        for (CamposLeiauteTO camposLeiauteTO : camposLeiaute) {
            int tamanhoCampo = camposLeiauteTO.getNumeroTamanhoCampo();
            String nomeCampo = camposLeiauteTO.getTextoNomeCampo();
            String valorCampo = this.getValorCampo(nomeCampo, to, tamanhoCampo);
            novaLinha.append(this.getCampo(tamanhoCampo, valorCampo));
        }
        return String.valueOf(novaLinha.toString()) + "\n";
    }

    private String getValorCampo(String nomeCampo, RecebimentoDebitoTO to, int tamanhoCampo) {
        String valor = "";
        if (nomeCampo.equalsIgnoreCase("TX_NM")) {
            PessoaTO pessoa = this.getPessoaTO(to);
            valor = this.retornaNaoNulo(pessoa.getTextoNome());
        } else if (nomeCampo.equalsIgnoreCase("CD_TIP_DOC")) {
            IdentificacaoTO identificacaoTO = this.getIdentificacaoPessoaTO(to);
            if (this.isReferencia(identificacaoTO)) {
                valor = this.retornaNaoNulo(identificacaoTO.getId().getCodigoTipoDocumento());
            }
        } else if (nomeCampo.equalsIgnoreCase("TX_IDFC")) {
            IdentificacaoTO identificacaoTO = this.getIdentificacaoPessoaTO(to);
            if (this.isReferencia(identificacaoTO)) {
                valor = this.retornaNaoNulo(identificacaoTO.getId().getTextoIdentificacao());
            }
        } else if (nomeCampo.equalsIgnoreCase("TX_LGR")) {
            LogradouroTO logradouro = this.getLogradouroTO(to);
            valor = this.retornaNaoNulo(logradouro.getTextoLogradouro());
        } else if (nomeCampo.equalsIgnoreCase("TX_BAI")) {
            LogradouroTO logradouro = this.getLogradouroTO(to);
            valor = this.retornaNaoNulo(logradouro.getTextoBairro());
        } else if (nomeCampo.equalsIgnoreCase("TX_CEP")) {
            LogradouroTO logradouro = this.getLogradouroTO(to);
            valor = this.retornaNaoNulo(logradouro.getTextoCep());
        } else if (nomeCampo.equalsIgnoreCase("TX_CID")) {
            LogradouroTO logradouro = this.getLogradouroTO(to);
            valor = this.retornaNaoNulo(logradouro.getTextoCidade());
        } else if (nomeCampo.equalsIgnoreCase("CD_NCLD")) {
            PessoaTO pessoaTO = this.getPessoaTO(to);
            if (pessoaTO instanceof ComplementoPessoaFisicaTO) {
                ComplementoPessoaFisicaTO complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO;
                valor = this.retornaNaoNulo(complementoPessoaFisicaTO.getNacionalidadeTO().getCodigoNacionalidade());
            } else {
                valor = this.retornaNumeroComZerosEsquerda(null, tamanhoCampo);
            }
        } else if (nomeCampo.equalsIgnoreCase("TX_NTLD")) {
            PessoaTO pessoaTO = this.getPessoaTO(to);
            if (pessoaTO instanceof ComplementoPessoaFisicaTO) {
                ComplementoPessoaFisicaTO complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO;
                valor = this.retornaNaoNulo(complementoPessoaFisicaTO.getTextoNaturalidade());
            }
        } else if (nomeCampo.equalsIgnoreCase("TX_SG_UF_END")) {
            LogradouroTO logradouro = this.getLogradouroTO(to);
            if (this.isReferencia(logradouro.getUnidadeFederativaBrasilTO())) {
                valor = this.retornaNaoNulo(logradouro.getUnidadeFederativaBrasilTO().getTextoDescricao());
            }
        } else if (nomeCampo.equalsIgnoreCase("TX_SEXO")) {
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO;
            Character textoSexo;
            PessoaTO pessoaTO = this.getPessoaTO(to);
            if (pessoaTO instanceof ComplementoPessoaFisicaTO && this.isReferencia(textoSexo = (complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO).getTextoSexo())) {
                valor = this.retornaNaoNulo(textoSexo.toString());
            }
        } else if (nomeCampo.equalsIgnoreCase("TX_OBS")) {
            PessoaTO pessoaTO = this.getPessoaTO(to);
            valor = this.retornaNaoNulo(pessoaTO.getTextoObservacao());
        } else if (nomeCampo.equalsIgnoreCase("NR_RCBT")) {
            valor = this.retornaNumeroComZerosEsquerda(to.getNumeroRecebimento(), tamanhoCampo);
        } else if (nomeCampo.equalsIgnoreCase("NR_CVN")) {
            ConvenioTO convenioTO = this.getConvenioTO(to);
            valor = this.retornaNumeroComZerosEsquerda(convenioTO.getId().getNumeroConvenio(), tamanhoCampo);
        } else if (nomeCampo.equalsIgnoreCase("TX_IDFC_DEB")) {
            valor = this.retornaNaoNulo(to.getIdentificadorClienteDebitoTO().getTextoIdentificadorDebito());
        } else if (nomeCampo.equalsIgnoreCase("CD_IFC_CLI")) {
            valor = this.retornaNumeroComZerosEsquerda(to.getCodigoBancoDebito(), tamanhoCampo);
        } else if (nomeCampo.equalsIgnoreCase("CD_AG_CLI")) {
            valor = this.retornaNumeroComZerosEsquerda(to.getCodigoAgenciaDebito(), tamanhoCampo);
        } else if (nomeCampo.equalsIgnoreCase("CD_CC_CLI")) {
            valor = this.retornaNumeroComZerosEsquerda(to.getCodigoContaCorrenteDebito(), tamanhoCampo);
        } else if (nomeCampo.equalsIgnoreCase("CD_CC_CLI_DV")) {
            Integer codigoContaCorrenteDebito = to.getCodigoContaCorrenteDebito();
            if (this.isReferencia(codigoContaCorrenteDebito)) {
                String calcularModulo11 = CalculaDigitoVerificador.calcularModulo11((String)codigoContaCorrenteDebito.toString());
                valor = this.retornaNumeroComZerosEsquerda(UtilConversorDeInteger.converterParaInteger((String)calcularModulo11), tamanhoCampo);
            } else {
                valor = this.retornaNumeroComZerosEsquerda(null, tamanhoCampo);
            }
        } else if (nomeCampo.equalsIgnoreCase("VL_RCBT")) {
            BigDecimal valorBigDecimal = to.getValorRecebimento();
            valor = this.retornaNaoNulo(this.recuperarValorMonetarioComZerosAEsquerda(tamanhoCampo, valorBigDecimal));
        } else if (nomeCampo.equalsIgnoreCase("DT_RCBT")) {
            valor = this.retornaNaoNulo(UtilFormatadorDeData.formatar((Date)to.getDataRecebimento(), (String)"ddMMyyyy"));
        } else if (nomeCampo.equalsIgnoreCase("CD_EST_RCBT")) {
            Character codigoSituacaoRecebimento = to.getSituacaoRecebimentoTO().getCodigoSituacaoRecebimento();
            if (this.isReferencia(codigoSituacaoRecebimento)) {
                valor = this.retornaNaoNulo(codigoSituacaoRecebimento.toString());
            }
        } else {
            RemessaTO remessaTO = to.getRemessaTO();
            if (!this.isReferencia(remessaTO)) {
                remessaTO = this.getFabricaDeTO().novoRemessaTO();
            }
            if (nomeCampo.equalsIgnoreCase("NR_RMS")) {
                valor = this.retornaNumeroComZerosEsquerda(remessaTO.getId().getNumeroRemessa(), tamanhoCampo);
            } else if (nomeCampo.equalsIgnoreCase("DT_RMS")) {
                valor = this.retornaNaoNulo(UtilFormatadorDeData.formatar((Date)remessaTO.getId().getDataRemessa(), (String)"ddMMyyyy"));
            } else {
                TipoRetornoTO tipoRetornoTO = remessaTO.getTipoRetornoTO();
                if (!this.isReferencia(tipoRetornoTO)) {
                    tipoRetornoTO = this.getFabricaDeTO().novoTipoRetornoTO();
                }
                if (nomeCampo.equalsIgnoreCase("TX_TIP_RTN")) {
                    char textoTipoRetorno = tipoRetornoTO.getTextoTipoRetorno();
                    if (Character.isDigit(textoTipoRetorno)) {
                        valor = this.retornaNaoNulo(String.valueOf(textoTipoRetorno));
                    }
                } else if (nomeCampo.equalsIgnoreCase("CD_RTN")) {
                    valor = this.retornaNumeroComZerosEsquerda(remessaTO.getCodigoRetorno(), tamanhoCampo);
                } else if (nomeCampo.equalsIgnoreCase("CD_BCO_LQDC")) {
                    valor = this.retornaNumeroComZerosEsquerda(to.getCodigoBancoLiquidacao(), tamanhoCampo);
                } else if (nomeCampo.equalsIgnoreCase("CD_AG_LQDC")) {
                    valor = this.retornaNumeroComZerosEsquerda(to.getCodigoAgenciaLiquidacao(), tamanhoCampo);
                } else if (nomeCampo.equalsIgnoreCase("CD_CC_LQDC")) {
                    Integer codigoContaCorrenteLiquidacao = to.getCodigoContaCorrenteLiquidacao();
                    if (this.isReferencia(codigoContaCorrenteLiquidacao)) {
                        String calcularModulo11 = CalculaDigitoVerificador.calcularModulo11((String)codigoContaCorrenteLiquidacao.toString());
                        valor = this.retornaNumeroComZerosEsquerda(UtilConversorDeInteger.converterParaInteger((String)calcularModulo11), tamanhoCampo);
                    } else {
                        valor = this.retornaNumeroComZerosEsquerda(null, tamanhoCampo);
                    }
                } else if (nomeCampo.equalsIgnoreCase("DV_CC")) {
                    Integer codigoContaCorrenteLiquidacao = to.getCodigoContaCorrenteLiquidacao();
                    if (this.isReferencia(codigoContaCorrenteLiquidacao)) {
                        valor = this.retornaNaoNulo(CalculaDigitoVerificador.calcularModulo11((String)codigoContaCorrenteLiquidacao.toString()));
                    }
                } else if (nomeCampo.equalsIgnoreCase("VL_DEB")) {
                    BigDecimal valorDebito = to.getValorDebito();
                    valor = this.recuperarValorMonetarioComZerosAEsquerda(tamanhoCampo, valorDebito);
                } else if (nomeCampo.equalsIgnoreCase("DT_DEB")) {
                    valor = this.retornaNaoNulo(UtilFormatadorDeData.formatar((Date)to.getDataDebito(), (String)"ddMMyyyy"));
                }
            }
        }
        return valor;
    }

    private String recuperarValorMonetarioComZerosAEsquerda(int tamanhoCampo, BigDecimal valorBigDecimal) {
        if (!this.isReferencia(valorBigDecimal)) {
            valorBigDecimal = new BigDecimal(0);
        }
        return String.format("%0" + tamanhoCampo + ".02f", valorBigDecimal);
    }

    private String retornaNumeroComZerosEsquerda(Integer numero, int tamanhoCampo) {
        if (!this.isReferencia(numero)) {
            numero = 0;
        }
        return String.format("%0" + tamanhoCampo + "d", numero);
    }

    private IdentificacaoTO getIdentificacaoPessoaTO(RecebimentoDebitoTO to) {
        IdentificacaoTO identificacaoTO = null;
        PessoaTO pessoa = this.getPessoaTO(to);
        Set colecaoIdentificacaoTO = pessoa.getIdentificacaoTOs();
        if (!UtilColecao.isVazio((Collection)colecaoIdentificacaoTO)) {
            identificacaoTO = (IdentificacaoTO)colecaoIdentificacaoTO.iterator().next();
        }
        return identificacaoTO;
    }

    private ConvenioTO getConvenioTO(RecebimentoDebitoTO to) {
        ConvenioTO convenioTO = to.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO();
        return convenioTO;
    }

    private ConvenenteTO getConvenenteTO() {
        return FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getConvenenteTO();
    }

    public ComplementoPessoaJuridicaTO getComplementoPessoaJuridicaTO(PessoaTO to) {
        ComplementoPessoaJuridicaTO resultado = null;
        if (UtilObjeto.isObjetoDoTipo((Object)to, ComplementoPessoaJuridicaTO.class)) {
            resultado = (ComplementoPessoaJuridicaTO)to;
        } else {
            resultado = new ComplementoPessoaJuridicaTO();
            try {
                BeanUtils.copyProperties((Object)resultado, (Object)to);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return resultado;
    }

    private PessoaTO getPessoaTO(RecebimentoDebitoTO to) {
        PessoaTO pessoa = to.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO();
        return pessoa;
    }

    private LogradouroTO getLogradouroTO(RecebimentoDebitoTO to) {
        PessoaTO pessoaTO = this.getPessoaTO(to);
        LogradouroTO logradouro = new LogradouroTO();
        if (pessoaTO != null && pessoaTO.getLogradouroTOs() != null && pessoaTO.getLogradouroTOs().iterator().hasNext()) {
            logradouro = (LogradouroTO)pessoaTO.getLogradouroTOs().iterator().next();
        }
        return logradouro;
    }

    protected LogradouroTO getLogradouroTO(ConvenentePessoaTODecorator decorator) {
        Set colecao = decorator.getPessoaTO().getLogradouroTOs();
        LogradouroTO retorno = TOFactory.getInstancia().novoLogradouroTO();
        if (!UtilColecao.isVazio((Collection)colecao)) {
            retorno = (LogradouroTO)colecao.iterator().next();
        }
        return retorno;
    }

    private String retornaNaoNulo(String valorCampo) {
        return valorCampo == null ? "" : valorCampo;
    }

    private String retornaNaoNulo(Integer valorCampo) {
        return valorCampo == null ? "" : String.valueOf(valorCampo);
    }

    private StringBuffer getCampo(int tamanhoCampo, String valorCampo) {
        StringBuffer temporaria = this.novaStringBuffer(tamanhoCampo, valorCampo);
        if (valorCampo == null) {
            valorCampo = "";
        }
        int i = 0;
        while (i < tamanhoCampo - valorCampo.length()) {
            temporaria.append(" ");
            ++i;
        }
        return temporaria;
    }

    private StringBuffer novaStringBuffer(int tamanhoCampo, String valorCampo) {
        StringBuffer temporaria = new StringBuffer(tamanhoCampo);
        if (this.isReferencia(valorCampo) && valorCampo.length() > temporaria.capacity()) {
            return temporaria.append(valorCampo.substring(0, tamanhoCampo));
        }
        return temporaria.append(valorCampo);
    }

    private void atualizaPorcentagem(UtilNotificador notificaExportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaExportacao.notifyObservers((Object)porcentagem);
    }

    public Collection<ConvenentePessoaTO> consultarPessoa() {
        return this.getConvenentePessoaDAO().consultar();
    }

    public Collection<LeiauteTO> recuperarLeiaute(LeiauteTO to) {
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        to.setServicoTO(servicoTO);
        to.setIndicadorLeiauteModelo(UtilConversorDeCharacter.converterParaCharacter((String)"1"));
        to.getServicoTO().setTextoIdentificadorServico("DBT");
        return this.getLeiauteDao().consultarPeloServico(to);
    }

    private String getPathArquivoExportacao(String pastaDestinoExportacao) {
        Date data = this.getDataFactory().novoDate();
        return String.valueOf(pastaDestinoExportacao) + "\\Cadastro_GAC." + this.getDia(data) + this.getMes(data) + UtilData.getAno((Date)data) + ".txt";
    }

    private String getDia(Date data) {
        if (UtilData.getDia((Date)data) < 10) {
            return "0" + UtilData.getDia((Date)data);
        }
        return Integer.toString(UtilData.getDia((Date)data));
    }

    private String getMes(Date data) {
        if (UtilData.getMes((Date)data) < 10) {
            return "0" + UtilData.getMes((Date)data);
        }
        return Integer.toString(UtilData.getMes((Date)data));
    }

    public InstituicaoFinanceiraDAO getInstituicaoFinanceiraDAO() {
        return this.instituicaoFinanceiraDAO;
    }

    public void setInstituicaoFinanceiraDAO(InstituicaoFinanceiraDAO instituicaoFinanceiraDAO) {
        this.instituicaoFinanceiraDAO = instituicaoFinanceiraDAO;
    }

    public IdentificacaoDAO getIdentificacaoDAO() {
        return this.identificacaoDAO;
    }

    public void setIdentificacaoDAO(IdentificacaoDAO identificacaoDAO) {
        this.identificacaoDAO = identificacaoDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public TipoDocumentoDAO getTipoDocumentoDAO() {
        return this.tipoDocumentoDAO;
    }

    public void setTipoDocumentoDAO(TipoDocumentoDAO tipoDocumentoDAO) {
        this.tipoDocumentoDAO = tipoDocumentoDAO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public LeiauteDAO getLeiauteDao() {
        return this.leiauteDao;
    }

    public void setLeiauteDao(LeiauteDAO leiauteDao) {
        this.leiauteDao = leiauteDao;
    }

    public CamposLeiauteDAO getCamposLeiauteDAO() {
        return this.camposLeiauteDAO;
    }

    public void setCamposLeiauteDAO(CamposLeiauteDAO camposLeiauteDAO) {
        this.camposLeiauteDAO = camposLeiauteDAO;
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    private File criaPastasSeNecessario(String pathPasta) {
        File pasta = new File(pathPasta);
        if (!pasta.exists()) {
            pasta.mkdirs();
        }
        return pasta;
    }
}

