/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.SituacaoIdentificadorDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.SituacaoRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.TipoOcorrenciaRecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.model.ManterDadosDeDebitoModel;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ArquivoFactory;
import br.com.bb.plugins.gac.integracao.dao.AgenciaInstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.ManterCadastroPessoaFisicaModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTOId;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTOId;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTOId;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.LancamentoTO;
import br.com.bb.plugins.gac.negocio.to.LancamentosArquivoTO;
import br.com.bb.plugins.gac.negocio.to.NacionalidadeTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoOcorrenciaRecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.TipoOcorrenciaRecebimentoDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.AgenciaInstituicaoFinanceiraTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioProcessarRetornoDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RetornoTODecorator;
import br.com.bb.plugins.gac.relatorio.RelatorioDataSource;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivo;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivoFactory;
import br.com.bb.plugins.gac.util.parserarquivo.ParserArquivoFactory;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessarArquivosRetornosModel
extends PluginModelAbstrato {
    private ConvenioDebitoDAO convenioDebitoDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private TipoOcorrenciaRecebimentoDebitoDAO tipoOcorrenciaRecebimentoDebitoDAO;
    private SituacaoRecebimentoDAO situacaoRecebimentoDAO;
    private SituacaoIdentificadorDebitoDAO situacaoIdentificadorDebitoDAO;
    private AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO;
    private InstituicaoFinanceiraDAO instituicaoFinanceiraDAO;
    private PessoaDAO pessoaDAO;
    private ConvenioDAO convenioDAO;
    private ServicoDAO servicoDAO;
    private IdentificacaoDAO identificacaoDAO;
    private IParserArquivo parser;
    private ConvenioTO convenioTO;
    private ConvenioDebitoTO convenioDebitoTO;
    private ConvenenteTO convenenteTO;
    private ContaCorrenteClienteTO contaCorrenteClienteTO;
    private AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO;
    private PessoaTO pessoaTO;
    private ManterDadosDeDebitoModel manterDadosDeDebitoModel;
    private ManterCadastroPessoaFisicaModel manterCadastroPessoaFisicaModel;
    private double valorTotalLancamentos = 0.0;
    private static final String SITUACAO_DEBITO_EFETUADO = "D\u00e9bito Efetuado";
    private static final String SITUACAO_DEBITO_NAO_EFETUADO = "D\u00e9bito n\u00e3o Efetuado";
    private ConvenentePessoaDAO convenentePessoaDAO;
    private boolean isExibeMensagemNaoEncontrado = true;

    public double getValorTotalLancamentos() {
        return this.valorTotalLancamentos;
    }

    public void setValorTotalLancamentos(double valorTotalLancamentos) {
        this.valorTotalLancamentos = valorTotalLancamentos;
    }

    public PessoaTO getPessoaTO() {
        return this.pessoaTO;
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public AgenciaInstituicaoFinanceiraTO getAgenciaInstituicaoFinanceiraTO() {
        return this.agenciaInstituicaoFinanceiraTO;
    }

    public void setAgenciaInstituicaoFinanceiraTO(AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO) {
        this.agenciaInstituicaoFinanceiraTO = agenciaInstituicaoFinanceiraTO;
    }

    public ManterDadosDeDebitoModel getManterDadosDeDebitoModel() {
        return this.manterDadosDeDebitoModel;
    }

    public void setManterDadosDeDebitoModel(ManterDadosDeDebitoModel manterDadosDeDebitoModel) {
        this.manterDadosDeDebitoModel = manterDadosDeDebitoModel;
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    public TipoOcorrenciaRecebimentoDebitoDAO getTipoOcorrenciaRecebimentoDebitoDAO() {
        return this.tipoOcorrenciaRecebimentoDebitoDAO;
    }

    public void setTipoOcorrenciaRecebimentoDebitoDAO(TipoOcorrenciaRecebimentoDebitoDAO tipoOcorrenciaRecebimentoDebitoDAO) {
        this.tipoOcorrenciaRecebimentoDebitoDAO = tipoOcorrenciaRecebimentoDebitoDAO;
    }

    public SituacaoRecebimentoDAO getSituacaoRecebimentoDAO() {
        return this.situacaoRecebimentoDAO;
    }

    public void setSituacaoRecebimentoDAO(SituacaoRecebimentoDAO situacaoRecebimentoDAO) {
        this.situacaoRecebimentoDAO = situacaoRecebimentoDAO;
    }

    public SituacaoIdentificadorDebitoDAO getSituacaoIdentificadorDebitoDAO() {
        return this.situacaoIdentificadorDebitoDAO;
    }

    public void setSituacaoIdentificadorDebitoDAO(SituacaoIdentificadorDebitoDAO situacaoIdentificadorDebitoDAO) {
        this.situacaoIdentificadorDebitoDAO = situacaoIdentificadorDebitoDAO;
    }

    public AgenciaInstituicaoFinanceiraDAO getAgenciaInstituicaoFinanceiraDAO() {
        return this.agenciaInstituicaoFinanceiraDAO;
    }

    public void setAgenciaInstituicaoFinanceiraDAO(AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO) {
        this.agenciaInstituicaoFinanceiraDAO = agenciaInstituicaoFinanceiraDAO;
    }

    public InstituicaoFinanceiraDAO getInstituicaoFinanceiraDAO() {
        return this.instituicaoFinanceiraDAO;
    }

    public void setInstituicaoFinanceiraDAO(InstituicaoFinanceiraDAO instituicaoFinanceiraDAO) {
        this.instituicaoFinanceiraDAO = instituicaoFinanceiraDAO;
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public Collection<RetornoTODecorator> recuperaArquivosRetorno(ConvenenteTO convenenteTO) throws BBException {
        IParserArquivoFactory factory = ParserArquivoFactory.getInstancia();
        File[] arquivos = this.recuperaArquivosDeRetorno();
        List colecaoRetornos = this.getColecaoFactory().novoArrayList();
        Collection<ConvenioTO> listaConveniosConvenente = this.getListaConveniosConvenente(convenenteTO);
        if (arquivos == null) {
            return colecaoRetornos;
        }
        File[] fileArray = arquivos;
        int n = arquivos.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IParserArquivo parser = factory.novoParserArquivo(file);
            if (this.verificaConvenio(parser.getValorDoCabecalhoString("Convenio"), listaConveniosConvenente)) {
                colecaoRetornos.add(this.preencherRetornoTO(parser, file));
            }
            ++n2;
        }
        return colecaoRetornos;
    }

    private Collection<ConvenioTO> getListaConveniosConvenente(ConvenenteTO convenenteTO) {
        ConvenioTO convenio = this.getFabricaDeTO().novoConvenioTO();
        convenio.setConvenenteTO(convenenteTO);
        convenio.getServicoTO().setTextoIdentificadorServico("DBT");
        return this.getConvenioDAO().consultarPorConvenenteServico(convenio);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public Collection<RelatorioProcessarRetornoDecorator> processarArquivosRetornos(Collection<RetornoTODecorator> colecaoRetornos, ConvenenteTO convenenteTO, UtilNotificador utilNotificador) throws BBException {
        File arquivoRetorno;
        ArrayList<LancamentoTO> cadastramentoExclusao = new ArrayList<LancamentoTO>();
        ArrayList<LancamentoTO> alteracaoComOcorrencia = new ArrayList<LancamentoTO>();
        ArrayList<LancamentoTO> recebimentoEfetuado = new ArrayList<LancamentoTO>();
        ArrayList<LancamentoTO> recebimentoComOcorrencia = new ArrayList<LancamentoTO>();
        LancamentosArquivoTO lancamentoArquivoTO = new LancamentosArquivoTO();
        ArrayList<LancamentosArquivoTO> lancamentoArquivo = new ArrayList<LancamentosArquivoTO>();
        IParserArquivoFactory factory = ParserArquivoFactory.getInstancia();
        int totalGeralRegistros = 0;
        double valorTotalLancamentos = 0.0;
        for (RetornoTODecorator retornoTODecorator : colecaoRetornos) {
            arquivoRetorno = this.recuperaArquivoRetorno(retornoTODecorator);
            if (!this.isReferencia(arquivoRetorno)) continue;
            this.setParser(factory.novoParserArquivo(arquivoRetorno));
            totalGeralRegistros += this.getTotalDeRegistros();
        }
        int registroProcessados = 0;
        for (RetornoTODecorator retornoTODecorator : colecaoRetornos) {
            arquivoRetorno = this.recuperaArquivoRetorno(retornoTODecorator);
            if (this.isReferencia(arquivoRetorno)) {
                this.setParser(factory.novoParserArquivo(arquivoRetorno));
                lancamentoArquivoTO.setLancamentosArquivoTODecorator(lancamentoArquivoTO);
                lancamentoArquivoTO.setNomeArquivo(this.getNomeArquivo(arquivoRetorno));
                lancamentoArquivoTO.setConvenio(this.getConvenioArquivo());
                lancamentoArquivoTO.setNumeroRetorno(this.getNumeroRetorno());
                lancamentoArquivoTO.setDataRetorno(this.getDataArquivo());
                lancamentoArquivoTO.setNomeConvenente(this.getNomeConvenente());
                lancamentoArquivoTO.setLancamentosArquivoTODecorator(lancamentoArquivoTO);
                lancamentoArquivo.add(lancamentoArquivoTO);
                int totalRegistros = this.getTotalDeRegistros();
                int indice = 0;
                while (indice < totalRegistros) {
                    this.setContaCorrenteClienteTO(null);
                    if (this.isRegistroTipoB(indice)) {
                        this.processarRegistroTipoB(convenenteTO, cadastramentoExclusao, indice);
                    } else if (this.isRegistroTipoF(indice)) {
                        this.processarRegistroTipoF(recebimentoEfetuado, recebimentoComOcorrencia, indice);
                    } else if (this.isRegistroTipoH(indice)) {
                        this.processarRegistroTipoH(alteracaoComOcorrencia, indice);
                    }
                    retornoTODecorator.setNumeroIdentificadorRetorno(totalGeralRegistros);
                    this.atualizaPorcentagem(utilNotificador, totalGeralRegistros, ++registroProcessados);
                    lancamentoArquivoTO.setTotalGeralReg(Integer.valueOf(totalGeralRegistros));
                    lancamentoArquivoTO.setValorTotal(Double.valueOf(this.getValorTotalLancamentos()));
                    ++indice;
                }
            }
            this.moverArquivoRetornoProcessado(arquivoRetorno);
        }
        ArrayList<RelatorioProcessarRetornoDecorator> colecaoRetorno = new ArrayList<RelatorioProcessarRetornoDecorator>();
        this.criaRelatorioDataSourceCadastramentoExclusao(colecaoRetornos, cadastramentoExclusao, colecaoRetorno, lancamentoArquivoTO);
        this.criaRelatorioDataSourceAlteracaoComOcorrencia(colecaoRetornos, alteracaoComOcorrencia, colecaoRetorno, lancamentoArquivoTO);
        this.criaRelatorioDataSourceRecebimentosComDebitoEfetuado(colecaoRetornos, recebimentoEfetuado, colecaoRetorno, lancamentoArquivoTO);
        this.criaRelatorioDataSourceRecebimentosComOcorrencia(colecaoRetornos, recebimentoComOcorrencia, colecaoRetorno, lancamentoArquivoTO);
        return colecaoRetorno;
    }

    private void atualizaPorcentagem(UtilNotificador notificaImportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaImportacao.notifyObservers((Object)porcentagem);
    }

    private void processarRegistroTipoH(List<LancamentoTO> lancamentos, int indice) throws BBException {
        if (this.getRecebimentoDebitoAnteriorArquivo(indice).equals("AGUARDANDO EXCLUSAO NO BB")) {
            IdentificadorClienteDebitoTO recDebitoAnt = this.consultarIdentificadorClienteDebitoAnterior(indice, this.getRecebimentoDebitoAtualArquivo(indice));
            if (this.isReferencia(recDebitoAnt)) {
                recDebitoAnt.setTextoDescricaoOcorrencia(this.getValorStringArquivo(indice, "Ocorrencia"));
                this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAnt, 'O');
                this.gerarLancamento(recDebitoAnt.getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), recDebitoAnt.getTextoIdentificadorDebito(), "Banco do Brasil", recDebitoAnt.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebitoAnt.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebitoAnt.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + recDebitoAnt.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getParser().getValorDoCabecalhoDate("DataArq"), 0.0, "Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de d\u00e9bito n\u00e3o processada no BB. Registro importado com sucesso na aplicativo", "IDENTIFICA\u00c7\u00c3O N\u00c3O EXISTE NO BB", lancamentos);
            }
        } else {
            IdentificadorClienteDebitoTO recDebitoAnt = this.consultarIdentificadorClienteDebitoAnterior(indice, this.getRecebimentoDebitoAnteriorArquivo(indice));
            IdentificadorClienteDebitoTO recDebitoAtual = this.consultarIdentificadorClienteDebitoAtual(indice, this.getRecebimentoDebitoAtualArquivo(indice));
            if (!this.getValorStringArquivo(indice, "IdDbtAnt").equals("")) {
                this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAnt, 'A');
                recDebitoAtual.setTextoDescricaoOcorrencia(this.getValorStringArquivo(indice, "Ocorrencia"));
                this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAtual, 'O');
                this.gerarLancamento(recDebitoAtual.getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), recDebitoAtual.getTextoIdentificadorDebito(), "Banco do Brasil", recDebitoAtual.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebitoAtual.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebitoAtual.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + recDebitoAtual.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getParser().getValorDoCabecalhoDate("DataArq"), 0.0, "Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de d\u00e9bito n\u00e3o processada no BB. Identifica\u00e7\u00e3o para d\u00e9bito alterado n\u00e3o localizado no Aplicativo, registro n\u00e3o importado", "IDENTIFICA\u00c7\u00c3O N\u00c3O EXISTE NO BB", lancamentos);
            }
        }
    }

    private void processarRegistroTipoF(List<LancamentoTO> recebimentoEfetuado, List<LancamentoTO> recebimentoComOcorrencia, int indice) throws BBException {
        String ocorrencia = "";
        String situacao = "";
        String descricaoOcorrencia = "";
        System.out.println(this.getIdRecebimentoArquivo(indice));
        RecebimentoDebitoTO recDebTO = this.consultarRecebimentoPeloTxIdeReg(this.getIdRecebimentoArquivo(indice));
        int codRet = UtilConversorDeString.converterParaInt((String)this.getValorStringArquivo(indice, "CodRet"));
        TipoDeListaRecebimento tipoDeListaRecebimento = new TipoDeListaRecebimento(recebimentoEfetuado, recebimentoComOcorrencia);
        if (!this.isReferencia(recDebTO)) {
            ocorrencia = this.consultarOcorrencia(codRet);
            situacao = codRet == 0 || codRet == 31 ? SITUACAO_DEBITO_EFETUADO : SITUACAO_DEBITO_NAO_EFETUADO;
            if (this.isExibeMensagemNaoEncontrado) {
                BBJPopupMensagem.exibirMensagem((String)"Lan\u00e7amento(s) n\u00e3o cadastrado(s) no m\u00f3dulo \"D\u00e9bito Autom\u00e1tico\". Apenas ser\u00e1 gerado um relat\u00f3rio para simples visualiza\u00e7\u00e3o/confer\u00eancia.");
                this.isExibeMensagemNaoEncontrado = false;
            }
            this.gerarLancamento("", this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", this.getValorIntegerArquivo(indice, "NumAgencia") + "-" + CalculaDigitoVerificador.calcularModulo11((String)this.getValorIntegerArquivo(indice, "NumAgencia").toString()), this.getValorIntegerArquivo(indice, "NumConta") + "-" + CalculaDigitoVerificador.calcularModulo11((String)this.getValorIntegerArquivo(indice, "NumConta").toString()), this.getValorDateArquivo(indice, "DataOpcao"), this.getValorDoubleArquivo(indice, "ValorDBT"), String.valueOf(situacao) + " - " + ocorrencia, "Lan\u00e7amento n\u00e3o cadastrado no Aplicativo.", tipoDeListaRecebimento.escolhaListaRecebimentoPor(situacao));
        } else if (codRet == 0 || codRet == 31) {
            situacao = SITUACAO_DEBITO_EFETUADO;
            this.atualizaRecebimentoDebito(recDebTO, 'D', indice);
            descricaoOcorrencia = recDebTO.getTipoOcorrenciaRecebimentoDebitoTO() == null ? "" : recDebTO.getTipoOcorrenciaRecebimentoDebitoTO().getTextoDescricao();
            this.gerarLancamento(recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), this.getValorDoubleArquivo(indice, "ValorDBT"), situacao, descricaoOcorrencia, recebimentoEfetuado);
        } else {
            situacao = SITUACAO_DEBITO_NAO_EFETUADO;
            this.atualizaCodigoSituacaoRecebimento(recDebTO, 'O', indice);
            descricaoOcorrencia = recDebTO.getTipoOcorrenciaRecebimentoDebitoTO() == null ? "" : recDebTO.getTipoOcorrenciaRecebimentoDebitoTO().getTextoDescricao();
            this.gerarLancamento(recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), this.getValorDoubleArquivo(indice, "ValorDBT"), situacao, descricaoOcorrencia, recebimentoComOcorrencia);
        }
        this.atualizaRecebimento(recDebTO, 'O', indice);
    }

    private void atualizarIdentificacao(PessoaTO pessoaTO, int indice) throws BBException {
        int tipoInscricao = this.getParser().getValorDoRegistroInteger(indice, "TipoId");
        tipoInscricao = tipoInscricao == 1 ? 2 : 1;
        Long inscricao = this.getParser().getValorDoRegistroLong(indice, "IdCliente");
        IdentificacaoTOId identificacaoTOId = new IdentificacaoTOId();
        IdentificacaoTO identificacaoTO = new IdentificacaoTO();
        identificacaoTOId.setCodigoPessoa(pessoaTO.getCodigoPessoa());
        identificacaoTOId.setCodigoTipoDocumento(Integer.valueOf(tipoInscricao));
        identificacaoTOId.setPessoaTO(pessoaTO);
        identificacaoTOId.setTextoIdentificacao(String.valueOf(inscricao).toString());
        identificacaoTOId.setTextoIdentificador(String.valueOf(tipoInscricao).toString());
        identificacaoTO.setTextoIdentificador(String.valueOf(tipoInscricao).toString());
        identificacaoTO.setTextoIdentificacao(String.valueOf(inscricao).toString());
        identificacaoTO.setPessoaTO(pessoaTO);
        identificacaoTO.setId(identificacaoTOId);
        Set identificacaoTOs = pessoaTO.getIdentificacaoTOs();
        identificacaoTOs.add(identificacaoTO);
        this.setIdentificacaoDAO(this.identificacaoDAO);
        if (this.getIdentificacaoDAO().listar((Serializable)identificacaoTOId) == null && !this.getIdentificacaoDAO().isExisteTextoIdentificacao(identificacaoTO)) {
            this.getIdentificacaoDAO().incluir((Object)identificacaoTO);
        }
    }

    private String consultarOcorrencia(int codRet) {
        TipoOcorrenciaRecebimentoDebitoTO tipoOcorrencia = this.getTipoOcorrenciaRecebimentoDebitoDAO().consultarPorCodigoRetorno(codRet);
        String ocorrencia = tipoOcorrencia.getTextoDescricao();
        return ocorrencia;
    }

    private void processarRegistroTipoB(ConvenenteTO convenenteTO, List<LancamentoTO> lancamentos, int indice) throws BBException {
        int codigoMovimentoArquivo;
        String identificador = this.getValorStringArquivo(indice, "IdDbt");
        IdentificadorClienteDebitoTO idCliDbt = this.consultarIdentificadorClienteDebitoCabecalho(identificador);
        int n = codigoMovimentoArquivo = this.getCodigoMovimentoArquivo(indice) == null ? 0 : this.getCodigoMovimentoArquivo(indice);
        if (codigoMovimentoArquivo == 1) {
            if (this.isReferencia(idCliDbt)) {
                this.atualizarExclusao(idCliDbt, indice, lancamentos);
            } else {
                this.gerarLancamento("", this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", this.getValorIntegerArquivo(indice, "NumAgencia") + "-" + CalculaDigitoVerificador.calcularModulo11((String)this.getValorIntegerArquivo(indice, "NumAgencia").toString()), this.getValorIntegerArquivo(indice, "NumConta") + "-" + CalculaDigitoVerificador.calcularModulo11((String)this.getValorIntegerArquivo(indice, "NumConta").toString()), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Exclu\u00eddo no BB.", "Identifica\u00e7\u00e3o para d\u00e9bito n\u00e3o localizada no aplicativo.", lancamentos);
            }
        } else if (codigoMovimentoArquivo == 2) {
            if (this.isReferencia(idCliDbt)) {
                this.atualizarInclusao(idCliDbt, lancamentos, indice);
            } else {
                this.clienteCadastradoPeloAplicativo(indice, lancamentos);
            }
        }
    }

    private void clienteCadastradoPeloAplicativo(int indice, List<LancamentoTO> lancamentos) throws BBException {
        AgenciaInstituicaoFinanceiraTO agencia = this.recuperaAgenciaInstituicaoFinanceiraTO(indice);
        agencia = this.cadastrarAgenciaTO(indice);
        PessoaTO pessoaTO = this.cadastraPessoaTO();
        ContaCorrenteClienteTO ccClienteTO = this.cadastraContaCorrenteClienteTO(pessoaTO, agencia, indice);
        this.cadastrarIdentificadorClienteDebitoTO(ccClienteTO, indice, lancamentos);
    }

    private void cadastrarIdentificadorClienteDebitoTO(ContaCorrenteClienteTO ccClienteTO, int indice, List<LancamentoTO> lancamentos) throws BBException {
        IdentificadorClienteDebitoTODecorator decorator = this.geraIdentificadorContaClienteTODecorator(this.convenenteTO, indice, ccClienteTO);
        this.incluirIdentificadorClienteDebito(decorator);
        this.gerarLancamento(decorator.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", decorator.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + decorator.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), decorator.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + decorator.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Inclu\u00eddo no BB.", "Identifica\u00e7\u00e3o para d\u00e9bito inclu\u00edda com sucesso na Aplicativo.", lancamentos);
    }

    private ContaCorrenteClienteTO cadastraContaCorrenteClienteTO(PessoaTO pessoaTO, AgenciaInstituicaoFinanceiraTO agenciaTO, int indice) throws BBException {
        ContaCorrenteClienteTO contaCorrenteClienteTO = this.getFabricaDeTO().novoContaCorrenteClienteTO();
        ContaCorrenteClienteTOId contaCorrenteClienteTOId = this.getFabricaDeTO().novoContaCorrenteClienteTOId();
        Long contaCorrente = this.getValorLongArquivo(indice, "NumConta");
        contaCorrenteClienteTOId.setCodigoAgencia(agenciaTO.getId().getCodigoAgencia());
        contaCorrenteClienteTOId.setCodigoContaCorrente(contaCorrente);
        contaCorrenteClienteTOId.setCodigoInstituicaoFinanceira(agenciaTO.getId().getCodigoInstituicaoFinanceira());
        contaCorrenteClienteTOId.setCodigoPessoa(pessoaTO.getCodigoPessoa().intValue());
        contaCorrenteClienteTO.setId(contaCorrenteClienteTOId);
        contaCorrenteClienteTO.setPessoaTO(pessoaTO);
        contaCorrenteClienteTO.setAgenciaInstituicaoFinanceiraTO(agenciaTO);
        String codigoVerificador = CalculaDigitoVerificador.calcularModulo11((String)contaCorrente.toString());
        contaCorrenteClienteTO.setDigitoVerificadorContaCorrente(Character.valueOf(codigoVerificador.charAt(0)));
        contaCorrenteClienteTO.setTextoDescricaoContaCorrente("CADASTRADO PELO ARQUIVO DE RETORNO");
        if (this.getContaCorrenteClienteDAO().existeContaParaPessoa(contaCorrenteClienteTO)) {
            return (ContaCorrenteClienteTO)this.getContaCorrenteClienteDAO().listar((Object)contaCorrenteClienteTO);
        }
        return (ContaCorrenteClienteTO)this.getContaCorrenteClienteDAO().incluir((Object)contaCorrenteClienteTO);
    }

    private PessoaTO cadastraPessoaTO() throws BBException {
        TipoPessoaTO tipoPessoaTO = this.getFabricaDeTO().novoTipoPessoaFisica();
        tipoPessoaTO.setCodigoTipoPessoa(Integer.valueOf(1));
        ComplementoPessoaFisicaTO complementoPessoaFisicaTO = new ComplementoPessoaFisicaTO();
        complementoPessoaFisicaTO.setTipoPessoaTO(tipoPessoaTO);
        complementoPessoaFisicaTO.setTextoNome("CADASTRADO PELO BB");
        complementoPessoaFisicaTO.setTextoObservacao("CADASTRADO PELO ARQUIVO DE RETORNO");
        NacionalidadeTO nacionalidadeTO = new NacionalidadeTO();
        nacionalidadeTO.setCodigoNacionalidade(Integer.valueOf(1));
        complementoPessoaFisicaTO.setNacionalidadeTO(nacionalidadeTO);
        ComplementoPessoaFisicaTO cadastrado = this.getManterCadastroPessoaFisicaModel().incluir(complementoPessoaFisicaTO);
        this.incluirConvenentePessoaTO((PessoaTO)cadastrado);
        return cadastrado;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    private void incluirConvenentePessoaTO(PessoaTO pessoaTO) throws BBException {
        ConvenentePessoaTO convenentePessoaTO = new ConvenentePessoaTO();
        ConvenentePessoaTOId id = new ConvenentePessoaTOId();
        id.setCodigoPessoa(pessoaTO.getCodigoPessoa().intValue());
        id.setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente().intValue());
        id.setTextoIdentificadorServico("DBT");
        convenentePessoaTO.setId(id);
        this.getConvenentePessoaDAO().incluir((Object)convenentePessoaTO);
    }

    private AgenciaInstituicaoFinanceiraTO cadastrarAgenciaTO(int indice) throws BBException {
        AgenciaInstituicaoFinanceiraTO agencia = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTO();
        AgenciaInstituicaoFinanceiraTOId agenciaId = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTOId();
        Integer codigoAgencia = this.getValorIntegerArquivo(indice, "NumAgencia");
        agenciaId.setCodigoAgencia(codigoAgencia);
        agenciaId.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        agencia.setId(agenciaId);
        String codigoVerificador = CalculaDigitoVerificador.calcularModulo11((String)codigoAgencia.toString());
        agencia.setDigitoVerificadorAgencia(Character.valueOf(codigoVerificador.charAt(0)));
        agencia.setIndicadorTipoAgencia(Character.valueOf('A'));
        agencia.setTextoDescricao("CADASTRADA PELO ARQUIVO DE RETORNO");
        agencia.setInstituicaoFinanceiraTO((InstituicaoFinanceiraTO)this.instituicaoFinanceiraDAO.listar((Serializable)Integer.valueOf(1)));
        boolean existeInstituicao = this.getAgenciaInstituicaoFinanceiraDAO().isExisteAgenciaParaInstistituicao(agencia);
        if (!existeInstituicao) {
            return (AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().incluir((Object)agencia);
        }
        return (AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Object)agencia);
    }

    private AgenciaInstituicaoFinanceiraTO recuperaAgenciaInstituicaoFinanceiraTO(int indice) throws BBException {
        if (this.agenciaInstituicaoFinanceiraTO == null) {
            AgenciaInstituicaoFinanceiraTO to = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTO();
            to.getId().setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
            to.getId().setCodigoInstituicaoFinanceira(Integer.valueOf(1));
            this.agenciaInstituicaoFinanceiraTO = (AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Object)to);
        }
        return this.agenciaInstituicaoFinanceiraTO;
    }

    private void atualizarExclusao(IdentificadorClienteDebitoTO idCliDbt, int indice, List<LancamentoTO> lancamentos) throws BBException {
        if (idCliDbt.getRecebimentoDebitoTOs().size() == 0) {
            this.excluirIdentificadorDebito(idCliDbt);
            this.gerarLancamento(idCliDbt.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", idCliDbt.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + idCliDbt.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), idCliDbt.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + idCliDbt.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Exclu\u00eddo no BB.", "Identifica\u00e7\u00e3o para d\u00e9bito exclu\u00edda no aplicativo.", lancamentos);
        } else {
            this.atualizaCodigoSituacaoIdentificadorDebito(idCliDbt, 'I');
            this.gerarLancamento(idCliDbt.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", idCliDbt.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + idCliDbt.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), idCliDbt.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + idCliDbt.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Exclu\u00eddo no BB.", "Identifica\u00e7\u00e3o para d\u00e9bito inativada no aplicativo.", lancamentos);
        }
    }

    private void atualizarInclusao(IdentificadorClienteDebitoTO idCliDbt, List<LancamentoTO> lancamentos, int indice) throws BBException {
        this.atualizaCodigoSituacaoIdentificadorDebito(idCliDbt, 'A');
        this.gerarLancamento(idCliDbt.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", idCliDbt.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + idCliDbt.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), idCliDbt.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + idCliDbt.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Inclu\u00eddo no BB.", "Identifica\u00e7\u00e3o para d\u00e9bito atualizada com sucesso no Aplicativo.", lancamentos);
        IdentificadorClienteDebitoTO idCliDbtAntigo = this.consultarIdentificadorClienteDebitoCabecalho(idCliDbt.getTextoIdentificadorAnterior());
        if (this.isReferencia(idCliDbtAntigo)) {
            this.atualizaCodigoSituacaoIdentificadorDebito(idCliDbtAntigo, 'I');
        }
    }

    private void idDbtCadastradoPelaAplicacao(ContaCorrenteClienteTO ccClienteTO, int indice, List<LancamentoTO> lancamentos) throws BBException {
        ccClienteTO = this.adicionarContaCorrenteClienteTO(indice);
        IdentificadorClienteDebitoTODecorator decorator = this.geraIdentificadorContaClienteTODecorator(this.convenenteTO, indice, ccClienteTO);
        this.incluirIdentificadorClienteDebito(decorator);
        this.gerarLancamento(decorator.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", decorator.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + decorator.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), decorator.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + decorator.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Inclu\u00eddo no BB.", "Cliente cadastrado pelo aplicativo.", lancamentos);
    }

    private void idDbtCadastradoPeloAplicativo(List<LancamentoTO> lancamentos, int indice, ContaCorrenteClienteTO ccClienteTO) throws BBException {
        IdentificadorClienteDebitoTODecorator decorator = this.geraIdentificadorContaClienteTODecorator(this.convenenteTO, indice, ccClienteTO);
        this.incluirIdentificadorClienteDebito(decorator);
        this.gerarLancamento(decorator.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", decorator.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + decorator.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), decorator.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + decorator.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "", "Cliente cadastrado no aplicativo.", lancamentos);
    }

    public void incluirIdentificadorClienteDebito(IdentificadorClienteDebitoTODecorator decorator) throws BBException {
        decorator.getIdentificadorClienteDebitoTO().setCodigoIdentificadorClienteDebito(null);
        this.gravarIdentificacao(decorator, true);
    }

    private void gravarIdentificacao(IdentificadorClienteDebitoTODecorator decorator, boolean valida) throws BBException {
        decorator.setAgenciaInstituicaoFinanceiraTO(decorator.getAgenciaInstituicaoFinanceiraTODaDecorator());
        decorator.getConvenioDebitoTO().setConvenioTO(decorator.getConvenioTO());
        ConvenioDebitoTOId id = this.getFabricaDeTO().novoConvenioDebitoTOId();
        id.setCodigoPessoaConvenente(decorator.getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente());
        id.setNumeroConvenio(decorator.getConvenioTO().getId().getNumeroConvenio());
        id.setTextoIdentificadorServico(decorator.getConvenioTO().getServicoTO().getTextoIdentificadorServico());
        ConvenioDebitoTO convenioDebitoTO = this.getConvenioDebitoTO(id);
        decorator.getIdentificadorClienteDebitoTO().setConvenioDebitoTO(convenioDebitoTO);
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoPessoa(decorator.getCodigoPessoaCliente().intValue());
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoAgencia(decorator.getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia());
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoInstituicaoFinanceira(decorator.getCodigoInstituicaoFinanceira());
        AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO = decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO();
        decorator.getIdentificadorClienteDebitoTO().setAgenciaInstituicaoFinanceiraTO(agenciaInstituicaoFinanceiraTO);
        decorator.getIdentificadorClienteDebitoTO().setPessoaTO(decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO());
        boolean existe = false;
        if (valida) {
            existe = this.getIdentificadorClienteDebitoDAO().isExistePeloTextoDeIdentificacaoConvenenteClienteEConvenio(decorator.getIdentificadorClienteDebitoTO());
        }
        if (!existe) {
            if (this.isReferencia(decorator.getMembroGrupoClienteRecebimentoTO().getGrupoClienteRecebimentoTO())) {
                decorator.getMembroGrupoClienteRecebimentoTO().setIdentificadorClienteDebitoTO(decorator.getIdentificadorClienteDebitoTO());
                decorator.getMembroGrupoClienteRecebimentoTO().setGrupoClienteRecebimentoTO(decorator.getGrupoClienteRecebimentoTO());
                decorator.getMembroGrupoClienteRecebimentoTO().getId().setCodigoGrupoClienteRecebimento(decorator.getGrupoClienteRecebimentoTO().getCodigoGrupoClienteRecebimento());
                decorator.getMembroGrupoClienteRecebimentoTO().getId().setCodigoPessoaCliente(decorator.getPessoaTO().getCodigoPessoa());
                decorator.getMembroGrupoClienteRecebimentoTO().setPessoaTO(decorator.getPessoaTO());
            } else {
                this.getIdentificadorClienteDebitoDAO().alterar(decorator.getIdentificadorClienteDebitoTO());
            }
        } else {
            throw new BBException("MP050");
        }
    }

    private void gravarContaCorrente(IdentificadorClienteDebitoTODecorator decorator, AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO) {
        Set contas = agenciaInstituicaoFinanceiraTO.getContaCorrenteClienteTOs();
        ContaCorrenteClienteTO containcluir = decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO();
        for (ContaCorrenteClienteTO to : contas) {
            if (!to.equals((Object)containcluir)) continue;
            contas.remove(to);
            return;
        }
        contas.add(containcluir);
    }

    private ConvenioDebitoTO getConvenioDebitoTO(ConvenioDebitoTOId id) {
        return (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar((Serializable)id);
    }

    private RecebimentoDebitoTO consultarRecebimentoPeloTxIdeReg(String idRecebimentoArquivo) {
        return this.getRecebimentoDebitoDAO().consultarPeloIDRegistro(this.verificarIDRegistro(idRecebimentoArquivo));
    }

    private String getIdRecebimentoArquivo(int indice) throws BBException {
        String valorRegistro = this.getValorStringArquivo(indice, "IdRecebimento");
        return valorRegistro == null ? "" : valorRegistro.trim();
    }

    private IdentificadorClienteDebitoTO consultarIdentificadorClienteDebitoCabecalho(String identificador) throws BBException {
        IdentificadorClienteDebitoTODecorator idClienteDebTO = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        idClienteDebTO.setTextoIdentificadorDebito(identificador);
        return this.getUnicoIdentificadorClienteDebito(this.getIdentificadorClienteDebitoDAO().consultarPeloTextoIdentificacaoEAgenciaEContaCorrente(idClienteDebTO));
    }

    private String verificarIDRegistro(String IDDebito) {
        return IDDebito == null || IDDebito.trim().length() <= 25 ? IDDebito : IDDebito.substring(0, 25);
    }

    private IdentificadorClienteDebitoTO consultarIdentificadorClienteDebitoAnterior(int indice, String idDbt) throws BBException {
        IdentificadorClienteDebitoTO to = this.getFabricaDeTO().novoIdentificadorClienteDebitoTO();
        to.getConvenioDebitoTO().getId().setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente());
        to.getConvenioDebitoTO().getId().setNumeroConvenio(this.getConvenioArquivo());
        to.getConvenioDebitoTO().getId().setTextoIdentificadorServico(this.getRecebimentoDebitoAnteriorArquivo(indice));
        return this.getUnicoIdentificadorClienteDebito(this.getIdentificadorClienteDebitoDAO().consultar(to), idDbt);
    }

    private IdentificadorClienteDebitoTO consultarIdentificadorClienteDebitoAtual(int indice, String idDbt) throws BBException {
        IdentificadorClienteDebitoTO to = this.getFabricaDeTO().novoIdentificadorClienteDebitoTO();
        to.getConvenioDebitoTO().getId().setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente());
        to.getConvenioDebitoTO().getId().setNumeroConvenio(this.getConvenioArquivo());
        to.getConvenioDebitoTO().getId().setTextoIdentificadorServico(this.getRecebimentoDebitoAtualArquivo(indice));
        return this.getUnicoIdentificadorClienteDebito(this.getIdentificadorClienteDebitoDAO().consultar(to), idDbt);
    }

    private IdentificadorClienteDebitoTO getUnicoIdentificadorClienteDebito(Collection<IdentificadorClienteDebitoTO> consultar) {
        return (IdentificadorClienteDebitoTO)UtilColecao.getElementoDoIndice(consultar, (int)0);
    }

    private IdentificadorClienteDebitoTO getUnicoIdentificadorClienteDebito(Collection<IdentificadorClienteDebitoTO> consultar, String idDbt) {
        for (IdentificadorClienteDebitoTO identificadorClienteDebitoTO : consultar) {
            if (!identificadorClienteDebitoTO.getTextoIdentificadorDebito().equals(idDbt)) continue;
            return identificadorClienteDebitoTO;
        }
        return null;
    }

    private RecebimentoDebitoTO getUnicoRecebimentoDebito(Collection<RecebimentoDebitoTO> consultar) {
        return (RecebimentoDebitoTO)UtilColecao.getElementoDoIndice(consultar, (int)0);
    }

    private void moverArquivoRetornoProcessado(File arquivoRetorno) throws BBException {
        String _arquivoDestino = String.valueOf(this.getDiretorioRetornoProcessado()) + File.separator + arquivoRetorno.getName();
        File arquivoDestino = new File(_arquivoDestino);
        try {
            if (arquivoDestino.exists()) {
                arquivoDestino.delete();
            }
            arquivoRetorno.renameTo(arquivoDestino);
        }
        catch (Exception e) {
            BBJPopupMensagem.exibirMensagemErro((String)"Erro ao mover o arquivo para a pasta 'processados'.");
            throw UtilBBException.getErroDeSistema((Throwable)e);
        }
    }

    private void atualizaRecebimento(RecebimentoDebitoTO recDebTO, char c, int indice) throws BBException {
        int codReceb = this.getValorIntegerArquivo(indice, "CodRet");
        if (codReceb == 0 && recDebTO != null) {
            recDebTO.setCodigoAgenciaDebito(this.getValorIntegerArquivo(indice, "NumAgencia"));
            recDebTO.setCodigoBancoDebito(Integer.valueOf(1));
            recDebTO.setCodigoContaCorrenteDebito(this.getValorIntegerArquivo(indice, "NumConta"));
            this.getRecebimentoDebitoDAO().alterar(recDebTO);
        }
    }

    private void atualizaCodigoSituacaoRecebimento(RecebimentoDebitoTO recDebTO, char c, int indice) throws BBException {
        TipoOcorrenciaRecebimentoDebitoTOId toID = this.getFabricaDeTO().novoTipoOcorrenciaRecebimentoDebitoTOId();
        toID.setCodigoRetorno(this.getValorIntegerArquivo(indice, "CodRet").intValue());
        toID.setTextoTipoRetorno('P');
        TipoOcorrenciaRecebimentoDebitoTO tipoOcorrenciaRecebimentoDebitoTO = (TipoOcorrenciaRecebimentoDebitoTO)this.getTipoOcorrenciaRecebimentoDebitoDAO().listar((Serializable)toID);
        recDebTO.setTipoOcorrenciaRecebimentoDebitoTO(tipoOcorrenciaRecebimentoDebitoTO);
        recDebTO.setSituacaoRecebimentoTO((SituacaoRecebimentoTO)this.getSituacaoRecebimentoDAO().listar(Character.valueOf(c)));
        this.getRecebimentoDebitoDAO().alterar(recDebTO);
    }

    private void gerarLancamento(String nome, String idDeb, String banco, String agencia, String conta, Date data, Double valor, String situacao, String ocorrencia, List<LancamentoTO> lancamentos) {
        LancamentoTO to = this.getFabricaDeTO().novoLancamentoTO();
        double valorTotal = 0.0;
        to.setNome(nome);
        to.setIdDeb(idDeb);
        to.setBanco(banco);
        to.setAgencia(agencia);
        to.setConta(conta);
        to.setData(data);
        to.setValor(valor);
        to.setSituacao(situacao);
        to.setOcorrencia(ocorrencia);
        lancamentos.add(to);
        valorTotal = this.getValorTotalLancamentos() + valor;
        this.setValorTotalLancamentos(valorTotal);
    }

    private Date getValorDateArquivo(int indice, String nomeCampo) throws BBException {
        return this.getParser().getValorDoRegistroDate(indice, nomeCampo);
    }

    private String getValorStringArquivo(int indice, String nomeCampo) throws BBException {
        return UtilString.trim((String)this.getParser().getValorDoRegistroString(indice, nomeCampo));
    }

    private Integer getValorIntegerArquivo(int indice, String nomeCampo) throws BBException {
        return new Integer(this.getParser().getValorDoRegistroString(indice, nomeCampo));
    }

    private Long getValorLongArquivo(int indice, String nomeCampo) throws BBException {
        return new Long(this.getParser().getValorDoRegistroString(indice, nomeCampo));
    }

    private Double getValorDoubleArquivo(int indice, String nomeCampo) throws BBException {
        return this.getParser().getValorDoRegistroDouble(indice, nomeCampo);
    }

    private IdentificadorClienteDebitoTODecorator geraIdentificadorContaClienteTODecorator(ConvenenteTO convenenteTO, int indice, ContaCorrenteClienteTO ccClienteTO) throws BBException {
        IdentificadorClienteDebitoTODecorator idClienteDebTO = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        idClienteDebTO.setContaCorrenteClienteTO(ccClienteTO);
        idClienteDebTO.setConvenioDebitoTO(this.getConvenioDebitoTO());
        idClienteDebTO.setTextoSituacaoIdentificador("A");
        idClienteDebTO.setTextoIdentificadorDebito(this.getValorStringArquivo(indice, "IdDbt"));
        idClienteDebTO.setTextoIdentificadorAnterior(null);
        idClienteDebTO.setDataUltimaRemessa(new Date());
        idClienteDebTO.setDataAlteracaoRemessa(null);
        idClienteDebTO.setNumeroAlteracaoRemessa(null);
        idClienteDebTO.setTextoDescricaoOcorrencia(null);
        idClienteDebTO.setIndicadorImpressao("2");
        ccClienteTO.getAgenciaInstituicaoFinanceiraTO().setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        ccClienteTO.getAgenciaInstituicaoFinanceiraTO().setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
        idClienteDebTO.setAgenciaInstituicaoFinanceiraTO(ccClienteTO.getAgenciaInstituicaoFinanceiraTO());
        idClienteDebTO.setCodigoPessoaCliente(ccClienteTO.getPessoaTO().getCodigoPessoa());
        AgenciaInstituicaoFinanceiraTODecorator aifTODecorator = new AgenciaInstituicaoFinanceiraTODecorator();
        aifTODecorator.setAgenciaInstituicaoFinanceiraTO(ccClienteTO.getAgenciaInstituicaoFinanceiraTO());
        idClienteDebTO.setAgenciaInstituicaoFinanceiraTODecorator(aifTODecorator);
        return idClienteDebTO;
    }

    private ContaCorrenteClienteTO adicionarContaCorrenteClienteTO(int indice) throws BBException {
        if (this.contaCorrenteClienteTO == null) {
            ContaCorrenteClienteTO to = this.getFabricaDeTO().novoContaCorrenteClienteTO();
            AgenciaInstituicaoFinanceiraTOId agenciaId = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTOId();
            agenciaId.setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
            agenciaId.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
            to.setAgenciaInstituicaoFinanceiraTO((AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Serializable)agenciaId));
            to.getId().setCodigoContaCorrente(this.getValorLongArquivo(indice, "NumConta"));
            this.contaCorrenteClienteTO = this.getContaCorrenteClienteDAO().listarPorBancoAgenciaConta(to);
        }
        return this.contaCorrenteClienteTO;
    }

    private ContaCorrenteClienteTO recuperaContaCorrenteClienteTO(int indice) throws BBException {
        if (this.contaCorrenteClienteTO == null) {
            this.contaCorrenteClienteTO = this.getFabricaDeTO().novoContaCorrenteClienteTO();
            AgenciaInstituicaoFinanceiraTOId agenciaId = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTOId();
            agenciaId.setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
            agenciaId.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
            this.contaCorrenteClienteTO.setAgenciaInstituicaoFinanceiraTO((AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Serializable)agenciaId));
            this.contaCorrenteClienteTO.getId().setCodigoContaCorrente(this.getValorLongArquivo(indice, "NumConta"));
        }
        return this.contaCorrenteClienteTO;
    }

    public void setContaCorrenteClienteTO(ContaCorrenteClienteTO contaCorrenteClienteTO) {
        this.contaCorrenteClienteTO = contaCorrenteClienteTO;
    }

    private void atualizaCodigoSituacaoIdentificadorDebito(IdentificadorClienteDebitoTO idCliDbt, char codigoSituacaoIdentificador) {
        if (idCliDbt == null) {
            return;
        }
        idCliDbt.setSituacaoIdentificadorDebitoTO(this.getSituacaoIdentificadorDebitoDAO().consultarPorSituacao(codigoSituacaoIdentificador));
        this.getIdentificadorClienteDebitoDAO().alterar(idCliDbt);
    }

    private void excluirIdentificadorDebito(IdentificadorClienteDebitoTO idCliDbt) {
        if (idCliDbt == null) {
            return;
        }
        this.getIdentificadorClienteDebitoDAO().excluir(idCliDbt);
    }

    private Integer getCodigoMovimentoArquivo(int indice) throws BBException {
        return this.getParser().getValorDoRegistroInteger(indice, "CodMovimento");
    }

    private boolean isRegistroTipoH(int indice) throws BBException {
        return "H".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private boolean isRegistroTipoB(int indice) throws BBException {
        return "B".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private boolean isRegistroTipoF(int indice) throws BBException {
        return "F".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private void atualizaRecebimentoDebito(RecebimentoDebitoTO recebimentoDebitoTO, char codigoSituacaoRecebimento, int indice) throws BBException {
        SituacaoRecebimentoTO situacaoRecebimentoTO = this.getSituacaoRecebimentoDAO().consultarPorId(codigoSituacaoRecebimento);
        recebimentoDebitoTO.setSituacaoRecebimentoTO(situacaoRecebimentoTO);
        recebimentoDebitoTO.setCodigoBancoLiquidacao(Integer.valueOf(1));
        recebimentoDebitoTO.setCodigoAgenciaLiquidacao(this.getValorIntegerArquivo(indice, "NumAgencia"));
        recebimentoDebitoTO.setCodigoContaCorrenteLiquidacao(this.getValorIntegerArquivo(indice, "NumConta"));
        recebimentoDebitoTO.setDataDebito(this.getValorDateArquivo(indice, "DataOpcao"));
        recebimentoDebitoTO.setValorDebito(new BigDecimal(this.getValorDoubleArquivo(indice, "ValorDBT")));
        this.getRecebimentoDebitoDAO().alterar(recebimentoDebitoTO);
    }

    private String getRecebimentoDebitoAnteriorArquivo(int indice) throws BBException {
        return this.getValorStringArquivo(indice, "IdDbtAnt");
    }

    private String getRecebimentoDebitoAtualArquivo(int indice) throws BBException {
        return this.getValorStringArquivo(indice, "IdDbtAtual");
    }

    private File recuperaArquivoRetorno(RetornoTODecorator retornoTODecorator) {
        return ArquivoFactory.getInstancia().novoFile(String.valueOf(this.getPathDiretorioRetorno()) + "\\" + retornoTODecorator.getNomeArquivo() + ".RET");
    }

    private RetornoTODecorator preencherRetornoTO(IParserArquivo parser, File file) throws BBException {
        RetornoTODecorator retornoDecorator = this.getFabricaDeTO().novoRetornoTODecorator();
        retornoDecorator.setNomeArquivo(this.getNomeArquivo(file));
        retornoDecorator.setNumeroConvenio(new Integer(parser.getValorDoCabecalhoString("Convenio")));
        retornoDecorator.setNumeroIdentificadorRetorno(parser.getValorDoCabecalhoInteger("SequencialArq").intValue());
        retornoDecorator.setDataProcessamentoRetorno(parser.getValorDoCabecalhoDate("DataArq"));
        return retornoDecorator;
    }

    private Integer getNumeroRetorno() throws BBException {
        return this.getParser().getValorDoCabecalhoInteger("SequencialArq");
    }

    private Date getDataArquivo() throws BBException {
        return this.getParser().getValorDoCabecalhoDate("DataArq");
    }

    private String getNomeConvenente() throws BBException {
        return this.getParser().getValorDoCabecalhoString("NomeEmpresa");
    }

    private String getNomeArquivo(File file) {
        String f = file.getName();
        return f.substring(0, f.lastIndexOf(46));
    }

    private boolean verificaConvenio(String valorDoCabecalhoString, Collection<ConvenioTO> listaConveniosConvenente) {
        if (valorDoCabecalhoString == null) {
            return false;
        }
        Integer valorConvenioArquivo = new Integer(valorDoCabecalhoString);
        for (ConvenioTO convenioTO : listaConveniosConvenente) {
            if (!convenioTO.getId().getNumeroConvenio().equals(valorConvenioArquivo)) continue;
            return true;
        }
        return false;
    }

    private File[] recuperaArquivosDeRetorno() {
        File diretorioArquivos = this.getArquivoFactory().novoFile(this.getPathDiretorioRetorno());
        File[] listaArquivos = diretorioArquivos.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.length() < 6) {
                    return false;
                }
                int inicioExtensaoArquivo = name.length() - 4;
                int fimExtensaoArquivo = name.length();
                String prefixoArquivo = name.substring(0, 6);
                return (prefixoArquivo.equalsIgnoreCase("DBT927") || prefixoArquivo.equalsIgnoreCase("DBT929")) && name.substring(inicioExtensaoArquivo, fimExtensaoArquivo).equalsIgnoreCase(".RET");
            }
        });
        return listaArquivos;
    }

    private String getPathDiretorioRetorno() {
        return UtilArquivoConfiguracao.getInstancia().getValorPropertie("diretorio.retorno");
    }

    private String getDiretorioRetornoProcessado() {
        return UtilArquivoConfiguracao.getInstancia().getValorPropertie("diretorio.processados");
    }

    protected IParserArquivo getParser() {
        return this.parser;
    }

    protected void setParser(IParserArquivo parser) {
        this.parser = parser;
    }

    protected int getTotalDeRegistros() throws BBException {
        return this.getParser().getTotalDeRegistros();
    }

    protected Integer getConvenioArquivo() throws BBException {
        return UtilConversorDeInteger.converterParaInteger((String)this.getParser().getValorDoCabecalhoString("Convenio"));
    }

    public ConvenioTO getConvenioTO() throws BBException {
        if (this.convenioTO == null) {
            ConvenioTOId toId = this.getFabricaDeTO().novoConvenioTOId();
            toId.setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente());
            toId.setServicoTO((ServicoTO)this.getServicoDAO().listar((Serializable)((Object)"DBT")));
            toId.setNumeroConvenio(this.getConvenioArquivo());
            this.convenioTO = (ConvenioTO)this.getConvenioDAO().listar((Serializable)toId);
        }
        return this.convenioTO;
    }

    public void setConvenioTO(ConvenioTO convenioTO) {
        this.convenioTO = convenioTO;
    }

    public ConvenioDebitoTO getConvenioDebitoTO() throws BBException {
        if (this.convenioDebitoTO == null) {
            ConvenioDebitoTOId toId = this.getFabricaDeTO().novoConvenioDebitoTOId();
            toId.setConvenioTO(this.getConvenioTO());
            this.convenioDebitoTO = (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar((Serializable)toId);
        }
        return this.convenioDebitoTO;
    }

    public void setConvenioDebitoTO(ConvenioDebitoTO convenioDebitoTO) {
        this.convenioDebitoTO = convenioDebitoTO;
    }

    public ConvenenteTO getConvenenteTO() {
        return this.convenenteTO;
    }

    public void setConvenenteTO(ConvenenteTO convenenteTO) {
        this.convenenteTO = convenenteTO;
    }

    public ConvenenteTO getConvenente() throws BBException {
        if (this.convenenteTO == null) {
            ConvenioTODecorator convenioTODecorator = this.getFabricaDeTO().novoConvenioTODecorator();
            convenioTODecorator.setNumeroConvenio(this.getConvenioArquivo());
            convenioTODecorator.setTextoIdentificadorServico("DBT");
            this.convenenteTO = this.getConvenioDAO().consultarPorConvenioServico(convenioTODecorator).getConvenenteTO();
        }
        return this.convenenteTO;
    }

    private void criaRelatorioDataSourceCadastramentoExclusao(Collection<RetornoTODecorator> retornoTODecorator, List<LancamentoTO> colecaoCadastramentoExclucao, List<RelatorioProcessarRetornoDecorator> colecaoRetorno, LancamentosArquivoTO lancamentoArquivoTO) throws BBException {
        RelatorioProcessarRetornoDecorator relatorioRetornoDecorator = new RelatorioProcessarRetornoDecorator();
        relatorioRetornoDecorator.setLancamentosArquivoTO(lancamentoArquivoTO);
        relatorioRetornoDecorator.setAlterecaoExclucaoDS(new RelatorioDataSource(colecaoCadastramentoExclucao));
        relatorioRetornoDecorator.setTipoRegistroTitulo("CADASTRAMENTO/EXCLUS\u00c3O DE IDENTIFICA\u00c7\u00c3O P/ DEBITO");
        for (RetornoTODecorator decorator : retornoTODecorator) {
            relatorioRetornoDecorator.setTotalRegistros(UtilConversorDeInteger.converterParaString((int)decorator.getNumeroLancamentosCadastramentoExclusao()));
        }
        colecaoRetorno.add(relatorioRetornoDecorator);
    }

    private void criaRelatorioDataSourceAlteracaoComOcorrencia(Collection<RetornoTODecorator> retornoTODecorator, List<LancamentoTO> colecaoAlteracaoComOcorrencia, List<RelatorioProcessarRetornoDecorator> colecaoRetorno, LancamentosArquivoTO lancamentoArquivoTO) throws BBException {
        RelatorioProcessarRetornoDecorator relatorioRetornoDecorator2 = new RelatorioProcessarRetornoDecorator();
        relatorioRetornoDecorator2.setLancamentosArquivoTO(lancamentoArquivoTO);
        relatorioRetornoDecorator2.setAlterecaoExclucaoDS(new RelatorioDataSource(colecaoAlteracaoComOcorrencia));
        relatorioRetornoDecorator2.setTipoRegistroTitulo("ALTERA\u00c7\u00c3O DE IDENTIFICA\u00c7\u00c3O P/ D\u00c9BITO COM OCORR\u00caNCIA");
        for (RetornoTODecorator decorator : retornoTODecorator) {
            relatorioRetornoDecorator2.setTotalRegistros(UtilConversorDeInteger.converterParaString((int)decorator.getNumeroLancamentosAlteracaoOcorrencia()));
        }
        colecaoRetorno.add(relatorioRetornoDecorator2);
    }

    private void criaRelatorioDataSourceRecebimentosComDebitoEfetuado(Collection<RetornoTODecorator> retornoTODecorator, List<LancamentoTO> colecaoRecebimentoComDebitoEfetuado, List<RelatorioProcessarRetornoDecorator> colecaoRetorno, LancamentosArquivoTO lancamentoArquivoTO) throws BBException {
        RelatorioProcessarRetornoDecorator relatorioRetornoDecorator3 = new RelatorioProcessarRetornoDecorator();
        relatorioRetornoDecorator3.setLancamentosArquivoTO(lancamentoArquivoTO);
        relatorioRetornoDecorator3.setAlterecaoExclucaoDS(new RelatorioDataSource(colecaoRecebimentoComDebitoEfetuado));
        relatorioRetornoDecorator3.setTipoRegistroTitulo("LAN\u00c7AMENTO COM D\u00c9BITO EFETUADO");
        for (RetornoTODecorator decorator : retornoTODecorator) {
            relatorioRetornoDecorator3.setTotalRegistros(UtilConversorDeInteger.converterParaString((int)decorator.getNumeroLancamentosRecebimentoComDebito()));
        }
        colecaoRetorno.add(relatorioRetornoDecorator3);
    }

    private void criaRelatorioDataSourceRecebimentosComOcorrencia(Collection<RetornoTODecorator> retornoTODecorator, List<LancamentoTO> colecaoRecebimentoComOcorrencia, List<RelatorioProcessarRetornoDecorator> colecaoRetorno, LancamentosArquivoTO lancamentoArquivoTO) throws BBException {
        RelatorioProcessarRetornoDecorator relatorioRetornoDecorator4 = new RelatorioProcessarRetornoDecorator();
        relatorioRetornoDecorator4.setLancamentosArquivoTO(lancamentoArquivoTO);
        relatorioRetornoDecorator4.setAlterecaoExclucaoDS(new RelatorioDataSource(colecaoRecebimentoComOcorrencia));
        relatorioRetornoDecorator4.setTipoRegistroTitulo("LAN\u00c7AMENTO COM OCORR\u00caNCIA");
        for (RetornoTODecorator decorator : retornoTODecorator) {
            relatorioRetornoDecorator4.setTotalRegistros(UtilConversorDeInteger.converterParaString((int)decorator.getNumeroLancamentosRecebimentoComOcorrencia()));
        }
        colecaoRetorno.add(relatorioRetornoDecorator4);
    }

    public ManterCadastroPessoaFisicaModel getManterCadastroPessoaFisicaModel() {
        return this.manterCadastroPessoaFisicaModel;
    }

    public void setManterCadastroPessoaFisicaModel(ManterCadastroPessoaFisicaModel manterCadastroPessoaFisicaModel) {
        this.manterCadastroPessoaFisicaModel = manterCadastroPessoaFisicaModel;
    }

    public IdentificacaoDAO getIdentificacaoDAO() {
        return this.identificacaoDAO;
    }

    public void setIdentificacaoDAO(IdentificacaoDAO identificacaoDAO) {
        this.identificacaoDAO = identificacaoDAO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TipoDeListaRecebimento {
        private List<LancamentoTO> recebimentoComOcorrencia;
        private List<LancamentoTO> recebimentoEfetuado;

        public TipoDeListaRecebimento(List<LancamentoTO> recebimentoEfetuado_, List<LancamentoTO> recebimentoComOcorrencia_) {
            this.recebimentoEfetuado = recebimentoEfetuado_;
            this.recebimentoComOcorrencia = recebimentoComOcorrencia_;
        }

        public List<LancamentoTO> escolhaListaRecebimentoPor(String situacao) {
            return situacao.equals(ProcessarArquivosRetornosModel.SITUACAO_DEBITO_EFETUADO) ? this.recebimentoEfetuado : this.recebimentoComOcorrencia;
        }
    }
}

