/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.swing.componente.comboBox;

import br.com.bb.plugins.dbt.apresentacao.dominio.action.ConsultarListaGrupoAction;
import br.com.bb.plugins.dbt.apresentacao.dominio.action.ConsultarListaGrupoClienteRecebimentoAction;
import br.com.bb.plugins.dbt.factory.DBTActionFactory;
import br.com.bb.plugins.gac.apresentacao.dominio.form.DominioForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxGrupoCliente
extends BBJComboBox {
    public void carregar() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaGrupoAction().executar((PluginFormAbstrato)dominioForm);
        this.preencherCombo(dominioForm.getListaGrupoClienteRecebimento());
    }

    public void carregarComFiltro(Integer numeroConvenio) {
        DominioForm dominioForm = this.getDominioForm();
        dominioForm.getConvenioTO().getId().setNumeroConvenio(numeroConvenio);
        this.getConsultarGrupoAction().executar((PluginFormAbstrato)dominioForm);
        this.preencherCombo(dominioForm.getListaGrupoClienteRecebimento());
    }

    private void preencherCombo(Collection<GrupoClienteRecebimentoTO> listaGrupo) {
        Collections.sort((ArrayList)listaGrupo, new Comparator<GrupoClienteRecebimentoTO>(){

            @Override
            public int compare(GrupoClienteRecebimentoTO o1, GrupoClienteRecebimentoTO o2) {
                return o1.getTextoDescricao().compareTo(o2.getTextoDescricao());
            }
        });
        this.setModel(this.getDefaultComboBoxModel(listaGrupo));
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<GrupoClienteRecebimentoTO> listaGrupo) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(listaGrupo);
        this.inserirElementoVazio(defaultComboBoxModel);
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<GrupoClienteRecebimentoTO> listaGrupo) {
        return new DefaultComboBoxModel<Object>(listaGrupo.toArray());
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(0));
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.insertElementAt("Selecione", 0);
    }

    private DominioForm getDominioForm() {
        return FormFactory.getInstancia().novoDominioForm();
    }

    private ConsultarListaGrupoClienteRecebimentoAction getConsultarListaGrupoAction() {
        return this.getDBTActionFactory().novoConsultarListaGrupoClienteRecebimentoAction();
    }

    private ConsultarListaGrupoAction getConsultarGrupoAction() {
        return this.getDBTActionFactory().novoConsultarListaGrupoAction();
    }

    private DBTActionFactory getDBTActionFactory() {
        return DBTActionFactory.getInstancia();
    }
}

