/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.array;

import br.com.politec.generico.colecao.IAlterador;
import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.objeto.UtilPrimitivo;
import br.com.politec.generico.string.UtilString;
import java.lang.reflect.Array;

public final class UtilArray {
    static /* synthetic */ Class class$java$lang$Byte;

    private UtilArray() {
    }

    public static boolean isArray(Object tipo) {
        boolean res = false;
        if (UtilArray.isReferencia(tipo)) {
            Class<?> classe = null;
            classe = UtilObjeto.isClasse(tipo) ? (Class<?>)tipo : tipo.getClass();
            res = classe.isArray();
        }
        return res;
    }

    public static boolean isArray(String tipo) {
        String sufixo = Constante.getSufixoArray();
        return !UtilArray.isVazio(tipo) && tipo.endsWith(sufixo);
    }

    public static boolean isArrayVazio(Object[] array) {
        boolean resultado = true;
        if (UtilArray.isReferencia(array)) {
            resultado = array.length == 0;
        }
        return resultado;
    }

    public static Object novaInstanciaDeArray(String tipo) throws ClassNotFoundException {
        Object res = null;
        if (!UtilArray.isVazio(tipo) && UtilArray.isArray(tipo)) {
            Class<?> result = Class.forName(UtilArray.getTipoDoArray(tipo));
            res = Array.newInstance(result, 0);
        }
        return res;
    }

    public static Object novaInstanciaDeArray(String tipo, int tamanho) throws ClassNotFoundException {
        Object res = null;
        if (!UtilArray.isVazio(tipo) && UtilArray.isArray(tipo)) {
            Class<?> result = Class.forName(UtilArray.getTipoDoArray(tipo));
            res = Array.newInstance(result, tamanho);
        }
        return res;
    }

    public static Object novaInstanciaDeArray(Class tipo) {
        Object objeto = null;
        if (UtilArray.isReferencia(tipo) && UtilArray.isArray(tipo)) {
            if (UtilPrimitivo.isPrimitivo(tipo = UtilArray.getTipoDoArray(tipo))) {
                tipo = UtilPrimitivo.getClasseWrapperDoPrimitivo(tipo);
            }
            objeto = Array.newInstance(tipo, 0);
        }
        return objeto;
    }

    public static Class novaClasseDeArray(String tipo) throws ClassNotFoundException {
        Object res = null;
        if (!UtilArray.isVazio(tipo) && UtilArray.isArray(tipo)) {
            res = UtilArray.novaInstanciaDeArray(tipo);
        }
        return res != null ? res.getClass() : null;
    }

    public static Class getTipoDoArray(Class tipo) {
        Class<?> res = null;
        if (UtilArray.isReferencia(tipo)) {
            res = tipo.getComponentType();
            while (UtilArray.isArray(res)) {
                res = res.getComponentType();
            }
        }
        return res;
    }

    public static String getString(Class tipo) {
        String res = null;
        if (UtilArray.isArray(tipo)) {
            tipo = UtilArray.getTipoDoArray(tipo);
            res = tipo.getName();
            res = res + Constante.getSufixoArray();
        }
        return res;
    }

    private static String getTipoDoArray(String tipo) {
        String res = null;
        if (UtilArray.isArray(tipo) && UtilPrimitivo.isPrimitivo(res = tipo.substring(0, tipo.length() - 2))) {
            res = UtilPrimitivo.getNomeDaClasseDoWrapper(res);
        }
        return res;
    }

    private static boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    public static boolean isTipoArrayByte(Object array) {
        boolean res = false;
        if (UtilObjeto.isReferencia(array) && UtilArray.isArray(array)) {
            Class tipo = UtilObjeto.getClasse(array);
            tipo = UtilArray.getTipoDoArray(tipo);
            res = tipo.isAssignableFrom(class$java$lang$Byte == null ? (class$java$lang$Byte = UtilArray.class$("java.lang.Byte")) : class$java$lang$Byte) || tipo.isAssignableFrom(Byte.TYPE);
        }
        return res;
    }

    public static String[] aplicarAlterador(String[] args, IAlterador alterador) {
        if (args != null && UtilArray.isReferencia(alterador)) {
            for (int indice = 0; indice < args.length; ++indice) {
                args[indice] = (String)alterador.alterar(args[indice]);
            }
        }
        return args;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

