/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.colecao;

import br.com.politec.generico.calculadores.UtilSomadoresDeNumero;
import br.com.politec.generico.colecao.IAlterador;
import br.com.politec.generico.colecao.IComparador;
import br.com.politec.generico.colecao.IFiltro;
import br.com.politec.generico.colecao.ISomador;
import br.com.politec.generico.excecao.FormatadorException;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.fabrica.NumeroFactory;
import br.com.politec.generico.formatador.instancia.IFormatador;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.log.UtilLog;
import br.com.politec.generico.objeto.UtilObjeto;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class UtilColecao {
    private UtilColecao() {
    }

    public static Collection ordenar(Collection colecao) {
        List resultado = null;
        if (UtilColecao.isReferencia(colecao)) {
            resultado = UtilColecao.getColecaoFactory().novoList(colecao);
            Collections.sort(resultado);
        }
        return resultado;
    }

    public static Collection ordenar(Collection colecao, Comparator comparator) {
        if (UtilColecao.isReferencia(colecao, comparator)) {
            Collections.sort((List)colecao, comparator);
        }
        return colecao;
    }

    public static boolean isContemElemento(Collection colecao, IFiltro filtro) {
        boolean resultado = false;
        if (UtilColecao.isReferencia(colecao, filtro)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext() && !resultado) {
                resultado = filtro.isFiltrado(iterator.next());
            }
        }
        return resultado;
    }

    public static boolean isContemElemento(Collection colecao, Object elemento, IComparador comparador) {
        boolean resultado = false;
        if (UtilColecao.isReferencia(colecao, elemento, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext() && !resultado) {
                resultado = comparador.isIguais(elemento, iterator.next());
            }
        }
        return resultado;
    }

    public static boolean isContemElementoEmComum(Collection colecao, Collection elementos, IComparador comparador) {
        boolean resultado = false;
        if (UtilColecao.isReferencia(colecao, elementos, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext() && !resultado) {
                Object objetoDeOrigem = iterator.next();
                Iterator iteratorElementos = UtilColecao.novoIterator(elementos);
                while (iteratorElementos.hasNext() && !resultado) {
                    Object objetoLocalizado = iteratorElementos.next();
                    resultado = comparador.isIguais(objetoDeOrigem, objetoLocalizado);
                }
            }
        }
        return resultado;
    }

    public static Collection filtrar(Collection colecao, IFiltro filtro) {
        if (UtilColecao.isReferencia(colecao, filtro)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                if (filtro.isFiltrado(iterator.next())) continue;
                iterator.remove();
            }
        }
        return colecao;
    }

    public static Collection novaColecao(Collection colecao, IFiltro filtro) {
        List resultado = UtilColecao.getColecaoFactory().novoArrayList();
        if (UtilColecao.isReferencia(colecao, filtro)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                Object objeto = iterator.next();
                if (!filtro.isFiltrado(objeto)) continue;
                resultado.add(objeto);
            }
        }
        return resultado;
    }

    public static Collection filtrar(Collection colecao, Object objeto, IComparador comparador) {
        if (UtilColecao.isReferencia(colecao, objeto, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                if (!comparador.isIguais(objeto, iterator.next())) continue;
                iterator.remove();
            }
        }
        return colecao;
    }

    public static Collection novaColecao(Collection colecao, Object objeto, IComparador comparador) {
        List resultado = UtilColecao.getColecaoFactory().novoArrayList();
        if (UtilColecao.isReferencia(colecao, objeto, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                Object objetoDaColecao = iterator.next();
                if (!comparador.isIguais(objeto, objetoDaColecao)) continue;
                resultado.add(objetoDaColecao);
            }
        }
        return resultado;
    }

    public static Collection filtrar(Collection colecao, Collection objetos, IComparador comparador) {
        if (UtilColecao.isReferencia(colecao, objetos, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                if (!UtilColecao.isContemElemento(objetos, iterator.next(), comparador)) continue;
                iterator.remove();
            }
        }
        return colecao;
    }

    public static Object getElemento(Collection colecao, IFiltro filtro) {
        Object resultado = null;
        if (UtilColecao.isReferencia(colecao, filtro)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext() && !UtilColecao.isReferencia(resultado)) {
                Object objetoDaColecao = iterator.next();
                if (!filtro.isFiltrado(objetoDaColecao)) continue;
                resultado = objetoDaColecao;
            }
        }
        return resultado;
    }

    public static Object getElemento(Collection colecao, Object objeto, IComparador comparador) {
        Object resultado = null;
        if (UtilColecao.isReferencia(colecao, objeto, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext() && !UtilColecao.isReferencia(resultado)) {
                Object objetoDaColecao = iterator.next();
                if (!comparador.isIguais(objeto, objetoDaColecao)) continue;
                resultado = objetoDaColecao;
            }
        }
        return resultado;
    }

    public static Object getElementoDoIndice(List lista, int indice) {
        Object resultado = null;
        if (!UtilColecao.isVazio(lista) && indice >= 0 && indice < lista.size()) {
            resultado = lista.get(indice);
        }
        return resultado;
    }

    public static Object getElementoDoIndice(Collection colecao, int indice) {
        List lista = UtilColecao.getColecaoFactory().novoList(colecao);
        return UtilColecao.getElementoDoIndice(lista, indice);
    }

    public static Object getElementoDoUltimoIndice(Collection colecao) {
        List lista = UtilColecao.getColecaoFactory().novoList(colecao);
        int indice = lista.size() - 1;
        return UtilColecao.getElementoDoIndice(lista, indice);
    }

    public static Collection aplicarAlterador(Collection colecao, IAlterador alterador) {
        if (UtilColecao.isReferencia(colecao, alterador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                alterador.alterar(iterator.next());
            }
        }
        return colecao;
    }

    public static Collection aplicarComparador(Collection colecao, Object objeto, IComparador comparador) {
        if (UtilColecao.isReferencia(colecao, comparador, objeto)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                comparador.isIguais(objeto, iterator.next());
            }
        }
        return colecao;
    }

    public static double aplicarSomador(Collection colecao, ISomador somador) {
        double resultado = 0.0;
        if (UtilColecao.isReferencia(colecao, somador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                double valor = somador.getValor(iterator.next());
                resultado = UtilSomadoresDeNumero.somar(resultado, valor);
            }
        }
        return resultado;
    }

    public static String aplicarSomador(Collection colecao, ISomador somador, IFormatador formatador) throws FormatadorException {
        String resultado = null;
        if (UtilColecao.isReferencia(colecao, somador, formatador)) {
            double soma = UtilColecao.aplicarSomador(colecao, somador);
            Double somaDouble = UtilColecao.getNumeroFactory().novoDouble(soma);
            resultado = formatador.formatar(somaDouble);
        }
        return resultado;
    }

    public static void completarColecao(Collection colecao, int total, Class tipo) {
        if (UtilColecao.isReferencia(colecao, tipo)) {
            while (colecao.size() < total) {
                try {
                    colecao.add(tipo.newInstance());
                }
                catch (Exception e) {
                    UtilColecao.getLog().warn(e);
                }
            }
        }
    }

    public static Collection getElementosIguais(Collection colecao, Collection elementos, IComparador comparador) {
        if (UtilColecao.isReferencia(colecao, elementos, comparador)) {
            Iterator iterator = UtilColecao.novoIterator(colecao);
            while (iterator.hasNext()) {
                if (UtilColecao.isContemElemento(elementos, iterator.next(), comparador)) continue;
                iterator.remove();
            }
        }
        return colecao;
    }

    public static Collection copiarColecao(Collection colecao) {
        List resultado = UtilColecao.getColecaoFactory().novoArrayList();
        Iterator iterator = UtilColecao.novoIterator(colecao);
        while (iterator.hasNext()) {
            resultado.add(iterator.next());
        }
        return resultado;
    }

    public static boolean isVazio(Collection colecao) {
        return !UtilColecao.isReferencia(colecao) || colecao.size() == 0;
    }

    public static int getTamanho(Collection colecao) {
        int resultado = 0;
        if (UtilColecao.isReferencia(colecao)) {
            resultado = colecao.size();
        }
        return resultado;
    }

    private static Iterator novoIterator(Collection colecao) {
        return UtilColecao.getColecaoFactory().novoIterator(colecao);
    }

    private static boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    private static boolean isReferencia(Object objeto0, Object objeto1) {
        return UtilObjeto.isReferencia(objeto0, objeto1);
    }

    private static boolean isReferencia(Object objeto0, Object objeto1, Object objeto2) {
        return UtilObjeto.isReferencia(objeto0, objeto1, objeto2);
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    private static NumeroFactory getNumeroFactory() {
        return NumeroFactory.getInstance();
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

