/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.colecao;

import br.com.politec.generico.colecao.IAlteradorMapa;
import br.com.politec.generico.colecao.IFiltroMapa;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import java.util.Iterator;
import java.util.Map;

public final class UtilMapa {
    private UtilMapa() {
    }

    public static Map filtrar(Map mapa, IFiltroMapa filtro) {
        if (UtilMapa.isReferencia(mapa, filtro)) {
            Iterator iterator = mapa.keySet().iterator();
            while (iterator.hasNext()) {
                Object valor;
                Object chave = iterator.next();
                if (filtro.isFiltrado(chave, valor = mapa.get(chave))) continue;
                iterator.remove();
            }
        }
        return mapa;
    }

    public static Map aplicarAlterador(Map mapa, IAlteradorMapa alterador) {
        Map resultado = UtilMapa.getColecaoFactory().novoHashMap();
        if (UtilMapa.isReferencia(mapa, alterador)) {
            Iterator iterator = mapa.keySet().iterator();
            while (iterator.hasNext()) {
                Object chave = iterator.next();
                Object valor = mapa.get(chave);
                chave = alterador.alterarChave(chave);
                valor = alterador.alterarValor(valor);
                resultado.put(chave, valor);
            }
        }
        return resultado;
    }

    public static Map aplicarFiltroEAlterador(Map mapa, IFiltroMapa filtro, IAlteradorMapa alterador) {
        Map resultado = UtilMapa.getColecaoFactory().novoHashMap();
        if (UtilMapa.isReferencia(mapa, filtro, alterador)) {
            Iterator iterator = mapa.keySet().iterator();
            while (iterator.hasNext()) {
                Object valor;
                Object chave = iterator.next();
                if (!filtro.isFiltrado(chave, valor = mapa.get(chave))) continue;
                chave = alterador.alterarChave(chave);
                valor = alterador.alterarValor(valor);
                resultado.put(chave, valor);
            }
        }
        return resultado;
    }

    private static boolean isReferencia(Object objeto0, Object objeto1) {
        return UtilObjeto.isReferencia(objeto0, objeto1);
    }

    private static boolean isReferencia(Object objeto0, Object objeto1, Object objeto2) {
        return UtilObjeto.isReferencia(objeto0, objeto1, objeto2);
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }
}

