/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.estrategia;

import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.arquivo.UtilCarregarMapaDeObjetos;
import br.com.politec.generico.constante.Arquivo;
import br.com.politec.generico.formatador.instancia.FormatadorDeString;
import br.com.politec.generico.formatador.instancia.IFormatador;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.util.Map;
import java.util.Properties;

public final class UtilEstrategiaDeFormatadores {
    private static Map formatadores;

    private UtilEstrategiaDeFormatadores() {
    }

    public static void adicionarFormatador(String tipo, IFormatador formatador) {
        if (!UtilString.isVazio(tipo) && UtilObjeto.isReferencia(formatador)) {
            UtilEstrategiaDeFormatadores.getFormatadores().put(tipo, formatador);
        }
    }

    public static void alterarFormatador(String tipo, IFormatador formatador) {
        UtilEstrategiaDeFormatadores.adicionarFormatador(tipo, formatador);
    }

    public static IFormatador getFormatador(Class tipo) {
        String chave = UtilObjeto.getNome(tipo);
        if (!UtilObjeto.isReferencia(chave)) {
            chave = UtilEstrategiaDeFormatadores.getTipoFormatadorPadrao();
        }
        return UtilEstrategiaDeFormatadores.getFormatador(chave);
    }

    public static IFormatador getFormatador(String tipo) {
        IFormatador formatador = (IFormatador)UtilEstrategiaDeFormatadores.getFormatadores().get(tipo);
        if (!UtilObjeto.isReferencia(formatador)) {
            formatador = UtilEstrategiaDeFormatadores.getFormatadorPadrao();
        }
        return formatador;
    }

    public static Map getFormatadores() {
        if (!UtilObjeto.isReferencia(formatadores)) {
            String arquivo = Arquivo.getPathFormatadoresPadraoProperties();
            Properties properties = UtilArquivo.getProperties(arquivo);
            UtilCarregarMapaDeObjetos util = new UtilCarregarMapaDeObjetos();
            formatadores = util.getMapa(properties);
        }
        return formatadores;
    }

    public static IFormatador getFormatadorPadrao() {
        return new FormatadorDeString();
    }

    public static String getTipoFormatadorPadrao() {
        return "java.lang.String";
    }

    public static IFormatador removerFormatador(String tipo) {
        IFormatador formatador = null;
        if (!UtilString.isVazio(tipo)) {
            formatador = (IFormatador)UtilEstrategiaDeFormatadores.getFormatadores().remove(tipo);
        }
        return formatador;
    }

    public static void setFormatadores(Map formatadores) {
        UtilEstrategiaDeFormatadores.formatadores = formatadores;
    }
}

