/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.fabrica;

import br.com.politec.generico.objeto.UtilObjeto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public final class ColecaoFactory {
    private static ColecaoFactory instance = new ColecaoFactory();

    private ColecaoFactory() {
    }

    public static ColecaoFactory getInstance() {
        return instance;
    }

    public List novoArrayList() {
        return new ArrayList();
    }

    public Map novoHashMap() {
        return new HashMap();
    }

    public List novoLinkedList() {
        return new LinkedList();
    }

    public Set novoLinkedHashSet() {
        return new LinkedHashSet();
    }

    public Vector novoVector() {
        return new Vector();
    }

    public List novoList(Collection colecao) {
        List resultado = this.novoArrayList();
        if (this.isReferencia(colecao)) {
            if (colecao instanceof List) {
                resultado = (List)colecao;
            } else {
                resultado.addAll(colecao);
            }
        }
        return resultado;
    }

    public List novoList(Iterator iterator) {
        List resultado = this.novoArrayList();
        if (this.isReferencia(iterator)) {
            while (iterator.hasNext()) {
                resultado.add(iterator.next());
            }
        }
        return resultado;
    }

    public Iterator novoIterator(Collection colecao) {
        Iterator resultado = null;
        resultado = this.isReferencia(colecao) ? colecao.iterator() : this.novoArrayList().iterator();
        return resultado;
    }

    public List novoList(Map mapa) {
        List resultado = this.novoArrayList();
        if (this.isReferencia(mapa)) {
            resultado = (List)mapa.values();
        }
        return resultado;
    }

    public Set novoHashSet() {
        return new HashSet();
    }

    public Set novoHashSet(Collection colecao) {
        Set resultado = this.novoHashSet();
        resultado.addAll(colecao);
        return resultado;
    }

    public Map novoTreeMap() {
        return new TreeMap();
    }

    public Map novoTreeMap(Map mapa) {
        Map tree = this.novoTreeMap();
        tree.putAll(mapa);
        return tree;
    }

    private boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }
}

