/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.fabrica;

import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.data.UtilData;
import br.com.politec.generico.objeto.UtilObjeto;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DataFactory {
    private static DataFactory instance = new DataFactory();

    private DataFactory() {
    }

    public static DataFactory getInstance() {
        return instance;
    }

    public Calendar novoCalendar() {
        return Calendar.getInstance(this.novoLocaleBrasil());
    }

    public Calendar novoCalendar(Date data) {
        Calendar calendar = this.novoCalendar();
        if (UtilObjeto.isReferencia(data)) {
            calendar.setTime(data);
        }
        return calendar;
    }

    public Calendar novoCalendar(long _long) {
        Calendar calendar = this.novoCalendar();
        calendar.setTimeInMillis(_long);
        return calendar;
    }

    public Calendar novoCalendar(int dia, int mes, int ano) {
        Calendar calendar = this.novoCalendar();
        calendar.set(ano, mes - 1, dia);
        return calendar;
    }

    public Calendar novoCalendar(int dia, int mes, int ano, int hora, int minuto) {
        Calendar calendar = this.novoCalendar();
        calendar.set(ano, mes - 1, dia, hora, minuto);
        return calendar;
    }

    public Calendar novoCalendar(int dia, int mes, int ano, int hora, int minuto, int segundo) {
        Calendar calendar = this.novoCalendar();
        calendar.set(ano, mes - 1, dia, hora, minuto, segundo);
        calendar.set(14, 0);
        return calendar;
    }

    public Date novoDate() {
        return new Date();
    }

    public Date novoDate(long _long) {
        Date data = this.novoDate();
        data.setTime(_long);
        return data;
    }

    public Date novoDate(int dia, int mes, int ano) {
        return this.novoCalendar(dia, mes, ano).getTime();
    }

    public Date novoDate(int dia, int mes, int ano, int hora, int minuto) {
        return this.novoCalendar(dia, mes, ano, hora, minuto).getTime();
    }

    public Date novoDate(int dia, int mes, int ano, int hora, int minuto, int segundo) {
        return this.novoCalendar(dia, mes, ano, hora, minuto, segundo).getTime();
    }

    public java.sql.Date novoSqlDate(long _long) {
        return new java.sql.Date(_long);
    }

    public java.sql.Date novoSqlDate(int dia, int mes, int ano) {
        Date data = this.novoDate(dia, mes, ano);
        return this.novoSqlDate(data.getTime());
    }

    public Timestamp novoTimestamp() {
        return new Timestamp(this.novoDate().getTime());
    }

    public Timestamp novoTimestamp(long _long) {
        return new Timestamp(_long);
    }

    public Timestamp novoTimestamp(int dia, int mes, int ano) {
        Date date = this.novoDate(dia, mes, ano);
        return new Timestamp(date.getTime());
    }

    public Timestamp novoTimestamp(int dia, int mes, int ano, int hora, int minuto) {
        Date date = this.novoDate(dia, mes, ano, hora, minuto);
        return new Timestamp(date.getTime());
    }

    public Timestamp novoTimestamp(int dia, int mes, int ano, int hora, int minuto, int segundo) {
        Date date = this.novoDate(dia, mes, ano, hora, minuto, segundo);
        return new Timestamp(date.getTime());
    }

    public Timestamp novoTimestamp(int dia, int mes, int ano, int hora, int minuto, int segundo, int nanosegundo) {
        Date date = this.novoDate(dia, mes, ano, hora, minuto, segundo);
        Timestamp Timestamp2 = this.novoTimestamp();
        Timestamp2.setTime(date.getTime());
        Timestamp2.setNanos(nanosegundo);
        return Timestamp2;
    }

    public Time novoTime() {
        return new Time(this.novoDate().getTime());
    }

    public Time novoTime(long _long) {
        return new Time(_long);
    }

    public Time novoTime(int hora, int minuto) {
        int day = UtilData.getPrimeiroDiaDoMesDefault();
        int month = UtilData.getPrimeiroMesDefault();
        int year = UtilData.getPrimeiroAnoDefault();
        Date data = this.novoDate(day, month, year, hora, minuto);
        return new Time(data.getTime());
    }

    public Time novoTime(int hour, int minute, int second) {
        int day = UtilData.getPrimeiroDiaDoMesDefault();
        int month = UtilData.getPrimeiroMesDefault();
        int year = UtilData.getPrimeiroAnoDefault();
        Date data = this.novoDate(day, month, year, hour, minute, second);
        return new Time(data.getTime());
    }

    public SimpleDateFormat novoSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern, this.novoLocaleBrasil());
    }

    public SimpleDateFormat novoSimpleDateFormat(String pattern, DateFormatSymbols dateFormatSymbols) {
        return new SimpleDateFormat(pattern, dateFormatSymbols);
    }

    public TimeZone novoTimeZonePadrao() {
        return TimeZone.getDefault();
    }

    public TimeZone novoTimeZone(String identificador) {
        return TimeZone.getTimeZone(identificador);
    }

    private Locale novoLocaleBrasil() {
        return Constante.getLocaleBrasil();
    }
}

