/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.formatador;

import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.formatador.UtilFormatadorAbstrato;
import br.com.politec.generico.numerico.UtilNumero;
import br.com.politec.generico.string.UtilString;

public final class UtilFormatadorDeReal
extends UtilFormatadorAbstrato {
    private UtilFormatadorDeReal() {
    }

    public static String formatar(Number real) {
        return UtilFormatadorDeReal.formatarReal(real);
    }

    public static String formatar(Number real, int casasDecimais) {
        return UtilFormatadorDeReal.formatarReal(real, casasDecimais);
    }

    public static String formatar(double real) {
        return UtilFormatadorDeReal.formatar(new Double(real));
    }

    public static String formatar(double real, int casasDecimais) {
        return UtilFormatadorDeReal.formatar(new Double(real), casasDecimais);
    }

    public static String formatar(String valor, int casasDecimais) {
        valor = UtilString.removerPrefixo(valor, "0");
        int tamanho = UtilString.getTamanho(valor);
        if (UtilNumero.isReal(valor) && casasDecimais > 0 && tamanho > casasDecimais) {
            int posicao = tamanho - casasDecimais;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(valor);
            stringBuffer.insert(posicao, UtilFormatadorDeReal.getSeparadorDecimal());
            valor = stringBuffer.toString();
        }
        return valor;
    }

    public static String formatarParaMonetario(double real) {
        String valor = UtilFormatadorDeReal.formatar(real);
        if (!UtilFormatadorDeReal.isVazio(valor)) {
            valor = Constante.getPrefixoMonetario() + " " + valor;
        }
        return valor;
    }

    public static String formatarParaMonetario(Number real) {
        String valor = UtilFormatadorDeReal.formatarReal(real);
        if (!UtilFormatadorDeReal.isVazio(valor)) {
            valor = Constante.getPrefixoMonetario() + " " + valor;
        }
        return valor;
    }

    public static String formatarParaMonetarioSemPrefixo(Number real) {
        return UtilFormatadorDeReal.formatarReal(real);
    }
}

