/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.formatador;

import br.com.politec.generico.formatador.UtilFormatadorAbstrato;
import br.com.politec.generico.pattern.UtilPatternsDeFormatacao;
import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorDeNumerosIguais;
import java.util.Map;

public class UtilFormatadorDeTelefone
extends UtilFormatadorAbstrato {
    private static Map patterns;

    private UtilFormatadorDeTelefone() {
    }

    public static String formatar(String telefone) {
        String resultado = telefone;
        if (UtilFormatadorDeTelefone.isValido(telefone)) {
            String pattern = UtilFormatadorDeTelefone.getPattern(telefone);
            resultado = UtilFormatadorDeTelefone.formatarString(telefone, pattern);
        }
        return resultado;
    }

    public static String formatar(Number telefone) {
        return UtilFormatadorDeTelefone.formatar(UtilString.getString(telefone));
    }

    public static String formatar(int telefone) {
        return UtilFormatadorDeTelefone.formatar(String.valueOf(telefone));
    }

    public static String formatar(long telefone) {
        return UtilFormatadorDeTelefone.formatar(String.valueOf(telefone));
    }

    private static boolean isValido(String telefone) {
        int tamanho = UtilString.getTamanho(telefone);
        return UtilFormatadorDeTelefone.isReferencia(telefone) && (UtilFormatadorDeTelefone.isTamanho(tamanho, 8) || UtilFormatadorDeTelefone.isTamanho(tamanho, 10) || UtilFormatadorDeTelefone.isTamanho(tamanho, 12));
    }

    private static boolean isTamanho(int tamanho, int desejado) {
        return UtilValidadorDeNumerosIguais.validar(tamanho, desejado);
    }

    private static Integer novoInteger(int _int) {
        return UtilFormatadorDeTelefone.getNumeroFactory().novoInteger(_int);
    }

    private static String getPattern(String telefone) {
        int tamanho = UtilString.getTamanho(telefone);
        return (String)UtilFormatadorDeTelefone.getPatterns().get(UtilFormatadorDeTelefone.novoInteger(tamanho));
    }

    private static Map getPatterns() {
        if (!UtilFormatadorDeTelefone.isReferencia(patterns)) {
            patterns = UtilFormatadorDeTelefone.getColecaoFactory().novoHashMap();
            patterns.put(UtilFormatadorDeTelefone.novoInteger(8), UtilPatternsDeFormatacao.getTelefoneDeOito());
            patterns.put(UtilFormatadorDeTelefone.novoInteger(10), UtilPatternsDeFormatacao.getTelefoneDeDez());
            patterns.put(UtilFormatadorDeTelefone.novoInteger(12), UtilPatternsDeFormatacao.getTelefoneDeDoze());
        }
        return patterns;
    }
}

