/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.log;

import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import org.apache.log4j.Logger;

public abstract class LogAbstrato {
    private Logger logger;

    public void infoInit(Class classe, String metodo) {
        this.info(this.criarMensagem(classe, metodo, "inicio"));
    }

    public void infoEnd(Class classe, String metodo) {
        this.info(this.criarMensagem(classe, metodo, "fim"));
    }

    public void debugInit(Class classe, String metodo) {
        this.debug(this.criarMensagem(classe, metodo, "inicio"));
    }

    public void debugEnd(Class classe, String metodo) {
        this.debug(this.criarMensagem(classe, metodo, "fim"));
    }

    public void debug(Object mensagem, Throwable excecao) {
        this.getLogger().debug(mensagem, excecao);
    }

    public void debug(Object mensagem) {
        this.getLogger().debug(mensagem);
    }

    public void debug(Throwable excecao) {
        String mensagem = excecao.getMessage();
        if (UtilString.isVazio(mensagem)) {
            mensagem = excecao.toString();
        }
        this.getLogger().debug((Object)mensagem);
    }

    public void error(Object mensagem, Throwable excecao) {
        this.getLogger().error(mensagem, excecao);
    }

    public void error(Object mensagem) {
        this.getLogger().error(mensagem);
    }

    public void fatal(Object mensagem, Throwable excecao) {
        this.getLogger().fatal(mensagem, excecao);
    }

    public void fatal(Object mensagem) {
        this.getLogger().fatal(mensagem);
    }

    public void info(Object mensagem, Throwable excecao) {
        this.getLogger().info(mensagem, excecao);
    }

    public void info(Object mensagem) {
        this.getLogger().info(mensagem);
    }

    public void warn(Object mensagem, Throwable excecao) {
        this.getLogger().warn(mensagem, excecao);
    }

    public void warn(Object mensagem) {
        this.getLogger().warn(mensagem);
    }

    protected abstract String getAppenderDoLog();

    protected Logger getLogger() {
        if (!UtilObjeto.isReferencia(this.logger)) {
            try {
                this.logger = Logger.getLogger((String)this.getAppenderDoLog());
                this.logger.info((Object)"Inicializando logger...");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.logger;
    }

    protected String criarMensagem(Class classe, String metodo, String sufix) {
        StringBuffer message = new StringBuffer();
        message.append(classe.getName());
        message.append(".").append(metodo);
        message.append(" - ").append(sufix);
        return message.toString();
    }
}

