/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.string;

import br.com.politec.generico.constante.Constante;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.pattern.UtilPatternsDeNumero;
import br.com.politec.generico.pattern.UtilPatternsDeString;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class UtilString {
    private UtilString() {
    }

    public static boolean isVazio(String string) {
        return !UtilObjeto.isReferencia(string) || string.trim().equals("");
    }

    public static boolean isVazio(String string1, String string2) {
        return UtilString.isVazio(string1) || UtilString.isVazio(string2);
    }

    public static boolean isVazio(String string1, String string2, String string3) {
        return UtilString.isVazio(string1, string2) || UtilString.isVazio(string3);
    }

    public static String maiuscula(String string) {
        if (!UtilString.isVazio(string)) {
            string = string.toUpperCase();
        }
        return string;
    }

    public static String maiuscula(char string) {
        return UtilString.maiuscula(String.valueOf(string));
    }

    public static String minuscula(String string) {
        if (!UtilString.isVazio(string)) {
            string = string.toLowerCase();
        }
        return string;
    }

    public static String minuscula(char string) {
        return UtilString.minuscula(String.valueOf(string));
    }

    public static String substituirString(String srcString, String localizar, String novaString) {
        if (!UtilString.isVazio(srcString, localizar)) {
            srcString = srcString.replaceAll(localizar, novaString);
        }
        return srcString;
    }

    public static String substituirStringSe(boolean condicao, String srcString, String localizar, String seVerdadeiro, String seFalso) {
        srcString = condicao ? UtilString.substituirString(srcString, localizar, seVerdadeiro) : UtilString.substituirString(srcString, localizar, seFalso);
        return srcString;
    }

    public static String remover(String srcString, String localizar) {
        if (!UtilString.isVazio(srcString, localizar)) {
            srcString = srcString.replaceAll(localizar, "");
        }
        return srcString;
    }

    public static List split(String string, String separador) {
        List result = UtilString.getColecaoFactory().novoArrayList();
        if (!UtilString.isVazio(string, separador)) {
            StringTokenizer st = new StringTokenizer(string, separador);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result;
    }

    public static List split(String string, int tamanho) {
        List result = UtilString.getColecaoFactory().novoArrayList();
        if (!UtilString.isVazio(string)) {
            tamanho = tamanho != 0 ? tamanho : 1;
            int inicio = 0;
            int fim = inicio + tamanho;
            while (inicio < string.length()) {
                result.add(UtilString.substring(string, inicio, fim));
                inicio = fim;
                fim += tamanho;
            }
        }
        return result;
    }

    public static boolean isTemString(String srcString, String localizar) {
        boolean result = false;
        if (!UtilString.isVazio(srcString, localizar)) {
            result = srcString.indexOf(localizar) != -1;
        }
        return result;
    }

    public static boolean isNoTamanho(String string, int tamanho) {
        boolean res = false;
        if (!UtilString.isVazio(string)) {
            res = string.length() == tamanho;
        }
        return res;
    }

    public static String repetir(String string, int quantidade) {
        StringBuffer result = new StringBuffer();
        if (!UtilString.isVazio(string)) {
            while (quantidade > 0) {
                result.append(string);
                --quantidade;
            }
        }
        return result.toString();
    }

    public static String completarAEsquerda(String srcString, String novaString, int tamanho) {
        StringBuffer result = UtilString.novoStringBuffer(srcString);
        if (UtilObjeto.isReferencia(novaString)) {
            result.insert(0, UtilString.repetir(novaString, tamanho -= result.length()));
        }
        return result.toString();
    }

    public static String completarADireita(String srcString, String novaString, int tamanho) {
        StringBuffer result = UtilString.novoStringBuffer(srcString);
        if (UtilObjeto.isReferencia(novaString)) {
            result.insert(result.length(), UtilString.repetir(novaString, tamanho -= result.length()));
        }
        return result.toString();
    }

    public static String removerCaracteres(String string) {
        if (!UtilString.isVazio(string)) {
            string = UtilString.remover(string, UtilPatternsDeString.getPattern());
        }
        return string;
    }

    public static String removerAcentuacao(String string) {
        if (!UtilString.isVazio(string)) {
            string = UtilString.substituirString(string, "[\u00c1\u00c0\u00c2\u00c3]", "A");
            string = UtilString.substituirString(string, "[\u00e1\u00e0\u00e2\u00e3\u00aa]", "a");
            string = UtilString.substituirString(string, "[\u00c9\u00c8\u00ca]", "E");
            string = UtilString.substituirString(string, "[\u00e9\u00e8\u00ea]", "e");
            string = UtilString.substituirString(string, "[\u00cd\u00cc\u00ce\u00cf]", "I");
            string = UtilString.substituirString(string, "[\u00ed\u00ec\u00ee\u00ef]", "i");
            string = UtilString.substituirString(string, "[\u00d3\u00d2\u00d4\u00d5\u00d6]", "O");
            string = UtilString.substituirString(string, "[\u00f3\u00f2\u00f4\u00f5\u00ba\u00f6]", "o");
            string = UtilString.substituirString(string, "[\u00da\u00d9\u00db\u00dc]", "U");
            string = UtilString.substituirString(string, "[\u00fa\u00f9\u00fb\u00fc]", "u");
            string = UtilString.substituirString(string, "[\u00c7]", "C");
            string = UtilString.substituirString(string, "[\u00e7]", "c");
            string = UtilString.substituirString(string, "[~\\d^\u00b4`]", "");
            string = UtilString.substituirString(string, "[\\d\u00a8]", "");
        }
        return string;
    }

    public static String removerNumeros(String string) {
        if (!UtilString.isVazio(string)) {
            string = UtilString.remover(string, UtilPatternsDeNumero.getInteger());
        }
        return string;
    }

    public static String removerSufixo(String srcString, String sufixo) {
        if (!UtilString.isVazio(srcString, sufixo) && srcString.endsWith(sufixo)) {
            int tamanho = srcString.length() - sufixo.length();
            srcString = UtilString.substring(srcString, 0, tamanho);
        }
        return srcString;
    }

    public static String removerPrefixo(String srcString, String prefixo) {
        if (!UtilString.isVazio(srcString, prefixo)) {
            while (srcString.startsWith(prefixo)) {
                srcString = UtilString.substring(srcString, 1);
            }
        }
        return srcString;
    }

    public static String trim(String string) {
        if (UtilObjeto.isReferencia(string)) {
            string = string.trim();
        }
        return string;
    }

    public static String substring(String string, int inicio) {
        if (!UtilString.isVazio(string) && string.length() > inicio) {
            string = string.substring(inicio);
        }
        return string;
    }

    public static String substring(String string, int inicio, int fim) {
        if (!UtilString.isVazio(string) && string.length() > inicio) {
            if (fim < inicio) {
                fim = inicio;
            }
            if (fim > string.length()) {
                fim = string.length();
            }
            string = string.substring(inicio, fim);
        }
        return string;
    }

    public static String getNomeMetodo(String prefix, String atributo) {
        StringBuffer nome = new StringBuffer();
        if (!UtilString.isVazio(prefix, atributo) && atributo.length() > 1) {
            nome.append(prefix);
            nome.append(atributo.substring(0, 1).toUpperCase());
            nome.append(atributo.substring(1));
        }
        return nome.toString();
    }

    public static String getNomeDoAtributo(String nomeDoMetodo) {
        StringBuffer atributo = new StringBuffer();
        if (!UtilString.isVazio(nomeDoMetodo)) {
            String get = Constante.getPrefixoMetodoGet();
            String set = Constante.getPrefixoMetodoSet();
            String is = Constante.getPrefixoMetodoIs();
            int inicio = 0;
            if (nomeDoMetodo.startsWith(get) || nomeDoMetodo.startsWith(set)) {
                inicio = 3;
            }
            if (nomeDoMetodo.startsWith(is)) {
                inicio = 2;
            }
            atributo.append(nomeDoMetodo);
            atributo.delete(0, inicio);
            atributo.replace(0, 1, UtilString.minuscula(atributo.charAt(0)));
        }
        return atributo.toString();
    }

    public static int getQuantidadeDeCaracteres(String string, char caracter) {
        int quantidade = 0;
        if (!UtilString.isVazio(string)) {
            for (int indice = 0; indice < string.length(); ++indice) {
                if (string.charAt(indice) != caracter) continue;
                ++quantidade;
            }
        }
        return quantidade;
    }

    public static String getString(Object objeto) {
        String resultado = null;
        if (UtilObjeto.isReferencia(objeto)) {
            resultado = objeto.toString();
        }
        return resultado;
    }

    public static byte[] getBytes(String string) {
        byte[] bytes = null;
        if (!UtilString.isVazio(string)) {
            bytes = string.getBytes();
        }
        return bytes;
    }

    public static Reader getReader(String string) {
        StringReader reader = null;
        if (!UtilString.isVazio(string)) {
            reader = new StringReader(string);
        }
        return reader;
    }

    public static boolean isSomenteLetras(String string) {
        boolean res = false;
        if (!UtilString.isVazio(string)) {
            String p = UtilPatternsDeString.getStringEmTodosOsCaracteres();
            res = Pattern.matches(p, string);
        }
        return res;
    }

    public static int getTamanho(String string) {
        int tamanho = 0;
        if (!UtilString.isVazio(string)) {
            tamanho = string.length();
        }
        return tamanho;
    }

    public static boolean isStringsIguais(String string0, String string1) {
        boolean resultado = false;
        if (!UtilString.isVazio(string0, string1)) {
            resultado = string0.equals(string1);
        }
        return resultado;
    }

    private static StringBuffer novoStringBuffer(String srcString) {
        StringBuffer buffer = new StringBuffer();
        if (!UtilString.isVazio(srcString)) {
            buffer.append(srcString);
        }
        return buffer;
    }

    private static ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }
}

