/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.generico.validador;

import br.com.politec.generico.string.UtilString;
import br.com.politec.generico.validador.UtilValidadorAbstrato;

public final class UtilValidadorDeCPF
extends UtilValidadorAbstrato {
    private UtilValidadorDeCPF() {
    }

    public static boolean validar(String cpf) {
        boolean resultado = false;
        if (!UtilValidadorDeCPF.isNumeroDeCPFNullOuPadrao(cpf = UtilString.removerCaracteres(cpf)) && cpf.length() == 11) {
            int i;
            cpf = cpf.trim();
            int posicaoTemp = 0;
            for (i = 0; i < 9; ++i) {
                posicaoTemp += (10 - i) * (cpf.charAt(i) - 48);
            }
            if ((posicaoTemp = 11 - posicaoTemp % 11) > 9) {
                posicaoTemp = 0;
            }
            if (posicaoTemp == cpf.charAt(9) - 48) {
                posicaoTemp = 0;
                for (i = 0; i < 10; ++i) {
                    posicaoTemp += (11 - i) * (cpf.charAt(i) - 48);
                }
                if ((posicaoTemp = 11 - posicaoTemp % 11) > 9) {
                    posicaoTemp = 0;
                }
                if (posicaoTemp == cpf.charAt(10) - 48) {
                    resultado = true;
                }
            }
        }
        return resultado;
    }

    private static boolean isNumeroDeCPFNullOuPadrao(String numeroDoCPF) {
        String numero = UtilString.removerCaracteres(numeroDoCPF);
        return numero == null || numero.equals("00000000000") || numero.equals("11111111111") || numero.equals("22222222222") || numero.equals("33333333333") || numero.equals("44444444444") || numero.equals("55555555555") || numero.equals("66666666666") || numero.equals("77777777777") || numero.equals("88888888888") || numero.equals("99999999999");
    }
}

