/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.gerarremessa.form;

import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioGerarRemessaDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.politec.generico.comparador.UtilComparadorDeDataMaior;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GerarRemessaForm
extends PluginFormAbstrato {
    private static final String MENSAGEM_VALIDACAO_DATA_LANCAMENTO = "N\u00e3o \u00e9 possivel gerar Remessa";
    private RemessaTODecorator remessaTODecorator;
    List<RecebimentoDebitoTO> colecaoRecebimento;
    List<RelatorioGerarRemessaDecorator> colecaoRelatorioGerarRemessaDecorator;
    private int qtidadeRec;
    private int qtidadeExcAlt;
    private int qtidadeTotal;
    private String totalRec;
    private boolean validaDataLancamento = false;

    public int getQtidadeRec() {
        return this.qtidadeRec;
    }

    public void setQtidadeRec(int qtidadeRec) {
        this.qtidadeRec = qtidadeRec;
    }

    public int getQtidadeExcAlt() {
        return this.qtidadeExcAlt;
    }

    public void setQtidadeExcAlt(int qtidadeExcAlt) {
        this.qtidadeExcAlt = qtidadeExcAlt;
    }

    public int getQtidadeTotal() {
        return this.qtidadeTotal;
    }

    public void setQtidadeTotal(int qtidadeTotal) {
        this.qtidadeTotal = qtidadeTotal;
    }

    public String getTotalRec() {
        return this.totalRec;
    }

    public void setTotalRec(String totalRec) {
        this.totalRec = totalRec;
    }

    public IdentificadorClienteDebitoTODecorator getIdentificadorClienteDebitoTODecorator() {
        return this.getRemessaTODecorator().getIdentificadorClienteDebitoTODecorator();
    }

    public void setIdentificadorClienteDebitoTODecorator(IdentificadorClienteDebitoTODecorator identificadorClienteDebitoTODecorator) {
        this.getRemessaTODecorator().setIdentificadorClienteDebitoTODecorator(identificadorClienteDebitoTODecorator);
    }

    public List<RecebimentoDebitoTO> getColecaoRecebimento() {
        if (this.colecaoRecebimento == null) {
            this.colecaoRecebimento = new ArrayList<RecebimentoDebitoTO>();
        }
        return this.colecaoRecebimento;
    }

    public void setColecaoRecebimento(List<RecebimentoDebitoTO> colecaoRecebimento) {
        this.colecaoRecebimento = colecaoRecebimento;
    }

    public ConvenioTO getConvenioTO() {
        if (!this.isReferencia(this.getRemessaTODecorator().getConvenioTO().getId().getNumeroConvenio())) {
            return null;
        }
        return this.getRemessaTODecorator().getConvenioTO();
    }

    public void setConvenioTO(ConvenioTO convenioTO) {
        this.getRemessaTODecorator().setConvenioTO(convenioTO);
    }

    public RemessaTODecorator getRemessaTODecorator() {
        if (this.remessaTODecorator == null) {
            this.remessaTODecorator = this.getTOFactory().novoRemessaTODecorator();
        }
        return this.remessaTODecorator;
    }

    public void setRemessaTODecorator(RemessaTODecorator remessaTODecorator) {
        this.remessaTODecorator = remessaTODecorator;
    }

    public List<RelatorioGerarRemessaDecorator> getColecaoRelatorioGerarRemessaDecorator() {
        if (this.colecaoRelatorioGerarRemessaDecorator == null) {
            this.colecaoRelatorioGerarRemessaDecorator = new ArrayList<RelatorioGerarRemessaDecorator>();
        }
        return this.colecaoRelatorioGerarRemessaDecorator;
    }

    public void setColecaoRelatorioGerarRemessaDecorator(List<RelatorioGerarRemessaDecorator> colecaoRelatorioGerarRemessaDecorator) {
        this.colecaoRelatorioGerarRemessaDecorator = colecaoRelatorioGerarRemessaDecorator;
    }

    protected void doCarregarValidadores() {
        this.adicionarValidadorDeObrigatoriedadeParaObjeto("convenioTO", "Conv\u00eanio");
        if (this.isValidaDataLancamento()) {
            for (RecebimentoDebitoTO recebimentoDebitoTO : this.getListaRecebimentoDebitoTO()) {
                String msg = this.validaDataLancamento(recebimentoDebitoTO.getDataRecebimento(), "Data Lancamento");
                if (msg.trim().length() <= 1) continue;
                this.adicionarValidador("DataLancamento", msg);
                return;
            }
        }
    }

    public boolean isValidaDataLancamento() {
        return this.validaDataLancamento;
    }

    public void setValidaDataLancamento(boolean validaDataLancamento) {
        this.validaDataLancamento = validaDataLancamento;
    }

    private String validaDataLancamento(Object valor, String string) {
        StringBuilder mensagem = new StringBuilder("");
        if (valor == null) {
            mensagem.append(MENSAGEM_VALIDACAO_DATA_LANCAMENTO);
            mensagem.append(" com a Data de Lan\u00e7amento n\u00e3o informada.");
        } else {
            Date data = (Date)valor;
            Calendar calendAtual = Calendar.getInstance();
            calendAtual.add(5, -1);
            Date dataFim = calendAtual.getTime();
            if (this.isReferencia(data)) {
                if (UtilComparadorDeDataMaior.comparar((Date)data, (Date)dataFim) == dataFim) {
                    mensagem.append(MENSAGEM_VALIDACAO_DATA_LANCAMENTO);
                    mensagem.append(" com a Data de Lan\u00e7amento Menor que a Data Atual.");
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(data);
                    switch (cal.get(7)) {
                        case 1: 
                        case 7: {
                            mensagem.append(MENSAGEM_VALIDACAO_DATA_LANCAMENTO);
                            mensagem.append(" com a Data de Lan\u00e7amento em dia n\u00e3o \u00fatil.");
                        }
                    }
                }
            } else {
                mensagem.append(MENSAGEM_VALIDACAO_DATA_LANCAMENTO);
                mensagem.append(" com a Data de Lan\u00e7amento n\u00e3o informada.");
            }
        }
        return mensagem.toString();
    }

    public Collection<RecebimentoDebitoTO> getListaRecebimentoDebitoTO() {
        return this.getRemessaTODecorator().getListaRecebimentoDebitoTO();
    }

    public void setListaRecebimentoDebitoTO(Collection<RecebimentoDebitoTO> listaRecebimentoDebitoTO) {
        this.getRemessaTODecorator().setListaRecebimentoDebitoTO(listaRecebimentoDebitoTO);
    }

    public UtilNotificador getNotificaProcessarRemessa() {
        return this.getRemessaTODecorator().getNotificaProcessarRemessa();
    }

    public void setNotificaProcessarRemessa(UtilNotificador notificaProcessarRemessa) {
        this.getRemessaTODecorator().setNotificaProcessarRemessa(notificaProcessarRemessa);
    }
}

