/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.incluirrecebimentoapartirremessaanterior.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.incluirrecebimentoapartirremessaanterior.action.ConsultarRemessasAction;
import br.com.bb.plugins.dbt.apresentacao.incluirrecebimentoapartirremessaanterior.action.IncluirRecebimentoApartirRemessaAction;
import br.com.bb.plugins.dbt.apresentacao.incluirrecebimentoapartirremessaanterior.action.RecalcularRemessasAction;
import br.com.bb.plugins.dbt.apresentacao.incluirrecebimentoapartirremessaanterior.action.RetirarRemessaAction;
import br.com.bb.plugins.dbt.apresentacao.incluirrecebimentoapartirremessaanterior.form.ApartirDaRemessaAnteriorForm;
import br.com.bb.plugins.dbt.factory.DBTFacadeFactory;
import br.com.bb.plugins.dbt.negocio.facade.ManterRecebimentoFacade;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjIncluirRecebimentosApartirRemessaAnterior;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxConvenioLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJDateChooserLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabelMonetario;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskTextField;
import br.com.bb.plugins.gac.util.swing.componente.BBJPanelInformacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButtonLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeDouble;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.generico.numerico.UtilNumero;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewIncluirRecebimentosApartirRemessaAnterior
extends DBTBasicInternalFrame {
    private BBJComboBoxConvenioLabel<ConvenioTO> comboConvenio;
    private BBJComboBoxLabel<RemessaTODecorator> comboRemessa;
    private BBJRadioButtonLabel radioDiasMes;
    private BBJRadioButtonLabel radioRsPercent;
    private BBJMaskTextField txtAdicionarDatas;
    private BBJDateChooserLabel txtFixarEmDatas;
    private BBJMaskLabelMonetario txtAdicionarValor;
    private BBJMaskLabelMonetario txtFixarEmValor;
    private Map<String, BBJRadioButton> opcoesRadioAdicionarFixarValores;
    private Map<String, BBJRadioButton> opcoesRadioDiasMensagem;
    private Map<String, BBJRadioButton> opcoesRadioRsPercent;
    private JPanel panelCombo;
    private JPanel panelPrincipal;
    private JPanel panelTabela;
    private JPanel panelAlterarDatas;
    private JPanel panelAlteraValores;
    private JPanel panelAlteracoes;
    private JPanel panelLabels;
    private JPanel panelBotoes;
    private JPanel panelInfo = null;
    private JPanel panelDica = null;
    private JPanel panelTextos;
    private JPanel panelTextosMonetarios;
    private JPanel panelTextoData;
    private BBJButton botaoRetirar;
    private BBJButton botaoRecalcularRecebimentos;
    private BBJButton botaoConfirmar;
    private BBJButton botaoVoltar;
    private JLabel labelDica;
    private BBJEstilos estiloLabel = BBJEstilos.LABELTEXTO;
    private BBJEstilos estiloLabelDica = BBJEstilos.TEXTODICA;
    private BBJPanelInformacao panelQuantidade = null;
    private BBJPanelInformacao panelValorTotal = null;
    private BBJRadioButton radioAdicionarData;
    private BBJRadioButton radioFixarData;
    private BBJRadioButton radioAdicionarValor;
    private BBJRadioButton radioFixarValor;
    private ButtonGroup adicionarFixarData = null;
    private ButtonGroup adicionarFixarValor = null;
    private final String selecioneRemessa = "Selecione";
    private final String[] columnNames = new String[]{"Nome", "Identifica\u00e7\u00e3o P/D\u00e9bito", "Ag\u00eancia", "Conta", "Data", "Valor"};
    private final int[] columnSizes = new int[]{250, 240, 70, 120, 80, 200};
    private final int[] columnAligment;
    private BBJTableScrollPane<IObjIncluirRecebimentosApartirRemessaAnterior> table;
    private JCheckBox checkBoxData;
    private JCheckBox checkBoxValor;
    private ManterRecebimentoFacade facade;

    public ManterRecebimentoFacade getFacade() {
        return this.facade;
    }

    public ViewIncluirRecebimentosApartirRemessaAnterior() {
        super("Incluir Lan\u00e7amentos por Arquivo Remessa", false, false);
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[1] = 4;
        nArray[3] = 4;
        nArray[5] = 4;
        this.columnAligment = nArray;
        this.checkBoxData = new JCheckBox("", false);
        this.checkBoxValor = new JCheckBox("", false);
        this.facade = DBTFacadeFactory.getInstancia().novoManterRecebimentoFacade();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.getPanelPrincipal(), "North");
        this.add(this.getPnlBotoes(), "Center");
        this.adicionarFixarData = new ButtonGroup();
        this.adicionarFixarData.add((AbstractButton)this.radioAdicionarData);
        this.adicionarFixarData.add((AbstractButton)this.radioFixarData);
        this.radioAdicionarData.addActionListener(this.getListenerRadiosFixarDatas());
        this.radioFixarData.addActionListener(this.getListenerRadiosFixarDatas());
        this.adicionarFixarValor = new ButtonGroup();
        this.adicionarFixarValor.add((AbstractButton)this.radioAdicionarValor);
        this.adicionarFixarValor.add((AbstractButton)this.radioFixarValor);
        this.radioAdicionarValor.addActionListener(this.getListenerRadiosFixarValores());
        this.radioFixarValor.addActionListener(this.getListenerRadiosFixarValores());
        this.checkBoxData.setName("calcularData");
        this.checkBoxValor.setName("calcularValor");
    }

    private ActionListener getListenerRadiosFixarValores() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof BBJRadioButton) {
                    BBJRadioButton objRadio = (BBJRadioButton)obj;
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.habilitarRadiosValores(objRadio);
                }
            }
        };
    }

    private ActionListener getListenerRadiosFixarDatas() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof BBJRadioButton) {
                    BBJRadioButton objRadio = (BBJRadioButton)obj;
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.habilitarRadiosDatas(objRadio);
                }
            }
        };
    }

    public void doShow(Map context) {
        this.getComboConvenio().getComboBoxConvenio().carregarComFiltro(false);
        this.carregarGrupos();
        this.txtAdicionarDatas.setText("");
        this.getTxtData().limpar();
        this.getRadioDiasMes().setSelected(1);
        this.getRadioRsPercent().setSelected(1);
        this.getPanelQuantidade().setValor("0");
        this.getPanelValorTotal().setValor(" R$ 0,00");
        this.zerarTabela();
        this.zerarCamposCalcular();
        this.setVisible(true);
    }

    private void zerarCamposCalcular() {
        this.checkBoxData.setSelected(false);
        this.checkBoxValor.setSelected(false);
        this.getPanelAlterarDatas().repaint();
        this.getPanelAlteraValores().repaint();
        this.habilitarComponentesData(this.checkBoxData.isSelected());
        this.habilitarComponentesValores(this.checkBoxValor.isSelected());
        this.getRadioAdicionarData().setSelected(true);
        this.getRadioAdicionarValor().setSelected(true);
        this.habilitarRadiosDatas(null);
        this.habilitarRadiosValores(null);
        this.txtAdicionarValor.setText("");
        this.txtFixarEmValor.setText("");
        this.txtAdicionarDatas.setText("");
        this.txtFixarEmDatas.setText(null);
    }

    private void zerarTabela() {
        ArrayList dados = new ArrayList();
        this.getTable().setDataListTabela(dados);
        this.getBotaoRetirar().setEnabled(false);
        this.getBtnConfirmar().setEnabled(false);
        this.verificarRecalcular();
    }

    public void doClose(Map context) {
        this.setVisible(false);
        super.doClose(context);
    }

    public BBJComboBoxConvenioLabel<ConvenioTO> getComboConvenio() {
        if (this.comboConvenio == null) {
            this.comboConvenio = new BBJComboBoxConvenioLabel("Conv\u00eanio:", false, 0, 630, 70);
            this.comboConvenio.setToolTipText(this.getMensagem("MH049"));
            this.comboConvenio.getComboBoxConvenio().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.carregarGrupos();
                }
            });
        }
        return this.comboConvenio;
    }

    private void carregarGrupos() {
        this.getComboRemessa().getComboBox().removeAllItems();
        this.zerarTabela();
        if (this.comboConvenio.getSelectedItem() != null) {
            this.comboConvenio.setEnabled(true);
            this.pesquisarRemessa();
            this.preencherComboRemessa();
        }
    }

    protected void pesquisarRemessa() {
        this.getApartirDaRemessaAnteriorForm().setConvenioTO(this.getComboConvenio().getSelectedItem());
        ConsultarRemessasAction action = this.getDBTActionFactory().novoConsultarRemessasAction();
        action.executar(this.getApartirDaRemessaAnteriorForm());
    }

    private void preencherComboRemessa() {
        this.getComboRemessa().getComboBox().setModel((ComboBoxModel)this.getDefaultComboBoxModel(this.getApartirDaRemessaAnteriorForm().getListaRemessa()));
    }

    private ApartirDaRemessaAnteriorForm getApartirDaRemessaAnteriorForm() {
        return (ApartirDaRemessaAnteriorForm)this.getForm();
    }

    protected PluginFormAbstrato novoForm() {
        ApartirDaRemessaAnteriorForm form = this.getDBTFormFactory().novoApartirDaRemessaAnteriorForm();
        return form;
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<RemessaTODecorator> listaConvenente) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(listaConvenente);
        this.inserirElementoVazio(defaultComboBoxModel);
        defaultComboBoxModel.setSelectedItem("Selecione");
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<RemessaTODecorator> listaConvenente) {
        return new DefaultComboBoxModel<Object>(listaConvenente.toArray());
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.insertElementAt("Selecione", 0);
    }

    public BBJComboBoxLabel<RemessaTODecorator> getComboRemessa() {
        if (this.comboRemessa == null) {
            this.comboRemessa = new BBJComboBoxLabel("Remessa:", false, 0, 630, 70);
            this.comboRemessa.getComboBox().setName("remessaTODecorator");
            this.comboRemessa.setToolTipText(this.getMensagem("MH104"));
            this.comboRemessa.getComboBox().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!ViewIncluirRecebimentosApartirRemessaAnterior.this.isReferencia(ViewIncluirRecebimentosApartirRemessaAnterior.this.comboRemessa.getSelectedItem())) {
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.comboRemessa.setSelectedItem(null);
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.zerarTabela();
                    } else if (ViewIncluirRecebimentosApartirRemessaAnterior.this.comboRemessa.getSelectedItem() instanceof RemessaTODecorator) {
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.carregarLancamentosNoForm((RemessaTODecorator)ViewIncluirRecebimentosApartirRemessaAnterior.this.comboRemessa.getSelectedItem());
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.preenchaTabela();
                    } else {
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.zerarTabela();
                    }
                }
            });
        }
        return this.comboRemessa;
    }

    protected void carregarLancamentosNoForm(RemessaTODecorator remessaTODecorator) {
        this.getApartirDaRemessaAnteriorForm().setRecebimentosTO(remessaTODecorator.getRemessaTO().getRecebimentoDebitoTOs());
    }

    private void preenchaTabela() {
        Set<RecebimentoDebitoTO> colecaoPessoaTO = this.getApartirDaRemessaAnteriorForm().getRecebimentosTO();
        ArrayList<IObjIncluirRecebimentosApartirRemessaAnterior> dados = new ArrayList<IObjIncluirRecebimentosApartirRemessaAnterior>();
        if (!UtilColecao.isVazio(colecaoPessoaTO)) {
            ArrayList<RecebimentoDebitoTO> lista = new ArrayList<RecebimentoDebitoTO>();
            for (RecebimentoDebitoTO recebimentoDebitoTO : colecaoPessoaTO) {
                lista.add(recebimentoDebitoTO);
            }
            Collections.sort(lista, new Comparator<RecebimentoDebitoTO>(){

                @Override
                public int compare(RecebimentoDebitoTO o1, RecebimentoDebitoTO o2) {
                    return o1.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome().compareTo(o2.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome());
                }
            });
            for (RecebimentoDebitoTO debitoTO : lista) {
                dados.add(new IObjIncluirRecebimentosApartirRemessaAnterior(debitoTO));
            }
            int i = 0;
            while (i < dados.size()) {
                IdentificacaoTO identificacaoTO = this.getFacade().getManterRecebimentoModel().getPessoaDAO().consultarIdPessoaTOCodigo(((RecebimentoDebitoTO)lista.get(i)).getIdentificadorClienteDebitoTO().getPessoaTO().getCodigoPessoa().intValue());
                ConvenioDebitoTO convenioDebitoTO = this.getFacade().getManterRecebimentoModel().getConvenioDebitoDAO().buscarVersaoLayout(((RecebimentoDebitoTO)lista.get(i)).getConvenioDebitoTO().getConvenioTO().getNumeroConvenio());
                if (convenioDebitoTO.getNumeroLayout() != null && convenioDebitoTO.getNumeroLayout() != 4 && convenioDebitoTO.getNumeroLayout() != null && convenioDebitoTO.getNumeroLayout() == 5 && (identificacaoTO == null || identificacaoTO.getId().getTextoIdentificacao().trim().equalsIgnoreCase(""))) {
                    BBJPopupMensagem.exibirMensagem((String)"Aten\u00e7\u00e3o! O(s) cliente(s) contido(s) na Remessa selecionada deve(m) possuir uma inscri\u00e7\u00e3o CPF/CNPJ que ser\u00e1 conferida no processamento. A inclus\u00e3o de lan\u00e7amento ser\u00e1 cancelada. Para cadastrar selecione o cliente e pressione o bot\u00e3o \"Editar\".");
                    this.zerarTabela();
                    this.doShow(null);
                    return;
                }
                ++i;
            }
            this.getApartirDaRemessaAnteriorForm().setRecebimentosDebitoTO(new HashSet<RecebimentoDebitoTO>(lista));
        }
        this.getTable().setDataListTabela(dados);
        this.getApartirDaRemessaAnteriorForm().setView(this);
        this.atualizaPanelValores();
        this.verificarRecalcular();
    }

    private void atualizaPanelValores() {
        this.getPanelQuantidade().setValor(" " + this.getTable().getItensSelecionados().size());
        this.getPanelValorTotal().setValor(" R$ " + UtilFormatadorDeReal.formatar((double)this.atualizaValorRemessa(), (int)2));
    }

    private float atualizaValorRemessa() {
        float valorRemessa = 0.0f;
        for (IObjIncluirRecebimentosApartirRemessaAnterior dados : this.getTable().getItensSelecionados()) {
            valorRemessa += dados.getRecebimentoDebitoTO().getValorRecebimento().floatValue();
        }
        return valorRemessa;
    }

    private void atualizaTabela() {
        this.getTable().getDataListTabela().removeAll(this.getTable().getItensSelecionados());
        this.atualizaTabelaDoForm();
        this.getTable().getBbtModel().marcaTodos(false);
    }

    private void atualizaTabelaDoForm() {
        this.getApartirDaRemessaAnteriorForm().getRecebimentosDebitoTO().clear();
        if (!UtilColecao.isVazio((Collection)this.getTable().getDataListTabela())) {
            for (IObjIncluirRecebimentosApartirRemessaAnterior dados : this.getTable().getDataListTabela()) {
                this.getApartirDaRemessaAnteriorForm().getRecebimentosDebitoTO().add(dados.getRecebimentoDebitoTO());
            }
        }
        this.atualizaPanelValores();
        this.verificarRecalcular();
        this.getTable().fireTableDataChanged();
        this.getApartirDaRemessaAnteriorForm().setView(this);
    }

    private void verificarRecalcular() {
        boolean recalcular;
        List dados = this.getTable().getDataListTabela();
        boolean bl = recalcular = dados != null && dados.size() > 0;
        if (recalcular) {
            recalcular = this.checkBoxData.isSelected() || this.checkBoxValor.isSelected();
        }
        this.botaoRecalcularRecebimentos.setEnabled(recalcular);
    }

    public BBJRadioButtonLabel getRadioDiasMes() {
        if (this.radioDiasMes == null) {
            this.radioDiasMes = new BBJRadioButtonLabel("", 0, this.getOpcoesRadioDiasMensagem(), 0, 1);
            this.radioDiasMes.setPreferredSize(new Dimension(80, 30));
            this.radioDiasMes.setName("diaOuMes");
            this.radioDiasMes.setEnabled(false);
        }
        return this.radioDiasMes;
    }

    public BBJRadioButtonLabel getRadioRsPercent() {
        if (this.radioRsPercent == null) {
            this.radioRsPercent = new BBJRadioButtonLabel("", 0, this.getOpcoesRadioRsPercent(), 0, 1);
            this.radioRsPercent.setPreferredSize(new Dimension(40, 30));
            this.radioRsPercent.setName("valorOuPorcentagem");
            this.radioRsPercent.setEnabled(false);
        }
        return this.radioRsPercent;
    }

    public Map<String, BBJRadioButton> getOpcoesRadioDiasMensagem() {
        if (this.opcoesRadioDiasMensagem == null) {
            this.opcoesRadioDiasMensagem = new TreeMap<String, BBJRadioButton>();
            BBJRadioButton radioDias = new BBJRadioButton("Dia(s)", true, 1);
            BBJRadioButton radioMeses = new BBJRadioButton("M\u00eas(es)", false, 2);
            radioDias.setToolTipText(this.getMensagem("MH107"));
            radioMeses.setToolTipText(this.getMensagem("MH108"));
            this.opcoesRadioDiasMensagem.put("0", radioDias);
            this.opcoesRadioDiasMensagem.put("1", radioMeses);
        }
        return this.opcoesRadioDiasMensagem;
    }

    public Map<String, BBJRadioButton> getOpcoesRadioRsPercent() {
        if (this.opcoesRadioRsPercent == null) {
            this.opcoesRadioRsPercent = new TreeMap<String, BBJRadioButton>();
            BBJRadioButton radioReal = new BBJRadioButton("R$", true, 1);
            BBJRadioButton radioPerc = new BBJRadioButton("%", false, 2);
            radioReal.setToolTipText(this.getMensagem("MH111"));
            radioPerc.setToolTipText(this.getMensagem("MH112"));
            this.opcoesRadioRsPercent.put("0", radioReal);
            this.opcoesRadioRsPercent.put("1", radioPerc);
        }
        return this.opcoesRadioRsPercent;
    }

    protected BBJDateChooserLabel getTxtData() {
        if (this.txtFixarEmDatas == null) {
            this.txtFixarEmDatas = new BBJDateChooserLabel("", true, 0, 20, 0);
            this.txtFixarEmDatas.getCampoData().setDate(Calendar.getInstance().getTime());
            this.txtFixarEmDatas.setName("dataFixa");
            this.txtFixarEmDatas.setToolTipText(this.getMensagem("MH100"));
            this.txtFixarEmDatas.setEnabled(false);
        }
        return this.txtFixarEmDatas;
    }

    public void preExecucaoIncluirRecebimentoApartirRemessaAction() {
        this.getApartirDaRemessaAnteriorForm().getRecebimentosDebitoTO().clear();
        if (!UtilColecao.isVazio((Collection)this.getTable().getItensSelecionados())) {
            for (IObjIncluirRecebimentosApartirRemessaAnterior dados : this.getTable().getItensSelecionados()) {
                this.getApartirDaRemessaAnteriorForm().getRecebimentosDebitoTO().add(dados.getRecebimentoDebitoTO());
            }
        }
    }

    public BBJButton getBtnConfirmar() {
        if (this.botaoConfirmar == null) {
            IncluirRecebimentoApartirRemessaAction acao = new IncluirRecebimentoApartirRemessaAction();
            this.botaoConfirmar = this.getBotaoFactory().novoConfirmar((PluginActionAbstrato)acao);
            this.botaoConfirmar.setPreferredSize(new Dimension(90, 17));
        }
        return this.botaoConfirmar;
    }

    public void posExecucaoIncluirRecebimentoApartirRemessaAction() {
        this.zerarCamposCalcular();
        BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP053"));
        this.getComboRemessa().getComboBox().getModel().setSelectedItem("Selecione");
        this.getPanelQuantidade().setValor("0");
        this.getPanelValorTotal().setValor(" R$ 0,00");
        this.getComboConvenio().requestFocus();
    }

    public BBJButton getBtnRecalcularRecebimentos() {
        if (this.botaoRecalcularRecebimentos == null) {
            RecalcularRemessasAction acao = new RecalcularRemessasAction();
            this.botaoRecalcularRecebimentos = this.getBotaoFactory().novoBotao("RECALCULAR", (PluginActionAbstrato)acao);
            this.botaoRecalcularRecebimentos.setPreferredSize(new Dimension(90, 17));
            this.botaoRecalcularRecebimentos.setEnabled(false);
        }
        return this.botaoRecalcularRecebimentos;
    }

    public void posExecucaoRecalcularRemessasAction() {
        this.atualizaTabelaDoForm();
    }

    public BBJButton getBotaoRetirar() {
        if (this.botaoRetirar == null) {
            RetirarRemessaAction acao = this.getDBTActionFactory().novoRetirarRemessaAction();
            this.botaoRetirar = this.getBotaoFactory().novoBotao("RETIRAR", (PluginActionAbstrato)acao);
            this.botaoRetirar.setPreferredSize(new Dimension(90, 17));
            this.botaoRetirar.setEnabled(false);
        }
        return this.botaoRetirar;
    }

    public void posExecucaoRetirarRemessaAction() {
        this.atualizaTabela();
    }

    public JButton getBtnVoltar() {
        if (this.botaoVoltar == null) {
            this.botaoVoltar = new BBJButton("VOLTAR");
            this.botaoVoltar.setPreferredSize(new Dimension(90, 17));
            ActionListener bntListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.doClose(null);
                }
            };
            this.botaoVoltar.addActionListener(bntListener);
        }
        return this.botaoVoltar;
    }

    public JLabel getLabelDica() {
        if (this.labelDica == null) {
            this.labelDica = new JLabel("Para alterar recebimentos utilize a op\u00e7\u00e3o: Consultar / Lan\u00e7amentos");
            this.labelDica.setFont(this.estiloLabelDica.getFont());
        }
        return this.labelDica;
    }

    public JPanel getPanelAlterarDatas() {
        if (this.panelAlterarDatas == null) {
            this.panelAlterarDatas = new JPanel();
            this.panelAlterarDatas.setLayout(new GridBagLayout());
            this.panelAlterarDatas.setOpaque(false);
            this.panelAlterarDatas.setBorder(BBJBordaOval.createCheckBoxOvalBorder((String)"Alterar Datas", (JComponent)this.panelAlterarDatas, (JCheckBox)this.checkBoxData));
            this.checkBoxData.addActionListener(this.getActionListenerDatas());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.weightx = 0.9;
            gc.gridx = 0;
            gc.gridy = 0;
            this.panelAlterarDatas.add((Component)this.getRadioAdicionarData(), gc);
            ++gc.gridx;
            this.panelAlterarDatas.add((Component)this.getTxtAdicionarDatas(), gc);
            ++gc.gridx;
            this.panelAlterarDatas.add((Component)this.getRadioDiasMes(), gc);
            ++gc.gridy;
            gc.gridx = 0;
            this.panelAlterarDatas.add((Component)this.getRadioFixarData(), gc);
            ++gc.gridx;
            this.panelAlterarDatas.add((Component)this.getTxtData(), gc);
            ++gc.gridx;
        }
        return this.panelAlterarDatas;
    }

    private ActionListener getActionListenerDatas() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof JCheckBox) {
                    JCheckBox checkBox = (JCheckBox)obj;
                    boolean enable = checkBox.isSelected();
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.habilitarComponentesData(enable);
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.verificarRecalcular();
                }
            }
        };
    }

    protected void habilitarComponentesData(boolean enabled) {
        if (enabled) {
            this.habilitarRadiosDatas(this.radioAdicionarData.isSelected() ? this.radioAdicionarData : this.radioFixarData);
        } else {
            this.getTxtData().setText(null);
            this.getTxtAdicionarDatas().setText("");
            this.getRadioDiasMes().setSelected(1);
            this.habilitarRadiosDatas(null);
        }
        this.getRadioAdicionarData().setEnabled(enabled);
        this.getRadioFixarData().setEnabled(enabled);
    }

    public BBJMaskTextField getTxtAdicionarDatas() {
        if (this.txtAdicionarDatas == null) {
            this.txtAdicionarDatas = new BBJMaskTextField("######");
            this.txtAdicionarDatas.setPreferredSize(new Dimension(90, 19));
            this.txtAdicionarDatas.setMinimumSize(new Dimension(90, 19));
            this.txtAdicionarDatas.setName("quantidadeDiasOuMes");
            this.txtAdicionarDatas.setToolTipText(this.getMensagem("MH106"));
            this.txtAdicionarDatas.setEnabled(false);
        }
        return this.txtAdicionarDatas;
    }

    public BBJRadioButton getRadioAdicionarData() {
        if (this.radioAdicionarData == null) {
            this.radioAdicionarData = new BBJRadioButton("Adicionar", true, 1);
            this.radioAdicionarData.setName("adicionarData");
            this.radioAdicionarData.setToolTipText(this.getMensagem("MH105"));
            this.radioAdicionarData.setEnabled(false);
            this.radioAdicionarData.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtData().setText(null);
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtAdicionarDatas().setText("");
                }
            });
        }
        return this.radioAdicionarData;
    }

    public BBJRadioButton getRadioFixarData() {
        if (this.radioFixarData == null) {
            this.radioFixarData = new BBJRadioButton("Fixar", false, 2);
            this.radioFixarData.setName("fixarData");
            this.radioFixarData.setToolTipText(this.getMensagem("MH109"));
            this.radioFixarData.setMinimumSize(new Dimension(80, 19));
            this.radioFixarData.setEnabled(false);
            this.radioFixarData.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtData().setText(null);
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtAdicionarDatas().setText("");
                }
            });
        }
        return this.radioFixarData;
    }

    public JPanel getPanelAlteraValores() {
        if (this.panelAlteraValores == null) {
            this.panelAlteraValores = new JPanel();
            this.panelAlteraValores.setLayout(new GridBagLayout());
            this.panelAlteraValores.setOpaque(false);
            this.panelAlteraValores.setBorder(BBJBordaOval.createCheckBoxOvalBorder((String)"Alterar Valores", (JComponent)this.panelAlteraValores, (JCheckBox)this.checkBoxValor));
            this.checkBoxValor.addActionListener(this.getActionListenerValores());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.weightx = 0.9;
            gc.gridx = 0;
            gc.gridy = 0;
            this.panelAlteraValores.add((Component)this.getRadioAdicionarValor(), gc);
            ++gc.gridx;
            this.panelAlteraValores.add((Component)this.getTxtAdicionarValor(), gc);
            ++gc.gridx;
            this.panelAlteraValores.add((Component)this.getRadioRsPercent(), gc);
            ++gc.gridy;
            gc.gridx = 0;
            this.panelAlteraValores.add((Component)this.getRadioFixarValor(), gc);
            ++gc.gridx;
            this.panelAlteraValores.add((Component)this.getTxtFixarEmValores(), gc);
            ++gc.gridx;
        }
        return this.panelAlteraValores;
    }

    private ActionListener getActionListenerValores() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof JCheckBox) {
                    JCheckBox checkBox = (JCheckBox)obj;
                    boolean enable = checkBox.isSelected();
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.habilitarComponentesValores(enable);
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.verificarRecalcular();
                }
            }
        };
    }

    private void habilitarComponentesValores(boolean enabled) {
        this.getRadioAdicionarValor().setEnabled(enabled);
        this.getRadioFixarValor().setEnabled(enabled);
        if (enabled) {
            this.habilitarRadiosValores(this.radioAdicionarValor.isSelected() ? this.radioAdicionarValor : this.radioFixarValor);
        } else {
            this.getTxtFixarEmValores().setText("");
            this.getTxtAdicionarValor().setText("");
            this.habilitarRadiosValores(null);
            this.getRadioRsPercent().setSelected(1);
        }
    }

    public BBJMaskLabelMonetario getTxtAdicionarValor() {
        if (this.txtAdicionarValor == null) {
            this.txtAdicionarValor = new BBJMaskLabelMonetario("", 20, true, 0, 130, 0);
            this.txtAdicionarValor.getDecimalTextField().setName("quantidadeValor");
            this.txtAdicionarValor.setToolTipText(this.getMensagem("MH101"));
            this.txtAdicionarValor.setEnabled(false);
        }
        return this.txtAdicionarValor;
    }

    public BBJMaskLabelMonetario getTxtFixarEmValores() {
        if (this.txtFixarEmValor == null) {
            this.txtFixarEmValor = new BBJMaskLabelMonetario("", 20, true, 0, 130, 0);
            this.txtFixarEmValor.setMinimumSize(new Dimension(80, 19));
            this.txtFixarEmValor.getDecimalTextField().setName("valorFixo");
            this.txtFixarEmValor.setToolTipText(this.getMensagem("MH101"));
            this.txtFixarEmValor.setEnabled(false);
        }
        return this.txtFixarEmValor;
    }

    public BBJRadioButton getRadioAdicionarValor() {
        if (this.radioAdicionarValor == null) {
            this.radioAdicionarValor = new BBJRadioButton("Adicionar", true, 1);
            this.radioAdicionarValor.setName("adicionarValor");
            this.radioAdicionarValor.setEnabled(false);
            this.radioAdicionarValor.setToolTipText(this.getMensagem("MH110"));
            this.radioAdicionarValor.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtFixarEmValores().setText("");
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtAdicionarValor().setText("");
                }
            });
        }
        return this.radioAdicionarValor;
    }

    public BBJRadioButton getRadioFixarValor() {
        if (this.radioFixarValor == null) {
            this.radioFixarValor = new BBJRadioButton("Fixar em", false, 2);
            this.radioFixarValor.setName("fixarValor");
            this.radioFixarValor.setToolTipText(this.getMensagem("MH113"));
            this.radioFixarValor.setEnabled(false);
            this.radioFixarValor.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtFixarEmValores().setText("");
                    ViewIncluirRecebimentosApartirRemessaAnterior.this.getTxtAdicionarValor().setText("");
                }
            });
        }
        return this.radioFixarValor;
    }

    public JPanel getPnlBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setLayout(new FlowLayout(2));
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.add((Component)this.getBtnConfirmar());
            this.panelBotoes.add(this.getBtnVoltar());
            this.panelBotoes.setPreferredSize(new Dimension(710, 30));
        }
        return this.panelBotoes;
    }

    public JPanel getPanelCombo() {
        if (this.panelCombo == null) {
            this.panelCombo = new JPanel();
            this.panelCombo.setOpaque(false);
            this.panelCombo.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(5, 5, 5, 5);
            gc.anchor = 17;
            gc.fill = 2;
            gc.weightx = 0.8;
            gc.gridx = 0;
            gc.gridy = 0;
            this.panelCombo.add((Component)this.getComboConvenio(), gc);
            ++gc.gridy;
            this.panelCombo.add((Component)this.getComboRemessa(), gc);
        }
        return this.panelCombo;
    }

    public JPanel getPanelLabels() {
        if (this.panelLabels == null) {
            this.panelLabels = new JPanel();
            this.panelLabels.setLayout(new GridBagLayout());
            this.panelLabels.setOpaque(false);
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 17;
            gc.fill = 2;
            gc.weightx = 0.99;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            this.panelLabels.add((Component)this.getPanelInfo(), gc);
            gc.gridx = 0;
            gc.gridy = 1;
            this.panelLabels.add((Component)this.getPanelDica(), gc);
        }
        return this.panelLabels;
    }

    public JPanel getPanelInfo() {
        if (this.panelInfo == null) {
            this.panelInfo = new JPanel();
            this.panelInfo.setOpaque(false);
            this.panelInfo.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(1, 7, 1, 7);
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.33;
            gbc.anchor = 17;
            this.panelInfo.add((Component)this.getPanelQuantidade(), gbc);
            ++gbc.gridx;
            this.panelInfo.add((Component)this.getPanelValorTotal(), gbc);
            ++gbc.gridx;
            gbc.fill = 0;
            gbc.anchor = 13;
            this.panelInfo.add((Component)this.getBotaoRetirar(), gbc);
        }
        return this.panelInfo;
    }

    public JPanel getPanelDica() {
        if (this.panelDica == null) {
            this.panelDica = new JPanel();
            this.panelDica.setOpaque(false);
            this.panelDica.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(1, 7, 1, 7);
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.99;
            gbc.anchor = 17;
            this.panelDica.add((Component)this.getLabelDica(), gbc);
        }
        return this.panelDica;
    }

    public JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setOpaque(false);
            this.panelPrincipal.setBorder(BBJBordaOval.createOvalBorder());
            this.panelPrincipal.setLayout(new BoxLayout(this.panelPrincipal, 1));
            this.panelPrincipal.add(this.getPanelCombo());
            this.panelPrincipal.add(Box.createRigidArea(new Dimension(0, 10)));
            this.panelPrincipal.add(this.getPanelAlteracoes());
            this.panelPrincipal.add(this.getPanelTabela());
            this.panelPrincipal.add(this.getPanelLabels());
        }
        return this.panelPrincipal;
    }

    public static void main(String[] args) {
        ViewIncluirRecebimentosApartirRemessaAnterior view = new ViewIncluirRecebimentosApartirRemessaAnterior();
        view.setVisible(true);
        JFrame frame = new JFrame("Teste");
        frame.getContentPane().add((Component)((Object)view));
        frame.pack();
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    public JPanel getPanelAlteracoes() {
        if (this.panelAlteracoes == null) {
            this.panelAlteracoes = new JPanel();
            this.panelAlteracoes.setOpaque(false);
            this.panelAlteracoes.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.weightx = 0.5;
            gbc.gridy = 0;
            this.panelAlteracoes.add((Component)this.getPanelAlterarDatas(), gbc);
            ++gbc.gridx;
            this.panelAlteracoes.add((Component)this.getPanelAlteraValores(), gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            JPanel panelBotao = new JPanel();
            panelBotao.setOpaque(false);
            panelBotao.setLayout(new FlowLayout(2));
            panelBotao.add((Component)this.getBtnRecalcularRecebimentos());
            this.panelAlteracoes.add((Component)panelBotao, gbc);
        }
        return this.panelAlteracoes;
    }

    public JPanel getPanelTabela() {
        if (this.panelTabela == null) {
            this.panelTabela = new JPanel();
            this.panelTabela.setBorder(BBJBordaOval.createOvalBorder((String)"Lan\u00e7amentos"));
            this.panelTabela.setOpaque(false);
            this.panelTabela.setLayout(new BorderLayout());
            this.panelTabela.setPreferredSize(new Dimension(0, 200));
            this.panelTabela.add((Component)this.getTable().getTable().getTableHeader(), "North");
            this.panelTabela.add((Component)this.getTable(), "Center");
        }
        return this.panelTabela;
    }

    public BBJTableScrollPane<IObjIncluirRecebimentosApartirRemessaAnterior> getTable() {
        if (this.table == null) {
            this.table = new BBJTableScrollPane(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.table.setPreferredSize(new Dimension(0, 200));
            this.table.setOrdenacaoAutomatica(true);
            this.table.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        boolean temRegistro = ViewIncluirRecebimentosApartirRemessaAnterior.this.table.getDataListTabela() != null && ViewIncluirRecebimentosApartirRemessaAnterior.this.table.getDataListTabela().size() > 0;
                        boolean habilitaBotoes = temRegistro && e.getActionCommand().equalsIgnoreCase("SELECIONADO");
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.getBotaoRetirar().setEnabled(habilitaBotoes);
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.getBtnConfirmar().setEnabled(habilitaBotoes);
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.atualizaPanelValores();
                    } else {
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.getBotaoRetirar().setEnabled(false);
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.getBtnConfirmar().setEnabled(false);
                        ViewIncluirRecebimentosApartirRemessaAnterior.this.atualizaPanelValores();
                    }
                }
            });
        }
        return this.table;
    }

    public BBJPanelInformacao getPanelQuantidade() {
        if (this.panelQuantidade == null) {
            this.panelQuantidade = new BBJPanelInformacao("Quantidade:", 150, 100);
            this.panelQuantidade.setAlinhamentotitulo(2);
            this.panelQuantidade.setAlinhamentovalor(4);
        }
        return this.panelQuantidade;
    }

    public BBJPanelInformacao getPanelValorTotal() {
        if (this.panelValorTotal == null) {
            this.panelValorTotal = new BBJPanelInformacao("Valor Total:", 150, 100);
            this.panelValorTotal.setAlinhamentotitulo(2);
            this.panelValorTotal.setAlinhamentovalor(4);
        }
        return this.panelValorTotal;
    }

    private void habilitarRadiosValores(BBJRadioButton objRadio) {
        this.getTxtAdicionarValor().setEnabled(objRadio == this.radioAdicionarValor);
        this.getRadioRsPercent().setEnabled(objRadio == this.radioAdicionarValor);
        this.getTxtFixarEmValores().setEnabled(objRadio == this.radioFixarValor);
    }

    private void habilitarRadiosDatas(BBJRadioButton objRadio) {
        this.getTxtAdicionarDatas().setEnabled(objRadio == this.radioAdicionarData);
        this.getRadioDiasMes().setEnabled(objRadio == this.radioAdicionarData);
        this.getTxtData().setEnabled(objRadio == this.radioFixarData);
    }

    public void recalcular(ApartirDaRemessaAnteriorForm anteriorForm) {
        if (anteriorForm.isCalcularData()) {
            this.recalcularDatas(anteriorForm);
        }
        if (anteriorForm.isCalcularValor()) {
            this.recalcularValor(anteriorForm);
        }
    }

    private void recalcularValor(ApartirDaRemessaAnteriorForm form) {
        String string = form.getFixarValor();
        ((Object)((Object)form)).getClass();
        if (string.equals("1")) {
            this.adicionarValor(form);
            this.adicionarPorcentagem(form);
        } else {
            String string2 = form.getFixarValor();
            ((Object)((Object)form)).getClass();
            if (string2.equals("2")) {
                this.fixarValor(form);
            }
        }
    }

    private void fixarValor(ApartirDaRemessaAnteriorForm anteriorForm) {
        for (IObjIncluirRecebimentosApartirRemessaAnterior to : this.getTable().getDataListTabela()) {
            Double valor = this.converterParaDouble(anteriorForm.getValorFixo());
            to.getRecebimentoDebitoTO().setValorRecebimento(new BigDecimal(valor));
        }
        this.getTable().fireTableDataChanged();
    }

    private void adicionarPorcentagem(ApartirDaRemessaAnteriorForm anteriorForm) {
        String string = anteriorForm.getValorOuPorcentagem();
        ((Object)((Object)anteriorForm)).getClass();
        if (string.equals("2") && this.isReferencia(anteriorForm.getValorFixo())) {
            for (IObjIncluirRecebimentosApartirRemessaAnterior to : this.getTable().getDataListTabela()) {
                Double valor = this.converterParaDouble(anteriorForm.getQuantidadeValor());
                valor = valor / 100.0 + 1.0;
                to.getRecebimentoDebitoTO().setValorRecebimento(new BigDecimal(to.getRecebimentoDebitoTO().getValorRecebimento().doubleValue() * valor));
            }
            this.getTable().fireTableDataChanged();
        }
    }

    private void adicionarValor(ApartirDaRemessaAnteriorForm anteriorForm) {
        String string = anteriorForm.getValorOuPorcentagem();
        ((Object)((Object)anteriorForm)).getClass();
        if (string.equals("1") && this.isReferencia(anteriorForm.getQuantidadeValor())) {
            for (IObjIncluirRecebimentosApartirRemessaAnterior to : this.getTable().getDataListTabela()) {
                Double valor = this.converterParaDouble(anteriorForm.getQuantidadeValor());
                to.getRecebimentoDebitoTO().setValorRecebimento(new BigDecimal(to.getRecebimentoDebitoTO().getValorRecebimento().doubleValue() + valor));
            }
            this.getTable().fireTableDataChanged();
        }
    }

    protected Double converterParaDouble(String real) {
        String valor = real;
        while (real.indexOf(".") > -1) {
            real = real.replace(".", "");
        }
        return UtilConversorDeDouble.converterParaDoubleWrapper((String)valor);
    }

    private void recalcularDatas(ApartirDaRemessaAnteriorForm anteriorForm) {
        String string = anteriorForm.getFixarData();
        ((Object)((Object)anteriorForm)).getClass();
        if (string.equals("1")) {
            this.adicionarDias(anteriorForm);
            this.adicionarMeses(anteriorForm);
        } else {
            String string2 = anteriorForm.getFixarData();
            ((Object)((Object)anteriorForm)).getClass();
            if (string2.equals("2")) {
                this.fixarData(anteriorForm);
            }
        }
    }

    private void fixarData(ApartirDaRemessaAnteriorForm anteriorForm) {
        for (IObjIncluirRecebimentosApartirRemessaAnterior to : this.getTable().getDataListTabela()) {
            to.getRecebimentoDebitoTO().setDataRecebimento(anteriorForm.getDataFixa());
        }
        this.getTable().fireTableDataChanged();
    }

    private void adicionarMeses(ApartirDaRemessaAnteriorForm anteriorForm) {
        String string = anteriorForm.getDiaOuMes();
        ((Object)((Object)anteriorForm)).getClass();
        if (string.equals("2") && UtilNumero.isInteiro((String)anteriorForm.getQuantidadeDiasOuMes())) {
            for (IObjIncluirRecebimentosApartirRemessaAnterior to : this.getTable().getDataListTabela()) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(to.getRecebimentoDebitoTO().getDataRecebimento());
                calendar.add(2, new Integer(anteriorForm.getQuantidadeDiasOuMes()));
                to.getRecebimentoDebitoTO().setDataRecebimento(calendar.getTime());
            }
            this.getTable().fireTableDataChanged();
        }
    }

    private void adicionarDias(ApartirDaRemessaAnteriorForm anteriorForm) {
        String string = anteriorForm.getDiaOuMes();
        ((Object)((Object)anteriorForm)).getClass();
        if (string.equals("1") && UtilNumero.isInteiro((String)anteriorForm.getQuantidadeDiasOuMes())) {
            for (IObjIncluirRecebimentosApartirRemessaAnterior to : this.getTable().getDataListTabela()) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(to.getRecebimentoDebitoTO().getDataRecebimento());
                calendar.add(5, new Integer(anteriorForm.getQuantidadeDiasOuMes()));
                to.getRecebimentoDebitoTO().setDataRecebimento(calendar.getTime());
            }
            this.getTable().fireTableDataChanged();
        }
    }
}

