/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterconvenente.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.form.ManterConvenenteForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.facade.ManterConvenenteFacade;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenenteTODecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultarConvenentesAction
extends DBTPluginActionAbstrato {
    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ManterConvenenteForm convenenteForm = (ManterConvenenteForm)form;
        PaginadorTO consultarConvenentes = this.getManterConvenenteFacade().consultar(convenenteForm.getConvenenteTO());
        this.preencherForm(convenenteForm, consultarConvenentes);
        return null;
    }

    private void preencherForm(ManterConvenenteForm convenenteForm, PaginadorTO consultarConvenentes) {
        convenenteForm.setListaConvenente(this.getColecaoConvenenteTODecorator(consultarConvenentes.getColecaoDeRegistros()));
        convenenteForm.setTotalDeRegistros(consultarConvenentes.getTotalDeRegistros());
    }

    private void ordenarPorInscricao(Collection<ConvenenteTODecorator> listaConvenente) {
        Collections.sort((ArrayList)listaConvenente, new Comparator<ConvenenteTODecorator>(){

            @Override
            public int compare(ConvenenteTODecorator o1, ConvenenteTODecorator o2) {
                return o1.getInscricao().compareTo(o2.getInscricao());
            }
        });
    }

    private Collection<ConvenenteTODecorator> getColecaoConvenenteTODecorator(Collection<ConvenenteTO> listaConvenentes) {
        List decorator = this.getColecaoFactory().novoArrayList();
        for (ConvenenteTO convenenteTO : listaConvenentes) {
            ConvenenteTODecorator convenenteTODecorator = this.getTOFactory().novoConvenenteTODecorator();
            convenenteTODecorator.setConvenente(convenenteTO);
            decorator.add(convenenteTODecorator);
        }
        return decorator;
    }

    private ManterConvenenteFacade getManterConvenenteFacade() {
        return this.getFacadeFactory().novoManterConvenenteFacade();
    }
}

