/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.form.ConsultarRecebimentosForm;
import br.com.bb.plugins.dbt.negocio.facade.ManterRecebimentoFacade;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.string.UtilString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultarRecebimentosAction
extends DBTPluginActionAbstrato {
    private ManterRecebimentoFacade facade;

    @Override
    public void preExecutar(PluginFormAbstrato form) {
        ConsultarRecebimentosForm recebimentoForm = (ConsultarRecebimentosForm)form;
        recebimentoForm.setAcaoBotaoConsultar(true);
        form.setPermitirValidacao(true);
    }

    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ConsultarRecebimentosForm recebimentoForm = (ConsultarRecebimentosForm)form;
        RecebimentoDebitoTODecorator decorator = recebimentoForm.getRecebimentoTODecorator();
        ConvenioTO convenioTO = recebimentoForm.getConvenioTO();
        decorator.setConvenioTO(convenioTO);
        ConvenenteTO convenenteTO = this.getConvenenteTO();
        decorator.setCodigoPessoaConvenente(convenenteTO.getCodigoPessoaConvenente());
        decorator.setConvenenteTO(convenenteTO);
        decorator.setPessoaTO(convenenteTO.getPessoaTO());
        decorator.setGrupoClienteRecebimentoTO(recebimentoForm.getGrupoClienteRecebimentoTO());
        decorator.setDataRemessa(recebimentoForm.getDataRemessa());
        decorator.setIdentificacaoTO(recebimentoForm.getIdentificacaoTO());
        decorator.setSituacaoRecebimentoTO(recebimentoForm.getSituacaoRecebimentoTO());
        decorator.setTextoIdentificacao(3 == recebimentoForm.getCodigoTipoDocumento() ? null : UtilString.removerCaracteres((String)recebimentoForm.getNumeroInscricao()));
        decorator.setTextoNome(recebimentoForm.getTextoNome());
        decorator.setDataRecebimentoInicial(recebimentoForm.getDataInicial());
        decorator.setDataRecebimentoFinal(recebimentoForm.getDataFinal());
        decorator.setCodigoContaCorrente(UtilConversorDeString.converterParaLong((String)this.getNumeroConta(recebimentoForm.getCodigoContaCorrente())));
        decorator.setAgenciaInstituicaoFinanceiraTO(recebimentoForm.getAgenciaInstituicaoFinanceiraTO().getAgenciaInstituicaoFinanceiraTO());
        decorator.setValorInicial(recebimentoForm.getValorInicial());
        decorator.setValorFinal(recebimentoForm.getValorFinal());
        decorator.setIdentificadorProprio(recebimentoForm.getIdentificadorProprio());
        decorator.setAcaoBotaoConsultar(recebimentoForm.isAcaoBotaoConsultar());
        if (recebimentoForm.isAcaoBotaoConsultar()) {
            recebimentoForm.setTotalRecebimentos(this.getManterRecebimentoFacade().totalizarRecebimentos(decorator));
        }
        recebimentoForm.setPaginadorTO(this.getManterRecebimentoFacade().consultar(decorator));
        return null;
    }

    private void ordenarPorSituacao(ArrayList<RecebimentoDebitoTO> lista) {
        Collections.sort(lista, new Comparator<RecebimentoDebitoTO>(){

            @Override
            public int compare(RecebimentoDebitoTO o1, RecebimentoDebitoTO o2) {
                if (o1.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome().equals(o2.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome()) && o1.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO().getNumeroConvenio().equals(o2.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO().getNumeroConvenio()) && o1.getDataRecebimento().equals(o2.getDataRecebimento())) {
                    return o1.getSituacaoRecebimentoTO().getCodigoHierarquia().compareTo(o2.getSituacaoRecebimentoTO().getCodigoHierarquia());
                }
                return 0;
            }
        });
    }

    private void ordenarPorData(ArrayList<RecebimentoDebitoTO> lista) {
        Collections.sort(lista, new Comparator<RecebimentoDebitoTO>(){

            @Override
            public int compare(RecebimentoDebitoTO o1, RecebimentoDebitoTO o2) {
                if (o1.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome().equals(o2.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome()) && o1.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO().getNumeroConvenio().equals(o2.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO().getNumeroConvenio())) {
                    return o1.getDataRecebimento().compareTo(o2.getDataRecebimento());
                }
                return 0;
            }
        });
    }

    private void ordenarPorConvenio(ArrayList<RecebimentoDebitoTO> lista) {
        Collections.sort(lista, new Comparator<RecebimentoDebitoTO>(){

            @Override
            public int compare(RecebimentoDebitoTO o1, RecebimentoDebitoTO o2) {
                if (o1.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome().equals(o2.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome())) {
                    return o1.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO().getNumeroConvenio().compareTo(o2.getIdentificadorClienteDebitoTO().getConvenioDebitoTO().getConvenioTO().getNumeroConvenio());
                }
                return 0;
            }
        });
    }

    private void ordenarPorNome(ArrayList<RecebimentoDebitoTO> lista) {
        Collections.sort(lista, new Comparator<RecebimentoDebitoTO>(){

            @Override
            public int compare(RecebimentoDebitoTO o1, RecebimentoDebitoTO o2) {
                return o1.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome().compareTo(o2.getIdentificadorClienteDebitoTO().getPessoaTO().getTextoNome());
            }
        });
    }

    private String getNumeroConta(String codigoContaCorrente) {
        if (codigoContaCorrente != null && codigoContaCorrente.trim().length() > 0) {
            return UtilString.removerCaracteres((String)codigoContaCorrente.trim().substring(0, codigoContaCorrente.trim().length() - 1));
        }
        return "0";
    }

    private ConvenenteTO getConvenenteTO() {
        return FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getConvenenteTO();
    }

    public ManterRecebimentoFacade getManterRecebimentoFacade() {
        if (this.facade == null) {
            this.facade = this.getDBTFacadeFactory().novoManterRecebimentoFacade();
        }
        return this.facade;
    }
}

