/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.form.ConsultarRecebimentosForm;
import br.com.bb.plugins.dbt.negocio.facade.ManterRecebimentoFacade;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.string.UtilString;

public class ImprimirRecebimentosDbtAction
extends DBTPluginActionAbstrato {
    private ManterRecebimentoFacade facade;

    public String executar(PluginFormAbstrato form) {
        ConsultarRecebimentosForm recebimentoForm = (ConsultarRecebimentosForm)form;
        RecebimentoDebitoTODecorator decorator = recebimentoForm.getRecebimentoTODecorator();
        decorator.setConvenenteTO(this.getConvenenteTO());
        decorator.setConvenioTO(recebimentoForm.getConvenioTO());
        decorator.setGrupoClienteRecebimentoTO(recebimentoForm.getGrupoClienteRecebimentoTO());
        decorator.setDataRemessa(recebimentoForm.getDataRemessa());
        decorator.setIdentificacaoTO(recebimentoForm.getIdentificacaoTO());
        decorator.setSituacaoRecebimentoTO(recebimentoForm.getSituacaoRecebimentoTO());
        decorator.setTextoIdentificacao(UtilString.removerCaracteres((String)recebimentoForm.getNumeroInscricao()));
        decorator.setTextoNome(recebimentoForm.getTextoNome());
        decorator.setDataRecebimentoInicial(recebimentoForm.getDataInicial());
        decorator.setDataRecebimentoFinal(recebimentoForm.getDataFinal());
        decorator.setCodigoContaCorrente(UtilConversorDeString.converterParaLong((String)this.getNumeroConta(recebimentoForm.getCodigoContaCorrente())));
        decorator.setAgenciaInstituicaoFinanceiraTO(recebimentoForm.getAgenciaInstituicaoFinanceiraTO().getAgenciaInstituicaoFinanceiraTO());
        decorator.setValorInicial(recebimentoForm.getValorInicial());
        decorator.setValorFinal(recebimentoForm.getValorFinal());
        decorator.setIdentificadorProprio(recebimentoForm.getIdentificadorProprio());
        recebimentoForm.setColecaoDeRegistrosImprimir(this.getManterRecebimentoFacade().consultarPorFiltroSemPaginacaoImpressao(decorator));
        return null;
    }

    private String getNumeroConta(String codigoContaCorrente) {
        if (codigoContaCorrente != null && codigoContaCorrente.trim().length() > 0) {
            return UtilString.removerCaracteres((String)codigoContaCorrente.trim().substring(0, codigoContaCorrente.trim().length() - 1));
        }
        return "0";
    }

    private ConvenenteTO getConvenenteTO() {
        return FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getConvenenteTO();
    }

    public ManterRecebimentoFacade getManterRecebimentoFacade() {
        if (this.facade == null) {
            this.facade = this.getDBTFacadeFactory().novoManterRecebimentoFacade();
        }
        return this.facade;
    }
}

