/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.recuperarremessa.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.recuperarremessa.action.ConfirmarRecuperarRemessaAction;
import br.com.bb.plugins.dbt.apresentacao.recuperarremessa.action.ConsultarRecuperarRemessaAction;
import br.com.bb.plugins.dbt.apresentacao.recuperarremessa.form.ConsultarRemessaPendenteForm;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.consultarremessaspendentes.action.ImprimirRemessaPendenteAction;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectRecuperarRemessas;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressAnimate;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewRecuperarRemessa
extends DBTBasicInternalFrame
implements Observer {
    private final String[] columnNames = new String[]{"Data Remessa", "N\u00ba Conv\u00eanio", "N\u00ba Remessa", "Valor Remessa", "Nome Arquivo"};
    private final int[] columnSizes = new int[]{90, 80, 80, 100, 200};
    private final int[] columnAligment;
    private BBJTableImpl<IObjectRecuperarRemessas> tabelaRemessa;
    private JPanel panelPrincipal;
    private JPanel panelDados;
    private JPanel panelBotoes;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso;
    private BBJButton btnConfirmar;
    private BBJButton btnMarcarTodos;
    private BBJButton btnDesmarcarTodos;
    private BBJButton btnImprimir;
    private BBJButton btnVoltar;
    private BBJProgressAnimate bBJProgressAnimate;

    public ViewRecuperarRemessa() {
        super("Recuperar Remessa", false, false);
        int[] nArray = new int[5];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        this.columnAligment = nArray;
        this.tabelaRemessa = null;
        this.panelDados = null;
        this.panelProgresso = null;
        this.bBJProgressAnimate = null;
        this.add(this.getPanelPrincipal(), "North");
        this.setVisible(true);
        this.getConsultarRemessaPendenteForm().getNotificaProcessarRemessa().addObserver((Observer)this);
        this.bBJProgressAnimate = new BBJProgressAnimate();
    }

    private JPanel getPanelPrincipal() {
        if (!this.isReferencia(this.panelPrincipal)) {
            this.panelPrincipal = this.getPainelFactory().novoJPainel();
            this.panelPrincipal.setLayout(new BorderLayout());
            this.panelPrincipal.add((Component)this.getPanelDados(), "North");
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.add((Component)this.getPanelProgresso(), "North");
            panel.add((Component)this.getPanelBotoes(), "Center");
            this.panelPrincipal.add((Component)panel, "Center");
            this.panelPrincipal.setOpaque(false);
        }
        return this.panelPrincipal;
    }

    public void doShow(Map context) {
        try {
            this.getConsultarRemessaAction().executar(this.getForm());
            this.preencherTblRemessa();
            this.habilitaBotoes();
            this.getBbprogress().setValoratual(0L);
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem((String)e.getMessage());
        }
        this.setVisible(true);
        super.doShow(context);
    }

    public void posExecucaoConsultarRemessaAction() {
        this.preencherTblRemessa();
    }

    private void preencherTblRemessa() {
        List list = this.getColecaoFactory().novoArrayList();
        for (RemessaTODecorator remessaTODecorator : this.getConsultarRemessaPendenteForm().getListaRemessaPendente()) {
            list.add(new IObjectRecuperarRemessas(remessaTODecorator));
        }
        this.getTabelaRemessa().getBbtModel().setDataListTabela(list);
        this.habilitarBotoes(!list.isEmpty());
    }

    private void habilitarBotoes(boolean isHabilitar) {
        this.getBtnConfirmar().setEnabled(isHabilitar);
        this.getBtnMarcarTodos().setEnabled(isHabilitar);
        this.getBtnDesmarcarTodos().setEnabled(isHabilitar);
        this.getBtnImprimir().setEnabled(isHabilitar);
    }

    private JPanel getPanelDados() {
        if (!this.isReferencia(this.panelDados)) {
            this.panelDados = this.getPainelFactory().novoJPainel();
            this.panelDados.setLayout(new BorderLayout());
            this.panelDados.add((Component)this.getTabelaRemessa().getTable().getTableHeader(), "First");
            this.panelDados.add((Component)this.getTabelaRemessa(), "Center");
            this.panelDados.setBorder(BBJBordaOval.createOvalBorder((String)"Lista de Remessas", (int)15));
            this.panelDados.setOpaque(false);
            this.panelDados.setPreferredSize(new Dimension(0, 400));
        }
        return this.panelDados;
    }

    private BBJTableImpl<IObjectRecuperarRemessas> getTabelaRemessa() {
        if (!this.isReferencia(this.tabelaRemessa)) {
            this.tabelaRemessa = new BBJTableImpl(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tabelaRemessa.setName("colecaoItensSelecionados");
            this.tabelaRemessa.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewRecuperarRemessa.this.habilitaBotoes();
                }
            });
        }
        return this.tabelaRemessa;
    }

    private void habilitaBotoes() {
        if (this.getTabelaRemessa().getDataListTabela() == null || this.getTabelaRemessa().getDataListTabela().size() == 0) {
            this.getBtnConfirmar().setEnabled(false);
            this.getBtnMarcarTodos().setEnabled(false);
            this.getBtnDesmarcarTodos().setEnabled(false);
        } else if (this.getTabelaRemessa().getItensChecadosCheckBox() == null || this.getTabelaRemessa().getItensChecadosCheckBox().size() == 0) {
            this.getBtnConfirmar().setEnabled(false);
            this.getBtnDesmarcarTodos().setEnabled(false);
            this.getBtnMarcarTodos().setEnabled(true);
        } else if (this.getTabelaRemessa().getDataListTabela().size() == this.getTabelaRemessa().getItensChecadosCheckBox().size()) {
            this.getBtnMarcarTodos().setEnabled(false);
            this.getBtnDesmarcarTodos().setEnabled(true);
            this.getBtnConfirmar().setEnabled(true);
        } else {
            this.getBtnConfirmar().setEnabled(true);
            this.getBtnMarcarTodos().setEnabled(true);
            this.getBtnDesmarcarTodos().setEnabled(true);
        }
    }

    private JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.setPreferredSize(new Dimension(0, 40));
            FlowLayout flayout = new FlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add((Component)this.getBtnConfirmar());
            this.panelBotoes.add((Component)this.getBtnMarcarTodos());
            this.panelBotoes.add((Component)this.getBtnDesmarcarTodos());
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    protected BBJButton getBtnVoltar() {
        if (!this.isReferencia(this.btnVoltar)) {
            this.btnVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.btnVoltar;
    }

    public void preExecucaoConfirmarRecuperarRemessaAction() {
        ConsultarRemessaPendenteForm form = this.getConsultarRemessaPendenteForm();
        form.setItensSelecionados(this.getTabelaRemessa().getBbtModel().getItensSelecionados());
        this.getBtnVoltar().setEnabled(false);
        this.habilitarBotoes(false);
        this.getPanelProgresso().setVisible(true);
    }

    public void posExecucaoConfirmarRecuperarRemessaAction() {
        try {
            this.getConsultarRemessaAction().executar(this.getForm());
            this.preencherTblRemessa();
            this.zerarBarraProgresso();
            this.getBtnVoltar().setEnabled(true);
        }
        catch (BBException e) {
            BBJPopupMensagem.exibirMensagem((String)e.getMessage());
        }
    }

    private void zerarBarraProgresso() {
        this.getPanelProgresso().setVisible(false);
        this.atualizaProgressBar(0);
    }

    private BBJButton getBtnConfirmar() {
        if (!this.isReferencia(this.btnConfirmar)) {
            ConfirmarRecuperarRemessaAction confirmarAction = this.getDBTActionFactory().novoConfirmarRecuperarRemessaAction();
            this.btnConfirmar = this.getBotaoFactory().novoConfirmar((PluginActionAbstrato)confirmarAction);
        }
        return this.btnConfirmar;
    }

    private BBJButton getBtnMarcarTodos() {
        if (!this.isReferencia(this.btnMarcarTodos)) {
            this.btnMarcarTodos = new BBJButton("MARCAR TODOS");
            this.btnMarcarTodos.addActionListener(this.marcarCheckBoxTabela(true));
        }
        return this.btnMarcarTodos;
    }

    private ActionListener marcarCheckBoxTabela(final boolean marcar) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewRecuperarRemessa.this.getTabelaRemessa().getBbtModel().marcaTodos(marcar);
                ViewRecuperarRemessa.this.habilitaBotoes();
            }
        };
        return actionListener;
    }

    private BBJButton getBtnDesmarcarTodos() {
        if (!this.isReferencia(this.btnDesmarcarTodos)) {
            this.btnDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.btnDesmarcarTodos.addActionListener(this.marcarCheckBoxTabela(false));
        }
        return this.btnDesmarcarTodos;
    }

    private BBJButton getBtnImprimir() {
        if (!this.isReferencia(this.btnImprimir)) {
            ImprimirRemessaPendenteAction acao = this.getDBTActionFactory().novoImprimirRemessaPendenteAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.btnImprimir;
    }

    public void posExecucaoImprimirRemessaPendenteAction() {
        this.imprimirRemessaPendente();
    }

    private void imprimirRemessaPendente() {
        JasperPrint impressao = null;
        try {
            impressao = UtilRelatorioJasper.imprimirRelatorio((String)Arquivo.JASPER_REMESSAS_PENDENTES_RECUPERAR, (Map)this.getMapaParametros(), this.getConsultarRemessaPendenteForm().getListaRemessaPendente());
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
    }

    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void doClose(Map context) {
        this.setVisible(false);
        super.doClose(context);
    }

    private BBJProgressBar getBbprogress() {
        if (!this.isReferencia(this.bbprogress)) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    private JPanel getPanelProgresso() {
        if (!this.isReferencia(this.panelProgresso)) {
            this.panelProgresso = this.getPainelFactory().novoJPainel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder((String)"Progresso", (int)10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    private Map getMapaParametros() {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        return mapa;
    }

    protected PluginFormAbstrato novoForm() {
        return new ConsultarRemessaPendenteForm();
    }

    private ConsultarRemessaPendenteForm getConsultarRemessaPendenteForm() {
        return (ConsultarRemessaPendenteForm)this.getForm();
    }

    private ConsultarRecuperarRemessaAction getConsultarRemessaAction() {
        return this.getDBTActionFactory().novoConsultarRecuperarRemessaAction();
    }

    @Override
    public void update(Observable o, Object arg) {
        Integer porcentagem = (Integer)arg;
        this.atualizaProgressBar(porcentagem);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual((long)porcentagem.intValue());
        this.getBbprogress().updateUI();
    }
}

