/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.integracao.dao;

import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.integracao.dao.UtilRestricaoDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.SituacaoIdentificadorDebitoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentificadorClienteDebitoDAOImpl
extends HibernateDAO<IdentificadorClienteDebitoTO, Integer>
implements IdentificadorClienteDebitoDAO {
    protected Integer getChavePrimaria(IdentificadorClienteDebitoTO to) {
        return to.getCodigoIdentificadorClienteDebito();
    }

    protected Class<IdentificadorClienteDebitoTO> novoTipoDeObjetoPersistente() {
        return IdentificadorClienteDebitoTO.class;
    }

    @Override
    public boolean isExisteConvenio(ConvenioTO to) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("convenioDebitoTO.id.numeroConvenio", to.getId().getNumeroConvenio()));
        criteria.list();
        return !UtilColecao.isVazio((Collection)criteria.list());
    }

    @Override
    public boolean isExistePeloTextoDeIdentificacao(IdentificadorClienteDebitoTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloTextoDeIdentificacao(query, to);
        return !UtilColecao.isVazio((Collection)query.list());
    }

    @Override
    public boolean isExistePeloTextoDeIdentificacaoConvenenteClienteEConvenio(IdentificadorClienteDebitoTO to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloTextoDeIdentificacao(query, to);
        this.adicionarCriterioConsultarPeloConvenio(query, to);
        this.adicionarCriterioConsultarPeloConvenente(query, to);
        this.adicionarCriterioConsultarPeloCliente(query, to);
        return !UtilColecao.isVazio((Collection)query.list());
    }

    private void adicionarCriterioConsultarPeloCliente(Criteria query, IdentificadorClienteDebitoTO to) {
        Integer codigoPessoa = to.getContaCorrenteClienteTO().getPessoaTO().getCodigoPessoa();
        if (this.isReferencia(codigoPessoa)) {
            Criteria cc = this.getCriteria(query, "contaCorrenteClienteTO");
            cc.add(this.novoCriterioEQ("pessoaTO.codigoPessoa", codigoPessoa));
        }
    }

    private void adicionarCriterioConsultarPeloConvenente(Criteria query, IdentificadorClienteDebitoTO to) {
        Integer codigoPessoaConvenente = to.getConvenioDebitoTO().getId().getCodigoPessoaConvenente();
        if (this.isReferencia(codigoPessoaConvenente)) {
            Criteria convenioDeb = this.getCriteria(query, "convenioDebitoTO");
            convenioDeb.add(this.novoCriterioEQ("id.codigoPessoaConvenente", codigoPessoaConvenente));
        }
    }

    private void adicionarCriterioConsultarPeloTextoDeIdentificacao(Criteria query, IdentificadorClienteDebitoTO to) {
        String texto = to.getTextoIdentificadorDebito();
        if (!this.isVazio(texto)) {
            query.add(this.novoCriterioLike("textoIdentificadorDebito", texto));
        }
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> listarIdentificadorClienteDebitoConvenente(IdentificadorClienteDebitoTODecorator decorator) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("convenioDebitoTO.id.numeroConvenio", decorator.getConvenioDebitoTOId().getNumeroConvenio()));
        criteria.add(this.novoCriterioEQ("convenioDebitoTO.id.textoIdentificadorServico", decorator.getConvenioDebitoTOId().getTextoIdentificadorServico()));
        criteria.add(this.novoCriterioEQ("convenioDebitoTO.id.codigoPessoaConvenente", decorator.getConvenioDebitoTOId().getCodigoPessoaConvenente()));
        criteria.add(this.novoCriterioEQ("situacaoIdentificadorDebitoTO.textoSituacaoIdentificador", Character.valueOf(decorator.getSituacaoIdentificadorDebitoTO().getTextoSituacaoIdentificador())));
        return criteria.list();
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> listarAutorizacoesParaDebitoConvenente(IdentificadorClienteDebitoTODecorator decorator) {
        Criteria criteria = this.novaCriteria();
        criteria.add(this.novoCriterioEQ("convenioDebitoTO.id.numeroConvenio", decorator.getConvenioDebitoTOId().getNumeroConvenio()));
        Criteria cp = this.getCriteria(criteria, "pessoaTO", 1);
        cp.addOrder(this.novaOrdenacaoASC("pessoaTO.textoNome"));
        return cp.list();
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> listarIdentificadorClienteDebitoEGrupos(IdentificadorClienteDebitoTODecorator identificador) {
        Criteria criteria = this.novaCriteria();
        criteria.createCriteria("contaCorrenteClienteTO").add(this.novoCriterioEQ("pessoaTO.codigoPessoa", identificador.getPessoaTO().getCodigoPessoa()));
        return criteria.list();
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> listarIdentificadorClienteDebitoPelaPessoaEConvenio(PessoaTO pessoaTO, ConvenioTO convenio) {
        Criteria query = this.novaCriteria();
        query.createCriteria("contaCorrenteClienteTO").add(this.novoCriterioEQ("pessoaTO.codigoPessoa", pessoaTO.getCodigoPessoa()));
        this.adicionarCriterioConsultarPeloConvenio(query, convenio);
        return query.list();
    }

    private void adicionarCriterioConsultarPorGrupoClienteRecebimento(Criteria query, GrupoClienteRecebimentoTO grupoClienteRecebimento) {
        if (grupoClienteRecebimento == null) {
            return;
        }
        Integer codigo = grupoClienteRecebimento.getCodigoGrupoClienteRecebimento();
        if (!this.isZero(codigo) && codigo != 9999) {
            Criteria membroGrupo = this.getCriteria(query, "membroGrupoClienteRecebimentoTOs");
            membroGrupo.add(this.novoCriterioEQ("id.codigoGrupoClienteRecebimento", codigo));
        } else if (!this.isZero(codigo) && codigo == 9999) {
            query.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"membroGrupoClienteRecebimentoTOs"), (Criterion)Restrictions.isEmpty((String)"membroGrupoClienteRecebimentoTOs")));
        }
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> consultarPeloTextoIdentificacaoEAgenciaEContaCorrente(IdentificadorClienteDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("textoIdentificadorDebito", decorator.getTextoIdentificadorDebito()));
        return query.list();
    }

    @Override
    public PaginadorTO consultarIdentificadorClienteDebitoPorPessoaCliente(IdentificadorClienteDebitoTODecorator decorador) {
        Criteria criteria = this.novaCriteria();
        Criteria cc = this.getCriteria(criteria, "contaCorrenteClienteTO");
        if ("membroGrupoClienteRecebimentoTOs.grupoClienteRecebimentoTO.textoDescricao".equals(decorador.getNomeColunaOrdenada())) {
            Criteria membrogrupo = this.getCriteria(criteria, "membroGrupoClienteRecebimentoTOs", 1);
            Criteria criteria2 = this.getCriteria(membrogrupo, "grupoClienteRecebimentoTO", 1);
        }
        cc.add(this.novoCriterioEQ("pessoaTO.codigoPessoa", decorador.getCodigoPessoaCliente()));
        this.adicionarCriterioConsultarPeloConvenente(criteria, decorador.getIdentificadorClienteDebitoTO());
        return this.novoPaginadorTO(criteria, (PluginTODecoratorAbstrato)decorador);
    }

    @Override
    public PaginadorTO consultarIdentificadorClienteDebitoPorColecaoPessoaCliente(Collection<IdentificadorClienteDebitoTODecorator> colecaoDecorador) {
        Criteria criteria = this.novaCriteria();
        Criteria cc = this.getCriteria(criteria, "contaCorrenteClienteTO");
        if (!colecaoDecorador.isEmpty() && colecaoDecorador.size() > 0) {
            IdentificadorClienteDebitoTODecorator decorador = (IdentificadorClienteDebitoTODecorator)((ArrayList)colecaoDecorador).get(0);
            if ("membroGrupoClienteRecebimentoTOs.grupoClienteRecebimentoTO.textoDescricao".equals(decorador.getNomeColunaOrdenada())) {
                Criteria membrogrupo = this.getCriteria(criteria, "membroGrupoClienteRecebimentoTOs", 1);
                Criteria criteria2 = this.getCriteria(membrogrupo, "grupoClienteRecebimentoTO", 1);
            }
            Criteria cp = this.getCriteria(cc, "pessoaTO", 1);
            cp.add(this.novoCriterioIN("pessoaTO.codigoPessoa", colecaoDecorador, "pessoaTO.codigoPessoa"));
            this.adicionarCriterioConsultarPeloConvenente(criteria, decorador.getIdentificadorClienteDebitoTO());
            PaginadorTO to = this.novoPaginadorTOSemResultado(criteria, (PluginTODecoratorAbstrato)decorador);
            cp.addOrder(this.novaOrdenacaoASC("pessoaTO.textoNome"));
            this.aplicarOrdenacao(criteria, (PluginTODecoratorAbstrato)decorador);
            to.setColecaoDeRegistros((Collection)criteria.list());
            return to;
        }
        PaginadorTO to = new PaginadorTO();
        to.setColecaoDeRegistros(new ArrayList());
        return to;
    }

    public PaginadorTO consultarPeloSituacaoEConvenio(IdentificadorClienteDebitoTODecorator decorador) {
        Criteria criteria = this.novaCriteria();
        Criteria cc = this.getCriteria(criteria, "contaCorrenteClienteTO");
        cc.add(this.novoCriterioEQ("pessoaTO.codigoPessoa", decorador.getCodigoPessoaCliente()));
        return this.novoPaginadorTO(criteria, (PluginTODecoratorAbstrato)decorador);
    }

    private void adicionarCriterioConsultarPelaSituacao(Criteria query, IdentificadorClienteDebitoTODecorator to) {
        SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTO = to.getSituacaoIdentificadorDebitoTO();
        if (this.isReferencia(situacaoIdentificadorDebitoTO)) {
            Criteria identificadorCliDeb = this.getCriteria(query, "situacaoIdentificadorDebitoTO");
            identificadorCliDeb.add(this.novoCriterioEQ("textoSituacaoIdentificador", Character.valueOf(situacaoIdentificadorDebitoTO.getTextoSituacaoIdentificador())));
        }
    }

    @Override
    public List<IdentificadorClienteDebitoTO> consultarPeloConvenioESituacaoDataUltimaRemessaNE(IdentificadorClienteDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloConvenio(query, decorator.getConvenioTO());
        this.adicionarCriterioConsultarPelaSituacao(query, decorator);
        this.adicionarCriterioConsultarPeloDataUltimaRemessa(query, decorator);
        this.aplicarOrdenacao(query, (PluginTODecoratorAbstrato)decorator);
        return query.list();
    }

    private void adicionarCriterioConsultarPeloDataUltimaRemessa(Criteria query, IdentificadorClienteDebitoTODecorator to) {
        Date dataUltimaRemessa = to.getIdentificadorClienteDebitoTO().getDataUltimaRemessa();
        if (this.isReferencia(dataUltimaRemessa)) {
            query.add((Criterion)Restrictions.or((Criterion)this.novoCriterioNE("dataUltimaRemessa", dataUltimaRemessa), (Criterion)Restrictions.isNull((String)"dataUltimaRemessa")));
        }
    }

    private void adicionarCriterioConsultarPeloConvenio(Criteria query, ConvenioTO convenioTO) {
        Integer numeroConvenio = convenioTO.getId().getNumeroConvenio();
        if (this.isReferencia(numeroConvenio)) {
            Criteria convenioDeb = this.getCriteria(query, "convenioDebitoTO");
            Criteria convenio = this.getCriteria(convenioDeb, "convenioTO");
            convenio.add(this.novoCriterioEQ("id.numeroConvenio", numeroConvenio));
        }
    }

    private void adicionarCriterioConsultarPeloConvenio(Criteria query, IdentificadorClienteDebitoTO to) {
        Integer numeroConvenio = to.getConvenioDebitoTO().getId().getNumeroConvenio();
        if (this.isReferencia(numeroConvenio)) {
            Criteria convenioDeb = this.getCriteria(query, "convenioDebitoTO");
            convenioDeb.add(this.novoCriterioEQ("id.numeroConvenio", numeroConvenio));
        }
    }

    @Override
    public List<IdentificadorClienteDebitoTO> consultarPeloConvenioESituacao(IdentificadorClienteDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloConvenio(query, decorator.getConvenioTO());
        this.adicionarCriterioConsultarPelaSituacao(query, decorator);
        this.aplicarOrdenacao(query, (PluginTODecoratorAbstrato)decorator);
        return query.list();
    }

    @Override
    public IdentificadorClienteDebitoTO listarPeloIdentificador(String textoIdentificador) {
        Criteria query = this.novaCriteria();
        if (!this.isVazio(textoIdentificador)) {
            query.add(this.novoCriterioLike("textoIdentificadorDebito", textoIdentificador));
            List lista = query.list();
            if (lista.size() != 0) {
                return (IdentificadorClienteDebitoTO)lista.get(0);
            }
        }
        return null;
    }

    @Override
    public List<IdentificadorClienteDebitoTO> consultarPeloConvenioESituacaoUltimaRemessaVazio(IdentificadorClienteDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloConvenio(query, decorator.getConvenioTO());
        this.adicionarCriterioConsultarPelaSituacao(query, decorator);
        query.add(Restrictions.isNull((String)"dataAlteracaoRemessa"));
        query.add((Criterion)Restrictions.or((Criterion)this.novoCriterioEQ("numeroAlteracaoRemessa", 0), (Criterion)Restrictions.isNull((String)"numeroAlteracaoRemessa")));
        this.aplicarOrdenacao(query, (PluginTODecoratorAbstrato)decorator);
        return query.list();
    }

    @Override
    public void excluir(ConvenentePessoaTO convenentePessoaTO) {
        String hql = "delete from IdentificadorClienteDebitoTO identTO where identTO.contaCorrenteClienteTO.id.codigoPessoa = :codigoPessoa  and identTO.convenioDebitoTO.id.codigoPessoaConvenente = :codigoPessoaConvenente ";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoa", convenentePessoaTO.getId().getCodigoPessoa());
        query.setInteger("codigoPessoaConvenente", convenentePessoaTO.getId().getCodigoPessoaConvenente());
        int linhasAfetadas = query.executeUpdate();
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> listarIdentificadorClienteDebitoPorConvenioEGrupo(ConvenioTO convenio, GrupoClienteRecebimentoTO grupoClienteRecebimentoTO) {
        Criteria query = this.novaCriteria();
        query.createCriteria("contaCorrenteClienteTO");
        this.adicionarCriterioConsultarPeloConvenio(query, convenio);
        this.adicionarCriterioConsultarPorGrupoClienteRecebimento(query, grupoClienteRecebimentoTO);
        return query.list();
    }

    @Override
    public void excluirPorConvenente(int codigo) {
        String hql = "delete IdentificadorClienteDebitoTO identClientDeb where identClientDeb.convenioDebitoTO.id.codigoPessoaConvenente = :codigoPessoaConvenente";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoaConvenente", codigo);
        query.executeUpdate();
    }

    @Override
    public Collection<IdentificadorClienteDebitoTO> listarAutorizacoesParaDebitoConvenentePor(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        StringBuilder hql = new StringBuilder("");
        hql.append(" select identificadorClienteDebitoTO from IdentificadorClienteDebitoTO identificadorClienteDebitoTO  join identificadorClienteDebitoTO.convenioDebitoTO objConvenioDebitoTO  left outer join identificadorClienteDebitoTO.membroGrupoClienteRecebimentoTOs membroGrupoClienteRecebimentoTO  left outer join identificadorClienteDebitoTO.pessoaTO objPessoaTO  where  objPessoaTO.codigoPessoa in ");
        Query query = UtilRestricaoDAO.adicionaFiltroConvenentePessoa((ConvenentePessoaTODecorator)convenentePessoaTODecorator, (boolean)true, (StringBuilder)hql, (HibernateDAO)this);
        return query.list();
    }

    public void montaHQLFiltroConvenio(StringBuilder hql) {
        hql.append(" and objConvenioDebitoTO.id.numeroConvenio =  ? ");
    }

    public void montaHQLFiltroImpressaoDaAutorizacaoDeDebito(StringBuilder hql) {
        hql.append(" and identificadorClienteDebitoTO.indicadorImpressao = ? ");
    }

    public void montaHQLFiltroTextoIdentificadorDeDebito(StringBuilder hql) {
        hql.append(" and identificadorClienteDebitoTO.textoIdentificadorDebito = ? ");
    }

    public void montaHQLFiltroSituacaoAutorizacaoDeDebito(StringBuilder hql) {
        hql.append(" and identificadorClienteDebitoTO.situacaoIdentificadorDebitoTO.textoSituacaoIdentificador = ? ");
    }

    @Override
    public PaginadorTO consultarAutorizacoesParaDebitoConvenentePor(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        return this.novoPaginadorTO(this.listarAutorizacoesParaDebitoConvenentePor(convenentePessoaTODecorator), (PluginTODecoratorAbstrato)convenentePessoaTODecorator);
    }

    public void montaHQLFiltroGrupoClienteRecebimento(StringBuilder hql) {
        hql.append(" and membroGrupoClienteRecebimentoTO.id.codigoGrupoClienteRecebimento = ? ");
    }

    public void montaHQLFiltroSemGrupoClienteRecebimento(StringBuilder hql) {
        hql.append(" and identificadorClienteDebitoTO.membroGrupoClienteRecebimentoTOs is empty ");
    }
}

