/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.integracao.dao;

import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeDouble;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecebimentoDebitoDAOImpl
extends HibernateDAO<RecebimentoDebitoTO, Integer>
implements RecebimentoDebitoDAO {
    protected Integer getChavePrimaria(RecebimentoDebitoTO to) {
        return to.getNumeroRecebimento();
    }

    protected Class<RecebimentoDebitoTO> novoTipoDeObjetoPersistente() {
        return RecebimentoDebitoTO.class;
    }

    @Override
    public PaginadorTO consultarPelaDataDeRecebimentoEConvenente(RecebimentoDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPelaDataDeRecebimento(query, decorator);
        this.adicionarCriterioConsultarPeloConvenente(query, decorator);
        return this.novoPaginadorTO(query, decorator);
    }

    @Override
    public PaginadorTO consultarPelaDataDeRecebimentoConvenioEConvenente(RecebimentoDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPelaDataDeRecebimento(query, decorator);
        this.adicionarCriterioConsultarPeloConvenio(query, decorator);
        this.adicionarCriterioConsultarPeloConvenente(query, decorator);
        return this.novoPaginadorTO(query, decorator);
    }

    @Override
    public List<RecebimentoDebitoTO> consultarPelaConvenioESituacaoRecebimento(RecebimentoDebitoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloConvenio(query, decorator);
        this.adicionarCriterioConsultarPelaSituacaoRecebimento(query, decorator);
        this.aplicarOrdenacao(query, decorator);
        return query.list();
    }

    @Override
    public boolean isExisteRegistro(RecebimentoDebitoTO to) {
        RecebimentoDebitoTODecorator d = this.novoRecebimentoDebitoTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloNumeroDoRecebimento(query, d);
        return !this.isVazio(query.list());
    }

    private void adicionarCriterioConsultarPeloNumeroDoRecebimento(Criteria query, RecebimentoDebitoTODecorator to) {
        Integer codigo = to.getCodigoIdentificadorClienteDebito();
        if (!this.isZero(codigo)) {
            Criteria idfc = this.novaCriteria();
            idfc.add(this.novoCriterioEQ("numeroRecebimento", codigo));
        }
    }

    private void adicionarCriterioConsultarPelaDataDeRecebimento(Criteria query, RecebimentoDebitoTODecorator to) {
        Date dataFinal;
        Date dataInicial = to.getDataRecebimentoInicial();
        if (this.isReferencia(dataInicial, dataFinal = to.getDataRecebimentoFinal())) {
            query.add(this.novoCriterioBetween("dataRecebimento", dataInicial, dataFinal));
        } else if (this.isReferencia(dataInicial)) {
            query.add(this.novoCriterioMaiorIgual("dataRecebimento", dataInicial));
        } else if (this.isReferencia(dataFinal)) {
            query.add(this.novoCriterioMenorIgual("dataRecebimento", dataFinal));
        }
    }

    private void adicionarCriterioConsultarPorValor(Criteria query, RecebimentoDebitoTODecorator to) {
        BigDecimal valorFinal;
        BigDecimal valorInicial = UtilConversorDeDouble.converterParaBigDecimal((double)to.getValorInicial().doubleValue());
        if (this.isReferencia(valorInicial, valorFinal = UtilConversorDeDouble.converterParaBigDecimal((double)to.getValorFinal().doubleValue())) && valorFinal.doubleValue() > 0.0) {
            query.add(this.novoCriterioBetween("valorRecebimento", valorInicial, valorFinal));
        } else if (this.isReferencia(valorInicial)) {
            query.add(this.novoCriterioMaiorIgual("valorRecebimento", valorInicial));
        } else if (this.isReferencia(valorFinal)) {
            query.add(this.novoCriterioMenorIgual("valorRecebimento", valorFinal));
        }
    }

    private void adicionarCriterioConsultarPeloConvenente(Criteria query, RecebimentoDebitoTODecorator decorator) {
        Integer codigo = decorator.getCodigoPessoaConvenente();
        if (!this.isZero(codigo)) {
            Criteria idfrCliente = this.getCriteria(query, "convenioDebitoTO");
            Criteria convenioDebito = this.getCriteria(idfrCliente, "convenioDebitoTO");
            convenioDebito.add(this.novoCriterioEQ("id.codigoPessoaConvenente", codigo));
        }
    }

    private RecebimentoDebitoTODecorator novoRecebimentoDebitoTODecorator(RecebimentoDebitoTO to) {
        return DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator(to);
    }

    @Override
    public boolean isExisteRegistroComTextoIdentificador(RecebimentoDebitoTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("textoIdentificadorRegistro", to.getTextoIdentificadorRegistro()));
        return !this.isVazio(query.list());
    }

    @Override
    public PaginadorTO consultarPorFiltro(RecebimentoDebitoTODecorator to) {
        Criteria query = this.getCriterioConsultarPorFiltro(to);
        return this.novoPaginadorTO(query, to);
    }

    @Override
    public List<RecebimentoDebitoTO> consultarPorFiltroSemPaginacaoImpressao(RecebimentoDebitoTODecorator to) {
        Criteria query = this.getCriterioConsultarPorFiltro(to);
        this.aplicarOrdenacao(query, to);
        return query.list();
    }

    @Override
    public PaginadorTO consultarFiltroDiferenteG(RecebimentoDebitoTODecorator to) {
        Criteria query = this.getCriterioConsultarPorFiltro(to);
        Criteria identificadorCliDeb = this.getCriteria(query, "situacaoRecebimentoTO");
        identificadorCliDeb.add(this.novoCriterioNE("codigoSituacaoRecebimento", Character.valueOf('G')));
        return this.novoPaginadorTO(query, to);
    }

    @Override
    public List<RecebimentoDebitoTO> listarPorFiltro(RecebimentoDebitoTODecorator to) {
        Criteria query = this.getCriterioConsultarPorFiltro(to);
        this.adicionarOrderByDataRecebimentoDebito(query, to);
        return query.list();
    }

    private Criteria getCriterioConsultarPorFiltro(RecebimentoDebitoTODecorator to) {
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPeloConvenente(query, to);
        this.adicionarCriterioConsultarPeloConvenio(query, to);
        this.adicionarCriterioConsultarPorGrupoClienteRecebimento(query, to.getGrupoClienteRecebimentoTO());
        this.adicionarCriterioConsultarPelaSituacaoRecebimento(query, to);
        this.adicionarCriterioConsultarPeloIdentificaodor(query, to);
        this.adicionarCriterioConsultarPelaIdentificacaoParaDebito(query, to);
        this.adicionarCriterioConsultarPeloNomePessoa(query, to);
        this.adicionarCriterioConsultarPelaDataDeRecebimento(query, to);
        this.adicionarCriterioConsultarPorValor(query, to);
        this.adicionarCriterioConsultarPelaAgencia(query, to);
        this.adicionarCriterioConsultarPelaContaCorrente(query, to);
        this.adicionarCriterioConsultarPelaDataRemessa(query, to);
        this.adicionarCriterioConsultarPelNumeroRemessa(query, to);
        this.adicionarCriterioConsultarPeloIdentificadorProprio(query, to);
        this.adicionarCriterioConsultarPelaDataInicialEFinal(query, to);
        return query;
    }

    @Override
    public BigDecimal totalizarValorRecebimentoPorFiltro(RecebimentoDebitoTODecorator to) {
        Criteria query = this.getCriterioConsultarPorFiltro(to);
        query.setProjection((Projection)Projections.sum((String)"valorRecebimento"));
        List colecao = query.list();
        BigDecimal total = (BigDecimal)UtilColecao.getElementoDoIndice((Collection)colecao, (int)0);
        return total;
    }

    private void adicionarOrderByDataRecebimentoDebito(Criteria query, RecebimentoDebitoTODecorator to) {
        this.aplicarOrdenacao(query, this.novaOrdenacaoASC("dataRecebimento"));
    }

    private void adicionarCriterioConsultarPelaDataRemessa(Criteria query, RecebimentoDebitoTODecorator to) {
        Date dataRemessa = to.getDataRemessa();
        Criteria remessa = this.getCriteria(query, "remessaTO", 1);
        if (this.isReferencia(dataRemessa)) {
            remessa.add(this.novoCriterioEQ("id.dataRemessa", dataRemessa));
        }
    }

    private void adicionarCriterioConsultarPelNumeroRemessa(Criteria query, RecebimentoDebitoTODecorator to) {
        Integer numeroRemessa = to.getNumeroRemessa();
        Criteria remessa = this.getCriteria(query, "remessaTO", 1);
        if (this.isReferencia(numeroRemessa)) {
            remessa.add(this.novoCriterioEQ("id.numeroRemessa", numeroRemessa));
        }
    }

    private void adicionarCriterioConsultarPelaDataInicialEFinal(Criteria query, RecebimentoDebitoTODecorator to) {
        Date dataDebitoInicial = to.getDataDebitoInicial();
        Date dataDebitoFinal = to.getDataDebitoFinal();
        if (this.isReferencia(dataDebitoInicial) && this.isReferencia(dataDebitoFinal)) {
            query.add(this.novoCriterioBetween("dataDebito", dataDebitoInicial, dataDebitoFinal));
        }
    }

    private void adicionarCriterioConsultarPeloNomePessoa(Criteria query, RecebimentoDebitoTODecorator to) {
        String textoNome = to.getTextoNome();
        if (this.isReferencia(textoNome)) {
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            Criteria cc = this.getCriteria(identificadorCliDeb, "contaCorrenteClienteTO");
            Criteria pss = this.getCriteria(cc, "pessoaTO");
            pss.add(this.novoCriterioLike("textoNome", textoNome));
        }
    }

    private void adicionarCriterioConsultarPelaSituacaoRecebimentoDouO(Criteria query) {
        Criteria identificadorCliDeb = this.getCriteria(query, "situacaoRecebimentoTO");
        identificadorCliDeb.add(this.novoCriterioEQ("codigoSituacaoRecebimento", Character.valueOf('D')));
        identificadorCliDeb.add(this.novoCriterioEQ("codigoSituacaoRecebimento", Character.valueOf('O')));
    }

    private void adicionarCriterioConsultarPelaSituacaoRecebimento(Criteria query, RecebimentoDebitoTODecorator to) {
        SituacaoRecebimentoTO situacaoRecebimentoTO = to.getSituacaoRecebimentoTO();
        if (this.isReferencia(situacaoRecebimentoTO.getCodigoSituacaoRecebimento())) {
            Criteria identificadorCliDeb = this.getCriteria(query, "situacaoRecebimentoTO");
            identificadorCliDeb.add(this.novoCriterioEQ("codigoSituacaoRecebimento", situacaoRecebimentoTO.getCodigoSituacaoRecebimento()));
        }
    }

    private void adicionarCriterioConsultarPelaIdentificacaoParaDebito(Criteria query, RecebimentoDebitoTODecorator to) {
        String textoIdentificadorDebito = to.getIdentificadorClienteDebitoTO().getTextoIdentificadorDebito();
        if (this.isReferencia(textoIdentificadorDebito)) {
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            identificadorCliDeb.add(this.novoCriterioEQ("textoIdentificadorDebito", textoIdentificadorDebito));
        }
    }

    private void adicionarCriterioConsultarPelaContaCorrente(Criteria query, RecebimentoDebitoTODecorator to) {
        Long codigoContaCorrente = to.getContaCorrenteClienteTOId().getCodigoContaCorrente();
        Character caracter = to.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente();
        if (this.isReferencia(codigoContaCorrente) && codigoContaCorrente.intValue() > 0) {
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            Criteria cc = this.getCriteria(identificadorCliDeb, "contaCorrenteClienteTO");
            cc.add(this.novoCriterioEQ("id.codigoContaCorrente", codigoContaCorrente));
            if (this.isReferencia(caracter)) {
                cc.add(this.novoCriterioEQ("digitoVerificadorContaCorrente", caracter));
            }
        }
    }

    private void adicionarCriterioConsultarPelaAgencia(Criteria query, RecebimentoDebitoTODecorator to) {
        Integer codigoAgencia = to.getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia();
        if (this.isReferencia(codigoAgencia) && codigoAgencia > 0) {
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            Criteria cc = this.getCriteria(identificadorCliDeb, "contaCorrenteClienteTO");
            Criteria ag = this.getCriteria(cc, "agenciaInstituicaoFinanceiraTO");
            ag.add(this.novoCriterioEQ("id.codigoAgencia", codigoAgencia));
        }
    }

    private void adicionarCriterioConsultarPeloTipoDocumento(Criteria query, RecebimentoDebitoTODecorator to) {
        Integer codigoTipoDocumento;
        if (this.isReferencia(to.getIdentificacaoTO()) && this.isReferencia(codigoTipoDocumento = to.getIdentificacaoTO().getTipoDocumentoTO().getCodigoTipoDocumento())) {
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            Criteria cc = this.getCriteria(identificadorCliDeb, "contaCorrenteClienteTO");
            Criteria pss = this.getCriteria(cc, "pessoaTO");
            Criteria ids = this.getCriteria(pss, "identificacaoTOs");
            Criteria identificador = this.getCriteria(ids, "identificadorTO");
            Criteria tipoDoc = this.getCriteria(identificador, "tipoDocumentoTO");
            tipoDoc.add(this.novoCriterioEQ("codigoTipoDocumento", codigoTipoDocumento));
        }
    }

    private void adicionarCriterioConsultarPorGrupoClienteRecebimento(Criteria query, GrupoClienteRecebimentoTO grupoClienteRecebimento) {
        if (grupoClienteRecebimento == null) {
            return;
        }
        Integer codigo = grupoClienteRecebimento.getCodigoGrupoClienteRecebimento();
        Criteria ident = this.getCriteria(query, "identificadorClienteDebitoTO");
        if (!this.isZero(codigo) && codigo != 9999) {
            Criteria membroGrupo = this.getCriteria(ident, "membroGrupoClienteRecebimentoTOs");
            membroGrupo.add(this.novoCriterioEQ("id.codigoGrupoClienteRecebimento", codigo));
        } else if (!this.isZero(codigo) && codigo == 9999) {
            ident.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"membroGrupoClienteRecebimentoTOs"), (Criterion)Restrictions.isEmpty((String)"membroGrupoClienteRecebimentoTOs")));
        }
    }

    private void adicionarCriterioConsultarPeloConvenio(Criteria query, RecebimentoDebitoTODecorator to) {
        if (to.getConvenioTO().getNumeroConvenio() == null) {
            return;
        }
        Integer numeroConvenio = to.getConvenioTO().getId().getNumeroConvenio();
        if (this.isReferencia(numeroConvenio)) {
            Criteria convenioDeb = this.getCriteria(query, "convenioDebitoTO");
            convenioDeb.add(this.novoCriterioEQ("id.numeroConvenio", numeroConvenio));
        }
    }

    private void adicionarCriterioConsultarPeloIdentificaodor(Criteria query, RecebimentoDebitoTODecorator to) {
        String identificacao;
        IdentificacaoTO identificacaoTO = to.getIdentificacaoTO();
        String string = identificacao = this.isReferencia(identificacaoTO) ? identificacaoTO.getTextoIdentificacao() : null;
        if (!this.isVazio(identificacao)) {
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            Criteria cc = this.getCriteria(identificadorCliDeb, "contaCorrenteClienteTO");
            Criteria pss = this.getCriteria(cc, "pessoaTO");
            Criteria ids = this.getCriteria(pss, "identificacaoTOs");
            ids.add(this.novoCriterioEQ("id.textoIdentificacao", identificacao));
        }
    }

    private void adicionarCriterioConsultarPeloIdentificadorProprio(Criteria query, RecebimentoDebitoTODecorator to) {
        String identificadorProprio = to.getIdentificadorProprio();
        IdentificadorTO identificadorTO = to.getConvenenteTO().getIdentificadorTO();
        if (!this.isVazio(identificadorProprio) && identificadorTO != null) {
            Integer codigoTipoDocumento = identificadorTO.getId().getCodigoTipoDocumento();
            Criteria identificadorCliDeb = this.getCriteria(query, "identificadorClienteDebitoTO");
            Criteria cc = this.getCriteria(identificadorCliDeb, "contaCorrenteClienteTO");
            Criteria pss = this.getCriteria(cc, "pessoaTO");
            Criteria ids = this.getCriteria(pss, "identificacaoTOs");
            ids.add(this.novoCriterioEQ("id.textoIdentificacao", identificadorProprio));
            ids.add(this.novoCriterioEQ("id.codigoTipoDocumento", codigoTipoDocumento));
        }
    }

    @Override
    public List<RemessaTODecorator> consultaRecebimentosSituacaoGravado() {
        String sql = " select conv.id.numeroConvenio,     rec.situacaoRecebimentoTO.codigoSituacaoRecebimento,\t\tcount(rec.numeroRecebimento) as qtd,\t\tsum(rec.valorRecebimento) as valor from RecebimentoDebitoTO rec  inner join rec.convenioDebitoTO conv  where rec.situacaoRecebimentoTO.codigoSituacaoRecebimento='G' group by conv.id.numeroConvenio,      rec.situacaoRecebimentoTO.codigoSituacaoRecebimento";
        Query query = this.novaQuery(sql);
        List resultado = query.list();
        return this.converterColecao(resultado);
    }

    private List<RemessaTODecorator> converterColecao(List<Object> resultado) {
        ArrayList<RemessaTODecorator> retorno = new ArrayList<RemessaTODecorator>();
        for (Object o : resultado) {
            Object[] array = (Object[])o;
            RemessaTODecorator to = new RemessaTODecorator();
            to.setNumeroConvenio(((Integer)array[0]).intValue());
            to.setTextoIdentificadorServico("DBT");
            Long lancamentos = (Long)array[2];
            to.setNumeroLancamentos(lancamentos.intValue());
            to.setSomaValoresDeRemessa((BigDecimal)array[3]);
            retorno.add(to);
        }
        return retorno;
    }

    @Override
    public RecebimentoDebitoTO consultarPeloIDRegistro(String IdentificadorRegistro) {
        Query query = this.novaQuery(this.getSQLConsultarPeloIDRegistro());
        query.setString("textoIdentificadorRegistro", IdentificadorRegistro);
        query.setMaxResults(1);
        return (RecebimentoDebitoTO)query.uniqueResult();
    }

    private String getSQLConsultarPeloIDRegistro() {
        return "select objRecebimentoDebitoTO from RecebimentoDebitoTO objRecebimentoDebitoTO where objRecebimentoDebitoTO.textoIdentificadorRegistro = :textoIdentificadorRegistro ";
    }

    @Override
    public boolean isExisteLancamentos(ConvenentePessoaTO convenentePessoaTO) {
        Criteria query = this.novaCriteria();
        query.setProjection((Projection)Projections.count((String)"numeroRecebimento"));
        Criteria idfrCliente = this.getCriteria(query, "convenioDebitoTO");
        Criteria convenioDebito = this.getCriteria(idfrCliente, "convenioDebitoTO");
        convenioDebito.add(this.novoCriterioEQ("id.codigoPessoaConvenente", convenentePessoaTO.getId().getCodigoPessoaConvenente()));
        Criteria idfrIdentificador = this.getCriteria(query, "identificadorClienteDebitoTO");
        Criteria contaCorrente = this.getCriteria(idfrIdentificador, "contaCorrenteClienteTO");
        contaCorrente.add(this.novoCriterioEQ("id.codigoPessoa", convenentePessoaTO.getId().getCodigoPessoa()));
        List colecao = query.list();
        Integer numeroLancamentos = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, (int)0);
        return numeroLancamentos > 0;
    }

    @Override
    public boolean isExisteLancamentosComRemessa(RemessaTO to) {
        Criteria query = this.novaCriteria();
        query.setProjection((Projection)Projections.count((String)"numeroRecebimento"));
        Criteria remessa = this.getCriteria(query, "remessaTO");
        remessa.add(this.novoCriterioEQ("id.numeroRemessa", to.getId().getNumeroRemessa()));
        remessa.add(this.novoCriterioEQ("id.numeroConvenio", to.getId().getNumeroConvenio()));
        remessa.add(this.novoCriterioEQ("id.codigoPessoaConvenente", to.getId().getCodigoPessoaConvenente()));
        remessa.add(this.novoCriterioEQ("id.textoIdentificadorServico", to.getId().getTextoIdentificadorServico()));
        remessa.add(this.novoCriterioEQ("id.dataRemessa", to.getId().getDataRemessa()));
        List colecao = query.list();
        Integer numeroLancamentos = (Integer)UtilColecao.getElementoDoIndice((Collection)colecao, (int)0);
        return numeroLancamentos > 0;
    }

    @Override
    public void excluirPorConvenente(int codigo) {
        String hql = "delete from RecebimentoDebitoTO  where convenioDebitoTO.id.codigoPessoaConvenente = :codigoPessoaConvenente";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoaConvenente", codigo);
        query.executeUpdate();
    }

    protected PaginadorTO novoPaginadorTO(Criteria query, RecebimentoDebitoTODecorator decorator) {
        PaginadorTO to = this.novoPaginadorTOSemResultado(query, decorator);
        this.aplicarOrdenacao(query, decorator);
        to.setColecaoDeRegistros((Collection)query.list());
        return to;
    }

    protected PaginadorTO novoPaginadorTOSemResultado(Criteria query, RecebimentoDebitoTODecorator decorator) {
        PaginadorTO to = this.getTOFactory().novoPaginadorTO();
        if (decorator.isAcaoBotaoConsultar()) {
            to.setTotalDeRegistros(this.getTotalDeRegistros(query));
            decorator.setTotalDeRegistros(to.getTotalDeRegistros());
            decorator.setAcaoBotaoConsultar(false);
        } else {
            to.setTotalDeRegistros(decorator.getTotalDeRegistros());
        }
        this.aplicarPaginacao(query, decorator);
        to.setPaginaAtual(decorator.getPaginaAtual());
        return to;
    }
}

