/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.GrupoClienteRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.MembroGrupoClienteRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.to.decorator.ConfigurarAplicativoDecorator;
import br.com.bb.plugins.dbt.util.objecttablemodel.DadosConfigurarAplicativo;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.ComplementoPessoaFisicaDAO;
import br.com.bb.plugins.gac.integracao.dao.ComplementoPessoaJuridicaDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenenteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificadorDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificadorProprioConvenenteServicoDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoConvenenteDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.integracao.dao.TipoDocumentoDAO;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoAplicacaoDAO;
import br.com.bb.plugins.gac.negocio.model.ManterCadastroPessoaJuridicaModel;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.CapacidadeCivilTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ContatoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.EstadoCivilTO;
import br.com.bb.plugins.gac.negocio.to.FormacaoTO;
import br.com.bb.plugins.gac.negocio.to.GrauInstrucaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorProprioConvenenteServicoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.NacionalidadeTO;
import br.com.bb.plugins.gac.negocio.to.NaturezaOcupacaoTO;
import br.com.bb.plugins.gac.negocio.to.NivelCargoTO;
import br.com.bb.plugins.gac.negocio.to.OcupacaoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ServicoConvenenteTOId;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoImovelTO;
import br.com.bb.plugins.gac.negocio.to.TipoContratoTrabalhoTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.CampoConfigurarFuncionalidadeTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.ConfigurarFuncionalidadeNegocioDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.ConfigurarFuncionalidadeTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificacaoTODecorator;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.UtilIdentificadorProprio;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.dominio.UtilDominioConfigurarFuncionalidade;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurarFuncionalidadeModel
extends PluginModelAbstrato {
    private ConvenioDebitoDAO convenioDebitoDAO;
    private PessoaDAO pessoaDAO;
    private ConvenentePessoaDAO convenentePessoaDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private TipoDocumentoDAO tipoDocumentoDAO;
    private ConvenenteDAO convenenteDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private ServicoDAO servicoDAO;
    private ConvenioDAO convenioDAO;
    private RemessaDAO remessaDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private ComplementoPessoaFisicaDAO complementoPessoaFisicaDAO;
    private ComplementoPessoaJuridicaDAO complementoPessoaJuridicaDAO;
    private ServicoAplicacaoDAO servicoAplicacaoDAO;
    private IdentificadorProprioConvenenteServicoDAO identificadorProprioConvenenteServicoDAO;
    private IdentificadorDAO identificadorDAO;
    private ServicoConvenenteDAO servicoConvenenteDAO;
    private MembroGrupoClienteRecebimentoDAO membroGrupoClienteRecebimentoDAO;
    private GrupoClienteRecebimentoDAO grupoClienteRecebimentoDAO;
    private IdentificacaoDAO identificacaoDAO;
    private PessoaTO pessoaTO;
    private IdentificacaoTO identificacaoTO;
    private ConvenioTO convenioTO;
    private ContaCorrenteClienteTO contaCorrenteClienteTO;
    private ConvenenteTO convenenteTO;
    private AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO;
    private ConvenioDebitoTO convenioDebitoTO;
    private ServicoConvenenteTO servicoConvenenteTO;
    private UtilDominioConfigurarFuncionalidade utilDominioConfigurarFuncionalidade;
    private Map<String, CampoConfigurarFuncionalidadeTODecorator> mapaCamposConfigurarFuncionalidade;
    private ConfigurarFuncionalidadeTODecorator configurarFuncionalidadeTODecorator;
    private String[] nomeColunas = new String[]{"N\u00ba Conv\u00eanio", "Ag\u00eancia", "Conta"};
    private int[] tamanhoColunas = new int[]{150, 150, 200};
    private int[] alinhamentoColunas;

    public ConfigurarFuncionalidadeModel() {
        int[] nArray = new int[3];
        nArray[2] = 2;
        this.alinhamentoColunas = nArray;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public UtilDominioConfigurarFuncionalidade getUtilDominioConfigurarFuncionalidade() {
        return this.utilDominioConfigurarFuncionalidade;
    }

    public void setUtilDominioConfigurarFuncionalidade(UtilDominioConfigurarFuncionalidade utilDominioConfigurarFuncionalidade) {
        this.utilDominioConfigurarFuncionalidade = utilDominioConfigurarFuncionalidade;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public TipoDocumentoDAO getTipoDocumentoDAO() {
        return this.tipoDocumentoDAO;
    }

    public void setTipoDocumentoDAO(TipoDocumentoDAO tipoDocumentoDAO) {
        this.tipoDocumentoDAO = tipoDocumentoDAO;
    }

    public ConvenenteDAO getConvenenteDAO() {
        return this.convenenteDAO;
    }

    public void setConvenenteDAO(ConvenenteDAO convenenteDAO) {
        this.convenenteDAO = convenenteDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    public PessoaTO getPessoaTO() {
        if (this.pessoaTO == null) {
            this.pessoaTO = this.getFabricaDeTO().novoPessoaTO();
        }
        return this.pessoaTO;
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public ConvenioTO getConvenioTO() {
        if (this.convenioTO == null) {
            this.convenioTO = this.getFabricaDeTO().novoConvenioTO();
        }
        return this.convenioTO;
    }

    public IdentificacaoTO getIdentificacaoTO() {
        if (this.identificacaoTO == null) {
            this.identificacaoTO = this.getFabricaDeTO().novoIdentificacaoTO();
        }
        return this.identificacaoTO;
    }

    public void setIdentificacaoTO(IdentificacaoTO identificacaoTO) {
        this.identificacaoTO = identificacaoTO;
    }

    public ContaCorrenteClienteTO getContaCorrenteClienteTO() {
        if (this.contaCorrenteClienteTO == null) {
            this.contaCorrenteClienteTO = this.getFabricaDeTO().novoContaCorrenteClienteTO();
        }
        return this.contaCorrenteClienteTO;
    }

    public void setContaCorrenteClienteTO(ContaCorrenteClienteTO contaCorrenteClienteTO) {
        this.contaCorrenteClienteTO = contaCorrenteClienteTO;
    }

    public void setConvenioTO(ConvenioTO convenioTO) {
        this.convenioTO = convenioTO;
    }

    public ConvenenteTO getConvenenteTO() {
        if (this.convenenteTO == null) {
            this.convenenteTO = this.getFabricaDeTO().novoConvenenteTO();
        }
        return this.convenenteTO;
    }

    public void setConvenenteTO(ConvenenteTO convenenteTO) {
        this.convenenteTO = convenenteTO;
    }

    public AgenciaInstituicaoFinanceiraTO getAgenciaInstituicaoFinanceiraTO() {
        if (this.agenciaInstituicaoFinanceiraTO == null) {
            this.agenciaInstituicaoFinanceiraTO = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTO();
        }
        return this.agenciaInstituicaoFinanceiraTO;
    }

    public void setAgenciaInstituicaoFinanceiraTO(AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO) {
        this.agenciaInstituicaoFinanceiraTO = agenciaInstituicaoFinanceiraTO;
    }

    public ConvenioDebitoTO getConvenioDebitoTO() {
        if (this.convenioDebitoTO == null) {
            this.convenioDebitoTO = this.getFabricaDeTO().novoConvenioDebitoTO();
        }
        return this.convenioDebitoTO;
    }

    public void setConvenioDebitoTO(ConvenioDebitoTO convenioDebitoTO) {
        this.convenioDebitoTO = convenioDebitoTO;
    }

    public void gravarDados(ConfigurarFuncionalidadeNegocioDecorator decorator) throws BBException {
        int posicaoProcessamento = 0;
        for (Object dadosConvenio : decorator.getListaDados()) {
            if (!(dadosConvenio instanceof DadosConfigurarAplicativo)) continue;
            DadosConfigurarAplicativo dadosAplicativo = (DadosConfigurarAplicativo)((Object)dadosConvenio);
            this.setAgenciaInstituicaoFinanceiraTO(null);
            this.setConvenioTO(null);
            this.setContaCorrenteClienteTO(null);
            this.setConvenenteTO(null);
            this.setPessoaTO(null);
            this.setIdentificacaoTO(null);
            this.setConvenioDebitoTO(null);
            ConfigurarAplicativoDecorator decoratorAplicativo = dadosAplicativo.getDecorator();
            this.atribuiInscricaoPessoaTO(decoratorAplicativo);
            PessoaTO pessoaTO = this.getPessoaPelaIdentificacao(this.getIdentificacaoTO());
            if (pessoaTO != null) {
                this.getPessoaTO().setCodigoPessoa(pessoaTO.getCodigoPessoa());
                this.getConvenenteTO().setPessoaTO((PessoaTO)this.getPessoaDAO().listar((Object)this.getPessoaTO()));
            } else {
                this.getPessoaTO().setTextoNome(decoratorAplicativo.getNomePessoa());
                this.incluirComplementoPessoa(this.getPessoaTO());
                this.getPessoaTO().setCodigoPessoa(this.getConvenenteTO().getPessoaTO().getCodigoPessoa());
                this.getConvenenteTO().setPessoaTO((PessoaTO)this.getPessoaDAO().listar((Object)this.getPessoaTO()));
            }
            if (posicaoProcessamento == 0 && this.existeConvenente()) {
                ConvenenteTO convenenteTO = null;
                if (this.getConvenenteDAO().isExistePessoa(this.getConvenenteTO())) {
                    convenenteTO = (ConvenenteTO)this.getConvenenteDAO().listar((Object)this.getConvenenteTO());
                    this.getConvenenteTO().setIdentificadorTO(((ConvenenteTO)this.getConvenenteDAO().listar((Object)this.getConvenenteTO())).getIdentificadorTO());
                    this.getConvenenteTO().setTipoDocumentoTO(((ConvenenteTO)this.getConvenenteDAO().listar((Object)this.getConvenenteTO())).getTipoDocumentoTO());
                } else {
                    convenenteTO = new ConvenenteTO();
                }
            }
            this.getConvenenteTO().setIndicadorEstadoConvenente(Character.valueOf('S'));
            this.getConvenenteTO().setTextoIdentificadorTipoComunicacao(Character.valueOf('S'));
            this.getConvenenteTO().setCodigoTipoEmpresa(Integer.valueOf(1));
            this.setConvenenteTO((ConvenenteTO)this.getConvenenteDAO().incluirOuAlterar((Object)this.getConvenenteTO()));
            this.getConvenioTO().setConvenenteTO(this.getConvenenteTO());
            this.atribuiAgenciaConta(decoratorAplicativo);
            this.getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO().getId().setCodigoInstituicaoFinanceira(new Integer(1));
            InstituicaoFinanceiraTO tadias = new InstituicaoFinanceiraTO();
            tadias.setCodigoInstituicaoFinanceira(new Integer(1));
            this.getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO().setInstituicaoFinanceiraTO(tadias);
            this.getContaCorrenteClienteTO().setDigitoVerificadorContaCorrente(Character.valueOf(CalculaDigitoVerificador.calcularModulo11((String)decoratorAplicativo.getNumeroContaCorrente()).charAt(0)));
            this.getConvenioTO().setContaCorrenteClienteTO((ContaCorrenteClienteTO)this.getContaCorrenteClienteDAO().incluirOuAlterar((Object)this.getContaCorrenteClienteTO()));
            this.getConvenioTO().setAgenciaInstituicaoFinanceiraTO(this.getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO());
            this.getConvenioTO().setServicoTO((ServicoTO)this.getServicoDAO().listar((Serializable)((Object)decorator.getNomeServico())));
            this.getConvenioTO().setTextoDescricaoConvenio(this.getConvenioTO().getServicoTO().getTextoDescricao());
            this.getConvenioTO().setIndicadorEstado("1");
            this.getConvenioTO().setValorLimite(new BigDecimal(0));
            this.getConvenioTO().getId().setNumeroConvenio(UtilConversorDeString.converterParaInteger((String)decoratorAplicativo.getNumeroConvenio()));
            this.incluirOuAlteraConvenio(this.getConvenioTO());
            this.atribuiConvenioDebito(decoratorAplicativo);
            this.incluirOuAlteraConvenioDebito();
            this.incluirOuAlterarServicoConvenente();
            ++posicaoProcessamento;
        }
        if (this.verificaVersaoDemonstracao(decorator.getNomeServico())) {
            ServicoConvenenteTO servicoConvenenteTO = TOFactory.getInstancia().novoServicoConvenenteTO();
            ServicoConvenenteTOId servicoConvenenteTOId = new ServicoConvenenteTOId();
            servicoConvenenteTOId.setCodigoPessoaConvenente(Integer.valueOf(400));
            servicoConvenenteTOId.setTextoIdentificadorServico("DBT");
            servicoConvenenteTO.setId(servicoConvenenteTOId);
            if (this.getServicoConvenenteDAO().listar((Object)servicoConvenenteTO) != null) {
                this.getServicoConvenenteDAO().excluir((Object)servicoConvenenteTO);
            }
            this.getRecebimentoDebitoDAO().excluirPorConvenente(400);
            this.getMembroGrupoClienteRecebimentoDAO().excluirTodos();
            this.getGrupoClienteRecebimentoDAO().excluirPorConvenente(400);
            this.getIdentificadorClienteDebitoDAO().excluirPorConvenente(400);
            this.getConvenioDebitoDAO().excluirPorConvenente(400);
            this.removerClientesDemonstracao();
            this.removerIdentificadorDemostracao();
            this.getConvenioDAO().excluirPorConvenenteEServico(400, "DBT");
        }
        this.atualizaRegistroDoAplicativo(decorator);
        this.apagarArquivoDeConfiguracao(decorator);
    }

    private void incluirOuAlterarServicoConvenente() {
        this.atribuiServicoConvenente();
        this.getServicoConvenenteDAO().incluirOuAlterar((Object)this.getServicoConvenenteTO());
    }

    private void atribuiServicoConvenente() {
        ServicoConvenenteTOId servicoConvenenteId = this.getFabricaDeTO().novoServicoConvenenteTOId();
        servicoConvenenteId.setCodigoPessoaConvenente(this.getConvenenteTO().getCodigoPessoaConvenente());
        servicoConvenenteId.setTextoIdentificadorServico("DBT");
        this.setServicoConvenenteTO((ServicoConvenenteTO)this.getServicoConvenenteDAO().listar((Serializable)servicoConvenenteId));
        if (this.getServicoConvenenteTO() == null) {
            ServicoTO servicoTO = (ServicoTO)this.getServicoDAO().listar((Serializable)((Object)"DBT"));
            this.setServicoConvenenteTO(new ServicoConvenenteTO());
            this.getServicoConvenenteTO().setConvenenteTO(this.getConvenenteTO());
            this.getServicoConvenenteTO().setId(servicoConvenenteId);
            this.getServicoConvenenteTO().setServicoTO(servicoTO);
        }
    }

    private void removerIdentificadorDemostracao() {
        IdentificadorTO identificador;
        ConvenenteTO convenenteTODemostracao = this.getFabricaDeTO().novoConvenenteTO();
        convenenteTODemostracao.setCodigoPessoaConvenente(Integer.valueOf(400));
        IdentificadorProprioConvenenteServicoTO identificadorProprioConvenenteServicoTO = UtilIdentificadorProprio.getInstancia().consultaIdentificadorProprioConvenenteServicoPor(convenenteTODemostracao, "DBT");
        IdentificadorTO identificadorTO = identificador = identificadorProprioConvenenteServicoTO != null ? identificadorProprioConvenenteServicoTO.getIdentificadorTO() : null;
        if (this.isReferencia(identificador)) {
            this.getIdentificadorProprioConvenenteServicoDAO().excluir((Object)identificadorProprioConvenenteServicoTO);
            this.getIdentificadorDAO().excluir((Object)identificador);
        }
    }

    private void incluirComplementoPessoa(PessoaTO pessoa) {
        if (this.pessoaTO != null) {
            for (IdentificacaoTO identificacao : this.pessoaTO.getIdentificacaoTOs()) {
                ManterCadastroPessoaJuridicaModel model;
                if (identificacao.getTipoDocumentoTO().getTextoDescricao().equals("CNPJ")) {
                    model = this.getFabricaDeModel().novoManterCadastroPessoaJuridicaModel();
                    ComplementoPessoaJuridicaTO pessoaJuridicaTO = this.getFabricaDeTO().novoComplementoPessoaJuridicaTO();
                    pessoaJuridicaTO.setTextoNome(pessoa.getTextoNome());
                    pessoaJuridicaTO.setLogradouroTOs(pessoa.getLogradouroTOs());
                    pessoaJuridicaTO.setContatoTOs(pessoa.getContatoTOs());
                    pessoaJuridicaTO.setIdentificacaoTOs(pessoa.getIdentificacaoTOs());
                    this.atribuiDataDaUltimaOperacao((PessoaTO)pessoaJuridicaTO);
                    this.atribuiIdContato(pessoaJuridicaTO);
                    this.atribuiTipoPessoa((PessoaTO)pessoaJuridicaTO, 2);
                    this.atribuiPessoaTONaColecaoIdentificacaoTO((PessoaTO)pessoaJuridicaTO);
                    this.atribuiPessoaTONaColecaoContatoTO((PessoaTO)pessoaJuridicaTO);
                    this.atribuiPessoaTONaColecaoLogradouroTO((PessoaTO)pessoaJuridicaTO);
                    this.getConvenenteTO().setPessoaTO((PessoaTO)this.getComplementoPessoaJuridicaDAO().incluir((Object)pessoaJuridicaTO));
                    continue;
                }
                if (identificacao.getTipoDocumentoTO().getTextoDescricao().equals("CPF")) {
                    model = this.getFabricaDeModel().novoManterCadastroPessoaFisicaModel();
                    ComplementoPessoaFisicaTO pessoaFisicaTO = this.getFabricaDeTO().novoComplementoPessoaFisicaTO();
                    pessoaFisicaTO.setTextoNome(pessoa.getTextoNome());
                    pessoaFisicaTO.setLogradouroTOs(pessoa.getLogradouroTOs());
                    pessoaFisicaTO.setContatoTOs(pessoa.getContatoTOs());
                    pessoaFisicaTO.setIdentificacaoTOs(pessoa.getIdentificacaoTOs());
                    this.atribuiValoresPadroes(pessoaFisicaTO);
                    this.atribuiIdContato(pessoaFisicaTO);
                    this.atribuiTipoPessoa((PessoaTO)pessoaFisicaTO, 1);
                    this.atribuiDataDaUltimaOperacao((PessoaTO)pessoaFisicaTO);
                    this.atribuiPessoaTONaColecaoIdentificacaoTO((PessoaTO)pessoaFisicaTO);
                    this.atribuiPessoaTONaColecaoContatoTO((PessoaTO)pessoaFisicaTO);
                    this.atribuiPessoaTONaColecaoLogradouroTO((PessoaTO)pessoaFisicaTO);
                    NacionalidadeTO nacionalidadeTO = this.getFabricaDeTO().novoNacionalidadeTO();
                    nacionalidadeTO.setCodigoNacionalidade(Integer.valueOf(1));
                    pessoaFisicaTO.setNacionalidadeTO(nacionalidadeTO);
                    this.getConvenenteTO().setPessoaTO((PessoaTO)this.getComplementoPessoaFisicaDAO().incluir((Object)pessoaFisicaTO));
                    System.out.println("CPF");
                    continue;
                }
                this.getConvenenteTO().setPessoaTO((PessoaTO)this.getPessoaDAO().incluirOuAlterar((Object)pessoa));
            }
        }
    }

    private void atribuiValoresPadroes(ComplementoPessoaFisicaTO complementoPessoaFisica) {
        complementoPessoaFisica.setPessoaTOByCdPssEpgr((PessoaTO)complementoPessoaFisica);
        complementoPessoaFisica.setCapacidadeCivilTO(new CapacidadeCivilTO());
        complementoPessoaFisica.getCapacidadeCivilTO().setCodigoCapacidadeCivil(Integer.valueOf(0));
        complementoPessoaFisica.setEstadoCivilTO(new EstadoCivilTO());
        complementoPessoaFisica.getEstadoCivilTO().setCodigoEstadoCivil(Integer.valueOf(0));
        complementoPessoaFisica.setFormacaoTO(new FormacaoTO());
        complementoPessoaFisica.getFormacaoTO().setCodigoFormacao(Integer.valueOf(0));
        complementoPessoaFisica.setGrauInstrucaoTO(new GrauInstrucaoTO());
        complementoPessoaFisica.getGrauInstrucaoTO().setCodigoGrauInstrucao(Integer.valueOf(0));
        complementoPessoaFisica.setNaturezaOcupacaoTO(new NaturezaOcupacaoTO());
        complementoPessoaFisica.getNaturezaOcupacaoTO().setCodigoNaturezaOcupacao(Integer.valueOf(0));
        complementoPessoaFisica.setNivelCargoTO(new NivelCargoTO());
        complementoPessoaFisica.getNivelCargoTO().setCodigoNivelCargo(Integer.valueOf(0));
        complementoPessoaFisica.setOcupacaoTO(new OcupacaoTO());
        complementoPessoaFisica.getOcupacaoTO().setCodigoOcupacao(Integer.valueOf(0));
        complementoPessoaFisica.setSituacaoImovelTO(new SituacaoImovelTO());
        complementoPessoaFisica.getSituacaoImovelTO().setCodigoSituacaoImovel(Integer.valueOf(0));
        complementoPessoaFisica.setTipoContratoTrabalhoTO(new TipoContratoTrabalhoTO());
        complementoPessoaFisica.getTipoContratoTrabalhoTO().setCodigoTipoContratoTrabalho(Integer.valueOf(0));
    }

    private void atribuiIdContato(ComplementoPessoaFisicaTO complementoPessoaFisicaTO) {
        int icont = 1;
        for (ContatoTO contatoTO : complementoPessoaFisicaTO.getContatoTOs()) {
            contatoTO.getId().setNumeroIdentificadorContato(Integer.valueOf(icont));
            ++icont;
        }
    }

    protected IdentificacaoTODecorator novoIdentificacaoTODecorator(IdentificacaoTO to) {
        return this.getFabricaDeTO().novoIdentificacaoTODecorator(to);
    }

    protected void atribuiPessoaTONaColecaoLogradouroTO(PessoaTO pessoaTO) {
        Set logradouroTOs = pessoaTO.getLogradouroTOs();
        for (LogradouroTO logradouroTO : logradouroTOs) {
            logradouroTO.setPessoaTO(pessoaTO);
            logradouroTO.setNumeroLogradouro(Integer.valueOf(0));
            logradouroTO.setTextoCep(this.removeMascara(logradouroTO.getTextoCep()));
        }
    }

    private String removeMascara(String valor) {
        String resultado = valor;
        if (!UtilString.isVazio((String)valor)) {
            resultado = UtilString.substituirString((String)valor, (String)"[^0-9]*", (String)"");
        }
        return resultado;
    }

    protected void atribuiPessoaTONaColecaoIdentificacaoTO(PessoaTO pessoaTO) {
        Set identificacaoTOs = pessoaTO.getIdentificacaoTOs();
        for (IdentificacaoTO to : identificacaoTOs) {
            IdentificacaoTODecorator decorator = this.novoIdentificacaoTODecorator(to);
            decorator.setPessoaTO(pessoaTO);
        }
    }

    protected void atribuiPessoaTONaColecaoContatoTO(PessoaTO pessoaTO) {
        Set contatoTOs = pessoaTO.getContatoTOs();
        for (ContatoTO contatoTO : contatoTOs) {
            contatoTO.setPessoaTO(pessoaTO);
        }
    }

    private void atribuiIdContato(ComplementoPessoaJuridicaTO complementoPessoaJuridicaTO) {
        int icont = 1;
        for (ContatoTO contatoTO : complementoPessoaJuridicaTO.getContatoTOs()) {
            contatoTO.getId().setNumeroIdentificadorContato(Integer.valueOf(icont));
            ++icont;
        }
    }

    protected void atribuiDataDaUltimaOperacao(PessoaTO pessoaTO) {
        pessoaTO.setDataUltimaOperacao(new Date());
    }

    protected void atribuiTipoPessoa(PessoaTO pessoaTO, Integer codigoTipoPessoa) {
        pessoaTO.setTipoPessoaTO(new TipoPessoaTO());
        pessoaTO.getTipoPessoaTO().setCodigoTipoPessoa(codigoTipoPessoa);
    }

    public void apagarArquivoDeConfiguracao(ConfigurarFuncionalidadeNegocioDecorator decorator) throws BBException {
        decorator.getArquivoConfiguracao().delete();
    }

    private void removerClientesDemonstracao() throws BBException {
        ConvenentePessoaTOId id = new ConvenentePessoaTOId();
        id.setCodigoPessoaConvenente(400);
        id.setTextoIdentificadorServico("DBT");
        this.getConvenentePessoaDAO().excluirPor(id);
    }

    private void removerConvenenteDemonstracao() throws BBException {
        this.getConvenenteDAO().excluirConvenente(Integer.valueOf(400));
    }

    private boolean existeConvenente() {
        ConvenenteTO to = this.getFabricaDeTO().novoConvenenteTO();
        to.setPessoaTO(this.getPessoaTO());
        return this.getConvenenteDAO().listar((Object)to) != null;
    }

    private void incluirOuAlteraConvenioDebito() {
        this.getConvenioDebitoDAO().incluirOuAlterar(this.getConvenioDebitoTO());
    }

    private void atualizaRegistroDoAplicativo(ConfigurarFuncionalidadeNegocioDecorator decorator) {
        ServicoTO servicoTO = (ServicoTO)this.getServicoDAO().listar((Serializable)((Object)decorator.getNomeServico()));
        servicoTO.setIndicadorEstadoConfiguracaoServico(Character.valueOf('1'));
        this.getServicoDAO().alterar((Object)servicoTO);
    }

    private void atribuiConvenioDebito(ConfigurarAplicativoDecorator decoratorAplicativo) {
        this.getConvenioDebitoTO().setConvenioTO(this.getConvenioTO());
        if (!this.existeConvenioDebito()) {
            this.getConvenioDebitoTO().setNumeroUltimaRemessa(Integer.valueOf(0));
        } else {
            ConvenioDebitoTO debitoTO = (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar((Serializable)this.getConvenioDebitoTO().getId());
            this.getConvenioDebitoTO().setNumeroUltimaRemessa(debitoTO.getNumeroUltimaRemessa());
        }
        int tipoIdentificador = UtilConversorDeString.converterParaInt((String)decoratorAplicativo.getTipoIdentificadorDebito());
        switch (tipoIdentificador) {
            case 0: {
                this.getConvenioDebitoTO().setTextoIdentificadorRegistroDebito("A");
                this.getConvenioDebitoTO().setNumeroTamanhoIdentificadorDebito(Integer.valueOf(25));
                break;
            }
            case 3: 
            case 5: {
                this.getConvenioDebitoTO().setTextoIdentificadorRegistroDebito("N");
                this.getConvenioDebitoTO().setNumeroTamanhoIdentificadorDebito(UtilConversorDeString.converterParaInteger((String)decoratorAplicativo.getTamanhoIdentificadorDebito()));
                break;
            }
            default: {
                this.getConvenioDebitoTO().setTextoIdentificadorRegistroDebito("A");
                this.getConvenioDebitoTO().setNumeroTamanhoIdentificadorDebito(UtilConversorDeString.converterParaInteger((String)decoratorAplicativo.getTamanhoIdentificadorDebito()));
            }
        }
        this.getConvenioDebitoTO().setIndicadorAutorizacao(Character.valueOf('N'));
        this.getConvenioDebitoTO().setCodigoAutorizacao(Integer.valueOf(1));
        this.getConvenioDebitoTO().setIndicadorManutencaoAutomatica(Character.valueOf('N'));
    }

    private boolean existeConvenioDebito() {
        return this.getConvenioDebitoDAO().isExisteConvenioDebito(this.getConvenioDebitoTO());
    }

    private void incluirOuAlteraConvenio(ConvenioTO convenioTO) {
        this.getConvenioDAO().incluirOuAlterar((Object)this.getConvenioTO());
    }

    private void atribuiInscricaoPessoaTO(ConfigurarAplicativoDecorator decoratorAplicativo) {
        String tipoDeInscricao = decoratorAplicativo.getTipoInscricao();
        Integer codigoTipoDocumento = UtilConversorDeInteger.converterParaInteger((String)tipoDeInscricao);
        String inscricao = decoratorAplicativo.getNumeroInscricao();
        this.getIdentificacaoTO().setPessoaTO(this.getPessoaTO());
        this.atribuiTipoDocumentoDaIdentificacao(codigoTipoDocumento, this.getIdentificacaoTO());
        this.atribuiIdentificadorDaIdentificacao(this.getIdentificacaoTO(), this.getIdentificacaoTO().getTipoDocumentoTO());
        TipoPessoaTO tipoPessoaTO = this.getIdentificacaoTO().getTipoDocumentoTO().getTipoPessoaTO();
        if (codigoTipoDocumento == 1) {
            this.getIdentificacaoTO().setTextoIdentificacao(inscricao.substring(3));
        } else {
            this.getIdentificacaoTO().setTextoIdentificacao(inscricao);
        }
        if (UtilColecao.isVazio((Collection)this.getPessoaTO().getIdentificacaoTOs())) {
            this.getPessoaTO().setIdentificacaoTOs(new HashSet());
        }
        this.getPessoaTO().setTipoPessoaTO(tipoPessoaTO);
        this.getPessoaTO().getIdentificacaoTOs().add(this.getIdentificacaoTO());
    }

    private void atribuiAgenciaConta(ConfigurarAplicativoDecorator decoratorAplicativo) {
        this.getAgenciaInstituicaoFinanceiraTO().getId().setCodigoAgencia(UtilConversorDeString.converterParaInteger((String)decoratorAplicativo.getNumeroAgencia()));
        this.getAgenciaInstituicaoFinanceiraTO().getId().setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        this.getAgenciaInstituicaoFinanceiraTO().setDigitoVerificadorAgencia(Character.valueOf(CalculaDigitoVerificador.calcularModulo11((String)decoratorAplicativo.getNumeroAgencia()).charAt(0)));
        this.getAgenciaInstituicaoFinanceiraTO().setTextoDescricao("Ag\u00eancia " + this.getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia() + this.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia());
        this.getContaCorrenteClienteTO().setAgenciaInstituicaoFinanceiraTO(this.getAgenciaInstituicaoFinanceiraTO());
        this.getContaCorrenteClienteTO().getId().setCodigoContaCorrente(UtilConversorDeString.converterParaLong((String)decoratorAplicativo.getNumeroContaCorrente()));
        this.getContaCorrenteClienteTO().getId().setCodigoAgencia(this.getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia());
        this.getContaCorrenteClienteTO().getId().setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        this.getContaCorrenteClienteTO().setPessoaTO(this.getPessoaTO());
    }

    private TipoDocumentoTO atribuiTipoDocumentoDaIdentificacao(Integer codigoTipoDocumento, IdentificacaoTO identificacaoTO) {
        if (codigoTipoDocumento == null) {
            identificacaoTO.setTipoDocumentoTO(null);
            return null;
        }
        TipoDocumentoTO tipoDocumentoTO = null;
        TipoPessoaTO tipoPessoa = new TipoPessoaTO();
        tipoPessoa.setCodigoTipoPessoa(new Integer(codigoTipoDocumento));
        tipoDocumentoTO = codigoTipoDocumento == 1 ? (TipoDocumentoTO)((ArrayList)this.getTipoDocumentoDAO().consultarPorPessoaFisica()).get(0) : (TipoDocumentoTO)((ArrayList)this.getTipoDocumentoDAO().consultarPorPessoaJuridica()).get(0);
        identificacaoTO.setTipoDocumentoTO(tipoDocumentoTO);
        return tipoDocumentoTO;
    }

    private void atribuiIdentificadorDaIdentificacao(IdentificacaoTO identificacaoTO, TipoDocumentoTO tipoDocumentoTO) {
        IdentificadorTO identificador = this.getIdentificadorDoTipoDocumento(tipoDocumentoTO);
        identificacaoTO.setIdentificadorTO(identificador);
    }

    private IdentificadorTO getIdentificadorDoTipoDocumento(TipoDocumentoTO tipoDocumentoTO) {
        Set colecao = tipoDocumentoTO.getIdentificadorTOs();
        IdentificadorTO retorno = null;
        Integer codigoTipoDocumento = tipoDocumentoTO.getCodigoTipoDocumento();
        String nomeIdentificador = null;
        for (IdentificadorTO identificadorTO : colecao) {
            nomeIdentificador = identificadorTO.getNomeIdentificador();
            if (codigoTipoDocumento.equals(UtilDominioTipoDocumento.CPF_PF) && nomeIdentificador.equals("CPF")) {
                retorno = identificadorTO;
                continue;
            }
            if (!codigoTipoDocumento.equals(UtilDominioTipoDocumento.CNPJ_PJ)) continue;
            retorno = identificadorTO;
        }
        return retorno;
    }

    private PessoaTO getPessoaPelaIdentificacao(IdentificacaoTO identificacaoTO) {
        return this.getPessoaDAO().consultarPorIndentificacao(identificacaoTO);
    }

    public ConfigurarFuncionalidadeNegocioDecorator getConfigurarFuncionalidadeDecorator(ConfigurarFuncionalidadeNegocioDecorator decorator) throws BBException {
        decorator.setListaDados(this.leArquivoDeConfiguracao(decorator.getArquivoConfiguracao()));
        if (decorator.getListaDados() != null && decorator.getListaDados().size() > 0) {
            ConfigurarAplicativoDecorator dadosconf = ((DadosConfigurarAplicativo)((Object)decorator.getListaDados().get(0))).getDecorator();
            decorator.setNomePessoa(dadosconf.getNomePessoa());
            decorator.setInscricaoPessoa(dadosconf.getNumeroInscricao());
        }
        decorator.setNomeColunas(this.nomeColunas);
        decorator.setAlinhamentoColunas(this.alinhamentoColunas);
        decorator.setTamanhoColunas(this.tamanhoColunas);
        return decorator;
    }

    public List<DadosConfigurarAplicativo> leArquivoDeConfiguracao(File arquivoConfiguracao) throws BBException {
        ArrayList<DadosConfigurarAplicativo> retorno = new ArrayList<DadosConfigurarAplicativo>();
        BufferedReader bufferedReader = null;
        String linha = null;
        List colecaoDeCampos = this.getUtilDominioConfigurarFuncionalidade().getColecaoDeCampos();
        try {
            try {
                bufferedReader = UtilArquivo.getBufferedReader((File)arquivoConfiguracao);
                while ((linha = bufferedReader.readLine()) != null) {
                    this.inicializaValores();
                    this.criaMapaDeValores(colecaoDeCampos, linha);
                    if (!"HC90".equalsIgnoreCase(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getTransacao()))) {
                        throw new BBException("MN054");
                    }
                    retorno.add(this.novoObjetoConfiguracao());
                }
            }
            catch (IOException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
            }
        }
        return retorno;
    }

    private DadosConfigurarAplicativo novoObjetoConfiguracao() {
        ConfigurarAplicativoDecorator decorator = this.getFabricaTODBT().novoConfigurarAplicativoDecorator();
        decorator.setNomeTransacao(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getTransacao()));
        decorator.setTipoInscricao(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getTipoInscricao()));
        decorator.setNumeroInscricao(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getInscricao()));
        decorator.setNomePessoa(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getNome()));
        decorator.setNumeroAgencia(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getAgencia()));
        decorator.setNumeroContaCorrente(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getConta()));
        decorator.setNumeroConvenio(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getNumeroConvenio()));
        decorator.setTipoIdentificadorDebito(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getTipoIdentificadorDebito()));
        decorator.setTamanhoIdentificadorDebito(this.getCampoNoMapa(this.getUtilDominioConfigurarFuncionalidade().getTamanhoIdentificadorDebito()));
        return new DadosConfigurarAplicativo(decorator);
    }

    private String getCampoNoMapa(String nome) {
        CampoConfigurarFuncionalidadeTODecorator campo = this.getMapaCamposConfigurarFuncionalidade().get(nome);
        return campo.getValor();
    }

    private void inicializaValores() {
        this.setMapaCamposConfigurarFuncionalidade(null);
        this.setConfigurarFuncionalidadeTODecorator(null);
    }

    private void criaMapaDeValores(List<CampoConfigurarFuncionalidadeTODecorator> colecaoCampoConfigurarFuncionalidadeTODecorator, String linha) {
        for (CampoConfigurarFuncionalidadeTODecorator campoConfigurarFuncionalidadeTODecorator : colecaoCampoConfigurarFuncionalidadeTODecorator) {
            int inicio = campoConfigurarFuncionalidadeTODecorator.getPosicaoInicial() - 1;
            int fim = inicio + campoConfigurarFuncionalidadeTODecorator.getTamanho();
            String valor = UtilString.substring((String)linha, (int)inicio, (int)fim);
            valor = UtilString.trim((String)valor);
            campoConfigurarFuncionalidadeTODecorator.setValor(valor);
            this.getMapaCamposConfigurarFuncionalidade().put(campoConfigurarFuncionalidadeTODecorator.getNome(), campoConfigurarFuncionalidadeTODecorator);
        }
    }

    public Map<String, CampoConfigurarFuncionalidadeTODecorator> getMapaCamposConfigurarFuncionalidade() {
        if (this.mapaCamposConfigurarFuncionalidade == null) {
            this.mapaCamposConfigurarFuncionalidade = new HashMap<String, CampoConfigurarFuncionalidadeTODecorator>();
        }
        return this.mapaCamposConfigurarFuncionalidade;
    }

    public void setMapaCamposConfigurarFuncionalidade(Map<String, CampoConfigurarFuncionalidadeTODecorator> mapaCamposConfigurarFuncionalidade) {
        this.mapaCamposConfigurarFuncionalidade = mapaCamposConfigurarFuncionalidade;
    }

    public void setConfigurarFuncionalidadeTODecorator(ConfigurarFuncionalidadeTODecorator configurarFuncionalidadeTODecorator) {
        this.configurarFuncionalidadeTODecorator = configurarFuncionalidadeTODecorator;
    }

    public DBTTOFactory getFabricaTODBT() {
        return DBTTOFactory.getInstancia();
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public ComplementoPessoaFisicaDAO getComplementoPessoaFisicaDAO() {
        return this.complementoPessoaFisicaDAO;
    }

    public void setComplementoPessoaFisicaDAO(ComplementoPessoaFisicaDAO complementoPessoaFisicaDAO) {
        this.complementoPessoaFisicaDAO = complementoPessoaFisicaDAO;
    }

    public ComplementoPessoaJuridicaDAO getComplementoPessoaJuridicaDAO() {
        return this.complementoPessoaJuridicaDAO;
    }

    public void setComplementoPessoaJuridicaDAO(ComplementoPessoaJuridicaDAO complementoPessoaJuridicaDAO) {
        this.complementoPessoaJuridicaDAO = complementoPessoaJuridicaDAO;
    }

    public boolean verificaVersaoDemonstracao(String nomeModulo) throws BBException {
        ServicoAplicacaoTO servicoAplicacaoTO = this.getServicoAplicacaoDAO().consultarServico(nomeModulo);
        return servicoAplicacaoTO == null || servicoAplicacaoTO != null && !"1".equalsIgnoreCase(servicoAplicacaoTO.getIndicadorEstadoConfiguracaoServico());
    }

    public ServicoAplicacaoDAO getServicoAplicacaoDAO() {
        if (this.servicoAplicacaoDAO == null) {
            this.servicoAplicacaoDAO = new ServicoAplicacaoDAO();
        }
        return this.servicoAplicacaoDAO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public void setIdentificadorProprioConvenenteServicoDAO(IdentificadorProprioConvenenteServicoDAO identificadorProprioConvenenteServicoDAO) {
        this.identificadorProprioConvenenteServicoDAO = identificadorProprioConvenenteServicoDAO;
    }

    public IdentificadorProprioConvenenteServicoDAO getIdentificadorProprioConvenenteServicoDAO() {
        return this.identificadorProprioConvenenteServicoDAO;
    }

    public void setIdentificadorDAO(IdentificadorDAO identificadorDAO) {
        this.identificadorDAO = identificadorDAO;
    }

    public IdentificadorDAO getIdentificadorDAO() {
        return this.identificadorDAO;
    }

    public void setServicoConvenenteDAO(ServicoConvenenteDAO servicoConvenenteDAO) {
        this.servicoConvenenteDAO = servicoConvenenteDAO;
    }

    public ServicoConvenenteDAO getServicoConvenenteDAO() {
        return this.servicoConvenenteDAO;
    }

    public void setServicoConvenenteTO(ServicoConvenenteTO servicoConvenenteTO) {
        this.servicoConvenenteTO = servicoConvenenteTO;
    }

    public ServicoConvenenteTO getServicoConvenenteTO() {
        return this.servicoConvenenteTO;
    }

    public void setMembroGrupoClienteRecebimentoDAO(MembroGrupoClienteRecebimentoDAO membroGrupoClienteRecebimentoDAO) {
        this.membroGrupoClienteRecebimentoDAO = membroGrupoClienteRecebimentoDAO;
    }

    public MembroGrupoClienteRecebimentoDAO getMembroGrupoClienteRecebimentoDAO() {
        return this.membroGrupoClienteRecebimentoDAO;
    }

    public GrupoClienteRecebimentoDAO getGrupoClienteRecebimentoDAO() {
        return this.grupoClienteRecebimentoDAO;
    }

    public void setGrupoClienteRecebimentoDAO(GrupoClienteRecebimentoDAO grupoClienteRecebimentoDAO) {
        this.grupoClienteRecebimentoDAO = grupoClienteRecebimentoDAO;
    }

    public IdentificacaoDAO getIdentificacaoDAO() {
        return this.identificacaoDAO;
    }

    public void setIdentificacaoDAO(IdentificacaoDAO identificacaoDAO) {
        this.identificacaoDAO = identificacaoDAO;
    }
}

