/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ExecutarExpurgoAutomaticoDAO;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.generico.calculadores.UtilSubtratoresDeData;
import br.com.politec.generico.fabrica.DataFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutarExpurgoAutomaticoModel
extends PluginModelAbstrato {
    private ExecutarExpurgoAutomaticoDAO expurgoAutomaticoDAO;
    private ServicoDAO servicoDAO;

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public int expurgaListaDeRecebimentos(Collection<RecebimentoDebitoTO> lista) throws BBException {
        return this.getExpurgoAutomaticoDAO().expurgaListaDeRecebimentos(lista);
    }

    public int consultaNumeroDiasRetencaoDados() throws BBException {
        return this.getExpurgoAutomaticoDAO().consultaNumeroDiasRetencaoDados();
    }

    public Collection<RecebimentoDebitoTO> consultaRecebimentosParaExpurgo() throws BBException {
        return this.getExpurgoAutomaticoDAO().consultaRecebimentosParaExpurgo();
    }

    public void atualizaDataUltimaExclusao() throws BBException {
        this.getExpurgoAutomaticoDAO().atualizaDataUltimaExclusao();
    }

    protected UtilArquivoConfiguracao getUtilArquivoConfiguracao() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public Date getDataAtual() {
        return DataFactory.getInstance().novoDate();
    }

    public ExecutarExpurgoAutomaticoDAO getExpurgoAutomaticoDAO() {
        if (this.expurgoAutomaticoDAO == null) {
            this.expurgoAutomaticoDAO = new ExecutarExpurgoAutomaticoDAO();
        }
        return this.expurgoAutomaticoDAO;
    }

    public void setExpurgoAutomaticoDAO(ExecutarExpurgoAutomaticoDAO expurgoAutomaticoDAO) {
        this.expurgoAutomaticoDAO = expurgoAutomaticoDAO;
    }

    public void executar() throws BBException {
        ArrayList<RecebimentoDebitoTO> novaLista = new ArrayList<RecebimentoDebitoTO>();
        for (RecebimentoDebitoTO rcbt : this.consultaRecebimentosParaExpurgo()) {
            long diferenca = UtilSubtratoresDeData.getDiasEntreDatas((Date)rcbt.getDataRecebimento(), (Date)this.getDataAtual());
            if (Math.abs(diferenca) <= (long)this.consultaNumeroDiasRetencaoDados()) continue;
            novaLista.add(rcbt);
        }
        int ret = this.expurgaListaDeRecebimentos(novaLista);
        if (ret > 0) {
            this.atualizaDataUltimaExclusao();
            BBJPopupMensagem.exibirMensagemSucesso((String)("Foram expurgados " + ret + " recebimentos."));
        } else if (ret <= 0) {
            BBJPopupMensagem.exibirMensagemErro((String)"N\u00e3o existem recebimentos para expurgo.");
        }
    }
}

