/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.CamposLeiauteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.CamposLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaFisicaTO;
import br.com.bb.plugins.gac.negocio.to.ComplementoPessoaJuridicaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.NacionalidadeTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.negocio.to.TipoLogradouroTO;
import br.com.bb.plugins.gac.negocio.to.UnidadeFederativaBrasilTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.data.UtilData;
import br.com.politec.generico.formatador.UtilFormatadorDeCPFouCNPJ;
import br.com.politec.generico.string.UtilString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportarDadosDebitoClienteModel
extends PluginModelAbstrato {
    private ConvenentePessoaDAO convenentePessoaDAO;
    private CamposLeiauteDAO camposLeiauteDAO;
    private PessoaDAO pessoaDAO;

    public PaginadorTO consultarPorFiltro(ConvenentePessoaTODecorator decorator) {
        PaginadorTO paginador = this.getPessoaDAO().consultarClientesPaginador(decorator);
        return paginador;
    }

    public boolean exportarDadosCliente(ConvenentePessoaTODecorator convenentePessoaTODecorator, LeiauteTO leiauteTO, String pastaDestinoExportacao) throws BBException {
        File destinodir = new File(pastaDestinoExportacao);
        if (destinodir.isDirectory()) {
            Collection colecaoDadosClientes = this.getConvenentePessoaDAO().consultarPorFiltroRetornandoColecao(convenentePessoaTODecorator);
            try {
                this.montarArquivoExportacao(convenentePessoaTODecorator, colecaoDadosClientes, leiauteTO, pastaDestinoExportacao);
            }
            catch (FileNotFoundException e) {
                throw new BBException("erro.de.sistema");
            }
            catch (IOException e) {
                throw new BBException("erro.de.sistema");
            }
            return true;
        }
        return false;
    }

    private Collection<CamposLeiauteTO> recuperaCamposLeiaute(TipoLeiauteTO tipoLeiauteTO) {
        tipoLeiauteTO.getServicoTO().setTextoIdentificadorServico("DBT");
        tipoLeiauteTO.setTextoTipoOperacao("EXP");
        return this.getCamposLeiauteDAO().consultarPorTipoDeLeiaute(tipoLeiauteTO);
    }

    private void montarArquivoExportacao(ConvenentePessoaTODecorator convenentePessoaTODecorator, Collection<ConvenentePessoaTO> colecaoDadosClientes, LeiauteTO leiauteTO, String pastaDestinoExportacao) throws FileNotFoundException, IOException {
        Set colecaoCamposLeiauteTO = leiauteTO.getCamposLeiauteTOs();
        int registroAtual = 1;
        int totalRegistros = colecaoDadosClientes.size();
        this.criaPastasSeNecessario(pastaDestinoExportacao);
        BufferedWriter bufferedWriter = this.getBufferedWriter(pastaDestinoExportacao);
        for (ConvenentePessoaTO convenentePessoaTO : colecaoDadosClientes) {
            bufferedWriter.write(this.geraNovaLinhaArquivo(convenentePessoaTO, colecaoCamposLeiauteTO));
            bufferedWriter.newLine();
            this.atualizaPorcentagem(convenentePessoaTODecorator.getNotificaExportacao(), totalRegistros, registroAtual);
            ++registroAtual;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private BufferedWriter getBufferedWriter(String pastaDestinoExportacao) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getPathArquivoExportacao(pastaDestinoExportacao))));
    }

    private String geraNovaLinhaArquivo(ConvenentePessoaTO convenentePessoaTO, Collection<CamposLeiauteTO> camposLeiaute) {
        StringBuffer novaLinha = new StringBuffer();
        ConvenentePessoaTODecorator decorator = this.getFabricaDeTO().novoConvenentePessoaTODecorator();
        decorator.setConvenentePessoaTO(convenentePessoaTO);
        for (CamposLeiauteTO camposLeiauteTO : camposLeiaute) {
            int tamanhoCampo = camposLeiauteTO.getNumeroTamanhoCampo();
            String nomeCampo = camposLeiauteTO.getTextoNomeCampo();
            String valorCampo = this.getValorCampo(nomeCampo, decorator, tamanhoCampo);
            novaLinha.append(this.getCampo(tamanhoCampo, valorCampo));
        }
        return novaLinha.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getValorCampo(String nomeCampo, ConvenentePessoaTODecorator decorator, int tamanhoCampo) {
        Integer codigoTipoLogradouro;
        TipoLogradouroTO tipoLogradouroTO;
        PessoaTO pessoaTO = decorator.getPessoaTO();
        if (nomeCampo.equalsIgnoreCase("TX_NM")) {
            return pessoaTO.getTextoNome();
        }
        if (nomeCampo.equalsIgnoreCase("CD_TIP_DOC")) {
            return this.retornaCodigoTipoPessoaAsString(pessoaTO);
        }
        if (nomeCampo.equalsIgnoreCase("TX_IDFC")) {
            return this.retornaCPFCNPJ(pessoaTO);
        }
        if (nomeCampo.equalsIgnoreCase("TX_LGR")) {
            return this.getLogradouroPessoaTO(pessoaTO).getTextoLogradouro();
        }
        if (nomeCampo.equalsIgnoreCase("TX_BAI")) {
            return this.getLogradouroPessoaTO(pessoaTO).getTextoBairro();
        }
        if (nomeCampo.equalsIgnoreCase("TX_CID")) {
            return this.getLogradouroPessoaTO(pessoaTO).getTextoCidade();
        }
        if (nomeCampo.equalsIgnoreCase("TX_SG_UF_END")) {
            UnidadeFederativaBrasilTO unidadeFederativaBrasilTO = this.getLogradouroPessoaTO(pessoaTO).getUnidadeFederativaBrasilTO();
            if (!this.isReferencia(unidadeFederativaBrasilTO)) return "";
            return unidadeFederativaBrasilTO.getTextoSiglaUf();
        }
        if (nomeCampo.equalsIgnoreCase("CD_NCLD")) {
            if (!(pessoaTO instanceof ComplementoPessoaFisicaTO)) return this.retornaNumeroComZerosEsquerda(null, tamanhoCampo);
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO;
            NacionalidadeTO nacionalidadeTO = complementoPessoaFisicaTO.getNacionalidadeTO();
            if (!this.isReferencia(nacionalidadeTO)) return "";
            return this.retornaNumeroComZerosEsquerda(nacionalidadeTO.getCodigoNacionalidade(), tamanhoCampo);
        }
        if (nomeCampo.equalsIgnoreCase("TX_NTLD")) {
            if (!(pessoaTO instanceof ComplementoPessoaFisicaTO)) return "";
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO;
            return complementoPessoaFisicaTO.getTextoNaturalidade();
        }
        if (nomeCampo.equalsIgnoreCase("TX_SG_UF_NASC")) {
            ComplementoPessoaFisicaTO complementoPessoaFisicaTO;
            UnidadeFederativaBrasilTO uf;
            if (!(pessoaTO instanceof ComplementoPessoaFisicaTO) || !this.isReferencia(uf = (complementoPessoaFisicaTO = (ComplementoPessoaFisicaTO)pessoaTO).getUnidadeFederativaBrasilTO())) return "";
            return uf.getTextoSiglaUf();
        }
        if (nomeCampo.equalsIgnoreCase("TX_IDFC_CEI")) {
            return this.retornaValorTipoDocumento(pessoaTO.getIdentificacaoTOs(), UtilDominioTipoDocumento.CEI_PJ);
        }
        if (nomeCampo.equalsIgnoreCase("TX_IDFC_NR_BENEF")) {
            return this.retornaValorTipoDocumento(pessoaTO.getIdentificacaoTOs(), UtilDominioTipoDocumento.NUMERO_BENEFICIO_PF);
        }
        if (nomeCampo.equalsIgnoreCase("TX_IDFC_REF")) {
            return this.retornaValorTipoDocumento(pessoaTO.getIdentificacaoTOs(), UtilDominioTipoDocumento.REFERENCIA_PJ);
        }
        if (nomeCampo.equalsIgnoreCase("TX_IDFC_PISPASEP")) {
            return this.retornaValorTipoDocumento(pessoaTO.getIdentificacaoTOs(), UtilDominioTipoDocumento.PASEP_PF);
        }
        if (nomeCampo.equalsIgnoreCase("TX_IDFC_NIT")) {
            return this.retornaValorTipoDocumento(pessoaTO.getIdentificacaoTOs(), UtilDominioTipoDocumento.NIT_PF);
        }
        if (!nomeCampo.equalsIgnoreCase("CD_TIP_LGR") || !this.isReferencia(tipoLogradouroTO = this.getLogradouroPessoaTO(pessoaTO).getTipoLogradouroTO()) || !this.isReferencia(codigoTipoLogradouro = tipoLogradouroTO.getCodigoTipoLogradouro())) return "";
        return codigoTipoLogradouro.toString();
    }

    private LogradouroTO getLogradouroPessoaTO(PessoaTO pessoaTO) {
        LogradouroTO retorno = this.getFabricaDeTO().novoLogradouroTO();
        if (!UtilColecao.isVazio((Collection)pessoaTO.getLogradouroTOs())) {
            retorno = (LogradouroTO)pessoaTO.getLogradouroTOs().iterator().next();
        }
        return retorno;
    }

    private String retornaCPFCNPJ(PessoaTO pessoaTO) {
        Set colecaoIdentificacao = pessoaTO.getIdentificacaoTOs();
        Integer tipoDocumento = UtilDominioTipoDocumento.CPF_PF;
        if (pessoaTO instanceof ComplementoPessoaJuridicaTO) {
            tipoDocumento = UtilDominioTipoDocumento.CNPJ_PJ;
        }
        return this.retornaValorTipoDocumento(colecaoIdentificacao, tipoDocumento);
    }

    private String retornaValorTipoDocumento(Set<IdentificacaoTO> colecaoIdentificacao, Integer tipoDocumento) {
        String valor = "";
        for (IdentificacaoTO identificacaoTO : colecaoIdentificacao) {
            if (!tipoDocumento.equals(identificacaoTO.getTipoDocumentoTO().getCodigoTipoDocumento())) continue;
            valor = identificacaoTO.getTextoIdentificacao();
        }
        return valor;
    }

    private String retornaCodigoTipoPessoaAsString(PessoaTO pessoaTO) {
        Integer codigoTipoPessoa = pessoaTO.getTipoPessoaTO().getCodigoTipoPessoa();
        if (this.isReferencia(codigoTipoPessoa)) {
            return codigoTipoPessoa.toString();
        }
        return "0";
    }

    private StringBuffer getCampo(int tamanhoCampo, String valorCampo) {
        if (valorCampo == null) {
            valorCampo = "";
        }
        StringBuffer temporaria = this.novaStringBuffer(tamanhoCampo, valorCampo);
        int i = 0;
        while (i < tamanhoCampo - valorCampo.length()) {
            temporaria.append(" ");
            ++i;
        }
        return temporaria;
    }

    private StringBuffer novaStringBuffer(int tamanhoCampo, String valorCampo) {
        StringBuffer temporaria = new StringBuffer(tamanhoCampo);
        if (valorCampo.length() > temporaria.capacity()) {
            return temporaria.append(valorCampo.substring(0, tamanhoCampo));
        }
        return temporaria.append(valorCampo);
    }

    private String getPathArquivoExportacao(String pastaDestinoExportacao) {
        Date data = this.getDataFactory().novoDate();
        return String.valueOf(pastaDestinoExportacao) + "\\Cadastro_GAC." + this.getDia(data) + this.getMes(data) + UtilData.getAno((Date)data) + ".txt";
    }

    private String getDia(Date data) {
        if (UtilData.getDia((Date)data) < 10) {
            return "0" + UtilData.getDia((Date)data);
        }
        return Integer.toString(UtilData.getDia((Date)data));
    }

    private String getMes(Date data) {
        if (UtilData.getMes((Date)data) < 10) {
            return "0" + UtilData.getMes((Date)data);
        }
        return Integer.toString(UtilData.getMes((Date)data));
    }

    private ConvenentePessoaTODecorator novoConvenentePessoaTODecorator(ConvenentePessoaTO convenentePessoaTO) {
        ConvenentePessoaTODecorator decorator = this.getFabricaDeTO().novoConvenentePessoaTODecorator(convenentePessoaTO);
        Set colecaoIdentificaoTO = convenentePessoaTO.getPessoaTO().getIdentificacaoTOs();
        IdentificacaoTO cpfCnpjIdentificacaoTO = null;
        for (IdentificacaoTO identificacaoTO : colecaoIdentificaoTO) {
            Integer codigoTipoDocumento;
            if (identificacaoTO.getTipoDocumentoTO() == null || !UtilDominioTipoDocumento.CPF_PF.equals(codigoTipoDocumento = identificacaoTO.getTipoDocumentoTO().getCodigoTipoDocumento()) && !UtilDominioTipoDocumento.CNPJ_PJ.equals(codigoTipoDocumento)) continue;
            cpfCnpjIdentificacaoTO = identificacaoTO;
            String cpfCnpj = UtilString.trim((String)cpfCnpjIdentificacaoTO.getTextoIdentificacao());
            cpfCnpjIdentificacaoTO.setTextoIdentificacao(UtilFormatadorDeCPFouCNPJ.formatar((String)cpfCnpj));
        }
        decorator.setIdentificacaoTO(cpfCnpjIdentificacaoTO);
        return decorator;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public CamposLeiauteDAO getCamposLeiauteDAO() {
        return this.camposLeiauteDAO;
    }

    public void setCamposLeiauteDAO(CamposLeiauteDAO camposLeiauteDAO) {
        this.camposLeiauteDAO = camposLeiauteDAO;
    }

    private void atualizaPorcentagem(UtilNotificador notificaExportacao, int totalCadastros, int numeroCadastroAtual) {
        int porcentagem = numeroCadastroAtual * 100 / totalCadastros;
        notificaExportacao.notifyObservers((Object)porcentagem);
    }

    private File criaPastasSeNecessario(String pathPasta) {
        File pasta = new File(pathPasta);
        if (!pasta.exists()) {
            pasta.mkdirs();
        }
        return pasta;
    }

    private String retornaNumeroComZerosEsquerda(Integer numero, int tamanhoCampo) {
        if (!this.isReferencia(numero)) {
            numero = 0;
        }
        return String.format("%0" + tamanhoCampo + "d", numero);
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }
}

