/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.MembroGrupoClienteRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTOId;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO2;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenentePessoaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.formatador.UtilFormatadorDeCEP;
import br.com.politec.generico.formatador.UtilFormatadorDeCPFouCNPJ;
import br.com.politec.generico.string.UtilString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterClienteModel
extends PluginModelAbstrato {
    private ConvenentePessoaDAO convenentePessoaDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private MembroGrupoClienteRecebimentoDAO membroGrupoClienteRecebimentoDAO;
    private IdentificacaoDAO identificacaoDAO;
    private PessoaDAO pessoaDAO;

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public MembroGrupoClienteRecebimentoDAO getMembroGrupoClienteRecebimentoDAO() {
        return this.membroGrupoClienteRecebimentoDAO;
    }

    public void setMembroGrupoClienteRecebimentoDAO(MembroGrupoClienteRecebimentoDAO membroGrupoClienteRecebimentoDAO) {
        this.membroGrupoClienteRecebimentoDAO = membroGrupoClienteRecebimentoDAO;
    }

    public IdentificacaoDAO getIdentificacaoDAO() {
        return this.identificacaoDAO;
    }

    public void setIdentificacaoDAO(IdentificacaoDAO identificacaoDAO) {
        this.identificacaoDAO = identificacaoDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public PaginadorTO consultarClientesPaginador(ConvenentePessoaTODecorator decorator) {
        PaginadorTO paginador = this.getPessoaDAO().consultarClientesPaginador(decorator);
        return paginador;
    }

    public Collection<ConvenentePessoaTODecorator> consultarClientes(ConvenentePessoaTODecorator decorator) {
        Collection colecao = this.getPessoaDAO().consultarClientesPessoaTO(decorator);
        ArrayList<ConvenentePessoaTODecorator> colecaoDecorator = new ArrayList<ConvenentePessoaTODecorator>();
        for (PessoaTO pessoaTO : colecao) {
            ConvenentePessoaTO convenentePessoaTO = this.getFabricaDeTO().novoConvenentePessoaTO();
            convenentePessoaTO.setConvenenteTO(decorator.getConvenenteTO());
            convenentePessoaTO.setPessoaTO(pessoaTO);
            colecaoDecorator.add(this.novoConvenentePessoaTODecorator(convenentePessoaTO));
        }
        return colecaoDecorator;
    }

    public Collection<PessoaTO2> consultarClientesPessoaTO2(ConvenentePessoaTODecorator decorator) {
        return this.getPessoaDAO().consultarClientes(decorator);
    }

    private ConvenentePessoaTODecorator novoConvenentePessoaTODecorator(ConvenentePessoaTO convenentePessoaTO) {
        ConvenentePessoaTODecorator decorator = this.getFabricaDeTO().novoConvenentePessoaTODecorator(convenentePessoaTO);
        Set colecaoIdentificaoTO = convenentePessoaTO.getPessoaTO().getIdentificacaoTOs();
        IdentificacaoTO cpfCnpjIdentificacaoTO = null;
        for (IdentificacaoTO identificacaoTO : colecaoIdentificaoTO) {
            Integer codigoTipoDocumento;
            if (identificacaoTO.getTipoDocumentoTO() == null || !UtilDominioTipoDocumento.CPF_PF.equals(codigoTipoDocumento = identificacaoTO.getTipoDocumentoTO().getCodigoTipoDocumento()) && !UtilDominioTipoDocumento.CNPJ_PJ.equals(codigoTipoDocumento)) continue;
            cpfCnpjIdentificacaoTO = identificacaoTO;
            String cpfCnpj = UtilString.trim((String)cpfCnpjIdentificacaoTO.getTextoIdentificacao());
            cpfCnpjIdentificacaoTO.setTextoIdentificacao(UtilFormatadorDeCPFouCNPJ.formatar((String)cpfCnpj));
        }
        decorator.setIdentificacaoTO(cpfCnpjIdentificacaoTO);
        String cep = decorator.getLogradouroTO().getTextoCep();
        if (cep != null && !UtilString.trim((String)cep).equals("")) {
            decorator.getLogradouroTO().setTextoCep(UtilFormatadorDeCEP.formatar((String)decorator.getLogradouroTO().getTextoCep()));
        }
        return decorator;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public void incluir(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        PessoaTO pessoaTO = convenentePessoaTODecorator.getPessoaTO();
        ServicoTO servicoTO = this.getFabricaDeTO().novoServicoTO();
        servicoTO.setTextoIdentificadorServico("DBT");
        ConvenentePessoaTO convenentePessoaTO = convenentePessoaTODecorator.getConvenentePessoaTO();
        ConvenentePessoaTOId id = this.getFabricaDeTO().novoConvenentePessoaTOId();
        id.setCodigoPessoa(pessoaTO.getCodigoPessoa().intValue());
        id.setCodigoPessoaConvenente(convenentePessoaTODecorator.getConvenenteTO().getCodigoPessoaConvenente().intValue());
        id.setTextoIdentificadorServico("DBT");
        convenentePessoaTO.setId(id);
        convenentePessoaTO.setConvenenteTO(convenentePessoaTODecorator.getConvenenteTO());
        convenentePessoaTO.setPessoaTO(pessoaTO);
        convenentePessoaTO.setServicoTO(servicoTO);
        this.getConvenentePessoaDAO().incluirOuAlterar((Object)convenentePessoaTO);
    }

    public void excluir(ConvenentePessoaTODecorator convenentePessoaTODecorator) throws BBException {
        if (this.getRecebimentoDebitoDAO().isExisteLancamentos(convenentePessoaTODecorator.getConvenentePessoaTO())) {
            throw new BBException("MP042");
        }
        this.getMembroGrupoClienteRecebimentoDAO().excluir(convenentePessoaTODecorator.getConvenentePessoaTO());
        this.getIdentificadorClienteDebitoDAO().excluir(convenentePessoaTODecorator.getConvenentePessoaTO());
        this.getConvenentePessoaDAO().excluir((Object)convenentePessoaTODecorator.getConvenentePessoaTO());
        if (convenentePessoaTODecorator.getConvenentePessoaTO().getConvenenteTO().getTipoDocumentoTO() != null && convenentePessoaTODecorator.getConvenentePessoaTO().getConvenenteTO().getIdentificadorTO() != null) {
            IdentificacaoTOId id = this.getFabricaDeTO().novoIdentificacaoTOId();
            id.setCodigoPessoa(Integer.valueOf(convenentePessoaTODecorator.getConvenentePessoaTO().getId().getCodigoPessoa()));
            id.setCodigoTipoDocumento(convenentePessoaTODecorator.getConvenentePessoaTO().getConvenenteTO().getTipoDocumentoTO().getCodigoTipoDocumento());
            id.setTextoIdentificador(convenentePessoaTODecorator.getConvenentePessoaTO().getConvenenteTO().getIdentificadorTO().getId().getTextoIdentificador());
            this.getIdentificacaoDAO().excluirIdentificadorProprio(id);
        }
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    private void verificaExclusaoCliente(RecebimentoDebitoTO recebimentoDebitoTO) throws BBException {
        if (this.getRecebimentoDebitoDAO().isExisteRegistro(recebimentoDebitoTO)) {
            throw new BBException("MP042");
        }
    }

    public Collection<IdentificadorClienteDebitoTO> listarIdentificadorClienteDebitoConvenente(ConvenenteTO to) {
        Set convenioTOs = to.getConvenioTOs();
        IdentificadorClienteDebitoTODecorator decorator = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        Collection<Object> colecao = new ArrayList(1);
        ArrayList<IdentificadorClienteDebitoTO> colecaoResultado = new ArrayList<IdentificadorClienteDebitoTO>(1);
        for (ConvenioTO convenioTO : convenioTOs) {
            decorator.getConvenioDebitoTOId().setNumeroConvenio(convenioTO.getId().getNumeroConvenio());
            decorator.getConvenioDebitoTOId().setTextoIdentificadorServico(convenioTO.getServicoTO().getTextoIdentificadorServico());
            decorator.getConvenioDebitoTOId().setCodigoPessoaConvenente(convenioTO.getConvenenteTO().getCodigoPessoaConvenente());
            decorator.getSituacaoIdentificadorDebitoTO().setTextoSituacaoIdentificador('S');
            colecao = this.getIdentificadorClienteDebitoDAO().listarIdentificadorClienteDebitoConvenente(decorator);
            colecaoResultado.addAll(colecao);
        }
        return colecaoResultado;
    }

    public Collection<IdentificadorClienteDebitoTO> listarAutorizacoesParaDebitoConvenente(ConvenenteTO to) {
        Set convenioTOs = to.getConvenioTOs();
        IdentificadorClienteDebitoTODecorator decorator = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        Collection<Object> colecao = new ArrayList(1);
        ArrayList<IdentificadorClienteDebitoTO> colecaoResultado = new ArrayList<IdentificadorClienteDebitoTO>(1);
        for (ConvenioTO convenioTO : convenioTOs) {
            decorator.getConvenioDebitoTOId().setNumeroConvenio(convenioTO.getId().getNumeroConvenio());
            colecao = this.getIdentificadorClienteDebitoDAO().listarAutorizacoesParaDebitoConvenente(decorator);
            colecaoResultado.addAll(colecao);
        }
        return colecaoResultado;
    }

    public Collection<IdentificadorClienteDebitoTO> listarAutorizacoesParaDebitoConvenio(Integer convenio) {
        IdentificadorClienteDebitoTODecorator decorator = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        Collection<Object> colecao = new ArrayList(1);
        ArrayList<IdentificadorClienteDebitoTO> colecaoResultado = new ArrayList<IdentificadorClienteDebitoTO>(1);
        decorator.getConvenioDebitoTOId().setNumeroConvenio(convenio);
        colecao = this.getIdentificadorClienteDebitoDAO().listarAutorizacoesParaDebitoConvenente(decorator);
        colecaoResultado.addAll(colecao);
        return colecaoResultado;
    }

    public Collection<IdentificadorClienteDebitoTO> listarIdentificadorClienteDebitoEGrupos(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        return this.getIdentificadorClienteDebitoDAO().listarAutorizacoesParaDebitoConvenentePor(convenentePessoaTODecorator);
    }

    public boolean consultarSeVinculado(PessoaTO pessoaTO) {
        ConvenentePessoaTO convenentePessoaTO = this.getFabricaDeTO().novoConvenentePessoaTO();
        convenentePessoaTO.setPessoaTO(pessoaTO);
        convenentePessoaTO.setConvenenteTO(this.getConvenenteTOSelecionado());
        convenentePessoaTO.setServicoTO(new ServicoTO("DBT"));
        return this.getConvenentePessoaDAO().isExistePessoaVinculadaConvenente(convenentePessoaTO);
    }

    public PessoaTO consultarPessoaCliente(PessoaTO pessoaTO) {
        return (PessoaTO)this.pessoaDAO.listar((Object)pessoaTO);
    }

    public IdentificacaoTO consultarIdentificacao(IdentificacaoTO identificacaoTO) {
        return this.getIdentificacaoDAO().consultarIdentificacao(identificacaoTO);
    }

    public Collection<IdentificadorClienteDebitoTO> listarAutorizacoesParaDebitoConvenentePor(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        LinkedHashSet<IdentificadorClienteDebitoTO> colecaoResultado = new LinkedHashSet<IdentificadorClienteDebitoTO>();
        colecaoResultado.addAll(this.getIdentificadorClienteDebitoDAO().listarAutorizacoesParaDebitoConvenentePor(convenentePessoaTODecorator));
        return colecaoResultado;
    }

    public PaginadorTO consultarIdentificadorClienteDebitoEGrupos(ConvenentePessoaTODecorator convenentePessoaTODecorator) {
        return this.getIdentificadorClienteDebitoDAO().consultarAutorizacoesParaDebitoConvenentePor(convenentePessoaTODecorator);
    }
}

