/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.constantes.EstadoIndicadoImpressao;
import br.com.bb.plugins.dbt.factory.DBTTOFactory;
import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.GrupoClienteRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.MembroGrupoClienteRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.SituacaoIdentificadorDebitoDAO;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.AgenciaInstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoIdentificadorDebitoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterDadosDeDebitoModel
extends PluginModelAbstrato {
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private ConvenioDAO convenioDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO;
    private GrupoClienteRecebimentoDAO grupoClienteRecebimentoDAO;
    private SituacaoIdentificadorDebitoDAO situacaoIdentificadorDebitoDAO;
    private MembroGrupoClienteRecebimentoDAO membroGrupoClienteRecebimentoDAO;
    private ConvenioDebitoDAO convenioDebitoDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public MembroGrupoClienteRecebimentoDAO getMembroGrupoClienteRecebimentoDAO() {
        return this.membroGrupoClienteRecebimentoDAO;
    }

    public void setMembroGrupoClienteRecebimentoDAO(MembroGrupoClienteRecebimentoDAO membroGrupoClienteRecebimentoDAO) {
        this.membroGrupoClienteRecebimentoDAO = membroGrupoClienteRecebimentoDAO;
    }

    public GrupoClienteRecebimentoDAO getGrupoClienteRecebimentoDAO() {
        return this.grupoClienteRecebimentoDAO;
    }

    public void setGrupoClienteRecebimentoDAO(GrupoClienteRecebimentoDAO grupoClienteRecebimentoDAO) {
        this.grupoClienteRecebimentoDAO = grupoClienteRecebimentoDAO;
    }

    public AgenciaInstituicaoFinanceiraDAO getAgenciaInstituicaoFinanceiraDAO() {
        return this.agenciaInstituicaoFinanceiraDAO;
    }

    public void setAgenciaInstituicaoFinanceiraDAO(AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO) {
        this.agenciaInstituicaoFinanceiraDAO = agenciaInstituicaoFinanceiraDAO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    public PaginadorTO consultar(IdentificadorClienteDebitoTODecorator identificadorClienteDebitoTODecorator) {
        return this.getIdentificadorClienteDebitoDAO().consultarIdentificadorClienteDebitoPorPessoaCliente(identificadorClienteDebitoTODecorator);
    }

    public PaginadorTO consultar(Collection<IdentificadorClienteDebitoTODecorator> colecaoIdentificadorClienteDebitoTODecorator) {
        return this.getIdentificadorClienteDebitoDAO().consultarIdentificadorClienteDebitoPorColecaoPessoaCliente(colecaoIdentificadorClienteDebitoTODecorator);
    }

    public Collection<ConvenioTO> carregarComboConvenio(IdentificadorClienteDebitoTODecorator identificadorClienteDebitoTODecorator) {
        ConvenioTO convenioTO = identificadorClienteDebitoTODecorator.getConvenioTO();
        return this.getConvenioDAO().consultarPorConvenenteServico(convenioTO);
    }

    public void incluir(IdentificadorClienteDebitoTODecorator decorator) throws BBException {
        decorator.getIdentificadorClienteDebitoTO().setCodigoIdentificadorClienteDebito(null);
        this.gravarIdentificacao(decorator, true);
    }

    private void gravarIdentificacao(IdentificadorClienteDebitoTODecorator decorator, boolean valida) throws BBException {
        decorator.setAgenciaInstituicaoFinanceiraTO(decorator.getAgenciaInstituicaoFinanceiraTODaDecorator());
        decorator.setIndicadorImpressao(EstadoIndicadoImpressao.NAO_IMPRESSO);
        decorator.getConvenioDebitoTO().setConvenioTO(decorator.getConvenioTO());
        ConvenioDebitoTOId id = this.getFabricaDeTO().novoConvenioDebitoTOId();
        id.setCodigoPessoaConvenente(decorator.getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente());
        id.setNumeroConvenio(decorator.getConvenioTO().getId().getNumeroConvenio());
        id.setTextoIdentificadorServico(decorator.getConvenioTO().getServicoTO().getTextoIdentificadorServico());
        ConvenioDebitoTO convenioDebitoTO = this.getConvenioDebitoTO(id);
        decorator.getIdentificadorClienteDebitoTO().setConvenioDebitoTO(convenioDebitoTO);
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoPessoa(decorator.getCodigoPessoaCliente().intValue());
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoAgencia(decorator.getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia());
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoInstituicaoFinanceira(decorator.getCodigoInstituicaoFinanceira());
        AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO = decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO();
        this.gravarContaCorrente(decorator, agenciaInstituicaoFinanceiraTO);
        this.getAgenciaInstituicaoFinanceiraDAO().alterar((Object)agenciaInstituicaoFinanceiraTO);
        decorator.getIdentificadorClienteDebitoTO().setAgenciaInstituicaoFinanceiraTO(agenciaInstituicaoFinanceiraTO);
        decorator.getIdentificadorClienteDebitoTO().setPessoaTO(decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO());
        boolean existe = false;
        if (valida) {
            existe = this.getIdentificadorClienteDebitoDAO().isExistePeloTextoDeIdentificacaoConvenenteClienteEConvenio(decorator.getIdentificadorClienteDebitoTO());
        }
        if (!existe) {
            if (this.isReferencia(decorator.getMembroGrupoClienteRecebimentoTO().getGrupoClienteRecebimentoTO())) {
                decorator.getMembroGrupoClienteRecebimentoTO().setIdentificadorClienteDebitoTO(decorator.getIdentificadorClienteDebitoTO());
                decorator.getMembroGrupoClienteRecebimentoTO().setGrupoClienteRecebimentoTO(decorator.getGrupoClienteRecebimentoTO());
                decorator.getMembroGrupoClienteRecebimentoTO().getId().setCodigoGrupoClienteRecebimento(decorator.getGrupoClienteRecebimentoTO().getCodigoGrupoClienteRecebimento());
                decorator.getMembroGrupoClienteRecebimentoTO().getId().setCodigoPessoaCliente(decorator.getPessoaTO().getCodigoPessoa());
                decorator.getMembroGrupoClienteRecebimentoTO().setPessoaTO(decorator.getPessoaTO());
                this.getMembroGrupoClienteRecebimentoDAO().alterar(decorator.getMembroGrupoClienteRecebimentoTO());
            } else {
                this.getIdentificadorClienteDebitoDAO().alterar(decorator.getIdentificadorClienteDebitoTO());
                this.excluirMembroGrupoClienteRecebimento(decorator);
            }
        } else {
            throw new BBException("MP050");
        }
    }

    private void excluirMembroGrupoClienteRecebimento(IdentificadorClienteDebitoTODecorator decorator) {
        if (decorator.getMembroGrupoClienteRecebimentoTO().getId() != null && decorator.getMembroGrupoClienteRecebimentoTO().getId().getCodigoPessoaCliente() != null && decorator.getMembroGrupoClienteRecebimentoTO().getId().getCodigoGrupoClienteRecebimento() != null) {
            this.getMembroGrupoClienteRecebimentoDAO().excluirMembroGrupoClienteRecebimentoTOId(decorator.getMembroGrupoClienteRecebimentoTO().getId());
        }
    }

    private ConvenioDebitoTO getConvenioDebitoTO(ConvenioDebitoTOId id) {
        return (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar((Serializable)id);
    }

    private void gravarContaCorrente(IdentificadorClienteDebitoTODecorator decorator, AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO) {
        Set contas = agenciaInstituicaoFinanceiraTO.getContaCorrenteClienteTOs();
        ContaCorrenteClienteTO containcluir = decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO();
        for (ContaCorrenteClienteTO to : contas) {
            if (!to.equals((Object)containcluir)) continue;
            contas.remove(to);
            return;
        }
        contas.add(containcluir);
    }

    public boolean verificaSeDadoDeDebitoExiste(IdentificadorClienteDebitoTODecorator decorator) {
        boolean retorno = false;
        Collection colecao = new ArrayList();
        colecao = this.getIdentificadorClienteDebitoDAO().consultar(decorator.getIdentificadorClienteDebitoTO());
        for (IdentificadorClienteDebitoTO to : colecao) {
            retorno = to.getTextoIdentificadorDebito().equals(decorator.getTextoIdentificadorDebito()) && to.getConvenioDebitoTO().getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente().equals(decorator.getConvenioDebitoTO().getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente());
        }
        return retorno;
    }

    public ConvenenteTO getConvenenteSelecionado() {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        return acesso.getConvenenteTO();
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    private IdentificadorClienteDebitoTO getIndentificadorClienteDebitoTO(IdentificadorClienteDebitoTODecorator decorator) {
        return (IdentificadorClienteDebitoTO)this.getIdentificadorClienteDebitoDAO().listar(decorator.getIdentificadorClienteDebitoTO().getCodigoIdentificadorClienteDebito());
    }

    public boolean excluir(IdentificadorClienteDebitoTODecorator decorator) {
        IdentificadorClienteDebitoTO identificadorClienteDebitoTO = this.getIndentificadorClienteDebitoTO(decorator);
        if (decorator.getSituacaoIdentificadorDebitoTO().getTextoSituacaoIdentificador() == 'I') {
            RecebimentoDebitoTODecorator recebimentoDebitoTODecorator = DBTTOFactory.getInstancia().novoRecebimentoDebitoTODecorator();
            recebimentoDebitoTODecorator.setIdentificadorClienteDebitoTO(identificadorClienteDebitoTO);
            PaginadorTO paginadorTO = this.getRecebimentoDebitoDAO().consultarPorFiltro(recebimentoDebitoTODecorator);
            Collection lista = paginadorTO.getColecaoDeRegistros();
            if (lista != null && lista.size() > 0) {
                for (RecebimentoDebitoTO to : lista) {
                    this.getRecebimentoDebitoDAO().excluir(to);
                }
            }
            this.getIdentificadorClienteDebitoDAO().excluir(identificadorClienteDebitoTO);
            return true;
        }
        SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTO = (SituacaoIdentificadorDebitoTO)this.getSituacaoIdentificadorDebitoDAO().listar(Character.valueOf('G'));
        identificadorClienteDebitoTO.setSituacaoIdentificadorDebitoTO(situacaoIdentificadorDebitoTO);
        identificadorClienteDebitoTO.setTextoIdentificadorAnterior("AGUARDANDO EXCLUSAO NO BB");
        identificadorClienteDebitoTO.setDataAlteracaoRemessa(null);
        identificadorClienteDebitoTO.setNumeroAlteracaoRemessa(null);
        return true;
    }

    public boolean desativar(IdentificadorClienteDebitoTODecorator decorator) {
        IdentificadorClienteDebitoTO identificadorClienteDebitoTO = this.getIndentificadorClienteDebitoTO(decorator);
        SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTO = (SituacaoIdentificadorDebitoTO)this.getSituacaoIdentificadorDebitoDAO().listar(Character.valueOf('I'));
        identificadorClienteDebitoTO.setSituacaoIdentificadorDebitoTO(situacaoIdentificadorDebitoTO);
        return true;
    }

    public boolean ativar(IdentificadorClienteDebitoTODecorator decorator) {
        IdentificadorClienteDebitoTO identificadorClienteDebitoTO = this.getIndentificadorClienteDebitoTO(decorator);
        identificadorClienteDebitoTO.setTextoIdentificadorAnterior(null);
        SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTO = (SituacaoIdentificadorDebitoTO)this.getSituacaoIdentificadorDebitoDAO().listar(Character.valueOf('A'));
        identificadorClienteDebitoTO.setSituacaoIdentificadorDebitoTO(situacaoIdentificadorDebitoTO);
        return true;
    }

    public boolean editar(IdentificadorClienteDebitoTODecorator decorator) throws BBException {
        if (!decorator.getIdentificadorClienteDebitoTO().getTextoIdentificadorDebito().equals(decorator.getIdentificadorClienteDebitoTO().getTextoIdentificadorAnterior())) {
            Integer alterado = decorator.getIdentificadorClienteDebitoTO().getCodigoIdentificadorClienteDebito();
            IdentificadorClienteDebitoTO to = (IdentificadorClienteDebitoTO)this.getIdentificadorClienteDebitoDAO().listar(alterado);
            SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTOAlterado = (SituacaoIdentificadorDebitoTO)this.getSituacaoIdentificadorDebitoDAO().listar(Character.valueOf('L'));
            to.setSituacaoIdentificadorDebitoTO(situacaoIdentificadorDebitoTOAlterado);
            this.getIdentificadorClienteDebitoDAO().alterar(to);
            SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTO = (SituacaoIdentificadorDebitoTO)this.getSituacaoIdentificadorDebitoDAO().listar(Character.valueOf('G'));
            decorator.setSituacaoIdentificadorDebitoTO(situacaoIdentificadorDebitoTO);
            this.incluir(decorator);
        } else {
            decorator.getIdentificadorClienteDebitoTO().setTextoIdentificadorAnterior(decorator.getIdentificadorEditar().getTextoIdentificadorDebito());
            decorator.getIdentificadorClienteDebitoTO().getSituacaoIdentificadorDebitoTO().setTextoSituacaoIdentificador('A');
            GrupoClienteRecebimentoTO grupoClienteRecebimentoTO = decorator.getMembroGrupoClienteRecebimentoTO().getGrupoClienteRecebimentoTO();
            if (grupoClienteRecebimentoTO != null && grupoClienteRecebimentoTO.getCodigoGrupoClienteRecebimento() != null) {
                decorator.getMembroGrupoClienteRecebimentoTO().setGrupoClienteRecebimentoTO(grupoClienteRecebimentoTO);
            }
            decorator.setNumeroAlteracaoRemessa(null);
            decorator.setSituacaoIdentificadorDebitoTO(null);
            SituacaoIdentificadorDebitoTO situacaoIdentificadorDebitoTO = (SituacaoIdentificadorDebitoTO)this.getSituacaoIdentificadorDebitoDAO().listar(Character.valueOf('A'));
            decorator.setSituacaoIdentificadorDebitoTO(situacaoIdentificadorDebitoTO);
            this.gravarIdentificacao(decorator, false);
        }
        return true;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public SituacaoIdentificadorDebitoDAO getSituacaoIdentificadorDebitoDAO() {
        return this.situacaoIdentificadorDebitoDAO;
    }

    public void setSituacaoIdentificadorDebitoDAO(SituacaoIdentificadorDebitoDAO situacaoIdentificadorDebitoDAO) {
        this.situacaoIdentificadorDebitoDAO = situacaoIdentificadorDebitoDAO;
    }

    public Collection<ConvenioDebitoTO> consultarConveniosDebitoConvenente() {
        ConvenioDebitoTO to = this.getFabricaDeTO().novoConvenioDebitoTO();
        Integer codigoPessoaConvenente = this.getConvenenteSelecionado().getCodigoPessoaConvenente();
        to.getId().setCodigoPessoaConvenente(codigoPessoaConvenente);
        return this.getConvenioDebitoDAO().consultarPorConvenente(to);
    }

    public void alteraEstadoImpressaoDaListaDeAutorizacaoDeDebito(Set<IdentificadorClienteDebitoTO> listaDeAutorizacaoDeDebito) {
        for (IdentificadorClienteDebitoTO identificadorClienteDebitoTO : listaDeAutorizacaoDeDebito) {
            identificadorClienteDebitoTO.setIndicadorImpressao(new Character(EstadoIndicadoImpressao.IMPRESSO.charAt(0)));
            this.getIdentificadorClienteDebitoDAO().alterar(identificadorClienteDebitoTO);
        }
    }
}

