/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.swing.componente.comboBox;

import br.com.bb.plugins.dbt.apresentacao.dominio.action.ConsultarListaSituacaoAction;
import br.com.bb.plugins.dbt.factory.DBTActionFactory;
import br.com.bb.plugins.gac.apresentacao.dominio.form.DominioForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxSituacao
extends BBJComboBox {
    public void carregar() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaSituacaoAction().executar((PluginFormAbstrato)dominioForm);
        this.preencherCombo(dominioForm.getListaSituacao());
    }

    private void preencherCombo(Collection<SituacaoRecebimentoTO> listaSituacao) {
        Collections.sort((ArrayList)listaSituacao, new Comparator<SituacaoRecebimentoTO>(){

            @Override
            public int compare(SituacaoRecebimentoTO o1, SituacaoRecebimentoTO o2) {
                return o1.getCodigoHierarquia().compareTo(o2.getCodigoHierarquia());
            }
        });
        this.setModel(this.getDefaultComboBoxModel(listaSituacao));
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<SituacaoRecebimentoTO> listaSituacao) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(listaSituacao);
        this.inserirElementoVazio(defaultComboBoxModel);
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<SituacaoRecebimentoTO> listaSituacao) {
        return new DefaultComboBoxModel<Object>(listaSituacao.toArray());
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(0));
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.insertElementAt("Selecione", 0);
    }

    private DominioForm getDominioForm() {
        return FormFactory.getInstancia().novoDominioForm();
    }

    private ConsultarListaSituacaoAction getConsultarListaSituacaoAction() {
        return this.getDBTActionFactory().novoConsultarListaSituacaoAction();
    }

    private DBTActionFactory getDBTActionFactory() {
        return DBTActionFactory.getInstancia();
    }
}

