/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.util.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.gerarremessa.action.GerarResumoRemessaAction;
import br.com.bb.plugins.dbt.apresentacao.gerarremessa.action.ImprimirListaLancamentoRemessaAction;
import br.com.bb.plugins.dbt.apresentacao.gerarremessa.action.RecuperaRecebimentosGerarAction;
import br.com.bb.plugins.dbt.apresentacao.gerarremessa.form.GerarRemessaForm;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.business.GerarRemessaDeDebitoAutomaticoBO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioGerarRemessaDecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxConvenioLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableScrollPane;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.instancia.ConversorDeUtilDateParaStringNoPadrao;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.generico.formatador.UtilFormatadorDeString;
import br.com.politec.infra.util.UtilLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGerarRemessa
extends DBTBasicInternalFrame
implements Observer {
    private final String[] columnNames = new String[]{"Cliente", "Data do D\u00e9bito", "Valor"};
    private final int[] columnSizes = new int[]{200, 150, 150};
    private final int[] columnAligment = new int[]{2, 4, 4};
    private BBJComboBoxConvenioLabel<ConvenioTO> comboConvenio;
    private BBJButton btnConsultar;
    private BBJButton btnMarcarTodos;
    private BBJButton btnDesmarcarTodos;
    private BBJPanelBotoesManut panelBotoes;
    private JPanel panelTabela;
    private JPanel panelPrincipal;
    private JPanel panelCombo;
    private JPanel panelCentro = null;
    private JPanel panelLabels;
    private BBJButton btnConfirmar;
    private BBJButton bntVoltar;
    private BBJLabel labelTotal;
    private BBJLabel labelTotalRegistros;
    private BBJTableScrollPane<GerarRemessaDeDebitoAutomaticoBO> tableModel;
    private Map<String, String> opcoesConvenio;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso = null;
    private BBJButton btnImprimir;

    public ViewGerarRemessa() {
        super("Gerar Remessa", false, false);
        this.setVisible(true);
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.getPanelPrincipal());
        this.carregaTabela();
        this.getGerarRemessaForm().getNotificaProcessarRemessa().addObserver((Observer)this);
    }

    public JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setOpaque(false);
            this.panelPrincipal.setLayout(new BorderLayout());
            JPanel panelComboDicas = new JPanel();
            panelComboDicas.setOpaque(false);
            panelComboDicas.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(6, 15, 6, 6);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.99;
            panelComboDicas.add((Component)this.getPanelCombo(), gbc);
            gbc.insets = new Insets(6, 4, 6, 6);
            JPanel panelNorte = new JPanel();
            panelNorte.setLayout(new BorderLayout());
            panelNorte.setPreferredSize(new Dimension(0, 60));
            panelNorte.setOpaque(false);
            panelNorte.add((Component)panelComboDicas, "West");
            this.panelPrincipal.add((Component)panelNorte, "North");
            this.panelPrincipal.add((Component)this.getPanelCentro(), "Center");
        }
        return this.panelPrincipal;
    }

    public JPanel getPanelCentro() {
        if (this.panelCentro == null) {
            this.panelCentro = new JPanel();
            this.panelCentro.setLayout(new BorderLayout());
            this.panelCentro.setOpaque(false);
            JPanel panelTab = new JPanel();
            panelTab.setOpaque(false);
            panelTab.setLayout(new BoxLayout(panelTab, 1));
            panelTab.add(this.getPanelTabela());
            JPanel panelBotoesDicas = new JPanel();
            panelBotoesDicas.setOpaque(false);
            panelBotoesDicas.setLayout(new BorderLayout());
            panelBotoesDicas.add((Component)this.getPanelLabels(), "North");
            panelBotoesDicas.add((Component)this.getPanelBotoes(), "Center");
            panelTab.add(this.getPanelProgresso());
            panelTab.add(panelBotoesDicas);
            this.panelCentro.add((Component)panelTab, "North");
        }
        return this.panelCentro;
    }

    private void carregaTabela() {
        double total = 0.0;
        Vector<GerarRemessaDeDebitoAutomaticoBO> dados = new Vector<GerarRemessaDeDebitoAutomaticoBO>();
        List<RecebimentoDebitoTO> lista = this.getGerarRemessaForm().getColecaoRecebimento();
        for (RecebimentoDebitoTO recebimentoDebitoTO : lista) {
            dados.add(new GerarRemessaDeDebitoAutomaticoBO(recebimentoDebitoTO));
            if (recebimentoDebitoTO.getValorRecebimento() == null) continue;
            total += recebimentoDebitoTO.getValorRecebimento().doubleValue();
        }
        this.getLabelTotal().setText("Valor Total: " + UtilFormatadorDeReal.formatar((double)total) + "  ");
        this.getLabelTotalRegistros().setText(String.format(" Total de Registros: %s", lista.size()));
        this.getTableModel().getBbtModel().setDataListTabela(dados);
        this.getBtnImprimir().setEnabled(!UtilColecao.isVazio(dados));
        this.getBtnMarcarTodos().setEnabled(!UtilColecao.isVazio(dados));
    }

    public void inicializaTela() {
        this.getBbprogress().setValoratual(0L);
        this.getCmbConvenio().getComboBoxConvenio().carregarComFiltro();
        this.getGerarRemessaForm().setColecaoRecebimento(new ArrayList<RecebimentoDebitoTO>());
        this.carregaTabela();
        this.habilitarBotoes();
        this.getCmbConvenio().requestFocus();
    }

    public void doShow(Map context) {
        this.inicializaTela();
        this.setVisible(true);
        super.doShow(context);
    }

    public Map<String, String> getOpcoesConvenio() {
        if (this.opcoesConvenio == null) {
            this.opcoesConvenio = new TreeMap<String, String>();
        }
        return this.opcoesConvenio;
    }

    public JPanel getBtnConsultar() {
        JPanel pnlBtnConsultar = new JPanel();
        if (this.btnConsultar == null) {
            RecuperaRecebimentosGerarAction action = this.getDBTActionFactory().novoRecuperaRecebimentosGerarAction();
            this.btnConsultar = this.getBotaoFactory().novoConsultar((PluginActionAbstrato)action);
            pnlBtnConsultar.setLayout(new FlowLayout(2));
            pnlBtnConsultar.add((Component)this.btnConsultar);
            pnlBtnConsultar.setOpaque(false);
        }
        return pnlBtnConsultar;
    }

    public void posExecucaoRecuperaRecebimentosGerarAction() {
        if (this.getGerarRemessaForm().getColecaoRecebimento().size() == 0) {
            BBJPopupMensagem.exibirMensagem((String)this.getUtilMensagem().getMensagem("MP004"));
        }
        this.carregaTabela();
        this.getGerarRemessaForm().setRemessaTODecorator(null);
    }

    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void posExecucaoProcessarGerarRemessaAction() throws BBException {
        RecuperaRecebimentosGerarAction action = this.getDBTActionFactory().novoRecuperaRecebimentosGerarAction();
        RemessaTODecorator decorator = this.getGerarRemessaForm().getRemessaTODecorator();
        List<RelatorioGerarRemessaDecorator> colecao = this.getGerarRemessaForm().getColecaoRelatorioGerarRemessaDecorator();
        HashMap<String, Object> mapaParametros = new HashMap<String, Object>();
        mapaParametros.put("input_sub_gerar_remessa", UtilArquivo.getInputStream((String)"/relatorios/sub_gerar_remessa.jasper"));
        mapaParametros.put("nomeDoConvente", decorator.getConvenioTO().getConvenenteTO().getPessoaTO().getTextoNome());
        mapaParametros.put("numeroConvenio", UtilConversorDeInteger.converterParaString((Integer)decorator.getConvenioTO().getId().getNumeroConvenio()));
        mapaParametros.put("totalRegistros", UtilConversorDeInteger.converterParaString((int)decorator.getNumeroLancamentos()));
        mapaParametros.put("valorTotalRecebimentos", UtilFormatadorDeReal.formatar((Number)decorator.getSomaValoresDeRemessa()));
        mapaParametros.put("numeroRemessa", UtilFormatadorDeString.formatar((Object)decorator.getNumeroRemessa()));
        mapaParametros.put("nomeArquivo", decorator.getRemessaTO().getTextoNomeArquivo());
        mapaParametros.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        try {
            JasperPrint impressao = UtilRelatorioJasper.imprimirRelatorio((String)"/relatorios/relatorio_gerar_remessa.jasper", mapaParametros, colecao);
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            e.printStackTrace();
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            e.printStackTrace();
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        action.executar(this.getForm());
        this.carregaTabela();
    }

    public BBJComboBoxConvenioLabel<ConvenioTO> getCmbConvenio() {
        if (this.comboConvenio == null) {
            this.comboConvenio = new BBJComboBoxConvenioLabel("Selecionar o Conv\u00eanio:", false, 0, 300, 132);
            this.comboConvenio.setName("convenioTO");
            this.comboConvenio.setToolTipText(this.getMensagem("MH049"));
            this.comboConvenio.getComboBoxConvenio().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    ViewGerarRemessa.this.getGerarRemessaForm().setColecaoRecebimento(null);
                    ViewGerarRemessa.this.carregaTabela();
                }
            });
        }
        return this.comboConvenio;
    }

    public BBJLabel getLabelTotal() {
        BBJEstilos estilo = BBJEstilos.LABELTEXTO;
        if (this.labelTotal == null) {
            this.labelTotal = new BBJLabel("Valor Total     ");
            this.labelTotal.setFont(estilo.getFont());
        }
        return this.labelTotal;
    }

    public BBJLabel getLabelTotalRegistros() {
        BBJEstilos estilo = BBJEstilos.LABELTEXTO;
        if (this.labelTotalRegistros == null) {
            this.labelTotalRegistros = new BBJLabel("  Total de Registros: ");
            this.labelTotalRegistros.setFont(estilo.getFont());
        }
        return this.labelTotalRegistros;
    }

    public BBJPanelBotoesManut getPanelBotoes() {
        if (!this.isReferencia(this.panelBotoes)) {
            this.panelBotoes = this.getPainelFactory().novoBBJPanelBotoesManut(-1);
            this.panelBotoes.removeAll();
            this.panelBotoes.add((Component)this.getBtnConfirmar());
            this.panelBotoes.add((Component)this.getBtnMarcarTodos());
            this.panelBotoes.add((Component)this.getBtnDesmarcarTodos());
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBtnDesmarcarTodos() {
        if (this.btnDesmarcarTodos == null) {
            this.btnDesmarcarTodos = new BBJButton("DESMARCAR TODOS");
            this.btnDesmarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerarRemessa.this.marcarTodosRegistros(false);
                    ViewGerarRemessa.this.getBtnConfirmar().setEnabled(false);
                }
            });
        }
        return this.btnDesmarcarTodos;
    }

    private BBJButton getBtnConfirmar() {
        if (this.btnConfirmar == null) {
            GerarResumoRemessaAction acao = this.getDBTActionFactory().novoGerarResumoRemessaAction();
            this.btnConfirmar = this.getBotaoFactory().novoConfirmar((PluginActionAbstrato)acao);
        }
        return this.btnConfirmar;
    }

    public BBJButton getBtnMarcarTodos() {
        if (this.btnMarcarTodos == null) {
            this.btnMarcarTodos = new BBJButton("MARCAR TODOS");
            this.btnMarcarTodos.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewGerarRemessa.this.marcarTodosRegistros(true);
                    ViewGerarRemessa.this.habilitarBotoes();
                }
            });
        }
        return this.btnMarcarTodos;
    }

    private void marcarTodosRegistros(boolean selected) {
        this.getTableModel().getBbtModel().marcaTodos(selected);
    }

    private BBJButton getBtnVoltar() {
        if (this.bntVoltar == null) {
            this.bntVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.bntVoltar;
    }

    protected BBJButton getBtnImprimir() {
        if (this.btnImprimir == null) {
            ImprimirListaLancamentoRemessaAction acao = this.getDBTActionFactory().novoImprimirListaLancamentoRemessaAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.btnImprimir;
    }

    public void posExecucaoImprimirListaLancamentoRemessaAction() {
        if (this.isReferencia(this.getGerarRemessaForm().getColecaoRecebimento())) {
            this.imprimirLancamentoRemessa();
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getUtilMensagem().getMensagem("MP004"));
        }
    }

    private void imprimirLancamentoRemessa() {
        JasperPrint impressao = null;
        try {
            impressao = UtilRelatorioJasper.imprimirRelatorio((String)Arquivo.JASPER_LISTA_LANCAMENTOS_REMESSA, (Map)this.getMapaParametros(), this.getListaRemessa());
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
    }

    private Collection<RecebimentoDebitoTODecorator> getListaRemessa() {
        ArrayList<RecebimentoDebitoTODecorator> colecaoDecorator = new ArrayList<RecebimentoDebitoTODecorator>();
        List lista = this.getTableModel().getDataListTabela();
        for (GerarRemessaDeDebitoAutomaticoBO bo : lista) {
            colecaoDecorator.add(this.novoRecebimentoDebitoTODecorator(bo));
        }
        return colecaoDecorator;
    }

    protected TOFactory getFabricaDeTO() {
        return TOFactory.getInstancia();
    }

    private RecebimentoDebitoTODecorator novoRecebimentoDebitoTODecorator(GerarRemessaDeDebitoAutomaticoBO bo) {
        RecebimentoDebitoTODecorator decorator = this.getFabricaDeTO().novoRecebimentoDebitoTODecorator();
        decorator.setTextoNomeRelatorio(bo.getCliente());
        decorator.setDataDoDebito(bo.getRecebimentoDebitoTO().getDataRecebimento());
        decorator.setValor(bo.getRecebimentoDebitoTO().getValorRecebimento());
        decorator.setValorTotal(2000.0);
        return decorator;
    }

    public String retornaValorDataFormatada(RecebimentoDebitoTO recebimentoDebitoTO, ConversorDeUtilDateParaStringNoPadrao padrao, String converter) {
        try {
            converter = (String)padrao.converter((Object)recebimentoDebitoTO.getDataDebito());
        }
        catch (ConversorException e) {
            e.printStackTrace();
        }
        return converter;
    }

    private Map getMapaParametros() {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("nomeDoConvenente", FramePrincipal.getInstance().getConvenente().getPessoaTO().getTextoNome());
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        return mapa;
    }

    public JPanel getPanelCombo() {
        if (this.panelCombo == null) {
            this.panelCombo = new JPanel();
            this.panelCombo.setOpaque(false);
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(0);
            this.panelCombo.setLayout(layout);
            this.panelCombo.add((Component)this.getCmbConvenio());
            this.panelCombo.add(this.getBtnConsultar());
        }
        return this.panelCombo;
    }

    public JPanel getPanelTabela() {
        if (this.panelTabela == null) {
            this.panelTabela = new JPanel();
            this.panelTabela.setOpaque(false);
            this.getTableModel().getTable().setModel((TableModel)this.getTableModel().getBbtModel());
            this.panelTabela.setLayout(new BorderLayout());
            this.panelTabela.setBorder(BBJBordaOval.createOvalBorder());
            this.panelTabela.add((Component)this.getTableModel().getTable().getTableHeader(), "First");
            this.panelTabela.add((Component)this.getTableModel(), "Center");
            this.panelTabela.setPreferredSize(new Dimension(0, 360));
        }
        return this.panelTabela;
    }

    public BBJTableScrollPane<GerarRemessaDeDebitoAutomaticoBO> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BBJTableScrollPane(this.columnNames, this.columnSizes, this.columnAligment, 10);
            this.tableModel.setName("listaRecebimentoDebitoTO");
            this.tableModel.getBbtModel().setOrdenacaoAutomatica(true);
            this.tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        ViewGerarRemessa.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewGerarRemessa.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewGerarRemessa.this.carregaTabela();
                    }
                }
            });
        }
        return this.tableModel;
    }

    private void habilitarBotoes() {
        if (this.getTableModel().getBbtModel().getItensChecadosCheckBox() != null && this.getTableModel().getBbtModel().getItensChecadosCheckBox().size() > 0) {
            this.getBtnDesmarcarTodos().setEnabled(true);
            if (!FramePrincipal.getInstance().getConvenente().getCodigoPessoaConvenente().equals(400)) {
                this.getBtnConfirmar().setEnabled(true);
            }
        } else {
            this.getBtnConfirmar().setEnabled(false);
            this.getBtnDesmarcarTodos().setEnabled(false);
        }
    }

    public JPanel getPanelLabels() {
        if (this.panelLabels == null) {
            this.panelLabels = new JPanel();
            this.panelLabels.setLayout(new BorderLayout());
            this.panelLabels.add((Component)this.getLabelTotal(), "East");
            this.panelLabels.add((Component)this.getLabelTotalRegistros(), "West");
            this.panelLabels.setOpaque(false);
        }
        return this.panelLabels;
    }

    public BBJProgressBar getBbprogress() {
        if (this.bbprogress == null) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    public JPanel getPanelProgresso() {
        if (this.panelProgresso == null) {
            this.panelProgresso = new JPanel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setPreferredSize(new Dimension(0, 65));
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder((String)"Progresso", (int)10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    private void setDimension(JPanel pnl, Dimension dim) {
        pnl.setPreferredSize(dim);
        pnl.setMaximumSize(dim);
        pnl.setSize(dim);
        pnl.setMinimumSize(dim);
    }

    public Date getDataDoDebito() {
        Date data = (Date)Calendar.getInstance().getTime();
        ConversorDeUtilDateParaStringNoPadrao padrao = new ConversorDeUtilDateParaStringNoPadrao();
        Date converter = null;
        try {
            converter = (Date)padrao.converter((Object)data);
        }
        catch (ConversorException e) {
            UtilLog.getLog().debug((Throwable)e);
        }
        return converter;
    }

    protected PluginFormAbstrato novoForm() {
        return this.getDBTFormFactory().novoGerarRemessaForm();
    }

    protected GerarRemessaForm getGerarRemessaForm() {
        return (GerarRemessaForm)this.getForm();
    }

    public void preExecucaoProcessarGerarRemessaAction() {
        this.getPanelProgresso().setVisible(true);
    }

    public void posExecucaoFinalProcessarGerarRemessaAction() {
        this.zerarBarraProgresso();
    }

    private void zerarBarraProgresso() {
        this.getBtnVoltar().setEnabled(true);
        this.habilitarBotoes();
        this.getPanelProgresso().setVisible(false);
        this.atualizaProgressBar(0);
    }

    @Override
    public void update(Observable o, Object arg) {
        Integer porcentagem = (Integer)arg;
        this.atualizaProgressBar(porcentagem);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual((long)porcentagem.intValue());
        this.getBbprogress().updateUI();
    }

    public void posExecucaoGerarResumoRemessaAction() {
        GerarRemessaForm form = (GerarRemessaForm)this.getForm();
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("FORM", form);
        this.comboConvenio = null;
        this.panelTabela = null;
        ControlableView view = ViewController.getInstance().goToView("DBTGERARREMESSARESUMO", mapa);
        this.inicializaTela();
        view.doShow(mapa);
    }
}

