/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.hob.utilitario;

import br.com.bb.hob.utilitario.FileLoaderListener;
import br.com.bb.util.Trace;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import netscape.security.PrivilegeManager;

public class FileLoader {
    private static FileLoader loader__;
    private static String nomeAtalho;
    private static String caminhoIndex;
    private static String dirImagem;
    private static String dirVersao;
    private static String homeBB__;
    private static String pathBB__;
    private static String subDir__;
    private static String logDir__;
    private static URL origemApplet__;
    private static MediaTracker mt;
    private static Panel p;
    private static Trace trace_;
    private static boolean indicadorTraceLido;
    private static boolean indicadorTrace;

    static {
        subDir__ = "";
        logDir__ = "";
        mt = null;
        p = null;
        indicadorTraceLido = false;
        indicadorTrace = false;
    }

    protected FileLoader() {
    }

    public static void apagarScript(String string) {
        FileLoader.getTrace().trace("FileLoader.apagarScript: Vou apagar o script para ambiente WINDOWS...");
        try {
            File file = new File(string);
            file.delete();
            FileLoader.getTrace().trace("FileLoader.apagarScript: O script foi apagado com sucesso");
        }
        catch (Exception exception) {
            FileLoader.getTrace().trace("FileLoader.apagarScript: Ocorreu o seguinte erro ao tentar apagar o script no Windows: ");
            FileLoader.getTrace().trace(exception);
        }
    }

    public static void comprimir(File file, File file2) throws IOException {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
        }
        FileLoader.garantirPath(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)new FileOutputStream(file2), new Deflater(9));
        FileLoader.copiar(fileInputStream, deflaterOutputStream);
        ((OutputStream)deflaterOutputStream).close();
    }

    public static void copiar(File file, File file2) throws IOException {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
        }
        FileLoader.garantirPath(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileLoader.copiar(fileInputStream, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void copiar(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
    }

    public static String corrigeParaBarraPath(String string) {
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar).replace('|', ':');
    }

    public static String corrigeParaBarraURL(String string) {
        return string.replace('\\', '/').replace(':', '|');
    }

    public static boolean executarComando(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        int n = -1;
        try {
            int n2;
            FileLoader.getTrace().trace("FileLoader.executarComando: Vou executar o script salvo para ambiente Windows...");
            Process process = runtime.exec(stringArray);
            n = n2 = process.waitFor();
            FileLoader.getTrace().trace("FileLoader.executarComando: A execu\u00e7\u00e3o retornou c\u00f3digo: " + n);
        }
        catch (Exception exception) {
            FileLoader.getTrace().trace("FileLoader.executarComando: Ocorreu o seguinte erro durante a execu\u00e7\u00e3o do script no windows: ");
            FileLoader.getTrace().trace(exception);
            FileLoader.apagarScript(stringArray[1]);
        }
        return n == 0;
    }

    public static boolean garantirPath(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return file.mkdirs();
        }
        String string = file.getParent();
        if (string == null || string.length() == 0) {
            return false;
        }
        return new File(string).mkdirs();
    }

    public static String getCaminhoIndex() {
        if (caminhoIndex == null) {
            caminhoIndex = String.valueOf(FileLoader.getPathBB()) + File.separatorChar + FileLoader.getSubDir() + File.separatorChar + "index.html";
        }
        return caminhoIndex;
    }

    public static String getDirImagem() {
        if (dirImagem == null) {
            dirImagem = String.valueOf(FileLoader.getPathBB()) + File.separatorChar + FileLoader.getSubDir() + File.separatorChar + "imagem" + File.separatorChar;
        }
        return dirImagem;
    }

    public static String getDirVersao() {
        if (dirVersao == null) {
            dirVersao = String.valueOf(FileLoader.getPathBB()) + File.separatorChar + FileLoader.getSubDir() + File.separatorChar;
        }
        return dirVersao;
    }

    public static FileLoader getFileLoader() {
        if (loader__ == null) {
            FileLoader.setFileLoader(new FileLoader());
        }
        return loader__;
    }

    public static String getHomeBB() {
        return homeBB__;
    }

    public static Image getImage(String string) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(FileLoader.loadApp("imagem/" + string, null));
            if (p == null) {
                p = new Panel();
            }
            if (mt == null) {
                mt = new MediaTracker(p);
            }
            mt.addImage(image, 0);
            mt.waitForAll();
        }
        catch (Exception exception) {}
        return image;
    }

    public static InputStream getInputStream(File file) throws IOException {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        return new FileInputStream(file);
    }

    public static synchronized InputStream getInputStream(String string) throws IOException {
        return FileLoader.getFileLoader().getInputStreamImpl(string);
    }

    public static InputStream getInputStream(URL uRL) throws IOException {
        if (FileLoader.isNetscape() && FileLoader.isOutroServidor(uRL)) {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        int n = 0;
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        do {
            try {
                inputStream = null;
                uRLConnection = null;
                uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                inputStream = uRLConnection.getInputStream();
                if (inputStream == null) continue;
                break;
            }
            catch (IOException iOException) {
                if (++n < 5) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw iOException;
            }
        } while (n < 5);
        return inputStream;
    }

    protected InputStream getInputStreamImpl(String string) throws IOException {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        return FileLoader.getInputStream(this.resolveURL(string));
    }

    public static String getLogDir() {
        return logDir__;
    }

    public static String getNomeAtalho() {
        return nomeAtalho;
    }

    public static String getNomeCache(String string) {
        String string2 = String.valueOf(FileLoader.getSubDir()) + File.separator + string;
        int n = 0;
        byte[] byArray = string2.getBytes();
        if (string2 != null) {
            int n2 = 0;
            while (n2 < byArray.length) {
                n = 37 * n + (byArray[n2] & 0xFF);
                ++n2;
            }
        }
        return String.valueOf(FileLoader.getPathBB()) + File.separator + FileLoader.getSubDir() + "cache" + File.separator + Integer.toHexString(n);
    }

    public static String getNomeScriptWin() {
        return "CriaAtalho.vbs";
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static OutputStream getOutputStream(File file) throws IOException {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        return new FileOutputStream(file);
    }

    public static OutputStream getOutputStream(URL uRL) throws IOException {
        if (FileLoader.isNetscape() && FileLoader.isOutroServidor(uRL)) {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        return uRLConnection.getOutputStream();
    }

    protected OutputStream getOutputStreamImpl(String string) throws IOException {
        if (FileLoader.isApplet()) {
            if (FileLoader.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            return FileLoader.getOutputStream(this.resolveURL(string));
        }
        return FileLoader.getOutputStream(FileLoader.resolveFile(string));
    }

    public static String getPathBB() {
        if (pathBB__ == null) {
            String string;
            if (FileLoader.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            if ((string = System.getProperty("user.dir")).endsWith(File.separator)) {
                string = string.substring(0, string.length() - File.separator.length());
            }
            return string;
        }
        return pathBB__;
    }

    public static String getPathBBTransf() {
        String string;
        File file;
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        if (!(file = new File(string = String.valueOf(FileLoader.getPathBB()) + File.separatorChar + "BBTransf")).exists()) {
            file.mkdir();
        }
        return String.valueOf(string) + File.separatorChar;
    }

    public static String getPathHob() {
        String string = String.valueOf(FileLoader.getPathBB()) + File.separatorChar;
        if (!FileLoader.getSubDir().equals("")) {
            string = String.valueOf(string) + FileLoader.getSubDir() + File.separatorChar;
        }
        return string;
    }

    public static String[] getScriptLinux() {
        String[] stringArray = new String[]{"[Desktop Entry]", "Comment=", "Comment[pt_BR]=", "Encoding=UTF-8", "Exec=", "GenericName=", "GenericName[pt_BR]=", "Icon=" + FileLoader.getDirImagem() + "bb.ico", "MimeType=", "Name=" + FileLoader.getNomeAtalho(), "Name[pt_BR]=" + FileLoader.getNomeAtalho(), "Path=", "StartupNotify=true", "Terminal=false", "TerminalOptions=", "Type=Link", "URL=" + FileLoader.getCaminhoIndex(), "X-DCOP-ServiceType=", "X-KDE-SubstituteUID=false", "X-KDE-Username="};
        return stringArray;
    }

    public static String[] getScriptWindows() {
        String[] stringArray = new String[]{"Set Shell = CreateObject(\"WScript.Shell\")", "DesktopPath = Shell.SpecialFolders(\"Desktop\")", "Set Args = Wscript.Arguments", "Set link = Shell.CreateShortcut(DesktopPath & \"\\" + FileLoader.getNomeAtalho() + ".lnk\")", "link.IconLocation = \"" + FileLoader.getDirImagem() + "bb.ico\"", "link.TargetPath = \"" + FileLoader.getCaminhoIndex() + "\"", "link.Save"};
        return stringArray;
    }

    public static String getSubDir() {
        return subDir__;
    }

    public static boolean isApplet() {
        return origemApplet__ != null;
    }

    public static boolean isDiretorio(File file) {
        return file.isDirectory();
    }

    public static boolean isIE() {
        return System.getProperty("java.vendor").toUpperCase().indexOf("MICROSOFT") != -1;
    }

    public static boolean isLinux() {
        String string = FileLoader.getOsName();
        return string.compareTo("Linux") == 0;
    }

    public static boolean isNetscape() {
        if (FileLoader.isIE()) {
            return false;
        }
        if (System.getProperty("java.vendor").toUpperCase().indexOf("NETSCAPE") != -1) {
            return true;
        }
        if (System.getProperty("java.vendor").toUpperCase().indexOf("SUN") != -1) {
            return false;
        }
        try {
            Class.forName("netscape.security.Target");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isOS2() {
        String string = FileLoader.getOsName();
        return string.toUpperCase().indexOf("OS/2") != -1;
    }

    public static boolean isOutroServidor(URL uRL) {
        return origemApplet__ == null || !origemApplet__.getHost().equalsIgnoreCase(uRL.getHost());
    }

    public static boolean isSun() {
        return System.getProperty("java.vendor").toUpperCase().indexOf("SUN") != -1;
    }

    public static byte[] load(File file) throws IOException {
        return FileLoader.load(file, null);
    }

    public static byte[] load(File file, FileLoaderListener fileLoaderListener) throws IOException {
        return FileLoader.load(file, fileLoaderListener, false);
    }

    public static synchronized byte[] load(File file, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        try {
            System.getSecurityManager().checkRead(file.getAbsolutePath());
        }
        catch (Exception exception) {}
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
        }
        InputStream inputStream = null;
        inputStream = new FileInputStream(file);
        if (bl) {
            inputStream = new InflaterInputStream(inputStream);
        }
        return FileLoader.readAllBytes(inputStream, file, (int)file.length(), fileLoaderListener);
    }

    public static synchronized byte[] load(String string, FileLoaderListener fileLoaderListener) throws IOException {
        return FileLoader.getFileLoader().loadImpl(string, fileLoaderListener, true);
    }

    public static byte[] load(URL uRL) throws IOException {
        return FileLoader.load(uRL, null, false);
    }

    public static byte[] load(URL uRL, FileLoaderListener fileLoaderListener) throws IOException {
        return FileLoader.load(uRL, fileLoaderListener, false);
    }

    public static byte[] load(URL uRL, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        if (FileLoader.isNetscape() && FileLoader.isOutroServidor(uRL)) {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
        }
        int n = 0;
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        do {
            try {
                inputStream = null;
                uRLConnection = null;
                uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                inputStream = uRLConnection.getInputStream();
                if (bl) {
                    inputStream = new InflaterInputStream(inputStream);
                }
                if (inputStream == null) continue;
                break;
            }
            catch (IOException iOException) {
                if (++n < 5) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw iOException;
            }
        } while (n < 5);
        return FileLoader.readAllBytes(inputStream, uRL, uRLConnection.getContentLength(), fileLoaderListener);
    }

    public static synchronized byte[] loadApp(String string, FileLoaderListener fileLoaderListener) throws IOException {
        return FileLoader.getFileLoader().loadImpl(string, fileLoaderListener, true);
    }

    public static String[] loadAsStringArray(URL uRL, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        return FileLoader.toStringArray(FileLoader.load(uRL, fileLoaderListener, bl));
    }

    public static byte[] loadFile(String string) throws IOException {
        return FileLoader.loadFile(string, false);
    }

    public static byte[] loadFile(String string, boolean bl) throws IOException {
        return FileLoader.getFileLoader().loadFileImpl(string, null, bl);
    }

    public byte[] loadFileImpl(String string, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        return FileLoader.load(FileLoader.resolveFile(string), fileLoaderListener, bl);
    }

    protected byte[] loadImpl(String string, FileLoaderListener fileLoaderListener, boolean bl) throws IOException {
        if (bl && FileLoader.getSubDir().length() != 0) {
            if (!string.startsWith(File.separator)) {
                string = String.valueOf(File.separator) + string;
            }
            string = String.valueOf(FileLoader.getSubDir()) + string;
        }
        if (FileLoader.isApplet()) {
            if (this.resolveURL(string) == null) {
                throw new FileNotFoundException("Arquivo n\u00e3o encontrado: " + string);
            }
            return FileLoader.load(this.resolveURL(string), fileLoaderListener);
        }
        return FileLoader.load(FileLoader.resolveFile(string), fileLoaderListener);
    }

    public static Object loadObjeto(String string) throws IOException {
        try {
            return FileLoader.getFileLoader().loadObjetoImpl(string, null, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IOException("Erro lendo objeto da stream: " + classNotFoundException.getMessage());
        }
    }

    protected Object loadObjetoImpl(String string, FileLoaderListener fileLoaderListener, boolean bl) throws IOException, ClassNotFoundException {
        InflaterInputStream inflaterInputStream = new InflaterInputStream(FileLoader.getInputStream(string));
        ObjectInputStream objectInputStream = new ObjectInputStream(inflaterInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        return FileLoader.readAllBytes(inputStream, null, -1, null);
    }

    public static byte[] readAllBytes(InputStream inputStream, Object object, int n, FileLoaderListener fileLoaderListener) throws IOException {
        int n2;
        byte[] byArray = new byte[5120];
        ByteArrayOutputStream byteArrayOutputStream = n > 0 ? new ByteArrayOutputStream(n) : new ByteArrayOutputStream();
        long l = 0L;
        int n3 = byArray.length;
        InfoLeitura infoLeitura = null;
        if (fileLoaderListener != null) {
            n3 = 512;
            infoLeitura = new InfoLeitura(object, n);
            l = System.currentTimeMillis();
        }
        long l2 = l;
        while ((n2 = inputStream.read(byArray, 0, n3)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            if (fileLoaderListener == null) continue;
            long l3 = System.currentTimeMillis();
            n3 = byArray.length;
            infoLeitura.addBloco(n2, l, l2, l3);
            l2 = l;
            fileLoaderListener.bytesArrived(infoLeitura);
        }
        inputStream.close();
        if (fileLoaderListener != null && infoLeitura.finalizar()) {
            fileLoaderListener.bytesArrived(infoLeitura);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static File resolveFile(String string) {
        return FileLoader.getFileLoader().resolveFileImpl(string);
    }

    public File resolveFileImpl(String string) {
        File file;
        if (string.indexOf(FileLoader.getPathBB()) == -1) {
            String string2 = FileLoader.getPathBB();
            string = (string = FileLoader.corrigeParaBarraPath(string)).startsWith(File.separator) ? string.substring(1) : string;
            file = new File(string2, string);
        } else {
            file = new File(string);
        }
        return file;
    }

    public URL resolveURL(String string) throws MalformedURLException {
        if (string.indexOf("://") == -1) {
            string = homeBB__.startsWith("file") && homeBB__.indexOf(File.separator) != -1 ? FileLoader.corrigeParaBarraPath(string) : FileLoader.corrigeParaBarraURL(string);
            StringBuffer stringBuffer = new StringBuffer(homeBB__);
            if (homeBB__.charAt(homeBB__.length() - 1) != '/') {
                stringBuffer.append('/');
            }
            string = stringBuffer.append(string).toString();
        } else {
            string = FileLoader.corrigeParaBarraURL(string);
        }
        return new URL(string);
    }

    public static boolean salvarScript(String string) {
        String[] stringArray = new String[]{};
        String string2 = FileLoader.getOsName();
        String string3 = null;
        File file = null;
        if (string2.toUpperCase().indexOf("WINDOWS") != -1) {
            stringArray = FileLoader.getScriptWindows();
            string3 = String.valueOf(string) + FileLoader.getNomeScriptWin();
            FileLoader.getTrace().trace("FileLoader.salvarScript: Sistema Operacional: " + string2.toUpperCase());
            FileLoader.getTrace().trace("FileLoader.salvarScript: O script ser\u00e1 salvo em  " + string3);
        } else if (string2.toUpperCase().indexOf("LINUX") != -1) {
            stringArray = FileLoader.getScriptLinux();
            string3 = String.valueOf(string) + "/Desktop/" + FileLoader.getNomeAtalho() + ".desktop";
            FileLoader.getTrace().trace("FileLoader.salvarScript: Sistema Operacional: " + string2.toUpperCase());
            FileLoader.getTrace().trace("FileLoader.salvarScript: O atalho ser\u00e1 salvo em: " + string3);
        }
        try {
            file = new File(string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            int n = 0;
            while (n < stringArray.length) {
                printWriter.write(String.valueOf(stringArray[n]) + "\r\n");
                ++n;
            }
            printWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("ERRO: N\u00e3o foi poss\u00edvel salvar em " + string3);
            FileLoader.getTrace().trace("FileLoader.salvarScript: Ocorreu erro ao tentar salvar script/atalho");
            FileLoader.getTrace().trace(exception);
            return false;
        }
        if (file.exists()) {
            FileLoader.getTrace().trace("FileLoader.salvarScript: Script/atalho foi salvo com sucesso!");
            return true;
        }
        return false;
    }

    public static void save(File file, byte[] byArray) throws IOException {
        FileLoader.save(file, byArray, false);
    }

    public static void save(File file, byte[] byArray, boolean bl) throws IOException {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
        }
        FileLoader.garantirPath(file);
        OutputStream outputStream = new FileOutputStream(file);
        if (bl) {
            outputStream = new DeflaterOutputStream(outputStream, new Deflater(9));
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        ((OutputStream)bufferedOutputStream).write(byArray);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void saveApp(String string, byte[] byArray, boolean bl) throws IOException {
        if (!string.startsWith(File.separator)) {
            string = String.valueOf(File.separator) + string;
        }
        FileLoader.getFileLoader().saveFileImpl(String.valueOf(FileLoader.getSubDir()) + string, byArray, bl);
    }

    public static void saveBB(String string, byte[] byArray) throws IOException {
        FileLoader.getFileLoader().saveFileImpl(string, byArray, false);
    }

    public void saveFileImpl(String string, byte[] byArray, boolean bl) throws IOException {
        FileLoader.save(FileLoader.resolveFile(string), byArray, bl);
    }

    public static synchronized void setFileLoader(FileLoader fileLoader) {
        if (loader__ != null) {
            new RuntimeException("O FileLoader j\u00e1 foi especificado.");
        }
        loader__ = fileLoader;
    }

    public static void setHomeBB(String string) {
        if (homeBB__ == null) {
            homeBB__ = string;
        }
    }

    public static void setLogDir(String string) {
        logDir__ = string;
    }

    public static void setOrigemApplet(URL uRL) {
        origemApplet__ = uRL;
    }

    public static void setPathBB(String string) {
        pathBB__ = string;
        if (System.getProperty("os.name").compareTo("Linux") == 0) {
            pathBB__ = "/" + string;
        }
    }

    public static void setCaminhoIndex(String string) {
        caminhoIndex = string;
    }

    public static void setDirImagem(String string) {
        dirImagem = String.valueOf(string) + File.separatorChar;
    }

    public static void setSubDir(String string) {
        subDir__ = string;
    }

    public static boolean testFileExists(File file) {
        if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
        } else if (FileLoader.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
        }
        return file.exists();
    }

    public static String[] toStringArray(byte[] byArray) throws IOException {
        String[] stringArray;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        Vector<String[]> vector = new Vector<String[]>();
        try {
            while ((stringArray = dataInputStream.readLine()) != null) {
                vector.addElement(stringArray);
            }
        }
        catch (IOException iOException) {}
        stringArray = new String[vector.size()];
        int n = vector.size() - 1;
        while (n != -1) {
            stringArray[n] = (String)vector.elementAt(n);
            --n;
        }
        return stringArray;
    }

    public static void setNomeAtalho(String string) {
        nomeAtalho = string.equalsIgnoreCase("governo") ? "Auto Atendimento Setor P\u00fablico" : "Gerenciador Financeiro";
    }

    public static Trace getTrace() {
        if (trace_ == null) {
            trace_ = new Trace("apj");
            if (FileLoader.isIndicadorTrace()) {
                trace_.openTrace("apj", true);
            }
        }
        return trace_;
    }

    public static void setIndicadorTrace(boolean bl) {
        indicadorTrace = bl;
    }

    public static boolean isIndicadorTrace() {
        if (!indicadorTraceLido) {
            indicadorTraceLido = true;
            if (FileLoader.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            File file = new File(String.valueOf(FileLoader.getPathBB()) + File.separatorChar + "trace.txt");
            indicadorTrace = file.exists();
        }
        return indicadorTrace;
    }

    public static class InfoLeitura {
        private Object origem_;
        private int bytesTamanho_;
        private int bytesTotalLidos_;
        private int bytesLidos_;
        private int indiceBloco_;
        private long tempoLatencia_;
        private int bytesLatencia_;
        private long tempoLeitura_;
        private long tempoLeituraInterno_;
        public int qtdArquivos_ = 1;
        public int bytesMaiorLatencia_;

        public InfoLeitura(Object object, int n) {
            this.origem_ = object;
            this.bytesTamanho_ = n;
        }

        public int getBytesTamanho() {
            return this.bytesTamanho_;
        }

        public int getBytesLatencia() {
            return this.bytesLatencia_;
        }

        public long getTempoLatencia() {
            return this.tempoLatencia_;
        }

        public long getTempoLeitura() {
            return this.tempoLeitura_;
        }

        public int getBytesLidos() {
            return this.bytesLidos_;
        }

        public int getBytesTotalLidos() {
            return this.bytesTotalLidos_;
        }

        public Object getOrigem() {
            return this.origem_;
        }

        public boolean finalizar() {
            if (this.bytesTamanho_ != this.bytesTotalLidos_) {
                this.bytesTamanho_ = this.bytesTotalLidos_;
                return true;
            }
            return false;
        }

        public void addBloco(int n, long l, long l2) {
            this.addBloco(n, l, this.tempoLeituraInterno_ + l, l2);
        }

        public long estimarTempoLeitura(int n) {
            long l = this.tempoLatencia_ / (long)this.qtdArquivos_;
            if ((n -= this.bytesMaiorLatencia_) > 0) {
                if (this.bytesTotalLidos_ - this.bytesLatencia_ != 0) {
                    l += (long)n * (this.tempoLeitura_ - this.tempoLatencia_) / (long)(this.bytesTotalLidos_ - this.bytesLatencia_);
                } else if (this.bytesTotalLidos_ != 0) {
                    l += (long)n * (this.tempoLeitura_ - this.tempoLatencia_) / (long)this.bytesTotalLidos_;
                }
                l += (long)(100 + n / 256);
            }
            return l;
        }

        public void addBloco(int n, long l, long l2, long l3) {
            this.bytesTotalLidos_ += n;
            this.bytesLidos_ = n;
            ++this.indiceBloco_;
            if (this.indiceBloco_ == 1) {
                this.bytesLatencia_ = n;
                this.tempoLatencia_ = l3 - l;
                if (n > this.bytesMaiorLatencia_) {
                    this.bytesMaiorLatencia_ = n;
                }
            }
            this.tempoLeitura_ = l3 - l;
            this.tempoLeituraInterno_ += l3 - l2;
        }

        public void incrementar(InfoLeitura infoLeitura) {
            this.origem_ = infoLeitura.origem_;
            this.bytesTamanho_ += infoLeitura.bytesTamanho_;
            this.bytesTotalLidos_ += infoLeitura.bytesTotalLidos_;
            this.indiceBloco_ += infoLeitura.indiceBloco_;
            this.tempoLatencia_ += infoLeitura.tempoLatencia_;
            this.bytesLatencia_ += infoLeitura.bytesLatencia_;
            this.tempoLeitura_ += infoLeitura.tempoLeitura_;
            this.tempoLeituraInterno_ += infoLeitura.tempoLeituraInterno_;
            ++this.qtdArquivos_;
            if (infoLeitura.bytesLatencia_ > this.bytesMaiorLatencia_) {
                this.bytesMaiorLatencia_ = infoLeitura.bytesLatencia_;
            }
        }

        public InfoLeitura somar(InfoLeitura infoLeitura) {
            InfoLeitura infoLeitura2 = new InfoLeitura(this.origem_, 0);
            infoLeitura2.incrementar(this);
            infoLeitura2.incrementar(infoLeitura);
            return infoLeitura2;
        }
    }
}

