/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.hob.visual;

import br.com.bb.util.ProgressoListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;

public class BBBarraProgresso
extends Panel
implements ProgressoListener {
    private long percentual_ = 0L;
    private long ultimoPercentual_ = -1L;
    private static final int BORDA = 4;
    private int valorInicial = 0;
    private int valorFinal = 0;
    private int valorAtual = 0;
    private int xTexto_;
    private int yTexto_;
    private int xBarra_;
    private int yBarra_;
    private int alturaBarra_;
    private int larguraTotalBarra_;

    public BBBarraProgresso() {
        this.setSize(this.getPreferredSize());
    }

    public BBBarraProgresso(Color color, Color color2) {
        this.setForeground(color2);
        this.setBackground(color);
        this.setSize(this.getPreferredSize());
    }

    public void bytesArrived() {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public long getPercentual() {
        return this.percentual_;
    }

    public Dimension getPreferredSize() {
        return new Dimension(23, 35);
    }

    public void layout() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        this.xTexto_ = 4;
        this.yTexto_ = (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        this.xBarra_ = 8 + fontMetrics.stringWidth("100%");
        this.yBarra_ = 4;
        this.alturaBarra_ = dimension.height - 8;
        this.larguraTotalBarra_ = dimension.width - 4 - this.xBarra_;
        this.ultimoPercentual_ = -1L;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (graphics != null) {
            if (this.ultimoPercentual_ != this.percentual_) {
                Dimension dimension = this.getSize();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.xBarra_ - 1, dimension.height);
                graphics.setColor(this.getForeground());
                graphics.drawString(String.valueOf(this.percentual_) + "%", this.xTexto_, this.yTexto_);
                this.ultimoPercentual_ = this.percentual_;
            }
            int n = (int)((long)this.larguraTotalBarra_ * this.percentual_ / 100L);
            if (this.alturaBarra_ > 0 && this.larguraTotalBarra_ > 0) {
                graphics.setColor(this.getForeground());
                graphics.drawRect(this.xBarra_, this.yBarra_, this.larguraTotalBarra_, this.alturaBarra_);
                graphics.fillRect(this.xBarra_ + 1, this.yBarra_ + 1, n - 1, this.alturaBarra_ - 1);
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.xBarra_ + n + 1, this.yBarra_ + 1, this.larguraTotalBarra_ - n - 1, this.alturaBarra_ - 1);
            }
        }
    }

    public void setPercentual(int n) {
        this.percentual_ = n;
        this.repaint();
    }

    public void setPercentual(long l) {
        this.percentual_ = l;
        this.repaint();
    }

    public void setValorAtual(int n) {
        long l = n;
        if (this.valorFinal - this.valorInicial > 0) {
            long l2 = (l - (long)this.valorInicial) * 100L / (long)(this.valorFinal - this.valorInicial);
            this.setPercentual(l2 > 100L ? 100L : l2);
        }
    }

    public void setValores(int n, int n2) {
        this.valorInicial = n;
        this.valorFinal = n2;
    }

    public void setValorFinal(int n) {
        this.valorFinal = n;
    }

    public void setValorInicial(int n) {
        this.valorInicial = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

