/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.instalacao;

import br.com.bb.hob.utilitario.BBException;
import br.com.bb.hob.utilitario.FileLoader;
import br.com.bb.instalacao.CriptoCachedFileLoader;
import br.com.bb.instalacao.Inicializavel;
import br.com.bb.instalacao.LoaderToolkit;
import br.com.bb.instalacao.ProvedorInstalacao;
import br.com.bb.instalacao.VerificaConexao;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public abstract class AppletLoader
extends Applet
implements Runnable,
ActionListener {
    private static final String SITE_BB_DEFAULT = "https://office.bancobrasil.com.br";
    private String titulo_ = "";
    private String cliente_ = "";
    private String cliente = null;
    private Button botaoErro;
    private Button botaoCertificado = null;

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            try {
                Button button = (Button)actionEvent.getSource();
                if (button.getActionCommand().equals("problemas")) {
                    try {
                        String string = this.getURLProvedor().substring(8);
                        if (this.cliente_.equals("office")) {
                            String string2 = "http://" + string + "/office/texto/problemasConexao.html";
                            this.getAppletContext().showDocument(new URL(string2), "Gerenciador Financeiro");
                            break block6;
                        }
                        String string3 = "http://" + string + "/governo/texto/problemasConexao.html";
                        this.getAppletContext().showDocument(new URL(string3), "Auto-Atendimento Setor P\u00fablico");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block6;
                }
                BBException bBException = new BBException(null, "AI01", "001", "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o Banco do Brasil.", this.executarTrace());
                LoaderToolkit.tratarErro(this, null, bBException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void carregarApplet(ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = classLoader.loadClass(this.getNomeClasse());
        Object obj = clazz.newInstance();
        this.inicializar(obj);
        this.validate();
    }

    private String[] executarTrace() {
        Object[] objectArray;
        if (FileLoader.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.EXEC);
        } else if (FileLoader.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalExecAccess");
        }
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = Runtime.getRuntime();
            URL uRL = new URL(this.getURLProvedor());
            if (!FileLoader.isLinux()) {
                Process process = objectArray.exec("tracert " + uRL.getHost());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    vector.addElement(string);
                    System.out.println(string);
                }
            } else {
                Process process = objectArray.exec("traceroute " + uRL.getHost());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    vector.addElement(string);
                    System.out.println(string);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Problemas na leitura da resposta do tracert");
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected abstract String getNomeClasse();

    public String getNomeCliente() {
        return this.cliente_;
    }

    protected abstract String getNomeProduto();

    protected String getNomeProvedor() {
        return "Banco do Brasil";
    }

    protected String getProvedorDefault() {
        return SITE_BB_DEFAULT;
    }

    protected abstract String getSubDir();

    public String getTitulo() {
        return this.titulo_;
    }

    protected String getURLProvedor() {
        String string = this.getParameter("homeBB");
        if (string != null) {
            return string;
        }
        return this.getProvedorDefault();
    }

    protected void inicializar(Object object) {
        if (object instanceof Inicializavel) {
            ((Inicializavel)object).inicializar(this);
        }
    }

    public void init() {
        this.cliente = this.getParameter("cliente");
        if (this.cliente == null) {
            this.cliente_ = "office";
        } else if (this.cliente.equalsIgnoreCase("governo")) {
            this.cliente_ = "governo";
        }
        this.titulo_ = this.cliente_.equals("office") ? "Gerenciador Financeiro" : "Auto-Atendimento Setor P\u00fablico";
        new Thread(this).start();
        this.setLayout(new BorderLayout());
        String string = "Aguarde, localizando site do " + this.titulo_ + "...";
        Label label = new Label(string, 1);
        label.setFont(new Font("sansserif", 0, 16));
        this.setBackground(new Color(255, 255, 255));
        this.setForeground(new Color(0, 0, 102));
        this.add((Component)label, "Center");
    }

    public void run() {
        try {
            ProvedorInstalacao provedorInstalacao = new ProvedorInstalacao(this.getNomeProduto(), this.getNomeProvedor(), this.getURLProvedor(), this.getNomeCliente());
            ProvedorInstalacao.setIndicadorAtualizacao(true);
            CriptoCachedFileLoader.resetTabelaHash();
            ClassLoader classLoader = this.getClassLoader();
            FileLoader.setPathBB(LoaderToolkit.findOrigem(this.getCodeBase()));
            FileLoader.setSubDir(this.getSubDir());
            FileLoader.setOrigemApplet(this.getCodeBase());
            FileLoader.setHomeBB(this.getURLProvedor());
            FileLoader.setFileLoader(new CriptoCachedFileLoader(classLoader, provedorInstalacao));
            FileLoader.getTrace().trace("AppletLoader.run: local de instala\u00e7\u00e3o [" + FileLoader.getPathBB() + File.separatorChar + FileLoader.getSubDir() + "]");
            if (!LoaderToolkit.atualizarVersao(this, this.getTitulo(), true)) {
                FileLoader.getTrace().trace("AppletLoader.run: Carregando interface do aplicativo...");
                this.carregarApplet(classLoader);
            }
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                BBException bBException;
                FileLoader.getTrace().trace("AppletLoader.run: Ocorreu o seguinte erro: " + exception.getMessage());
                FileLoader.getTrace().trace(exception);
                String[] stringArray = new String[]{"Caso esteja utilizando Internet Explorer 4.x, atualize o Certificado Raiz", "conforme instru\u00e7\u00f5es contidas em Outros Problemas.", " ", "Se a comunica\u00e7\u00e3o est\u00e1 sendo feita por modem, certifique-se que", "a conex\u00e3o telef\u00f4nica est\u00e1 ativa.", " ", "Se a comunica\u00e7\u00e3o est\u00e1 sendo feita por proxy, certifique-se que", "o acesso \u00e0 internet est\u00e1 normal.", " ", "Se a utiliza\u00e7\u00e3o do " + this.titulo_ + " vem sendo feita normalmente,", "tente novamente ap\u00f3s alguns minutos.", " ", "Caso o acesso esteja sendo efetuado pela primeira vez neste", "equipamento, entre em contato com a Central de Atendimento pelo", "telefone 0800-7290500."};
                try {
                    FileLoader.getTrace().trace("AppletLoader.run: Iniciando testes de DNS, Data/hora e HTTP...");
                    VerificaConexao.testeDNS();
                    VerificaConexao.testeDataHora();
                    VerificaConexao.testeHTTP();
                    bBException = new BBException(exception, "AI01", "001", "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o Banco do Brasil.", stringArray);
                }
                catch (BBException bBException2) {
                    bBException = bBException2;
                }
                this.removeAll();
                Panel panel = new Panel();
                Panel panel2 = new Panel(new FlowLayout());
                this.botaoCertificado = new Button("Outros Problemas");
                this.botaoCertificado.addActionListener(this);
                this.botaoCertificado.setActionCommand("problemas");
                this.botaoErro = new Button("Verificar Conex\u00e3o");
                this.botaoErro.addActionListener(this);
                this.botaoErro.setActionCommand("AI01");
                LoaderToolkit.tratarErro(panel, null, bBException);
                panel2.add(this.botaoErro);
                panel2.add(this.botaoCertificado);
                this.setLayout(new BorderLayout());
                this.add("Center", panel);
                this.add("South", panel2);
                this.invalidate();
                this.validate();
                this.repaint();
            }
            String string = System.getProperty("java.vendor");
            boolean bl = this.getDocumentBase().toString().toUpperCase().indexOf("OFFICEIE") != -1 || this.getDocumentBase().toString().toUpperCase().indexOf("GOVERNOIE") != -1;
            boolean bl2 = this.getDocumentBase().toString().toUpperCase().indexOf("OFFICENE") != -1 || this.getDocumentBase().toString().toUpperCase().indexOf("GOVERNONE") != -1;
            boolean bl3 = this.getDocumentBase().toString().toUpperCase().indexOf("OFFICEPLUGIN") != -1 || this.getDocumentBase().toString().toUpperCase().indexOf("GOVERNOPLUGIN") != -1;
            if (bl & string.toUpperCase().indexOf("SUN") != -1) {
                LoaderToolkit.tratarErro(this, "Para esta instala\u00e7\u00e3o use m\u00e1quina virtual Java Microsoft", exception);
            }
            if (bl2 & string.toUpperCase().indexOf("MICROSOFT") != -1) {
                LoaderToolkit.tratarErro(this, "Para esta instala\u00e7\u00e3o use m\u00e1quina virtual Java Netscape ou Sun Microsystems", exception);
            }
            if (bl3 & string.toUpperCase().indexOf("MICROSOFT") != -1) {
                LoaderToolkit.tratarErro(this, "Para esta instala\u00e7\u00e3o use m\u00e1quina virtual Java Sun Microsystems", exception);
            }
            if (bl3 & string.toUpperCase().indexOf("NETSCAPE") != -1) {
                LoaderToolkit.tratarErro(this, "Para esta instala\u00e7\u00e3o use m\u00e1quina virtual Java Sun Microsystems", exception);
            }
            FileLoader.getTrace().trace("AppletLoader.run: Falha n\u00e3o identificada: " + exception.getMessage());
            FileLoader.getTrace().trace(exception);
            LoaderToolkit.tratarErro(this, "Falha n\u00e3o identificada.", exception);
        }
    }
}

