/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.instalacao;

import br.com.bb.hob.utilitario.FileLoader;
import br.com.bb.hob.utilitario.FileLoaderListener;
import br.com.bb.instalacao.TabelaInfoDiretorio;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import netscape.security.PrivilegeManager;

public class ProvedorInstalacao
implements FileLoaderListener {
    private final String nome_;
    private final String url_;
    private final String produto_;
    private int hashVersao_;
    private int versaoAtual_;
    private int versaoNova_;
    private int versaoCliente_;
    private TabelaInfoDiretorio infoDir_;
    private TabelaInfoDiretorio infoZip_;
    private String[] arquivosToCopy_;
    private String[] arquivosNucleo_;
    private boolean atualizacaoNecessaria_;
    private boolean verificado_;
    private FileLoader.InfoLeitura infoLeitura_ = new FileLoader.InfoLeitura(null, 0);
    private int status_ = 0;
    public static final byte DESCONHECIDO = 0;
    public static final byte NAO_ENCONTRADO = 1;
    public static final byte VERSAO_ERRADA = 2;
    public static final byte VERIFICANDO = 3;
    public static final byte VERIFICADO = 4;
    public static String DIR_MATRIZ = "office/matriz";
    private String[] arquivosAtualiza_;
    private static boolean indicadorAtualizacao_ = false;
    private static boolean indicadorArquivoAtualizacao_ = false;
    private static boolean indicadorVerificacaoArquivoAtualizacao_ = false;

    public ProvedorInstalacao(String string, String string2, String string3, String string4) {
        this.nome_ = string2;
        this.produto_ = string;
        this.url_ = string3;
        if (string4.equalsIgnoreCase("governo")) {
            DIR_MATRIZ = "governo/matriz";
        }
    }

    public void bytesArrived(FileLoader.InfoLeitura infoLeitura) {
        if (infoLeitura.getBytesTamanho() == infoLeitura.getBytesTotalLidos()) {
            this.infoLeitura_.incrementar(infoLeitura);
        }
    }

    public static int byteToHash(byte[] byArray) {
        return Integer.parseInt(new String(byArray));
    }

    public String[] getArquivosToCopy() throws IOException {
        if (this.arquivosToCopy_ == null) {
            this.arquivosToCopy_ = FileLoader.loadAsStringArray(this.getURLRelacaoArquivos(), this, true);
        }
        return this.arquivosToCopy_;
    }

    public String getIdentificador() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = gregorianCalendar.get(14);
        String string = String.valueOf(ProvedorInstalacao.strZero(n, 4)) + ProvedorInstalacao.strZero(n2, 2) + ProvedorInstalacao.strZero(n3, 2) + ProvedorInstalacao.strZero(n4, 2) + ProvedorInstalacao.strZero(n5, 2) + ProvedorInstalacao.strZero(n6, 2) + ProvedorInstalacao.strZero(n7, 4);
        String string2 = String.valueOf(string) + System.getProperty("java.version") + System.getProperty("java.vendor") + System.getProperty("os.name") + System.getProperty("os.version");
        int n8 = string2.hashCode();
        int n9 = 0;
        if (n8 < 0) {
            n9 = 1;
            n8 *= -1;
        }
        string = String.valueOf(n9) + ProvedorInstalacao.strZero(n8, 10) + string;
        return string;
    }

    public static boolean getIndicadorAtualizacao() {
        return indicadorAtualizacao_;
    }

    public TabelaInfoDiretorio getInfoAssinado() {
        return this.infoDir_;
    }

    public FileLoader.InfoLeitura getInfoLeitura() {
        return this.infoLeitura_;
    }

    public TabelaInfoDiretorio getInfoZip() throws MalformedURLException, IOException {
        if (this.infoZip_ == null) {
            byte[] byArray = FileLoader.load(this.getURLTabelaHashZip(), (FileLoaderListener)this, true);
            this.infoZip_ = new TabelaInfoDiretorio(byArray, false);
        }
        return this.infoZip_;
    }

    public String[] getListaAtualiza() throws IOException, MalformedURLException {
        if (this.arquivosAtualiza_ == null) {
            this.arquivosAtualiza_ = FileLoader.loadAsStringArray(this.getURLRelacaoAtualiza(), this, true);
        }
        return this.arquivosAtualiza_;
    }

    public String[] getListaNucleo() throws IOException, MalformedURLException {
        if (this.arquivosNucleo_ == null) {
            this.arquivosNucleo_ = FileLoader.loadAsStringArray(this.getURLArquivoComprimido("nucleo.info"), null, true);
        }
        return this.arquivosNucleo_;
    }

    public String getNome() {
        return this.nome_;
    }

    public String getProduto() {
        return this.produto_;
    }

    public int getStatus() {
        return this.status_;
    }

    public String getStatusAsString() {
        switch (this.status_) {
            case 0: {
                return "Desconhecido";
            }
            case 1: {
                return "N\u00e3o Encontrado";
            }
            case 2: {
                return "Vers\u00e3o Errada";
            }
            case 3: {
                return "Verificando...";
            }
            case 4: {
                return "Ok";
            }
        }
        return null;
    }

    public long getTempo() {
        return this.infoLeitura_.getTempoLeitura();
    }

    public String getURL() {
        return this.url_;
    }

    public URL getURLArquivoComprimido(String string) throws MalformedURLException, IOException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/" + Integer.toString(this.hashVersao_) + "/zip/" + FileLoader.corrigeParaBarraURL(string));
    }

    private URL getURLRelacaoArquivos() throws MalformedURLException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/" + Integer.toString(this.hashVersao_) + "/nucleo_instalacao.info");
    }

    private URL getURLRelacaoAtualiza() throws MalformedURLException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/" + Integer.toString(this.hashVersao_) + "/atualiza.info");
    }

    private URL getURLTabelaHash() throws MalformedURLException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/" + Integer.toString(this.hashVersao_) + "/hashassinado.info");
    }

    private URL getURLTabelaHashZip() throws MalformedURLException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/" + Integer.toString(this.hashVersao_) + "/hashzipado.info");
    }

    private URL getURLVersaoAtual() throws MalformedURLException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/versaoatual.info");
    }

    private URL getURLVersaoNova() throws MalformedURLException {
        return new URL(String.valueOf(this.url_) + "/" + DIR_MATRIZ + "/" + this.produto_ + "/versaonova.info");
    }

    public int getVersao() {
        return this.hashVersao_;
    }

    public boolean isArquivoNucleo(String string) throws IOException, MalformedURLException {
        String[] stringArray = this.getListaNucleo();
        int n = stringArray.length - 1;
        while (n != -1) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public boolean isOk() {
        return this.status_ == 4;
    }

    public boolean precisaAtualizar() {
        return this.atualizacaoNecessaria_;
    }

    public void salvarIdentificador() {
        try {
            if (FileLoader.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
            }
            File file = new File(String.valueOf(FileLoader.getPathBB()) + File.separator + FileLoader.getSubDir() + File.separator + "cache" + File.separator + Integer.toHexString(TabelaInfoDiretorio.calcularHash("arquivoX".getBytes())));
            FileLoader.garantirPath(file);
            if (!file.exists()) {
                Deflater deflater = new Deflater(9);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new DeflaterOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), deflater));
                objectOutputStream.writeObject(this.getIdentificador());
                objectOutputStream.close();
            }
        }
        catch (IOException iOException) {
            FileLoader.getTrace().trace("ProvedorInstalacao.salvarIdentificador: Ocorreu erro na tentativa de grava\u00e7\u00e3o de arquivo: " + iOException.getMessage());
            FileLoader.getTrace().trace(iOException);
            iOException.printStackTrace();
        }
    }

    public static void setIndicadorAtualizacao(boolean bl) {
        indicadorAtualizacao_ = bl;
    }

    public void setVersao(int n) {
        this.hashVersao_ = n;
    }

    public static String strZero(int n, int n2) {
        String string = String.valueOf(n);
        String string2 = "0";
        if ((string = string.trim()) != null && string.length() <= n2) {
            string2 = string;
            int n3 = 0;
            while (n3 < n2 - string.length()) {
                string2 = "0" + string2;
                ++n3;
            }
        }
        return string2;
    }

    public boolean existeAtualizacaoZbb() {
        if (!indicadorVerificacaoArquivoAtualizacao_) {
            try {
                FileLoader.getInputStream(this.getURLArquivoComprimido("atualizacao.zbb"));
            }
            catch (IOException iOException) {
                indicadorArquivoAtualizacao_ = false;
                return indicadorArquivoAtualizacao_;
            }
            indicadorArquivoAtualizacao_ = true;
            indicadorVerificacaoArquivoAtualizacao_ = true;
            return indicadorArquivoAtualizacao_;
        }
        return indicadorArquivoAtualizacao_;
    }

    public void verificar() throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (!this.verificado_) {
            try {
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar: Buscando versaoatual...");
                byArray = FileLoader.load(this.getURLVersaoAtual(), (FileLoaderListener)this);
                this.versaoAtual_ = ProvedorInstalacao.byteToHash(byArray);
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar: Buscando versaonova...");
                byArray2 = FileLoader.load(this.getURLVersaoNova(), (FileLoaderListener)this);
                this.versaoNova_ = ProvedorInstalacao.byteToHash(byArray2);
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar: Arquivos de versao buscados com sucesso!");
            }
            catch (IOException iOException) {
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar: Ocorreu erro ao buscar arquivo de vers\u00e3o!\n" + iOException.getMessage());
                FileLoader.getTrace().trace(iOException);
                System.out.println("Arquivo de versao n\u00e3o encontrado! " + this.versaoAtual_ + "/" + this.versaoNova_);
                if (this.versaoAtual_ != 0) {
                    FileLoader.getTrace().trace("ProvedorInstalacao.verificar: arquivo versaonova n\u00e3o foi encontrado. Irei usar versaoatual para atualizar, se necess\u00e1rio.");
                    this.setVersao(this.versaoAtual_);
                    this.verificar(this.versaoAtual_);
                    this.verificado_ = true;
                }
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar: O seguinte erro ocorreu:\r\n   " + iOException.getMessage());
                FileLoader.getTrace().trace(iOException);
                throw iOException;
            }
            this.verificarVersao();
            this.verificado_ = true;
        } else {
            FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: versaoatual   = " + this.versaoAtual_);
            FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: versaonova    = " + this.versaoNova_);
            FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: versaocliente = " + this.versaoCliente_);
        }
    }

    private void verificar(int n) {
        this.status_ = 3;
        this.salvarIdentificador();
        try {
            byte[] byArray;
            try {
                File file = new File(String.valueOf(FileLoader.getPathBB()) + File.separatorChar + FileLoader.getSubDir() + File.separatorChar + "hashassinado.info");
                byArray = FileLoader.load(file);
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar(int): versaoatual = " + n);
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar(int): versaocliente = " + TabelaInfoDiretorio.calcularHash(byArray));
                if (TabelaInfoDiretorio.calcularHash(byArray) != n) {
                    byArray = FileLoader.load(this.getURLTabelaHash(), (FileLoaderListener)this, true);
                    FileLoader.saveBB(String.valueOf(FileLoader.getSubDir()) + File.separatorChar + "hashassinado.info", byArray);
                    this.atualizacaoNecessaria_ = true;
                }
            }
            catch (IOException iOException) {
                FileLoader.getTrace().trace("ProvedorInstalacao.verificar(int): Ocorreu o seguinte erro na tentativa de carregar o arquivo versaocliente: \r\n    " + iOException.getMessage());
                FileLoader.getTrace().trace(iOException);
                byArray = FileLoader.load(this.getURLTabelaHash(), (FileLoaderListener)this, true);
                if (TabelaInfoDiretorio.calcularHash(byArray) != n) {
                    this.status_ = 2;
                    return;
                }
                FileLoader.saveBB(String.valueOf(FileLoader.getSubDir()) + File.separatorChar + "hashassinado.info", byArray);
                this.atualizacaoNecessaria_ = true;
            }
            this.infoDir_ = new TabelaInfoDiretorio(byArray, false);
            this.status_ = 4;
        }
        catch (Exception exception) {
            FileLoader.getTrace().trace("ProvedorInstalacao.verificar(int): Ocorreu o seguinte erro:\r\n    " + exception.getMessage());
            FileLoader.getTrace().trace(exception);
            exception.printStackTrace();
            this.status_ = 1;
        }
    }

    private void verificarVersao() {
        this.status_ = 3;
        byte[] byArray = null;
        this.salvarIdentificador();
        try {
            try {
                File file = new File(String.valueOf(FileLoader.getPathBB()) + File.separatorChar + FileLoader.getSubDir() + File.separatorChar + "hashassinado.info");
                FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: versaoatual   = " + this.versaoAtual_);
                FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: versaonova    = " + this.versaoNova_);
                if (file.exists()) {
                    byArray = FileLoader.load(file, (FileLoaderListener)this);
                    this.versaoCliente_ = TabelaInfoDiretorio.calcularHash(byArray);
                    FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: versaocliente = " + this.versaoCliente_);
                    if (this.versaoCliente_ != this.versaoAtual_ & this.versaoCliente_ != this.versaoNova_) {
                        this.setVersao(this.versaoNova_);
                        byArray = FileLoader.load(this.getURLTabelaHash(), (FileLoaderListener)this, true);
                        FileLoader.saveBB(String.valueOf(FileLoader.getSubDir()) + File.separatorChar + "hashassinado.info", byArray);
                        this.atualizacaoNecessaria_ = true;
                    } else {
                        this.setVersao(this.versaoCliente_);
                    }
                } else {
                    FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: Arquivo versaoCliente n\u00e3o existe.");
                    FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: A vers\u00e3o do cliente ser\u00e1 ajustada para versaonova.");
                    this.setVersao(this.versaoNova_);
                    byArray = FileLoader.load(this.getURLTabelaHash(), (FileLoaderListener)this, true);
                    if (TabelaInfoDiretorio.calcularHash(byArray) != this.versaoNova_) {
                        this.status_ = 2;
                        return;
                    }
                    FileLoader.saveBB(String.valueOf(FileLoader.getSubDir()) + File.separatorChar + "hashassinado.info", byArray);
                    this.atualizacaoNecessaria_ = true;
                }
            }
            catch (IOException iOException) {
                FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: ocorreu o seguinte erro na tentativa de leitura de arquivo do servidor:\n    " + iOException.getMessage());
                FileLoader.getTrace().trace(iOException);
                iOException.printStackTrace();
            }
            this.infoDir_ = new TabelaInfoDiretorio(byArray, false);
            this.status_ = 4;
        }
        catch (Exception exception) {
            FileLoader.getTrace().trace("ProvedorInstalacao.verificarVersao: ocorreu o seguinte erro durante a verifica\u00e7\u00e3o de versao:\r\n    " + exception.getMessage());
            FileLoader.getTrace().trace(exception);
            exception.printStackTrace();
            this.status_ = 1;
        }
    }
}

