/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.instalacao;

import br.com.bb.hob.utilitario.FileLoader;
import br.com.bb.instalacao.InfoArquivo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class TabelaInfoDiretorio {
    private final Hashtable tabelaHash_ = new Hashtable();
    private final Vector listaOrdenada_ = new Vector();

    public TabelaInfoDiretorio(byte[] byArray, boolean bl) throws IOException {
        InputStream inputStream = new ByteArrayInputStream(byArray);
        if (bl) {
            inputStream = new InflaterInputStream(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            while (true) {
                String string = FileLoader.corrigeParaBarraPath(dataInputStream.readUTF());
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                this.addInfo(new InfoArquivo(string, n, n2));
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public TabelaInfoDiretorio(File file, String string) throws IOException {
        File file2 = new File(String.valueOf(file.toString()) + File.separatorChar + string);
        this.hashArvore(file2, string);
    }

    private void addInfo(InfoArquivo infoArquivo) {
        this.tabelaHash_.put(infoArquivo.getNome().toUpperCase(), infoArquivo);
        this.listaOrdenada_.addElement(infoArquivo);
    }

    public static int calcularHash(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 37 * n + (byArray[n2] & 0xFF);
            ++n2;
        }
        return n;
    }

    public static int calcularHash(File file) throws IOException {
        byte[] byArray = FileLoader.load(file);
        return TabelaInfoDiretorio.calcularHash(byArray);
    }

    public int count() {
        return this.listaOrdenada_.size();
    }

    public InfoArquivo[] desatualizados(String[] stringArray) {
        Vector<InfoArquivo> vector = new Vector<InfoArquivo>();
        int n = 0;
        while (n < stringArray.length) {
            InfoArquivo infoArquivo = this.getInfo(stringArray[n]);
            if (infoArquivo == null) {
                System.out.println("Arquivo '" + stringArray[n] + "' n\u00e3o se encontra na lista de hash.");
                System.out.println("Atual tabela de hash (nome-tamanho-hash):");
                int n2 = 0;
                while (n2 < this.count()) {
                    infoArquivo = this.getInfoAt(n2);
                    System.out.println("      " + infoArquivo.getNome() + "     |" + infoArquivo.getTamanho() + "|" + infoArquivo.getHash());
                    ++n2;
                }
                throw new RuntimeException("Arquivo '" + stringArray[n] + "' n\u00e3o se encontra na lista de hash.");
            }
            if (!infoArquivo.isSincronizado()) {
                vector.addElement(infoArquivo);
            }
            ++n;
        }
        Object[] objectArray = new InfoArquivo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public byte[] getBytes(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.salvar(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public int getHashTabela() throws IOException {
        return TabelaInfoDiretorio.calcularHash(this.getBytes(false));
    }

    public InfoArquivo getInfo(String string) {
        return (InfoArquivo)this.tabelaHash_.get(string.toUpperCase());
    }

    public InfoArquivo getInfoAt(int n) {
        return (InfoArquivo)this.listaOrdenada_.elementAt(n);
    }

    private void hashArvore(File file, String string) throws IOException {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(String.valueOf(file.toString()) + File.separatorChar + stringArray[n]);
            String string2 = string.length() != 0 ? String.valueOf(string) + File.separatorChar + stringArray[n] : stringArray[n];
            if (file2.isDirectory()) {
                this.hashArvore(file2, string2);
            } else {
                byte[] byArray = FileLoader.load(file2);
                if (byArray.length > 0) {
                    int n2 = TabelaInfoDiretorio.calcularHash(byArray);
                    int n3 = byArray.length;
                    InfoArquivo infoArquivo = new InfoArquivo(string2, n2, n3);
                    this.addInfo(infoArquivo);
                }
                byArray = null;
            }
            ++n;
        }
    }

    public void reset() {
        int n = this.count() - 1;
        while (n != -1) {
            this.getInfoAt(n).reset();
            --n;
        }
    }

    public void salvar(OutputStream outputStream, boolean bl) throws IOException {
        if (bl) {
            outputStream = new DeflaterOutputStream(outputStream, new Deflater(9));
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        FileWriter fileWriter = new FileWriter("C:\\relatorio.txt");
        int n = 0;
        while (n < this.listaOrdenada_.size()) {
            InfoArquivo infoArquivo = (InfoArquivo)this.listaOrdenada_.elementAt(n);
            fileWriter.write(String.valueOf(infoArquivo.getNome()) + "  " + infoArquivo.getHash() + "  " + infoArquivo.getTamanho() + "\n");
            dataOutputStream.writeUTF(infoArquivo.getNome());
            dataOutputStream.writeInt(infoArquivo.getHash());
            dataOutputStream.writeInt(infoArquivo.getTamanho());
            ++n;
        }
        fileWriter.close();
        dataOutputStream.close();
        outputStream.close();
    }

    public void salvarArquivo(String string, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.salvar(fileOutputStream, bl);
        ((OutputStream)fileOutputStream).close();
    }
}

