/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Trace {
    public boolean tracing = false;
    private boolean horaThread = true;
    private String traceDir = String.valueOf(File.separator) + "tmp" + File.separator;
    private String traceArq;
    private DateFormat data = null;
    private FileWriter traceDescriptor = null;
    PrintWriter tracePrinter_ = null;
    private int diaCorrente = Calendar.getInstance().get(7);

    public Trace() {
        this(null);
    }

    public Trace(Object object) {
        this(object.getClass().getName());
    }

    public Trace(String string) {
        this.traceArq = string;
        this.data = new SimpleDateFormat("ddMMMyyyy");
    }

    public Trace(String string, boolean bl) {
        this(string);
        this.horaThread = bl;
    }

    public final void closeTrace() {
        this.tracing = false;
        if (this.traceDescriptor == null) {
            return;
        }
        try {
            this.traceDescriptor.close();
        }
        catch (IOException iOException) {}
    }

    public final synchronized String getTraceArq() {
        return this.traceArq;
    }

    public final synchronized String getTraceDir() {
        return this.traceDir;
    }

    public final synchronized boolean isTrace() {
        return this.tracing;
    }

    public final boolean openTrace() {
        if (this.tracing) {
            return false;
        }
        if (this.traceArq == null) {
            return this.openTrace(this, false);
        }
        return this.openTrace(this.traceArq, false);
    }

    public final boolean openTrace(Object object) {
        if (this.tracing) {
            return false;
        }
        String string = object.getClass().getName();
        return this.openTrace(string, false);
    }

    public final boolean openTrace(Object object, boolean bl) {
        if (this.tracing) {
            return false;
        }
        String string = object.getClass().getName();
        return this.openTrace(string, bl);
    }

    public final boolean openTrace(String string) {
        return this.openTrace(string, false);
    }

    public final boolean openTrace(String string, boolean bl) {
        int n = 0;
        if (this.tracing) {
            return false;
        }
        this.traceArq = string;
        new Date();
        FileWriter fileWriter = null;
        if (string == null) {
            return false;
        }
        File file = new File(this.traceDir);
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        try {
            n = Calendar.getInstance().get(7);
            fileWriter = new FileWriter(String.valueOf(this.traceDir) + string + ".trc" + n, bl);
        }
        catch (IOException iOException) {
            return false;
        }
        this.traceDescriptor = fileWriter;
        this.tracePrinter_ = new PrintWriter((Writer)fileWriter, true);
        this.tracing = true;
        return true;
    }

    public final synchronized void setTraceDir(String string) {
        File file;
        if (string == null) {
            return;
        }
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        if (!(file = new File(string)).exists() && !file.mkdirs()) {
            string = ".";
        }
        this.traceDir = string;
    }

    public final synchronized boolean trace(String string) {
        if (!this.tracing) {
            return false;
        }
        return this.trace(string, null);
    }

    public final synchronized boolean trace(String string, Object[] objectArray) {
        if (!this.tracing) {
            return false;
        }
        if (string == null || this.traceDescriptor == null) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMM-HH:mm:ss:SSS");
        try {
            Calendar calendar = Calendar.getInstance();
            String string2 = objectArray == null ? (this.horaThread ? String.valueOf(simpleDateFormat.format(calendar.getTime())) + " " + Thread.currentThread().getName() + ":" + string : string) : (this.horaThread ? String.valueOf(simpleDateFormat.format(calendar.getTime())) + " " + Thread.currentThread().getName() + ":" + MessageFormat.format(string, objectArray) : MessageFormat.format(string, objectArray));
            if (Calendar.getInstance().get(7) != this.diaCorrente) {
                this.tracePrinter_.println("Trace(trace) - Vou fechar trace do dia: " + this.diaCorrente);
                this.tracePrinter_.flush();
                this.closeTrace();
                this.diaCorrente = Calendar.getInstance().get(7);
                this.openTrace(this.traceArq, false);
                this.tracePrinter_.println("Trace(trace) - Abri trace do dia: " + this.diaCorrente);
                this.tracePrinter_.flush();
            }
            this.tracePrinter_.println(string2);
            this.tracePrinter_.flush();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public final synchronized boolean trace(String string, Object object) {
        if (!this.tracing) {
            return false;
        }
        Object[] objectArray = new Object[]{object};
        return this.trace(string, objectArray);
    }

    public final synchronized boolean trace(String string, Object object, Object object2) {
        if (!this.tracing) {
            return false;
        }
        Object[] objectArray = new Object[]{object, object2};
        return this.trace(string, objectArray);
    }

    public final synchronized boolean trace(Throwable throwable) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMM-HH:mm:ss:SSS");
        if (!this.tracing) {
            return false;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            String string = String.valueOf(simpleDateFormat.format(calendar.getTime())) + " " + Thread.currentThread().getName() + ":";
            this.tracePrinter_.print(string);
            throwable.printStackTrace(this.tracePrinter_);
            this.tracePrinter_.flush();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

