/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.standard.resources.Resources;

public class Util {
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    private static final String DEFAULT = "default";
    private static final String SHORT = "short";
    private static final String MEDIUM = "medium";
    private static final String LONG = "long";
    private static final String FULL = "full";
    public static final int HIGHEST_SPECIAL = 62;
    public static char[][] specialCharactersRepresentation = new char[63][];

    public static int getScope(String string) {
        int n = 1;
        if (REQUEST.equalsIgnoreCase(string)) {
            n = 2;
        } else if (SESSION.equalsIgnoreCase(string)) {
            n = 3;
        } else if (APPLICATION.equalsIgnoreCase(string)) {
            n = 4;
        }
        return n;
    }

    public static int getStyle(String string, String string2) throws JspException {
        int n = 2;
        if (string != null) {
            if (DEFAULT.equalsIgnoreCase(string)) {
                n = 2;
            } else if (SHORT.equalsIgnoreCase(string)) {
                n = 3;
            } else if (MEDIUM.equalsIgnoreCase(string)) {
                n = 2;
            } else if (LONG.equalsIgnoreCase(string)) {
                n = 1;
            } else if (FULL.equalsIgnoreCase(string)) {
                n = 0;
            } else {
                throw new JspException(Resources.getMessage(string2, string));
            }
        }
        return n;
    }

    public static String escapeXml(String string) {
        int n = 0;
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n2; ++i) {
            char[] cArray2;
            char c = cArray[i];
            if (c > '>' || (cArray2 = specialCharactersRepresentation[c]) == null) continue;
            if (n == 0) {
                stringBuffer = new StringBuffer(n2 + 5);
            }
            if (n < i) {
                stringBuffer.append(cArray, n, i - n);
            }
            n = i + 1;
            stringBuffer.append(cArray2);
        }
        if (n == 0) {
            return string;
        }
        if (n < n2) {
            stringBuffer.append(cArray, n, n2 - n);
        }
        return stringBuffer.toString();
    }

    public static String getContentTypeAttribute(String string, String string2) {
        int n;
        int n2;
        int n3 = string.toUpperCase().indexOf(string2.toUpperCase());
        if (n3 == -1) {
            return null;
        }
        n3 += string2.length();
        if ((n3 = string.indexOf(61, n3)) == -1) {
            return null;
        }
        if ((string = string.substring(++n3).trim()).charAt(0) == '\"') {
            n2 = 1;
            n = string.indexOf(34, n2);
            if (n == -1) {
                return null;
            }
        } else {
            n2 = 0;
            n = string.indexOf(59);
            if (n == -1) {
                n = string.indexOf(32);
            }
            if (n == -1) {
                n = string.length();
            }
        }
        return string.substring(n2, n).trim();
    }

    public static String URLEncode(String string, String string2) {
        if (string == null) {
            return "null";
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            if (Util.isSafeChar(c)) {
                stringBuffer.append(c);
                continue;
            }
            try {
                outputStreamWriter.write(c);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                stringBuffer.append(Character.forDigit(byArray[j] >> 4 & 0xF, 16));
                stringBuffer.append(Character.forDigit(byArray[j] & 0xF, 16));
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    private static boolean isSafeChar(int n) {
        if (n >= 97 && n <= 122) {
            return true;
        }
        if (n >= 65 && n <= 90) {
            return true;
        }
        if (n >= 48 && n <= 57) {
            return true;
        }
        return n == 45 || n == 95 || n == 46 || n == 33 || n == 126 || n == 42 || n == 39 || n == 40 || n == 41;
    }

    public static Enumeration getRequestLocales(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaders("accept-language");
        if (enumeration.hasMoreElements()) {
            return httpServletRequest.getLocales();
        }
        return enumeration;
    }

    static {
        Util.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        Util.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        Util.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        Util.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        Util.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }
}

