/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.awt.color.ICC_Transform;
import sun.security.action.LoadLibraryAction;

public abstract class ColorModel
implements Transparency {
    private long pData;
    protected int pixel_bits;
    int[] nBits;
    int transparency = 3;
    boolean supportsAlpha = true;
    boolean isAlphaPremultiplied = false;
    int numComponents = -1;
    int numColorComponents = -1;
    ColorSpace colorSpace = ColorSpace.getInstance(1000);
    int colorSpaceType = 5;
    int maxBits;
    boolean is_sRGB = true;
    protected int transferType;
    private static boolean loaded = false;
    private static ColorModel RGBdefault;
    static byte[] l8Tos8;
    static byte[] s8Tol8;
    static byte[] l16Tos8;
    static short[] s8Tol16;
    static Map g8Tos8Map;
    static Map lg16Toog8Map;
    static Map g16Tos8Map;
    static Map lg16Toog16Map;

    static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    private static native void initIDs();

    public static ColorModel getRGBdefault() {
        if (RGBdefault == null) {
            RGBdefault = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        return RGBdefault;
    }

    public ColorModel(int n) {
        this.pixel_bits = n;
        if (n < 1) {
            throw new IllegalArgumentException("Number of bits must be > 0");
        }
        this.numComponents = 4;
        this.numColorComponents = 3;
        this.maxBits = n;
        this.transferType = ColorModel.getDefaultTransferType(n);
    }

    protected ColorModel(int n, int[] nArray, ColorSpace colorSpace, boolean bl, boolean bl2, int n2, int n3) {
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numColorComponents = colorSpace.getNumComponents();
        this.numComponents = this.numColorComponents + (bl ? 1 : 0);
        this.supportsAlpha = bl;
        if (nArray.length < this.numComponents) {
            throw new IllegalArgumentException("Number of color/alpha components should be " + this.numComponents + " but length of bits array is " + nArray.length);
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("Unknown transparency: " + n2);
        }
        if (!this.supportsAlpha) {
            this.isAlphaPremultiplied = false;
            this.transparency = 1;
        } else {
            this.isAlphaPremultiplied = bl2;
            this.transparency = n2;
        }
        this.nBits = (int[])nArray.clone();
        this.pixel_bits = n;
        if (n <= 0) {
            throw new IllegalArgumentException("Number of pixel bits must be > 0");
        }
        this.maxBits = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] <= 0) {
                throw new IllegalArgumentException("Number of bits must be > 0");
            }
            if (this.maxBits < nArray[n4]) {
                this.maxBits = nArray[n4];
            }
            ++n4;
        }
        if (colorSpace != ColorSpace.getInstance(1000)) {
            this.is_sRGB = false;
        }
        this.transferType = n3;
    }

    public final boolean hasAlpha() {
        return this.supportsAlpha;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public final int getTransferType() {
        return this.transferType;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public int getComponentSize(int n) {
        if (this.nBits == null) {
            throw new NullPointerException("Number of bits array is null.");
        }
        return this.nBits[n];
    }

    public int[] getComponentSize() {
        if (this.nBits != null) {
            return (int[])this.nBits.clone();
        }
        return null;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getNumColorComponents() {
        return this.numColorComponents;
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int n) {
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
    }

    public int getRed(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getRed(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getGreen(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getGreen(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getBlue(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getBlue(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getAlpha(Object object) {
        int n = 0;
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                n2 = byArray.length;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                n2 = sArray.length;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                n2 = nArray.length;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (n2 == 1) {
            return this.getAlpha(n);
        }
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public int getRGB(Object object) {
        return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object) << 0;
    }

    public Object getDataElements(int n, Object object) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n, int[] nArray, int n2) {
        if (this.colorSpace == null) {
            throw new UnsupportedOperationException("This method is not supported by this color model.");
        }
        if (this.nBits == null) {
            throw new UnsupportedOperationException("This method is not supported.  Unable to determine #bits per component.");
        }
        if (fArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied) {
            float f = fArray[n + this.numColorComponents];
            int n3 = 0;
            while (n3 < this.numColorComponents) {
                nArray[n2 + n3] = (int)(fArray[n + n3] * (float)((1 << this.nBits[n3]) - 1) * f + 0.5f);
                ++n3;
            }
            nArray[n2 + this.numColorComponents] = (int)(f * (float)(1 << this.nBits[this.numColorComponents] - 1) + 0.5f);
        } else {
            int n4 = 0;
            while (n4 < this.numComponents) {
                nArray[n2 + n4] = (int)(fArray[n + n4] * (float)((1 << this.nBits[n4]) - 1) + 0.5f);
                ++n4;
            }
        }
        return nArray;
    }

    public float[] getNormalizedComponents(int[] nArray, int n, float[] fArray, int n2) {
        if (this.colorSpace == null) {
            throw new UnsupportedOperationException("This method is not supported by this color model.");
        }
        if (this.nBits == null) {
            throw new UnsupportedOperationException("This method is not supported.  Unable to determine #bits per component.");
        }
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        if (fArray == null) {
            fArray = new float[this.numComponents + n2];
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied) {
            float f = nArray[n + this.numColorComponents];
            f /= (float)((1 << this.nBits[this.numColorComponents]) - 1);
            int n3 = 0;
            while (n3 < this.numColorComponents) {
                fArray[n2 + n3] = (float)nArray[n + n3] / (f * (float)((1 << this.nBits[n3]) - 1));
                ++n3;
            }
            fArray[n2 + this.numColorComponents] = f;
        } else {
            int n4 = 0;
            while (n4 < this.numComponents) {
                fArray[n2 + n4] = (float)nArray[n + n4] / (float)((1 << this.nBits[n4]) - 1);
                ++n4;
            }
        }
        return fArray;
    }

    public int getDataElement(int[] nArray, int n) {
        throw new UnsupportedOperationException("This method is not supported by this color model.");
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        throw new UnsupportedOperationException("This method has not been implemented for this color model.");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorModel)) {
            return false;
        }
        ColorModel colorModel = (ColorModel)object;
        if (this == colorModel) {
            return true;
        }
        if (this.supportsAlpha != colorModel.hasAlpha() || this.isAlphaPremultiplied != colorModel.isAlphaPremultiplied() || this.pixel_bits != colorModel.getPixelSize() || this.transparency != colorModel.getTransparency() || this.numComponents != colorModel.getNumComponents()) {
            return false;
        }
        int[] nArray = colorModel.getComponentSize();
        int n = 0;
        while (n < this.numComponents) {
            if (this.nBits[n] != nArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        n = (this.supportsAlpha ? 2 : 3) + (this.isAlphaPremultiplied ? 4 : 5) + this.pixel_bits * 6 + this.transparency * 7 + this.numComponents * 8;
        int n2 = 0;
        while (n2 < this.numComponents) {
            n += this.nBits[n2] * (n2 + 9);
            ++n2;
        }
        return n;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public boolean isCompatibleRaster(Raster raster) {
        throw new UnsupportedOperationException("This method has not been implemented for this ColorModel.");
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        throw new UnsupportedOperationException("This method is not supported by this color model");
    }

    public void finalize() {
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        return null;
    }

    public String toString() {
        return new String("ColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }

    static int getDefaultTransferType(int n) {
        if (n <= 8) {
            return 0;
        }
        if (n <= 16) {
            return 1;
        }
        if (n <= 32) {
            return 3;
        }
        return 32;
    }

    static boolean isLinearRGBspace(ColorSpace colorSpace) {
        return colorSpace == ColorSpace.getInstance(1004);
    }

    static boolean isLinearGRAYspace(ColorSpace colorSpace) {
        return colorSpace == ColorSpace.getInstance(1003);
    }

    static byte[] getLinearRGB8TosRGB8LUT() {
        if (l8Tos8 == null) {
            l8Tos8 = new byte[256];
            int n = 0;
            while (n <= 255) {
                float f = (float)n / 255.0f;
                float f2 = f <= 0.0031308f ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
                ColorModel.l8Tos8[n] = (byte)Math.round(f2 * 255.0f);
                ++n;
            }
        }
        return l8Tos8;
    }

    static byte[] getsRGB8ToLinearRGB8LUT() {
        if (s8Tol8 == null) {
            s8Tol8 = new byte[256];
            int n = 0;
            while (n <= 255) {
                float f = (float)n / 255.0f;
                float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow((f + 0.055f) / 1.055f, 2.4);
                ColorModel.s8Tol8[n] = (byte)Math.round(f2 * 255.0f);
                ++n;
            }
        }
        return s8Tol8;
    }

    static byte[] getLinearRGB16TosRGB8LUT() {
        if (l16Tos8 == null) {
            l16Tos8 = new byte[65536];
            int n = 0;
            while (n <= 65535) {
                float f = (float)n / 65535.0f;
                float f2 = f <= 0.0031308f ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
                ColorModel.l16Tos8[n] = (byte)Math.round(f2 * 255.0f);
                ++n;
            }
        }
        return l16Tos8;
    }

    static short[] getsRGB8ToLinearRGB16LUT() {
        if (s8Tol16 == null) {
            s8Tol16 = new short[256];
            int n = 0;
            while (n <= 255) {
                float f = (float)n / 255.0f;
                float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow((f + 0.055f) / 1.055f, 2.4);
                ColorModel.s8Tol16[n] = (short)Math.round(f2 * 65535.0f);
                ++n;
            }
        }
        return s8Tol16;
    }

    static byte[] getGray8TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        byte[] byArray;
        if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
            return ColorModel.getLinearRGB8TosRGB8LUT();
        }
        if (g8Tos8Map != null && (byArray = (byte[])g8Tos8Map.get(iCC_ColorSpace)) != null) {
            return byArray;
        }
        byArray = new byte[256];
        int n = 0;
        while (n <= 255) {
            byArray[n] = (byte)n;
            ++n;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        byte[] byArray2 = iCC_Transform.colorConvert(byArray, (byte[])null);
        int n2 = 0;
        int n3 = 2;
        while (n2 <= 255) {
            byArray[n2] = byArray2[n3];
            ++n2;
            n3 += 3;
        }
        if (g8Tos8Map == null) {
            g8Tos8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        g8Tos8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static byte[] getLinearGray16ToOtherGray8LUT(ICC_ColorSpace iCC_ColorSpace) {
        Object[] objectArray;
        if (lg16Toog8Map != null && (objectArray = (Object[])((byte[])lg16Toog8Map.get(iCC_ColorSpace))) != null) {
            return objectArray;
        }
        objectArray = new short[65536];
        int n = 0;
        while (n <= 65535) {
            objectArray[n] = (short)n;
            ++n;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        objectArray = iCC_Transform.colorConvert((short[])objectArray, null);
        byte[] byArray = new byte[65536];
        int n2 = 0;
        while (n2 <= 65535) {
            byArray[n2] = (byte)((float)(objectArray[n2] & 0xFFFF) * 0.0038910506f + 0.5f);
            ++n2;
        }
        if (lg16Toog8Map == null) {
            lg16Toog8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        lg16Toog8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static byte[] getGray16TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        Object[] objectArray;
        if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
            return ColorModel.getLinearRGB16TosRGB8LUT();
        }
        if (g16Tos8Map != null && (objectArray = (Object[])((byte[])g16Tos8Map.get(iCC_ColorSpace))) != null) {
            return objectArray;
        }
        objectArray = new short[65536];
        int n = 0;
        while (n <= 65535) {
            objectArray[n] = (short)n;
            ++n;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1000);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        objectArray = iCC_Transform.colorConvert((short[])objectArray, null);
        byte[] byArray = new byte[65536];
        int n2 = 0;
        int n3 = 2;
        while (n2 <= 65535) {
            byArray[n2] = (byte)((float)(objectArray[n3] & 0xFFFF) * 0.0038910506f + 0.5f);
            ++n2;
            n3 += 3;
        }
        if (g16Tos8Map == null) {
            g16Tos8Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        g16Tos8Map.put(iCC_ColorSpace, byArray);
        return byArray;
    }

    static short[] getLinearGray16ToOtherGray16LUT(ICC_ColorSpace iCC_ColorSpace) {
        short[] sArray;
        if (lg16Toog16Map != null && (sArray = (short[])lg16Toog16Map.get(iCC_ColorSpace)) != null) {
            return sArray;
        }
        sArray = new short[65536];
        int n = 0;
        while (n <= 65535) {
            sArray[n] = (short)n;
            ++n;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[2];
        ICC_ColorSpace iCC_ColorSpace2 = (ICC_ColorSpace)ColorSpace.getInstance(1003);
        iCC_TransformArray[0] = new ICC_Transform(iCC_ColorSpace2.getProfile(), -1, 1);
        iCC_TransformArray[1] = new ICC_Transform(iCC_ColorSpace.getProfile(), -1, 2);
        ICC_Transform iCC_Transform = new ICC_Transform(iCC_TransformArray);
        short[] sArray2 = iCC_Transform.colorConvert(sArray, null);
        if (lg16Toog16Map == null) {
            lg16Toog16Map = Collections.synchronizedMap(new WeakHashMap(2));
        }
        lg16Toog16Map.put(iCC_ColorSpace, sArray2);
        return sArray2;
    }

    static {
        ColorModel.loadLibraries();
        ColorModel.initIDs();
        l8Tos8 = null;
        s8Tol8 = null;
        l16Tos8 = null;
        s8Tol16 = null;
        g8Tos8Map = null;
        lg16Toog8Map = null;
        g16Tos8Map = null;
        lg16Toog16Map = null;
    }
}

