/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.security.action.GetPropertyAction;

class DefaultPopupFactory
implements PopupFactory {
    private int lastPopupType = 0;
    private static final Object heavyPopupCacheKey = new StringBuffer("PopupFactory.heavyPopupCache");
    private static final Object lightPopupCacheKey = new StringBuffer("PopupFactory.lightPopupCache");
    private static final Object mediumPopupCacheKey = new StringBuffer("PopupFactory.mediumPopupCache");
    private static final Object defaultLWPopupEnabledKey = new StringBuffer("PopupFactory.defaultLWPopupEnabledKey");
    private static final int MAX_CACHE_SIZE = 5;
    private boolean lightWeightPopupEnabled = true;
    static boolean popupPostionFixEnabled = false;
    private static final int LIGHT_WEIGHT_POPUP = 0;
    private static final int MEDIUM_WEIGHT_POPUP = 1;
    private static final int HEAVY_WEIGHT_POPUP = 2;
    private static final Object classLock;

    DefaultPopupFactory() {
    }

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        SwingUtilities.appContextPut(defaultLWPopupEnabledKey, new Boolean(bl));
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl = (Boolean)SwingUtilities.appContextGet(defaultLWPopupEnabledKey);
        if (bl == null) {
            SwingUtilities.appContextPut(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    private static Hashtable getHeavyPopupCache() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(heavyPopupCacheKey);
        if (hashtable == null) {
            hashtable = new Hashtable(2);
            SwingUtilities.appContextPut(heavyPopupCacheKey, hashtable);
        }
        return hashtable;
    }

    private static Vector getLightPopupCache() {
        Vector vector = (Vector)SwingUtilities.appContextGet(lightPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(lightPopupCacheKey, vector);
        }
        return vector;
    }

    private static Vector getMediumPopupCache() {
        Vector vector = (Vector)SwingUtilities.appContextGet(mediumPopupCacheKey);
        if (vector == null) {
            vector = new Vector();
            SwingUtilities.appContextPut(mediumPopupCacheKey, vector);
        }
        return vector;
    }

    static void recycleHeavyPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector;
            final Window window = SwingUtilities.getWindowAncestor((Component)((Object)popup));
            Hashtable hashtable = DefaultPopupFactory.getHeavyPopupCache();
            if (hashtable.containsKey(window)) {
                vector = (Vector)hashtable.get(window);
            } else {
                vector = new Vector();
                hashtable.put(window, vector);
                window.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        Hashtable hashtable = DefaultPopupFactory.getHeavyPopupCache();
                        hashtable.remove(window);
                    }
                });
            }
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    static Popup getRecycledHeavyPopup(Window window) {
        Object object = classLock;
        synchronized (object) {
            Hashtable hashtable = DefaultPopupFactory.getHeavyPopupCache();
            if (!hashtable.containsKey(window)) {
                Popup popup = null;
                return popup;
            }
            Vector vector = (Vector)hashtable.get(window);
            int n = vector.size();
            if (n > 0) {
                Popup popup = (Popup)vector.elementAt(0);
                vector.removeElementAt(0);
                Popup popup2 = popup;
                return popup2;
            }
            Popup popup = null;
            return popup;
        }
    }

    boolean adjustPopuLocationToFitScreen(Component component, Point point) {
        if (!popupPostionFixEnabled) {
            return false;
        }
        if (component == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n3 = point.x;
        int n4 = point.y;
        Dimension dimension = component.getPreferredSize();
        if (point.x + dimension.width > n) {
            point.x = n - dimension.width;
        }
        if (point.y + dimension.height > n2) {
            point.y = n2 - dimension.height;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        return true;
    }

    static void recycleLightPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector = DefaultPopupFactory.getLightPopupCache();
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    static Popup getRecycledLightPopup() {
        Object object = classLock;
        synchronized (object) {
            Vector vector = DefaultPopupFactory.getLightPopupCache();
            int n = vector.size();
            if (n > 0) {
                Popup popup = (Popup)vector.elementAt(0);
                vector.removeElementAt(0);
                Popup popup2 = popup;
                return popup2;
            }
            Popup popup = null;
            return popup;
        }
    }

    static void recycleMediumPopup(Popup popup) {
        Object object = classLock;
        synchronized (object) {
            Vector vector = DefaultPopupFactory.getMediumPopupCache();
            if (vector.size() < 5) {
                vector.addElement(popup);
            }
        }
    }

    static Popup getRecycledMediumPopup() {
        Object object = classLock;
        synchronized (object) {
            Vector vector = DefaultPopupFactory.getMediumPopupCache();
            int n = vector.size();
            if (n > 0) {
                Popup popup = (Popup)vector.elementAt(0);
                vector.removeElementAt(0);
                Popup popup2 = popup;
                return popup2;
            }
            Popup popup = null;
            return popup;
        }
    }

    static void recyclePopup(Popup popup) {
        if (popup instanceof JPanelPopup) {
            DefaultPopupFactory.recycleLightPopup(popup);
        } else if (popup instanceof WindowPopup) {
            DefaultPopupFactory.recycleHeavyPopup(popup);
        } else if (popup instanceof PanelPopup) {
            DefaultPopupFactory.recycleMediumPopup(popup);
        }
    }

    protected Popup createLightWeightPopup(Component component, Component component2) {
        Popup popup = DefaultPopupFactory.getRecycledLightPopup();
        if (popup == null) {
            popup = new JPanelPopup();
        }
        return popup;
    }

    protected Popup createMediumWeightPopup(Component component, Component component2) {
        Popup popup = DefaultPopupFactory.getRecycledMediumPopup();
        if (popup == null) {
            popup = new PanelPopup();
        }
        return popup;
    }

    protected Popup createHeavyWeightPopup(Component component, Component component2) {
        Window window = component2 != null ? SwingUtilities.getWindowAncestor(component2) : null;
        Popup popup = null;
        if (window != null) {
            popup = DefaultPopupFactory.getRecycledHeavyPopup(window);
        } else {
            window = new Frame();
        }
        if (popup == null) {
            popup = new WindowPopup(window);
        }
        ((Window)((Object)popup)).setName("###overrideRedirect###");
        return popup;
    }

    private boolean popupFit(Component component, Rectangle rectangle) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return SwingUtilities.isRectangleContainingRectangle(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet) {
                    Rectangle rectangle2 = container.getBounds();
                    Point point = container.getLocationOnScreen();
                    rectangle2.x = point.x;
                    rectangle2.y = point.y;
                    return SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle);
                }
                container = container.getParent();
            }
        }
        return false;
    }

    private boolean ancestorIsModalDialog(Component component) {
        Container container = null;
        if (component != null) {
            container = component.getParent();
            while (container != null) {
                if (container instanceof Dialog && ((Dialog)container).isModal()) {
                    return true;
                }
                container = container.getParent();
            }
        }
        return false;
    }

    private Popup replacePopup(Component component, Component component2, int n, int n2, Popup popup, int n3) {
        popup.removeComponent(component);
        DefaultPopupFactory.recyclePopup(popup);
        popup = null;
        switch (n3) {
            case 0: {
                popup = this.createLightWeightPopup(component, component2);
                break;
            }
            case 1: {
                popup = this.createMediumWeightPopup(component, component2);
                break;
            }
            case 2: {
                popup = this.createHeavyWeightPopup(component, component2);
            }
        }
        popup.setLocationOnScreen(n, n2);
        popup.addComponent(component, "Center");
        component.invalidate();
        popup.pack();
        return popup;
    }

    private boolean invokerInHeavyWeightPopup(Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof WindowPopup) {
                    return true;
                }
                if (container instanceof PanelPopup || container instanceof JPanelPopup) break;
                container = container.getParent();
            }
        }
        return false;
    }

    public Popup getPopup(Component component, Component component2, int n, int n2) {
        Popup popup = null;
        switch (this.lastPopupType) {
            case 0: {
                popup = this.createLightWeightPopup(component, component2);
                break;
            }
            case 1: {
                popup = this.createMediumWeightPopup(component, component2);
                break;
            }
            case 2: {
                popup = this.createHeavyWeightPopup(component, component2);
            }
        }
        int n3 = this.lastPopupType;
        Point point = new Point(n, n2);
        if (this.adjustPopuLocationToFitScreen(component, point)) {
            n = point.x;
            n2 = point.y;
        }
        popup.setLocationOnScreen(n, n2);
        popup.addComponent(component, "Center");
        popup.pack();
        Rectangle rectangle = new Rectangle(n, n2, popup.getWidth(), popup.getHeight());
        int n4 = this.popupFit(component2, rectangle) ? ((component instanceof JToolTip || component instanceof JPopupMenu && ((JPopupMenu)component).isLightWeightPopupEnabled()) && this.lightWeightPopupEnabled ? 0 : 1) : 2;
        if (this.invokerInHeavyWeightPopup(component2)) {
            n4 = 2;
        }
        if (component2 == null) {
            n4 = 2;
        }
        if (n4 != n3) {
            popup = this.replacePopup(component, component2, n, n2, popup, n4);
            n3 = n4;
        }
        this.lastPopupType = n3;
        return popup;
    }

    static {
        popupPostionFixEnabled = AccessController.doPrivileged(new GetPropertyAction("javax.swing.adjustPopupLocationToFit", "")).equals("true");
        classLock = new Object();
    }

    protected class PanelPopup
    extends Panel
    implements Popup,
    Serializable {
        int desiredLocationX;
        int desiredLocationY;
        JRootPane rootPane;

        public PanelPopup() {
            this.setLayout(new BorderLayout());
            this.rootPane = new JRootPane();
            this.add((Component)this.rootPane, "Center");
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public int getWidth() {
            return this.getBounds().width;
        }

        public int getHeight() {
            return this.getBounds().height;
        }

        public Component getComponent() {
            return this;
        }

        public void addComponent(Component component, Object object) {
            this.rootPane.getContentPane().add(component, object);
        }

        public void removeComponent(Component component) {
            this.rootPane.getContentPane().remove(component);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }

        public void pack() {
            this.setSize(this.getPreferredSize());
        }

        public void show(Component component) {
            Container container = null;
            if (component != null) {
                container = component.getParent();
            }
            while (!(container instanceof Window) && !(container instanceof Applet) && container != null) {
                container = container.getParent();
            }
            super.hide();
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getLayeredPane();
                Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
                this.setLocation(point.x, point.y);
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
                this.setLocation(point.x, point.y);
                container.add(this);
            }
            super.show();
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Rectangle getBoundsOnScreen() {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                return rectangle;
            }
            throw new Error("getBoundsOnScreen called on an invisible popup");
        }

        Point convertParentLocationToScreen(Container container, int n, int n2) {
            Component component = null;
            Container container2 = this;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    component = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(container, point, null);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }
            throw new Error("convertParentLocationToScreen: no window ancestor found");
        }

        Point convertScreenLocationToParent(Container container, int n, int n2) {
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (window != null) {
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, container);
                return point;
            }
            throw new Error("convertScreenLocationToParent: no window ancestor found");
        }

        public void setLocationOnScreen(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Point point = this.convertScreenLocationToParent(container, n, n2);
                this.setLocation(point.x, point.y);
            } else {
                this.desiredLocationX = n;
                this.desiredLocationY = n2;
            }
        }
    }

    protected class JPanelPopup
    extends JPanel
    implements Popup,
    Serializable {
        int desiredLocationX;
        int desiredLocationY;

        public JPanelPopup() {
            this.setLayout(new BorderLayout());
            this.setDoubleBuffered(true);
            this.setOpaque(true);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public Component getComponent() {
            return this;
        }

        public void addComponent(Component component, Object object) {
            this.add(component, object);
        }

        public void removeComponent(Component component) {
            this.remove(component);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void pack() {
            this.setSize(this.getPreferredSize());
        }

        public void show(Component component) {
            Container container = null;
            if (component != null) {
                container = component.getParent();
            }
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof JRootPane) {
                    if (!(container2.getParent() instanceof JInternalFrame)) {
                        container = ((JRootPane)container2).getLayeredPane();
                        container2 = container.getParent();
                        while (container2 != null && !(container2 instanceof Window)) {
                            container2 = container2.getParent();
                        }
                        window = (Window)container2;
                        break;
                    }
                } else if (container2 instanceof Window) {
                    container = container2;
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            Point point = this.convertScreenLocationToParent(container, this.desiredLocationX, this.desiredLocationY);
            this.setLocation(point.x, point.y);
            if (container instanceof JLayeredPane) {
                ((JLayeredPane)container).add(this, JLayeredPane.POPUP_LAYER, 0);
            } else {
                container.add(this);
            }
        }

        public void hide() {
            Container container = this.getParent();
            Rectangle rectangle = this.getBounds();
            if (container != null) {
                container.remove(this);
            }
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public Rectangle getBoundsOnScreen() {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                Point point = this.convertParentLocationToScreen(container, rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                return rectangle;
            }
            throw new Error("getBoundsOnScreen called on an invisible popup");
        }

        Point convertParentLocationToScreen(Container container, int n, int n2) {
            Component component = null;
            Container container2 = this;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    component = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(container, point, null);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }
            throw new Error("convertParentLocationToScreen: no window ancestor found");
        }

        Point convertScreenLocationToParent(Container container, int n, int n2) {
            Window window = null;
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof Window) {
                    window = (Window)container2;
                    break;
                }
                container2 = container2.getParent();
            }
            if (window != null) {
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, container);
                return point;
            }
            throw new Error("convertScreenLocationToParent: no window ancestor found");
        }

        public void setLocationOnScreen(int n, int n2) {
            Container container = this.getParent();
            if (container != null) {
                Point point = this.convertScreenLocationToParent(container, n, n2);
                this.setLocation(point.x, point.y);
            } else {
                this.desiredLocationX = n;
                this.desiredLocationY = n2;
            }
        }
    }

    protected class WindowPopup
    extends JWindow
    implements Popup,
    Serializable,
    Accessible {
        int saveX;
        int saveY;
        boolean firstShow = true;

        public WindowPopup(Window window) {
            super(window);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public Component getComponent() {
            return this;
        }

        public int getWidth() {
            return this.getBounds().width;
        }

        public int getHeight() {
            return this.getBounds().height;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void show(Component component) {
            this.setLocation(this.saveX, this.saveY);
            this.setVisible(true);
            if (this.firstShow) {
                this.hide();
                this.setVisible(true);
                this.firstShow = false;
            }
        }

        public void hide() {
            super.hide();
            this.removeNotify();
        }

        public Rectangle getBoundsOnScreen() {
            return this.getBounds();
        }

        public void setLocationOnScreen(int n, int n2) {
            this.setLocation(n, n2);
            this.saveX = n;
            this.saveY = n2;
        }

        public void addComponent(Component component, Object object) {
            this.getContentPane().add(component, object);
        }

        public void removeComponent(Component component) {
            this.getContentPane().remove(component);
            DefaultPopupFactory.recyclePopup(this);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWindowPopup();
            }
            return this.accessibleContext;
        }

        protected class AccessibleWindowPopup
        extends AccessibleContext
        implements Serializable,
        AccessibleComponent {
            protected AccessibleContext accessibleContext = null;

            protected AccessibleWindowPopup() {
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.WINDOW;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                if (WindowPopup.this.getFocusOwner() != null) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                    accessibleStateSet.add(AccessibleState.FOCUSED);
                }
                if (this.isFocusTraversable()) {
                    accessibleStateSet.add(AccessibleState.FOCUSABLE);
                }
                if (WindowPopup.this.isOpaque()) {
                    accessibleStateSet.add(AccessibleState.OPAQUE);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                }
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                if (this.accessibleParent != null) {
                    return this.accessibleParent;
                }
                Container container = WindowPopup.this.getParent();
                if (container instanceof Accessible) {
                    return (Accessible)((Object)container);
                }
                return null;
            }

            public int getAccessibleIndexInParent() {
                return SwingUtilities.getAccessibleIndexInParent(WindowPopup.this);
            }

            public int getAccessibleChildrenCount() {
                return SwingUtilities.getAccessibleChildrenCount(WindowPopup.this);
            }

            public Accessible getAccessibleChild(int n) {
                return SwingUtilities.getAccessibleChild(WindowPopup.this, n);
            }

            public Locale getLocale() {
                return WindowPopup.this.getLocale();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public Color getBackground() {
                return WindowPopup.this.getBackground();
            }

            public void setBackground(Color color) {
                WindowPopup.this.setBackground(color);
            }

            public Color getForeground() {
                return WindowPopup.this.getForeground();
            }

            public void setForeground(Color color) {
                WindowPopup.this.setForeground(color);
            }

            public Cursor getCursor() {
                return WindowPopup.this.getCursor();
            }

            public void setCursor(Cursor cursor) {
                WindowPopup.this.setCursor(cursor);
            }

            public Font getFont() {
                return WindowPopup.this.getFont();
            }

            public void setFont(Font font) {
                WindowPopup.this.setFont(font);
            }

            public FontMetrics getFontMetrics(Font font) {
                return WindowPopup.this.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return WindowPopup.this.isEnabled();
            }

            public void setEnabled(boolean bl) {
                WindowPopup.this.setEnabled(bl);
            }

            public boolean isVisible() {
                return WindowPopup.this.isVisible();
            }

            public void setVisible(boolean bl) {
                WindowPopup.this.setVisible(bl);
            }

            public boolean isShowing() {
                return WindowPopup.this.isShowing();
            }

            public boolean contains(Point point) {
                return WindowPopup.this.contains(point);
            }

            public Point getLocationOnScreen() {
                return WindowPopup.this.getLocationOnScreen();
            }

            public Point getLocation() {
                return WindowPopup.this.getLocation();
            }

            public void setLocation(Point point) {
                WindowPopup.this.setLocation(point);
            }

            public Rectangle getBounds() {
                return WindowPopup.this.getBounds();
            }

            public void setBounds(Rectangle rectangle) {
                WindowPopup.this.setBounds(rectangle);
            }

            public Dimension getSize() {
                return WindowPopup.this.getSize();
            }

            public void setSize(Dimension dimension) {
                WindowPopup.this.setSize(dimension);
            }

            public Accessible getAccessibleAt(Point point) {
                return SwingUtilities.getAccessibleAt(WindowPopup.this, point);
            }

            public boolean isFocusTraversable() {
                return WindowPopup.this.isFocusTraversable();
            }

            public void requestFocus() {
                WindowPopup.this.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                WindowPopup.this.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                WindowPopup.this.removeFocusListener(focusListener);
            }
        }
    }
}

