/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.MalformedURLException;
import java.net.URL;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.PathMap;

abstract class AuthenticationInfo
implements Cloneable {
    static final char SERVER_AUTHENTICATION = 's';
    static final char PROXY_AUTHENTICATION = 'p';
    private static PathMap cache = new PathMap();
    char type;
    char authType;
    String host;
    int port;
    String realm;
    String path;

    AuthenticationInfo(char c, char c2, String string, int n, String string2) {
        this.type = c;
        this.authType = c2;
        this.host = string.toLowerCase();
        this.port = n;
        this.realm = string2;
        this.path = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static int getDefaultPort(URL uRL) {
        if (uRL.getProtocol().toLowerCase().equals("http")) {
            return 80;
        }
        if (uRL.getProtocol().toLowerCase().equals("https")) {
            return 443;
        }
        return -1;
    }

    AuthenticationInfo(char c, char c2, URL uRL, String string) {
        this.type = c;
        this.authType = c2;
        this.host = uRL.getHost().toLowerCase();
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = AuthenticationInfo.getDefaultPort(uRL);
        }
        this.realm = string;
        try {
            String string2;
            this.path = string2 = new URL(uRL, "./").getPath();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Exception : " + malformedURLException);
            malformedURLException.printStackTrace();
        }
    }

    static AuthenticationInfo getServerAuth(URL uRL) {
        int n = uRL.getPort();
        if (n == -1) {
            n = AuthenticationInfo.getDefaultPort(uRL);
        }
        String string = "s:" + uRL.getHost() + ":" + n;
        return AuthenticationInfo.getAuth(string, uRL);
    }

    static AuthenticationInfo getServerAuth(URL uRL, String string, char c) {
        int n = uRL.getPort();
        if (n == -1) {
            n = AuthenticationInfo.getDefaultPort(uRL);
        }
        String string2 = "s:" + c + ":" + uRL.getHost().toLowerCase() + ":" + n + ":" + string;
        return AuthenticationInfo.getAuth(string2, null);
    }

    private static AuthenticationInfo getAuth(String string, URL uRL) {
        if (uRL == null) {
            return cache.get(string, null);
        }
        try {
            return cache.get(string, new URL(uRL, "./").getPath());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Exception: " + malformedURLException);
            malformedURLException.printStackTrace();
            return null;
        }
    }

    static AuthenticationInfo getProxyAuth(String string, int n) {
        String string2 = "p:" + string.toLowerCase() + ":" + n;
        AuthenticationInfo authenticationInfo = cache.get(string2, null);
        return authenticationInfo;
    }

    static AuthenticationInfo getProxyAuth(String string, int n, String string2, char c) {
        String string3 = "p:" + c + ":" + string.toLowerCase() + ":" + n + ":" + string2;
        AuthenticationInfo authenticationInfo = cache.get(string3, null);
        return authenticationInfo;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), null);
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue();

    boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser) {
        httpURLConnection.setAuthenticationProperty(this.getHeaderName(), this.getHeaderValue());
        return true;
    }

    String cacheKey(boolean bl) {
        if (bl) {
            return this.type + ":" + this.authType + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.host + ":" + this.port;
    }
}

