/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac;

import br.com.bb.plugins.gac.IniciarUtilizacao;
import br.com.bb.plugins.gac.apresentacao.WindowSplash;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.ServicoAplicacaoDAO;
import br.com.bb.plugins.gac.negocio.facade.IniciarUtilizacaoFacade;
import br.com.bb.plugins.gac.negocio.facade.ManterBancoDadosControleFacade;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoAplicacaoTO;
import br.com.bb.plugins.gac.negocio.to.controle.ServicoControleTO;
import br.com.bb.plugins.gac.util.AtualizacaoModuloBasico;
import br.com.bb.plugins.gac.util.ClassLoaderUtil;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.Log;
import br.com.bb.plugins.gac.util.PluginInfo;
import br.com.bb.plugins.gac.util.ReinicializadorDeAplicacao;
import br.com.bb.plugins.gac.util.ServicoInfo;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilMapeamentoAction;
import br.com.bb.plugins.gac.util.Utilitarios;
import br.com.bb.plugins.gac.util.arquivo.AlarmeUtil;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdom.JDOMException;

public class Iniciar {
    private static Runnable inicializa;
    private static ConfiguracaoProperties configuracaoProperties;
    private static ServicoAplicacaoDAO servicoAplicacaoDAO;
    private static String versaoAplicativoLocal;
    private static String versaoAplicativoBanco;
    private static final boolean PILOTO = false;

    static {
        configuracaoProperties = ConfiguracaoProperties.getConfiguracaoProperties();
        servicoAplicacaoDAO = new ServicoAplicacaoDAO();
        versaoAplicativoBanco = "";
    }

    private static boolean bancoJaInicializado(String message) {
        return message.contains("335544344");
    }

    private static String getTipoInstalacaoBD() {
        return configuracaoProperties.getTipoInstalacaoBancoDados();
    }

    private static boolean existemArquivosBD() {
        String localBD = configuracaoProperties.getLocalBD();
        File bdAplicacao = new File(String.valueOf(localBD) + File.separator + "BBGACA" + "." + "FDB");
        File bdControle = new File(String.valueOf(localBD) + File.separator + "BBGACC" + "." + "FDB");
        return bdControle.exists() && bdAplicacao.exists();
    }

    private static void carregarMapeamentoActionCodigo() {
        UtilMapeamentoAction util = UtilMapeamentoAction.getInstancia();
        util.carregarMapeamento();
    }

    private static boolean validadeJava() {
        int iresult = 0;
        StringTokenizer stb = new StringTokenizer(System.getProperty("java.version").toString());
        int icnt = 100;
        while (icnt > 1) {
            if (stb.hasMoreElements()) {
                String pedaco = stb.nextToken(".");
                try {
                    iresult += icnt * Integer.parseInt(pedaco);
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                }
            }
            icnt /= 10;
        }
        return iresult >= 150;
    }

    protected static void setWindowsLookAndFeel() {
        try {
            if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
        }
        catch (ClassNotFoundException e) {
            Log.getInstance().logMsgNoExit(e);
        }
        catch (InstantiationException e) {
            Log.getInstance().logMsgNoExit(e);
        }
        catch (IllegalAccessException e) {
            Log.getInstance().logMsgNoExit(e);
        }
        catch (UnsupportedLookAndFeelException e) {
            Log.getInstance().logMsgNoExit(e);
        }
    }

    private static boolean testarExistenciaBancoDeDados() throws BBException {
        return new ServicoAplicacaoDAO().testarExistenciaTabela();
    }

    private static boolean gacDesatualizado() throws BBException {
        ServicoInfo.getInstance().setPath(configuracaoProperties.getDirTemp());
        ServicoAplicacaoTO gacBanco = new ServicoAplicacaoTO();
        PluginInfo gacLocal = new PluginInfo();
        try {
            gacBanco = servicoAplicacaoDAO.consultarServico("GAC");
            gacLocal = ServicoInfo.getInstance().GetFileInfoGAC();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (JDOMException jdome) {
            jdome.printStackTrace();
        }
        catch (BBException bbe) {
            bbe.printStackTrace();
        }
        versaoAplicativoBanco = gacBanco.getTextoVersao().replace(".", "");
        versaoAplicativoLocal = gacLocal.getVersao().replace(".", "");
        if (Integer.parseInt(versaoAplicativoLocal) > Integer.parseInt(versaoAplicativoBanco)) {
            gacBanco.setTextoVersao(versaoAplicativoLocal);
            servicoAplicacaoDAO.gravarServico(gacBanco);
        }
        return Integer.parseInt(versaoAplicativoBanco) > Integer.parseInt(versaoAplicativoLocal);
    }

    public static void main(String[] args) {
        WindowSplash splash = new WindowSplash();
        Utilitarios.centralizeWindow(splash);
        splash.setVisible(true);
        String s_dir = System.getProperty("user.dir");
        s_dir = s_dir.replaceAll("\\\\", "/");
        ClassLoaderUtil.addFilesFromFolder(String.valueOf(s_dir) + "/plugins");
        ClassLoaderUtil.addFilesFromFolder(String.valueOf(s_dir) + "/lib");
        System.setProperty("java.libray.path", s_dir);
        if (!Iniciar.validadeJava()) {
            JOptionPane.showMessageDialog(null, "Aten\u00e7\u00e3o! A m\u00e1quina virtual Java que est\u00e1 sendo utilizada para execu\u00e7\u00e3o do aplicativo \u00e9 diferente de 1.5. Reinstale o aplicativo e tente novamente. O Aplicativo ser\u00e1 finalizado.");
            System.exit(0);
        }
        try {
            Iniciar.removerAplicativo();
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, "Erro durante a exclus\u00e3o do m\u00f3dulo!" + t.getMessage());
        }
        try {
            if (Iniciar.testarExistenciaBancoDeDados() && Iniciar.gacDesatualizado()) {
                BBJPopupMensagem.criarInstancia();
                if (Iniciar.existeGACAtualizadoNoServicoControle()) {
                    BBJPopupMensagem.exibirMensagemInformacao("Aten\u00e7\u00e3o! A vers\u00e3o do BB Gest\u00e3oMax instalada neste computador est\u00e1 desatualizada - Vers\u00e3o Local: " + Util.formatarVersao(versaoAplicativoLocal) + " - Vers\u00e3o Servidor: " + Util.formatarVersao(versaoAplicativoBanco) + " Uma nova vers\u00e3o ser\u00e1 instalada e o sistema ser\u00e1 reinciado.");
                    ReinicializadorDeAplicacao.reiniciaAplicacao(AtualizacaoModuloBasico.getInstance());
                } else {
                    BBJPopupMensagem.exibirMensagemErro("Aten\u00e7\u00e3o! A vers\u00e3o do BB Gest\u00e3oMax instalada neste computador est\u00e1 desatualizada - Vers\u00e3o Local: " + Util.formatarVersao(versaoAplicativoLocal) + " - Vers\u00e3o Servidor: " + Util.formatarVersao(versaoAplicativoBanco) + " Para atualizar a vers\u00e3o, baixe o instalador do aplicativo no site do BB (http://www.bb.com.br/aplicativos) e instale neste computador. " + "O aplicativo ser\u00e1 finalizado.");
                    System.exit(0);
                }
            }
            if (Iniciar.getTipoInstalacaoBD().equals("1") && !Iniciar.existemArquivosBD()) {
                Iniciar.alteraBancoParaRede();
            }
        }
        catch (BBException e) {
            e.printStackTrace();
        }
        try {
            BBJPopupMensagem.criarInstancia();
            IniciarUtilizacao.getInstancia().iniciarUtilizacao("GAC");
            BBJPopupMensagem.removerInstancia();
        }
        catch (BBException e) {
            e.printStackTrace();
            if (Iniciar.bancoJaInicializado(e.getKey())) {
                BBJPopupMensagem.exibirMensagemErro("Erro ao conectar: a base j\u00e1 deve estar sendo utilizada ou o servidor n\u00e3o foi inicializado.");
            } else {
                BBJPopupMensagem.exibirMensagemErro(e.getMessage());
            }
            System.exit(0);
        }
        ViewController.getInstance().goToView("viewPrincipal", null);
        Iniciar.carregarMapeamentoActionCodigo();
        splash.dispose();
        try {
            AlarmeUtil.main(null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean existeGACAtualizadoNoServicoControle() throws BBException {
        ManterBancoDadosControleFacade manterBancoDadosControleFacade = new ManterBancoDadosControleFacade();
        ServicoControleTO servicoControleTO = manterBancoDadosControleFacade.getManterBancoDadosControleModel().consultarServico("GAC");
        if (servicoControleTO == null) {
            return false;
        }
        return Integer.parseInt(servicoControleTO.getVersaoPacote()) >= Integer.parseInt(versaoAplicativoBanco);
    }

    public static Runnable getInicializa() {
        return inicializa;
    }

    private static void alteraBancoParaRede() throws BBException {
        configuracaoProperties.setTipoInstalacaoBancoDados("0");
        configuracaoProperties.setBancoTemProblema("1");
        ConfiguracaoProperties.getConfiguracaoProperties().salvaPropriedades();
        JOptionPane.showMessageDialog(null, "Arquivos de banco de dados n\u00e3o localizados!\nO aplicativo precisa ser reinicializado para proceder com a configura\u00e7\u00e3o da base de dados.", "Erro", 1);
        System.exit(0);
    }

    public static boolean isPiloto() {
        return false;
    }

    private static void removerAplicativo() throws BBException {
        IniciarUtilizacaoFacade iniciarFacade = new IniciarUtilizacaoFacade();
        String splitModulos = iniciarFacade.buscarModulosRemover();
        String[] modulos = splitModulos != null && !splitModulos.trim().equals("") ? splitModulos.split(";") : null;
        try {
            if (modulos == null) {
                return;
            }
            int i = 0;
            while (i < modulos.length) {
                iniciarFacade.removerJarModulo(modulos[i]);
                ++i;
            }
            i = 0;
            while (i < modulos.length) {
                iniciarFacade.excluirModuloServido(modulos[i]);
                ++i;
            }
        }
        finally {
            ConfiguracaoProperties.getConfiguracaoProperties().setRemoverModulo("");
            ConfiguracaoProperties.getConfiguracaoProperties().salvaPropriedades();
        }
    }
}

